INCLUDE("${CMAKE_CURRENT_LIST_DIR}/SetUtils.cmake")

# Ignore warnings coming from TPL headers (see #1458)
TRIL_SET_BOOL_CACHE_VAR(${PROJECT_NAME}_TPL_SYSTEM_INCLUDE_DIRS TRUE)

# Disable a bunch of TPLs that are not to be enabled in CI testing (since
# the SEMS env does not have them).
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_GLM OFF)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_Matio OFF)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_X11 OFF)

# Default enable the TPLs that SEMS provides
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_Pthread ON)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_BLAS ON)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_LAPACK ON)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_Boost ON)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_BoostLib ON)
IF (TPL_ENABLE_MPI)
  TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_Scotch ON)
  TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_ParMETIS ON)
ENDIF()
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_Zlib ON)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_HDF5 ON)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_Netcdf ON)
TRIL_SET_BOOL_CACHE_VAR(TPL_ENABLE_SuperLU ON)

# We want to see tracing of added tests to help in debugging
# problems.
TRIL_SET_BOOL_CACHE_VAR(Trilinos_TRACE_ADD_TEST ON)

# Disable long-failing Piro test until it can be fixed (#826)
TRIL_SET_BOOL_CACHE_VAR(Piro_EpetraSolver_MPI_4_DISABLE ON)

# Disable test that was enabled when Scotch TPL was enabled (#2051, #2052)
TRIL_SET_BOOL_CACHE_VAR(Zoltan2_orderingTestDriverExample_MPI_1_DISABLE ON)
