/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "buildpicunitsworker.h"

#include <QMetaType>
#include <QBuffer>
#include <QCryptographicHash>

BuildPicUnitsWorker::BuildPicUnitsWorker()
{
    //自定义结构提，线程传递时无法放入列表，注册解决
    qRegisterMetaType<BgInfo>("BgInfo");
    exitFlag = false;
    filenameList.clear();
}

BuildPicUnitsWorker::~BuildPicUnitsWorker()
{
    delete xmlHandleObj;
    xmlHandleObj = nullptr;
}

void BuildPicUnitsWorker::run(){
    //构建xmlhandle对象
    xmlHandleObj = new XmlHandle();
    //解析壁纸数据，如果本地xml文件不存在则自动构建
    xmlHandleObj->init();
    QByteArray allData = "";
    //获取本地壁纸列表
    QMap<QString, BgInfo> wholeBgInfo = BgFileParse::bgFileReader();
    for (BgInfo sinBfInfo : wholeBgInfo){
        if (exitFlag) {
            return;
        }
        QFile file(sinBfInfo.filename);
        if(file.open(QIODevice::ReadOnly)) {//打开文件（只读
            QByteArray content = file.readAll();
            allData += content;
            file.close();
        }
        filenameList.append(sinBfInfo.filename);
    }
    QByteArray hashDataWrite = QCryptographicHash::hash(allData, QCryptographicHash::Md5);
    QFile hashFile;
    hashFile.setFileName(LOCAL_WALLPAPER_HASH_PATH);
    if (hashFile.open(QIODevice::ReadOnly)) {
        QByteArray hashDataRead = hashFile.readAll();
        hashFile.close();
        if (hashDataRead.compare(hashDataWrite) == 0) { //和已保存的一样
            QDir dir(LOCAL_WALLPAPER_PATH);
            QFileInfoList fileInfoList = dir.entryInfoList(QDir::Files | QDir::NoDotAndDotDot | QDir::Dirs);
            if ((fileInfoList.size() - 1) == filenameList.size()) { //文件数量也一致
                emit readWallPaper_data(filenameList);
                return;
            }
        }
    }
    //未保存正确的缩略壁纸，先创建pixmap发送到wallpaper进行显示
    for (BgInfo sinBfInfo : wholeBgInfo) {
        QString filename = sinBfInfo.filename;
        QPixmap pixmap = QPixmap(filename).scaled(QSize(166, 110));
        if (exitFlag) {
            return;
        }
        emit pixmapGeneral(pixmap, sinBfInfo);
    }

    //保存正确的缩略壁纸
    QDir dir;
    dir.setPath(LOCAL_WALLPAPER_PATH);
    if (dir.exists()) {
        dir.removeRecursively();
        qDebug()<<"removeRecursively:"<<LOCAL_WALLPAPER_PATH;
    }

    if (dir.mkpath(LOCAL_WALLPAPER_PATH)) {
        qDebug()<<"mkpath "<<LOCAL_WALLPAPER_PATH<<"  success.";
        int num = 0; //确保显示顺序与xml中的一致
        //写图片
        for (QString filename : filenameList) {
            if (exitFlag) {
                return;
            }
            QPixmap pixmap = QPixmap(filename).scaled(QSize(166, 110));
            QFile wallpaperFile;
            filename.replace("/","-");
            wallpaperFile.setFileName(LOCAL_WALLPAPER_PATH + QString::number(num) + filename);
            QFileInfo fileinfo = QFileInfo(filename);
            pixmap.save(&wallpaperFile, fileinfo.suffix().toUtf8().data());
            num++;

        }
        //写hash
        if (hashFile.open(QIODevice::WriteOnly)) {
            hashFile.write(hashDataWrite);
            hashFile.close();
        }

    } else {
        qDebug()<<"mkpath "<<LOCAL_WALLPAPER_PATH<<"  failed.";
    }
    return;
}

void BuildPicUnitsWorker::setExit(bool falg)
{
    this->exitFlag = falg;
    return;
}
