/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TUserSettings.h"

TUserSettings::TUserSettings()
{
	settings = new QSettings("VideoCut", "VideoCut");
}


TUserSettings::~TUserSettings(void)
{

}

void TUserSettings::readSettings() // read settings
{
    // main window settings
    settings->beginGroup("MainWindow");
	toolbarSize = settings->value("toolbarSize", 48).toInt();
	geometry = settings->value("geometry", QRect(0, 0, 700, 600)).toRect();
	path = settings->value("path", "~/").toString();
	showPanel = settings->value("showPanel", true).toBool();
    settings->endGroup();
	
	// preview settings
	settings->beginGroup("Preview");
	countFrames = settings->value("countFrames", 15).toInt();
	countHor = settings->value("countHor", 3).toInt();
	indentBorder = settings->value("indentBorder", 20).toInt();
	indentItems = settings->value("indentItems", 20).toInt();
	scale = settings->value("scale", 40).toDouble();
	style = settings->value("style", 0).toInt();
	quality = settings->value("quality", 70).toInt();
	formatImg = settings->value("formatImg", 0).toInt();
	logo = settings->value("logo", true).toBool();
	
	infoName = settings->value("infoName", true).toBool();
	infoSize = settings->value("infoSize", true).toBool();
	infoDuration = settings->value("infoDuration", true).toBool();
	infoResolution = settings->value("infoResolution", true).toBool();
	infoVideo = settings->value("infoVideo", true).toBool();
	infoAudio = settings->value("infoAudio", true).toBool();
	
	settings->endGroup();
	
	// time settings
	settings->beginGroup("Time");
	indentTimeStart = settings->value("indentTimeStart").value<QTime>();
	indentTimeFinish = settings->value("indentTimeFinish").value<QTime>();
	
	settings->endGroup();

    // fonts settings
    settings->beginGroup("Fonts");
    fontMetaInfo = settings->value("fontMetaInfo").value<QFont>();
    fontTimeInfo = settings->value("fontTimeInfo").value<QFont>();
    settings->endGroup();
	
	// colors settings
	settings->beginGroup("Colors");
	colorInfoText = settings->value("colorInfoText", QColor(0, 0, 0, 255)).value<QColor>();
	colorInfoInfo = settings->value("colorInfoInfo", QColor(0, 0, 0, 255)).value<QColor>();
	colorBackground = settings->value("colorBackground", QColor(255, 255, 255, 255)).value<QColor>();
	settings->endGroup();
}

void TUserSettings::writeSettings() // write settings
{
    // main window settings
    settings->beginGroup("MainWindow");
	settings->setValue("toolbarSize", toolbarSize);
	settings->setValue("geometry", geometry);
	settings->setValue("path", path);
	settings->setValue("showPanel", showPanel);
    settings->endGroup();
	
	// preview settings
	settings->beginGroup("Preview");
	settings->setValue("countFrames", countFrames);
	settings->setValue("countHor", countHor);
	settings->setValue("indentBorder", indentBorder);
	settings->setValue("indentItems", indentItems);
	settings->setValue("scale", scale);
	settings->setValue("style", style);
	settings->setValue("quality", quality);
	settings->setValue("formatImg", formatImg);
	settings->setValue("logo", logo);
	
	settings->setValue("infoName", infoName);
	settings->setValue("infoSize", infoSize);
	settings->setValue("infoDuration", infoDuration);
	settings->setValue("infoResolution", infoResolution);
	settings->setValue("infoVideo", infoVideo);
	settings->setValue("infoAudio", infoAudio);
	settings->endGroup();
	
	// time settings
	settings->beginGroup("Time");
	settings->setValue("indentTimeStart", indentTimeStart);
	settings->setValue("indentTimeFinish", indentTimeFinish);
	settings->endGroup();

    // fonts settings
    settings->beginGroup("Fonts");
    settings->setValue("fontMetaInfo", fontMetaInfo);
    settings->setValue("fontTimeInfo", fontTimeInfo);
    settings->endGroup();
	
	// colors settings
	settings->beginGroup("Colors");
	settings->setValue("colorInfoText", colorInfoText);
	settings->setValue("colorInfoInfo", colorInfoInfo);
	settings->setValue("colorBackground", colorBackground);
	settings->endGroup();
}

void TUserSettings::sync()
{
    settings->sync();
}

/////// returning functions ////////

int TUserSettings::getToolbarSize()
{
	return toolbarSize;
}

QRect TUserSettings::getGeometry()
{
	return geometry;
}

QString TUserSettings::getPath()
{
	return path;
}

bool TUserSettings::getShowPanel()
{
	return showPanel;
}

QFont TUserSettings::getFontMetaInfo()
{
    return fontMetaInfo;
}

QFont TUserSettings::getFontTimeInfo()
{
    return fontTimeInfo;
}

int TUserSettings::getCountFrames()
{
	return countFrames;
}

int TUserSettings::getCountHor()
{
	return countHor;
}

int TUserSettings::getIndentBorder()
{
	return indentBorder;
}

int TUserSettings::getIndentItems()
{
	return indentItems;
}

qreal TUserSettings::getScale()
{
	return scale;
}

int TUserSettings::getStyle()
{
	return style;
}

int TUserSettings::getQuality()
{
	return quality;
}

int TUserSettings::getFormatImg()
{
	if(formatImg > 2 || formatImg < 0)
		formatImg = 0;
	return formatImg;
}

bool TUserSettings::getLogo()
{
	return logo;
}

QTime TUserSettings::getIndentTimeStart()
{
	return indentTimeStart;
}

QTime TUserSettings::getIndentTimeFinish()
{
	return indentTimeFinish;
}

bool TUserSettings::getInfoName()
{
	return infoName;
}

bool TUserSettings::getInfoSize()
{
	return infoSize;
}

bool TUserSettings::getInfoDuration()
{
	return infoDuration;
}

bool TUserSettings::getInfoResolution()
{
	return infoResolution;
}

bool TUserSettings::getInfoVideo()
{
	return infoVideo;
}

bool TUserSettings::getInfoAudio()
{
	return infoAudio;
}

QColor TUserSettings::getColorInfoText()
{
	return colorInfoText;
}

QColor TUserSettings::getColorInfoInfo()
{
	return colorInfoInfo;
}

QColor TUserSettings::getColorBackground()
{
	return colorBackground;
}

/////// write functions ////////

void TUserSettings::setToolbarSize(int toolbarSize)
{
	this->toolbarSize = toolbarSize;
}

void TUserSettings::setGeometry(QRect geometry)
{
	this->geometry = geometry;
}

void TUserSettings::setPath(QString path)
{
	this->path = path;
}

void TUserSettings::setShowPanel(bool showPanel)
{
	this->showPanel = showPanel;
}

void TUserSettings::setFontMetaInfo(QFont fontMetaInfo)
{
     this->fontMetaInfo = fontMetaInfo;
}

void TUserSettings::setFontTimeInfo(QFont fontTimeInfo)
{
    this->fontTimeInfo = fontTimeInfo;
}

void TUserSettings::setCountFrames(int countFrames)
{
	this->countFrames = countFrames;
}

void TUserSettings::setCountHor(int countHor)
{
	this->countHor = countHor;
}

void TUserSettings::setIndentBorder(int indentBorder)
{
	this->indentBorder = indentBorder;
}
	
void TUserSettings::setIndentItems(int indentItems)
{
	this->indentItems = indentItems;
}

void TUserSettings::setScale(qreal scale)
{
	this->scale = scale;
}

void TUserSettings::setStyle(int style)
{
	this->style = style;
}

void TUserSettings::setQuality(int quality)
{
	this->quality = quality;
}

void TUserSettings::setFormatImg(int formatImg)
{
	this->formatImg = formatImg;
}

void TUserSettings::setLogo(bool logo)
{
	this->logo = logo;
}

void TUserSettings::setIndentTimeStart(QTime indentTimeStart)
{
	this->indentTimeStart = indentTimeStart;
}

void TUserSettings::setIndentTimeFinish(QTime indentTimeFinish)
{
	this->indentTimeFinish = indentTimeFinish;
}

void TUserSettings::setInfoName(bool infoName)
{
	this->infoName = infoName;
}

void TUserSettings::setInfoSize(bool infoSize)
{
	this->infoSize = infoSize;
}

void TUserSettings::setInfoDuration(bool infoDuration)
{
	this->infoDuration = infoDuration;
}

void TUserSettings::setInfoResolution(bool infoResolution)
{
	this->infoResolution = infoResolution;
}

void TUserSettings::setInfoVideo(bool infoVideo)
{
	this->infoVideo = infoVideo;
}

void TUserSettings::setInfoAudio(bool infoAudio)
{
	this->infoAudio = infoAudio;
}

void TUserSettings::setColorInfoText(QColor colorInfoText)
{
	this->colorInfoText = colorInfoText;
}

void TUserSettings::setColorInfoInfo(QColor colorInfoInfo)
{
	this->colorInfoInfo = colorInfoInfo;
}

void TUserSettings::setColorBackground(QColor colorBackground)
{
	this->colorBackground = colorBackground;
}
