/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-f1ap.c                                                              */
/* asn2wrs.py -q -L -p f1ap -c ./f1ap.cnf -s ./packet-f1ap-template -D . -O ../.. F1AP-CommonDataTypes.asn F1AP-Constants.asn F1AP-Containers.asn F1AP-IEs.asn F1AP-PDU-Contents.asn F1AP-PDU-Descriptions.asn */

/* packet-f1ap.c
 * Routines for E-UTRAN F1 Application Protocol (F1AP) packet dissection
 * Copyright 2018-2025, Pascal Quantin <pascal@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * References: 3GPP TS 38.473 V18.6.0 (2025-06)
 */

#include "config.h"

#include <epan/packet.h>

#include <epan/asn1.h>
#include <epan/sctpppids.h>
#include <epan/proto_data.h>
#include <epan/stats_tree.h>
#include <epan/tfs.h>
#include <epan/unit_strings.h>
#include <wsutil/array.h>

#include "packet-per.h"
#include "packet-f1ap.h"
#include "packet-x2ap.h"
#include "packet-nr-rrc.h"
#include "packet-e212.h"
#include "packet-pdcp-nr.h"
#include "packet-lte-rrc.h"
#include "packet-nrppa.h"
#include "packet-lpp.h"

#define PNAME  "F1 Application Protocol"
#define PSNAME "F1AP"
#define PFNAME "f1ap"

#define SCTP_PORT_F1AP 38472

void proto_register_f1ap(void);
void proto_reg_handoff_f1ap(void);

#define maxPrivateIEs                  65535
#define maxProtocolExtensions          65535
#define maxProtocolIEs                 65535
#define maxNRARFCN                     3279165
#define maxnoofErrors                  256
#define maxnoofIndividualF1ConnectionsToReset 65536
#define maxCellingNBDU                 512
#define maxnoofSCells                  32
#define maxnoofSRBs                    8
#define maxnoofDRBs                    64
#define maxnoofULUPTNLInformation      2
#define maxnoofDLUPTNLInformation      2
#define maxnoofBPLMNs                  6
#define maxnoofCandidateSpCells        64
#define maxnoofPotentialSpCells        64
#define maxnoofNrCellBands             32
#define maxnoofSIBTypes                32
#define maxnoofSITypes                 32
#define maxnoofPagingCells             512
#define maxnoofTNLAssociations         32
#define maxnoofQoSFlows                64
#define maxnoofSliceItems              1024
#define maxCellineNB                   256
#define maxnoofExtendedBPLMNs          6
#define maxnoofUEIDs                   65536
#define maxnoofBPLMNsNR                12
#define maxnoofUACPLMNs                12
#define maxnoofUACperPLMN              64
#define maxnoofAdditionalSIBs          63
#define maxnoofslots                   5120
#define maxnoofTLAs                    16
#define maxnoofGTPTLAs                 16
#define maxnoofBHRLCChannels           65536
#define maxnoofRoutingEntries          1024
#define maxnoofIABSTCInfo              45
#define maxnoofSymbols                 14
#define maxnoofServingCells            32
#define maxnoofDUFSlots                320
#define maxnoofHSNASlots               5120
#define maxnoofServedCellsIAB          512
#define maxnoofSSBarea                 64
#define maxnoofChildIABNodes           1024
#define maxnoofNonUPTrafficMappings    32
#define maxnoofTLAsIAB                 1024
#define maxnoofMappingEntries          67108864
#define maxnoofDSInfo                  64
#define maxnoofEgressLinks             2
#define maxnoofULUPTNLInformationforIAB 32678
#define maxnoofUPTNLAddresses          8
#define maxnoofSLDRBs                  512
#define maxnoofQoSParaSets             8
#define maxnoofPC5QoSFlows             2048
#define maxnoofSSBAreas                64
#define maxnoofPhysicalResourceBlocks  275
#define maxnoofPhysicalResourceBlocks_1 274
#define maxnoofPRACHconfigs            16
#define maxnoofRAReports               64
#define maxnoofRLFReports              64
#define maxnoofAdditionalPDCPDuplicationTNL 2
#define maxnoofRLCDuplicationState     3
#define maxnoofCHOcells                8
#define maxnoofMDTPLMNs                16
#define maxnoofCAGsupported            12
#define maxnoofNIDsupported            12
#define maxnoofNRSCSs                  5
#define maxnoofExtSliceItems           65535
#define maxnoofPosMeas                 16384
#define maxnoofTRPInfoTypes            64
#define maxnoofTRPs                    65535
#define maxnoofSRSTriggerStates        3
#define maxnoofSpatialRelations        64
#define maxnoBcastCell                 16384
#define maxnoofAngleInfo               65535
#define maxnooflcs_gcs_translation     3
#define maxnoofPath                    2
#define maxnoofMeasE_CID               64
#define maxnoofSSBs                    255
#define maxnoSRS_ResourceSets          16
#define maxnoSRS_ResourcePerSet        16
#define maxnoSRS_Carriers              32
#define maxnoSCSs                      5
#define maxnoSRS_Resources             64
#define maxnoSRS_PosResources          64
#define maxnoSRS_PosResourceSets       16
#define maxnoSRS_PosResourcePerSet     16
#define maxnoofPRS_ResourceSets        2
#define maxnoofPRS_ResourcesPerSet     64
#define maxNoOfMeasTRPs                64
#define maxnoofPRSresourceSets         8
#define maxnoofPRSresources            64
#define maxnoofSuccessfulHOReports     64
#define maxnoofNR_UChannelIDs          16
#define maxServedCellforSON            256
#define maxNeighbourCellforSON         32
#define maxAffectedCells               32
#define maxnoofMRBs                    32
#define maxnoofMBSQoSFlows             64
#define maxnoofMBSFSAs                 256
#define maxnoofUEIDforPaging           4096
#define maxnoofCellsforMBS             512
#define maxnoofTAIforMBS               512
#define maxnoofMBSAreaSessionIDs       256
#define maxnoofMBSServiceAreaInformation 256
#define maxnoofIABCongInd              1024
#define maxnoofNeighbourNodeCellsIAB   1024
#define maxnoofRBsetsPerCell           8
#define maxnoofRBsetsPerCell_1         7
#define maxnoofMeasPDC                 16
#define maxnoARPs                      16
#define maxnoofULAoAs                  8
#define maxNoPathExtended              8
#define maxnoTRPTEGs                   8
#define maxFreqLayers                  4
#define maxNumResourcesPerAngle        24
#define maxnoAzimuthAngles             3600
#define maxnoElevationAngles           1801
#define maxnoofPRSTRPs                 256
#define maxnoofQoEInformation          16
#define maxnoofUuRLCChannels           32
#define maxnoofPC5RLCChannels          512
#define maxnoofSMBRValues              8
#define maxnoofMRBsforUE               64
#define maxnoofMBSSessionsofUE         256
#define maxnoofSLdestinations          32
#define maxnoofNSAGs                   256
#define maxnoofSDTBearers              72
#define maxnoofServingCellMOs          16
#define maxNrofBWPs                    8
#define maxnoofPosSITypes              32
#define maxnoofUETypes                 8
#define maxnoofLTMCells                8
#define maxnoofTAList                  8
#define maxnoofLTMgNB_DUs              8
#define maxnoofUEsInQMCTransferControlMessage 512
#define maxnoofUEsforRAReportIndications 64
#define maxnoofSuccessfulPSCellChangeReports 64
#define maxnoofPeriodicities           8
#define maxnoofThresholdMBS_1          7
#define maxMBSSessionsinSessionInfoList 1024
#define maxnoofLBTFailureInformation   64
#define maxnoofRSPPQoSFlows            2048
#define maxnoVACell                    32
#define maxnoAggregatedSRS_Resources   3
#define maxnoAggregatedPosSRSResourceSets 3
#define maxnoAggregatedPosPRSResourceSets 3
#define maxnoofTimeWindowSRS           16
#define maxnoofTimeWindowMea           16
#define maxnoPreconfiguredSRS          16
#define maxnoHopsMinusOne              5
#define maxnoAggCombinations           2
#define maxnoAggregatedPosSRSCombinations 32
#define maxnoofCandidateCells          8
#define maxnoofSSBIndices              64

typedef enum _ProcedureCode_enum {
  id_Reset     =   0,
  id_F1Setup   =   1,
  id_ErrorIndication =   2,
  id_gNBDUConfigurationUpdate =   3,
  id_gNBCUConfigurationUpdate =   4,
  id_UEContextSetup =   5,
  id_UEContextRelease =   6,
  id_UEContextModification =   7,
  id_UEContextModificationRequired =   8,
  id_procedure_code_9_not_to_be_used =   9,
  id_UEContextReleaseRequest =  10,
  id_InitialULRRCMessageTransfer =  11,
  id_DLRRCMessageTransfer =  12,
  id_ULRRCMessageTransfer =  13,
  id_privateMessage =  14,
  id_UEInactivityNotification =  15,
  id_GNBDUResourceCoordination =  16,
  id_SystemInformationDeliveryCommand =  17,
  id_Paging    =  18,
  id_Notify    =  19,
  id_WriteReplaceWarning =  20,
  id_PWSCancel =  21,
  id_PWSRestartIndication =  22,
  id_PWSFailureIndication =  23,
  id_GNBDUStatusIndication =  24,
  id_RRCDeliveryReport =  25,
  id_F1Removal =  26,
  id_NetworkAccessRateReduction =  27,
  id_TraceStart =  28,
  id_DeactivateTrace =  29,
  id_DUCURadioInformationTransfer =  30,
  id_CUDURadioInformationTransfer =  31,
  id_BAPMappingConfiguration =  32,
  id_GNBDUResourceConfiguration =  33,
  id_IABTNLAddressAllocation =  34,
  id_IABUPConfigurationUpdate =  35,
  id_resourceStatusReportingInitiation =  36,
  id_resourceStatusReporting =  37,
  id_accessAndMobilityIndication =  38,
  id_accessSuccess =  39,
  id_cellTrafficTrace =  40,
  id_PositioningMeasurementExchange =  41,
  id_PositioningAssistanceInformationControl =  42,
  id_PositioningAssistanceInformationFeedback =  43,
  id_PositioningMeasurementReport =  44,
  id_PositioningMeasurementAbort =  45,
  id_PositioningMeasurementFailureIndication =  46,
  id_PositioningMeasurementUpdate =  47,
  id_TRPInformationExchange =  48,
  id_PositioningInformationExchange =  49,
  id_PositioningActivation =  50,
  id_PositioningDeactivation =  51,
  id_E_CIDMeasurementInitiation =  52,
  id_E_CIDMeasurementFailureIndication =  53,
  id_E_CIDMeasurementReport =  54,
  id_E_CIDMeasurementTermination =  55,
  id_PositioningInformationUpdate =  56,
  id_ReferenceTimeInformationReport =  57,
  id_ReferenceTimeInformationReportingControl =  58,
  id_BroadcastContextSetup =  59,
  id_BroadcastContextRelease =  60,
  id_BroadcastContextReleaseRequest =  61,
  id_BroadcastContextModification =  62,
  id_MulticastGroupPaging =  63,
  id_MulticastContextSetup =  64,
  id_MulticastContextRelease =  65,
  id_MulticastContextReleaseRequest =  66,
  id_MulticastContextModification =  67,
  id_MulticastDistributionSetup =  68,
  id_MulticastDistributionRelease =  69,
  id_PDCMeasurementInitiation =  70,
  id_PDCMeasurementReport =  71,
  id_procedure_code_72_not_to_be_used =  72,
  id_procedure_code_73_not_to_be_used =  73,
  id_procedure_code_74_not_to_be_used =  74,
  id_pRSConfigurationExchange =  75,
  id_measurementPreconfiguration =  76,
  id_measurementActivation =  77,
  id_QoEInformationTransfer =  78,
  id_PDCMeasurementTerminationCommand =  79,
  id_PDCMeasurementFailureIndication =  80,
  id_PosSystemInformationDeliveryCommand =  81,
  id_DUCUCellSwitchNotification =  82,
  id_CUDUCellSwitchNotification =  83,
  id_DUCUTAInformationTransfer =  84,
  id_CUDUTAInformationTransfer =  85,
  id_QoEInformationTransferControl =  86,
  id_RachIndication =  87,
  id_TimingSynchronisationStatus =  88,
  id_TimingSynchronisationStatusReport =  89,
  id_MIABF1SetupTriggering =  90,
  id_MIABF1SetupOutcomeNotification =  91,
  id_MulticastContextNotification =  92,
  id_MulticastCommonConfiguration =  93,
  id_BroadcastTransportResourceRequest =  94,
  id_DUCUAccessAndMobilityIndication =  95,
  id_SRSInformationReservationNotification =  96,
  id_CUDUMobilityInitiationRequest =  97
} ProcedureCode_enum;

typedef enum _ProtocolIE_ID_enum {
  id_Cause     =   0,
  id_Cells_Failed_to_be_Activated_List =   1,
  id_Cells_Failed_to_be_Activated_List_Item =   2,
  id_Cells_to_be_Activated_List =   3,
  id_Cells_to_be_Activated_List_Item =   4,
  id_Cells_to_be_Deactivated_List =   5,
  id_Cells_to_be_Deactivated_List_Item =   6,
  id_CriticalityDiagnostics =   7,
  id_CUtoDURRCInformation =   9,
  id_Unknown_10 =  10,
  id_Unknown_11 =  11,
  id_DRBs_FailedToBeModified_Item =  12,
  id_DRBs_FailedToBeModified_List =  13,
  id_DRBs_FailedToBeSetup_Item =  14,
  id_DRBs_FailedToBeSetup_List =  15,
  id_DRBs_FailedToBeSetupMod_Item =  16,
  id_DRBs_FailedToBeSetupMod_List =  17,
  id_DRBs_ModifiedConf_Item =  18,
  id_DRBs_ModifiedConf_List =  19,
  id_DRBs_Modified_Item =  20,
  id_DRBs_Modified_List =  21,
  id_DRBs_Required_ToBeModified_Item =  22,
  id_DRBs_Required_ToBeModified_List =  23,
  id_DRBs_Required_ToBeReleased_Item =  24,
  id_DRBs_Required_ToBeReleased_List =  25,
  id_DRBs_Setup_Item =  26,
  id_DRBs_Setup_List =  27,
  id_DRBs_SetupMod_Item =  28,
  id_DRBs_SetupMod_List =  29,
  id_DRBs_ToBeModified_Item =  30,
  id_DRBs_ToBeModified_List =  31,
  id_DRBs_ToBeReleased_Item =  32,
  id_DRBs_ToBeReleased_List =  33,
  id_DRBs_ToBeSetup_Item =  34,
  id_DRBs_ToBeSetup_List =  35,
  id_DRBs_ToBeSetupMod_Item =  36,
  id_DRBs_ToBeSetupMod_List =  37,
  id_DRXCycle  =  38,
  id_DUtoCURRCInformation =  39,
  id_gNB_CU_UE_F1AP_ID =  40,
  id_gNB_DU_UE_F1AP_ID =  41,
  id_gNB_DU_ID =  42,
  id_GNB_DU_Served_Cells_Item =  43,
  id_gNB_DU_Served_Cells_List =  44,
  id_gNB_DU_Name =  45,
  id_ProtocolIE_ID_46_not_to_be_used =  46,
  id_oldgNB_DU_UE_F1AP_ID =  47,
  id_ResetType =  48,
  id_ResourceCoordinationTransferContainer =  49,
  id_RRCContainer =  50,
  id_SCell_ToBeRemoved_Item =  51,
  id_SCell_ToBeRemoved_List =  52,
  id_SCell_ToBeSetup_Item =  53,
  id_SCell_ToBeSetup_List =  54,
  id_SCell_ToBeSetupMod_Item =  55,
  id_SCell_ToBeSetupMod_List =  56,
  id_Served_Cells_To_Add_Item =  57,
  id_Served_Cells_To_Add_List =  58,
  id_Served_Cells_To_Delete_Item =  59,
  id_Served_Cells_To_Delete_List =  60,
  id_Served_Cells_To_Modify_Item =  61,
  id_Served_Cells_To_Modify_List =  62,
  id_SpCell_ID =  63,
  id_SRBID     =  64,
  id_SRBs_FailedToBeSetup_Item =  65,
  id_SRBs_FailedToBeSetup_List =  66,
  id_SRBs_FailedToBeSetupMod_Item =  67,
  id_SRBs_FailedToBeSetupMod_List =  68,
  id_SRBs_Required_ToBeReleased_Item =  69,
  id_SRBs_Required_ToBeReleased_List =  70,
  id_SRBs_ToBeReleased_Item =  71,
  id_SRBs_ToBeReleased_List =  72,
  id_SRBs_ToBeSetup_Item =  73,
  id_SRBs_ToBeSetup_List =  74,
  id_SRBs_ToBeSetupMod_Item =  75,
  id_SRBs_ToBeSetupMod_List =  76,
  id_TimeToWait =  77,
  id_TransactionID =  78,
  id_TransmissionActionIndicator =  79,
  id_UE_associatedLogicalF1_ConnectionItem =  80,
  id_UE_associatedLogicalF1_ConnectionListResAck =  81,
  id_gNB_CU_Name =  82,
  id_SCell_FailedtoSetup_List =  83,
  id_SCell_FailedtoSetup_Item =  84,
  id_SCell_FailedtoSetupMod_List =  85,
  id_SCell_FailedtoSetupMod_Item =  86,
  id_RRCReconfigurationCompleteIndicator =  87,
  id_Cells_Status_Item =  88,
  id_Cells_Status_List =  89,
  id_Candidate_SpCell_List =  90,
  id_Candidate_SpCell_Item =  91,
  id_Potential_SpCell_List =  92,
  id_Potential_SpCell_Item =  93,
  id_FullConfiguration =  94,
  id_C_RNTI    =  95,
  id_SpCellULConfigured =  96,
  id_InactivityMonitoringRequest =  97,
  id_InactivityMonitoringResponse =  98,
  id_DRB_Activity_Item =  99,
  id_DRB_Activity_List = 100,
  id_EUTRA_NR_CellResourceCoordinationReq_Container = 101,
  id_EUTRA_NR_CellResourceCoordinationReqAck_Container = 102,
  id_Unknown_103 = 103,
  id_Unknown_104 = 104,
  id_Protected_EUTRA_Resources_List = 105,
  id_RequestType = 106,
  id_ServCellIndex = 107,
  id_RAT_FrequencyPriorityInformation = 108,
  id_ExecuteDuplication = 109,
  id_Unknown_110 = 110,
  id_NRCGI     = 111,
  id_PagingCell_Item = 112,
  id_PagingCell_List = 113,
  id_PagingDRX = 114,
  id_PagingPriority = 115,
  id_SItype_List = 116,
  id_UEIdentityIndexValue = 117,
  id_gNB_CUSystemInformation = 118,
  id_HandoverPreparationInformation = 119,
  id_GNB_CU_TNL_Association_To_Add_Item = 120,
  id_GNB_CU_TNL_Association_To_Add_List = 121,
  id_GNB_CU_TNL_Association_To_Remove_Item = 122,
  id_GNB_CU_TNL_Association_To_Remove_List = 123,
  id_GNB_CU_TNL_Association_To_Update_Item = 124,
  id_GNB_CU_TNL_Association_To_Update_List = 125,
  id_MaskedIMEISV = 126,
  id_PagingIdentity = 127,
  id_DUtoCURRCContainer = 128,
  id_Cells_to_be_Barred_List = 129,
  id_Cells_to_be_Barred_Item = 130,
  id_TAISliceSupportList = 131,
  id_GNB_CU_TNL_Association_Setup_List = 132,
  id_GNB_CU_TNL_Association_Setup_Item = 133,
  id_GNB_CU_TNL_Association_Failed_To_Setup_List = 134,
  id_GNB_CU_TNL_Association_Failed_To_Setup_Item = 135,
  id_DRB_Notify_Item = 136,
  id_DRB_Notify_List = 137,
  id_ProtocolIE_ID_138_not_to_be_used = 138,
  id_RANAC     = 139,
  id_PWSSystemInformation = 140,
  id_RepetitionPeriod = 141,
  id_NumberofBroadcastRequest = 142,
  id_Unknown_143 = 143,
  id_Cells_To_Be_Broadcast_List = 144,
  id_Cells_To_Be_Broadcast_Item = 145,
  id_Cells_Broadcast_Completed_List = 146,
  id_Cells_Broadcast_Completed_Item = 147,
  id_Broadcast_To_Be_Cancelled_List = 148,
  id_Broadcast_To_Be_Cancelled_Item = 149,
  id_Cells_Broadcast_Cancelled_List = 150,
  id_Cells_Broadcast_Cancelled_Item = 151,
  id_NR_CGI_List_For_Restart_List = 152,
  id_NR_CGI_List_For_Restart_Item = 153,
  id_PWS_Failed_NR_CGI_List = 154,
  id_PWS_Failed_NR_CGI_Item = 155,
  id_ConfirmedUEID = 156,
  id_Cancel_all_Warning_Messages_Indicator = 157,
  id_GNB_DU_UE_AMBR_UL = 158,
  id_DRXConfigurationIndicator = 159,
  id_RLC_Status = 160,
  id_DLPDCPSNLength = 161,
  id_GNB_DUConfigurationQuery = 162,
  id_MeasurementTimingConfiguration = 163,
  id_DRB_Information = 164,
  id_ServingPLMN = 165,
  id_Unknown_166 = 166,
  id_Unknown_167 = 167,
  id_Protected_EUTRA_Resources_Item = 168,
  id_Unknown_169 = 169,
  id_GNB_CU_RRC_Version = 170,
  id_GNB_DU_RRC_Version = 171,
  id_GNBDUOverloadInformation = 172,
  id_CellGroupConfig = 173,
  id_RLCFailureIndication = 174,
  id_UplinkTxDirectCurrentListInformation = 175,
  id_DC_Based_Duplication_Configured = 176,
  id_DC_Based_Duplication_Activation = 177,
  id_SULAccessIndication = 178,
  id_AvailablePLMNList = 179,
  id_PDUSessionID = 180,
  id_ULPDUSessionAggregateMaximumBitRate = 181,
  id_ServingCellMO = 182,
  id_QoSFlowMappingIndication = 183,
  id_RRCDeliveryStatusRequest = 184,
  id_RRCDeliveryStatus = 185,
  id_BearerTypeChange = 186,
  id_RLCMode   = 187,
  id_Duplication_Activation = 188,
  id_Dedicated_SIDelivery_NeededUE_List = 189,
  id_Dedicated_SIDelivery_NeededUE_Item = 190,
  id_DRX_LongCycleStartOffset = 191,
  id_ULPDCPSNLength = 192,
  id_SelectedBandCombinationIndex = 193,
  id_SelectedFeatureSetEntryIndex = 194,
  id_ResourceCoordinationTransferInformation = 195,
  id_ExtendedServedPLMNs_List = 196,
  id_ExtendedAvailablePLMN_List = 197,
  id_Associated_SCell_List = 198,
  id_latest_RRC_Version_Enhanced = 199,
  id_Associated_SCell_Item = 200,
  id_Cell_Direction = 201,
  id_SRBs_Setup_List = 202,
  id_SRBs_Setup_Item = 203,
  id_SRBs_SetupMod_List = 204,
  id_SRBs_SetupMod_Item = 205,
  id_SRBs_Modified_List = 206,
  id_SRBs_Modified_Item = 207,
  id_Ph_InfoSCG = 208,
  id_RequestedBandCombinationIndex = 209,
  id_RequestedFeatureSetEntryIndex = 210,
  id_RequestedP_MaxFR2 = 211,
  id_DRX_Config = 212,
  id_IgnoreResourceCoordinationContainer = 213,
  id_UEAssistanceInformation = 214,
  id_NeedforGap = 215,
  id_PagingOrigin = 216,
  id_new_gNB_CU_UE_F1AP_ID = 217,
  id_RedirectedRRCmessage = 218,
  id_new_gNB_DU_UE_F1AP_ID = 219,
  id_NotificationInformation = 220,
  id_PLMNAssistanceInfoForNetShar = 221,
  id_UEContextNotRetrievable = 222,
  id_BPLMN_ID_Info_List = 223,
  id_SelectedPLMNID = 224,
  id_UAC_Assistance_Info = 225,
  id_RANUEID   = 226,
  id_GNB_DU_TNL_Association_To_Remove_Item = 227,
  id_GNB_DU_TNL_Association_To_Remove_List = 228,
  id_TNLAssociationTransportLayerAddressgNBDU = 229,
  id_portNumber = 230,
  id_AdditionalSIBMessageList = 231,
  id_Cell_Type = 232,
  id_IgnorePRACHConfiguration = 233,
  id_CG_Config = 234,
  id_PDCCH_BlindDetectionSCG = 235,
  id_Requested_PDCCH_BlindDetectionSCG = 236,
  id_Ph_InfoMCG = 237,
  id_MeasGapSharingConfig = 238,
  id_systemInformationAreaID = 239,
  id_areaScope = 240,
  id_RRCContainer_RRCSetupComplete = 241,
  id_TraceActivation = 242,
  id_TraceID   = 243,
  id_Neighbour_Cell_Information_List = 244,
  id_Unknown_245 = 245,
  id_ProtocolIE_ID_246_not_to_be_used = 246,
  id_ProtocolIE_ID_247_not_to_be_used = 247,
  id_AdditionalRRMPriorityIndex = 248,
  id_DUCURadioInformationType = 249,
  id_CUDURadioInformationType = 250,
  id_AggressorgNBSetID = 251,
  id_VictimgNBSetID = 252,
  id_LowerLayerPresenceStatusChange = 253,
  id_Transport_Layer_Address_Info = 254,
  id_Neighbour_Cell_Information_Item = 255,
  id_IntendedTDD_DL_ULConfig = 256,
  id_QosMonitoringRequest = 257,
  id_BHChannels_ToBeSetup_List = 258,
  id_BHChannels_ToBeSetup_Item = 259,
  id_BHChannels_Setup_List = 260,
  id_BHChannels_Setup_Item = 261,
  id_BHChannels_ToBeModified_Item = 262,
  id_BHChannels_ToBeModified_List = 263,
  id_BHChannels_ToBeReleased_Item = 264,
  id_BHChannels_ToBeReleased_List = 265,
  id_BHChannels_ToBeSetupMod_Item = 266,
  id_BHChannels_ToBeSetupMod_List = 267,
  id_BHChannels_FailedToBeModified_Item = 268,
  id_BHChannels_FailedToBeModified_List = 269,
  id_BHChannels_FailedToBeSetupMod_Item = 270,
  id_BHChannels_FailedToBeSetupMod_List = 271,
  id_BHChannels_Modified_Item = 272,
  id_BHChannels_Modified_List = 273,
  id_BHChannels_SetupMod_Item = 274,
  id_BHChannels_SetupMod_List = 275,
  id_BHChannels_Required_ToBeReleased_Item = 276,
  id_BHChannels_Required_ToBeReleased_List = 277,
  id_BHChannels_FailedToBeSetup_Item = 278,
  id_BHChannels_FailedToBeSetup_List = 279,
  id_BHInfo    = 280,
  id_BAPAddress = 281,
  id_ConfiguredBAPAddress = 282,
  id_BH_Routing_Information_Added_List = 283,
  id_BH_Routing_Information_Added_List_Item = 284,
  id_BH_Routing_Information_Removed_List = 285,
  id_BH_Routing_Information_Removed_List_Item = 286,
  id_UL_BH_Non_UP_Traffic_Mapping = 287,
  id_Activated_Cells_to_be_Updated_List = 288,
  id_Child_Nodes_List = 289,
  id_IAB_Info_IAB_DU = 290,
  id_IAB_Info_IAB_donor_CU = 291,
  id_IAB_TNL_Addresses_To_Remove_List = 292,
  id_IAB_TNL_Addresses_To_Remove_Item = 293,
  id_IAB_Allocated_TNL_Address_List = 294,
  id_IAB_Allocated_TNL_Address_Item = 295,
  id_IABIPv6RequestType = 296,
  id_IABv4AddressesRequested = 297,
  id_IAB_Barred = 298,
  id_TrafficMappingInformation = 299,
  id_UL_UP_TNL_Information_to_Update_List = 300,
  id_UL_UP_TNL_Information_to_Update_List_Item = 301,
  id_UL_UP_TNL_Address_to_Update_List = 302,
  id_UL_UP_TNL_Address_to_Update_List_Item = 303,
  id_DL_UP_TNL_Address_to_Update_List = 304,
  id_DL_UP_TNL_Address_to_Update_List_Item = 305,
  id_NRV2XServicesAuthorized = 306,
  id_LTEV2XServicesAuthorized = 307,
  id_NRUESidelinkAggregateMaximumBitrate = 308,
  id_LTEUESidelinkAggregateMaximumBitrate = 309,
  id_SIB12_message = 310,
  id_SIB13_message = 311,
  id_SIB14_message = 312,
  id_SLDRBs_FailedToBeModified_Item = 313,
  id_SLDRBs_FailedToBeModified_List = 314,
  id_SLDRBs_FailedToBeSetup_Item = 315,
  id_SLDRBs_FailedToBeSetup_List = 316,
  id_SLDRBs_Modified_Item = 317,
  id_SLDRBs_Modified_List = 318,
  id_SLDRBs_Required_ToBeModified_Item = 319,
  id_SLDRBs_Required_ToBeModified_List = 320,
  id_SLDRBs_Required_ToBeReleased_Item = 321,
  id_SLDRBs_Required_ToBeReleased_List = 322,
  id_SLDRBs_Setup_Item = 323,
  id_SLDRBs_Setup_List = 324,
  id_SLDRBs_ToBeModified_Item = 325,
  id_SLDRBs_ToBeModified_List = 326,
  id_SLDRBs_ToBeReleased_Item = 327,
  id_SLDRBs_ToBeReleased_List = 328,
  id_SLDRBs_ToBeSetup_Item = 329,
  id_SLDRBs_ToBeSetup_List = 330,
  id_SLDRBs_ToBeSetupMod_Item = 331,
  id_SLDRBs_ToBeSetupMod_List = 332,
  id_SLDRBs_SetupMod_List = 333,
  id_SLDRBs_FailedToBeSetupMod_List = 334,
  id_SLDRBs_SetupMod_Item = 335,
  id_SLDRBs_FailedToBeSetupMod_Item = 336,
  id_SLDRBs_ModifiedConf_List = 337,
  id_SLDRBs_ModifiedConf_Item = 338,
  id_UEAssistanceInformationEUTRA = 339,
  id_PC5LinkAMBR = 340,
  id_SL_PHY_MAC_RLC_Config = 341,
  id_SL_ConfigDedicatedEUTRA_Info = 342,
  id_AlternativeQoSParaSetList = 343,
  id_CurrentQoSParaSetIndex = 344,
  id_gNBCUMeasurementID = 345,
  id_gNBDUMeasurementID = 346,
  id_RegistrationRequest = 347,
  id_ReportCharacteristics = 348,
  id_CellToReportList = 349,
  id_CellMeasurementResultList = 350,
  id_HardwareLoadIndicator = 351,
  id_ReportingPeriodicity = 352,
  id_TNLCapacityIndicator = 353,
  id_CarrierList = 354,
  id_ULCarrierList = 355,
  id_FrequencyShift7p5khz = 356,
  id_SSB_PositionsInBurst = 357,
  id_NRPRACHConfig = 358,
  id_RAReportList = 359,
  id_RLFReportInformationList = 360,
  id_TDD_UL_DLConfigCommonNR = 361,
  id_CNPacketDelayBudgetDownlink = 362,
  id_ExtendedPacketDelayBudget = 363,
  id_TSCTrafficCharacteristics = 364,
  id_ReportingRequestType = 365,
  id_TimeReferenceInformation = 366,
  id_Unknown_367 = 367,
  id_Unknown_368 = 368,
  id_CNPacketDelayBudgetUplink = 369,
  id_AdditionalPDCPDuplicationTNL_List = 370,
  id_RLCDuplicationInformation = 371,
  id_AdditionalDuplicationIndication = 372,
  id_ConditionalInterDUMobilityInformation = 373,
  id_ConditionalIntraDUMobilityInformation = 374,
  id_targetCellsToCancel = 375,
  id_requestedTargetCellGlobalID = 376,
  id_ManagementBasedMDTPLMNList = 377,
  id_TraceCollectionEntityIPAddress = 378,
  id_PrivacyIndicator = 379,
  id_TraceCollectionEntityURI = 380,
  id_mdtConfiguration = 381,
  id_ServingNID = 382,
  id_NPNBroadcastInformation = 383,
  id_NPNSupportInfo = 384,
  id_NID       = 385,
  id_AvailableSNPN_ID_List = 386,
  id_SIB10_message = 387,
  id_Unknown_388 = 388,
  id_DLCarrierList = 389,
  id_ExtendedTAISliceSupportList = 390,
  id_RequestedSRSTransmissionCharacteristics = 391,
  id_PosAssistance_Information = 392,
  id_PosBroadcast = 393,
  id_RoutingID = 394,
  id_PosAssistanceInformationFailureList = 395,
  id_PosMeasurementQuantities = 396,
  id_PosMeasurementResultList = 397,
  id_TRPInformationTypeListTRPReq = 398,
  id_TRPInformationTypeItem = 399,
  id_TRPInformationListTRPResp = 400,
  id_TRPInformationItem = 401,
  id_LMF_MeasurementID = 402,
  id_SRSType   = 403,
  id_ActivationTime = 404,
  id_AbortTransmission = 405,
  id_PositioningBroadcastCells = 406,
  id_SRSConfiguration = 407,
  id_PosReportCharacteristics = 408,
  id_PosMeasurementPeriodicity = 409,
  id_TRPList   = 410,
  id_RAN_MeasurementID = 411,
  id_LMF_UE_MeasurementID = 412,
  id_RAN_UE_MeasurementID = 413,
  id_E_CID_MeasurementQuantities = 414,
  id_E_CID_MeasurementQuantities_Item = 415,
  id_E_CID_MeasurementPeriodicity = 416,
  id_E_CID_MeasurementResult = 417,
  id_Cell_Portion_ID = 418,
  id_SFNInitialisationTime = 419,
  id_SystemFrameNumber = 420,
  id_SlotNumber = 421,
  id_TRP_MeasurementRequestList = 422,
  id_MeasurementBeamInfoRequest = 423,
  id_E_CID_ReportCharacteristics = 424,
  id_ConfiguredTACIndication = 425,
  id_Extended_GNB_CU_Name = 426,
  id_Extended_GNB_DU_Name = 427,
  id_F1CTransferPath = 428,
  id_SFN_Offset = 429,
  id_TransmissionStopIndicator = 430,
  id_SrsFrequency = 431,
  id_SCGIndicator = 432,
  id_EstimatedArrivalProbability = 433,
  id_TRPType   = 434,
  id_SRSSpatialRelationPerSRSResource = 435,
  id_PDCPTerminatingNodeDLTNLAddrInfo = 436,
  id_ENBDLTNLAddress = 437,
  id_PosMeasurementPeriodicityExtended = 438,
  id_PRS_Resource_ID = 439,
  id_LocationMeasurementInformation = 440,
  id_SliceRadioResourceStatus = 441,
  id_CompositeAvailableCapacity_SUL = 442,
  id_SuccessfulHOReportInformationList = 443,
  id_NR_U_Channel_List = 444,
  id_NR_U      = 445,
  id_Coverage_Modification_Notification = 446,
  id_CCO_Assistance_Information = 447,
  id_ProtocolIE_ID_448_not_to_be_used = 448,
  id_CellsForSON_List = 449,
  id_MIMOPRBusageInformation = 450,
  id_gNB_CU_MBS_F1AP_ID = 451,
  id_gNB_DU_MBS_F1AP_ID = 452,
  id_ProtocolIE_ID_453_not_to_be_used = 453,
  id_MBS_CUtoDURRCInformation = 454,
  id_MBS_Session_ID = 455,
  id_SNSSAI    = 456,
  id_MBS_Broadcast_NeighbourCellList = 457,
  id_BroadcastMRBs_FailedToBeModified_List = 458,
  id_BroadcastMRBs_FailedToBeModified_Item = 459,
  id_BroadcastMRBs_FailedToBeSetup_List = 460,
  id_BroadcastMRBs_FailedToBeSetup_Item = 461,
  id_BroadcastMRBs_FailedToBeSetupMod_List = 462,
  id_BroadcastMRBs_FailedToBeSetupMod_Item = 463,
  id_BroadcastMRBs_Modified_List = 464,
  id_BroadcastMRBs_Modified_Item = 465,
  id_BroadcastMRBs_Setup_List = 466,
  id_BroadcastMRBs_Setup_Item = 467,
  id_BroadcastMRBs_SetupMod_List = 468,
  id_BroadcastMRBs_SetupMod_Item = 469,
  id_BroadcastMRBs_ToBeModified_List = 470,
  id_BroadcastMRBs_ToBeModified_Item = 471,
  id_BroadcastMRBs_ToBeReleased_List = 472,
  id_BroadcastMRBs_ToBeReleased_Item = 473,
  id_BroadcastMRBs_ToBeSetup_List = 474,
  id_BroadcastMRBs_ToBeSetup_Item = 475,
  id_BroadcastMRBs_ToBeSetupMod_List = 476,
  id_BroadcastMRBs_ToBeSetupMod_Item = 477,
  id_Supported_MBS_FSA_ID_List = 478,
  id_UEIdentity_List_For_Paging_List = 479,
  id_UEIdentity_List_For_Paging_Item = 480,
  id_MBS_ServiceArea = 481,
  id_MulticastMRBs_FailedToBeModified_List = 482,
  id_MulticastMRBs_FailedToBeModified_Item = 483,
  id_MulticastMRBs_FailedToBeSetup_List = 484,
  id_MulticastMRBs_FailedToBeSetup_Item = 485,
  id_MulticastMRBs_FailedToBeSetupMod_List = 486,
  id_MulticastMRBs_FailedToBeSetupMod_Item = 487,
  id_MulticastMRBs_Modified_List = 488,
  id_MulticastMRBs_Modified_Item = 489,
  id_MulticastMRBs_Setup_List = 490,
  id_MulticastMRBs_Setup_Item = 491,
  id_MulticastMRBs_SetupMod_List = 492,
  id_MulticastMRBs_SetupMod_Item = 493,
  id_MulticastMRBs_ToBeModified_List = 494,
  id_MulticastMRBs_ToBeModified_Item = 495,
  id_MulticastMRBs_ToBeReleased_List = 496,
  id_MulticastMRBs_ToBeReleased_Item = 497,
  id_MulticastMRBs_ToBeSetup_List = 498,
  id_MulticastMRBs_ToBeSetup_Item = 499,
  id_MulticastMRBs_ToBeSetupMod_List = 500,
  id_MulticastMRBs_ToBeSetupMod_Item = 501,
  id_MBSMulticastF1UContextDescriptor = 502,
  id_MulticastF1UContext_ToBeSetup_List = 503,
  id_MulticastF1UContext_ToBeSetup_Item = 504,
  id_MulticastF1UContext_Setup_List = 505,
  id_MulticastF1UContext_Setup_Item = 506,
  id_MulticastF1UContext_FailedToBeSetup_List = 507,
  id_MulticastF1UContext_FailedToBeSetup_Item = 508,
  id_IABCongestionIndication = 509,
  id_IABConditionalRRCMessageDeliveryIndication = 510,
  id_F1CTransferPathNRDC = 511,
  id_BufferSizeThresh = 512,
  id_IAB_TNL_Addresses_Exception = 513,
  id_BAP_Header_Rewriting_Added_List = 514,
  id_BAP_Header_Rewriting_Added_List_Item = 515,
  id_Re_routingEnableIndicator = 516,
  id_NonF1terminatingTopologyIndicator = 517,
  id_EgressNonF1terminatingTopologyIndicator = 518,
  id_IngressNonF1terminatingTopologyIndicator = 519,
  id_rBSetConfiguration = 520,
  id_frequency_Domain_HSNA_Configuration_List = 521,
  id_child_IAB_Nodes_NA_Resource_List = 522,
  id_Parent_IAB_Nodes_NA_Resource_Configuration_List = 523,
  id_uL_FreqInfo = 524,
  id_uL_Transmission_Bandwidth = 525,
  id_dL_FreqInfo = 526,
  id_dL_Transmission_Bandwidth = 527,
  id_uL_NR_Carrier_List = 528,
  id_dL_NR_Carrier_List = 529,
  id_nRFreqInfo = 530,
  id_transmission_Bandwidth = 531,
  id_nR_Carrier_List = 532,
  id_Neighbour_Node_Cells_List = 533,
  id_Serving_Cells_List = 534,
  id_permutation = 535,
  id_MDTPollutedMeasurementIndicator = 536,
  id_M5ReportAmount = 537,
  id_M6ReportAmount = 538,
  id_M7ReportAmount = 539,
  id_SurvivalTime = 540,
  id_PDCMeasurementPeriodicity = 541,
  id_PDCMeasurementQuantities = 542,
  id_PDCMeasurementQuantities_Item = 543,
  id_PDCMeasurementResult = 544,
  id_PDCReportType = 545,
  id_RAN_UE_PDC_MeasID = 546,
  id_SCGActivationRequest = 547,
  id_SCGActivationStatus = 548,
  id_PRSTRPList = 549,
  id_PRSTransmissionTRPList = 550,
  id_OnDemandPRS = 551,
  id_AoA_SearchWindow = 552,
  id_TRP_MeasurementUpdateList = 553,
  id_ZoAInformation = 554,
  id_ResponseTime = 555,
  id_ARPLocationInfo = 556,
  id_ARP_ID    = 557,
  id_MultipleULAoA = 558,
  id_UL_SRS_RSRPP = 559,
  id_SRSResourcetype = 560,
  id_ExtendedAdditionalPathList = 561,
  id_LoS_NLoSInformation = 562,
  id_Unknown_563 = 563,
  id_NumberOfTRPRxTEG = 564,
  id_NumberOfTRPRxTxTEG = 565,
  id_TRPTxTEGAssociation = 566,
  id_TRPTEGInformation = 567,
  id_TRPRx_TEGInformation = 568,
  id_TRP_PRS_Info_List = 569,
  id_PRS_Measurement_Info_List = 570,
  id_PRSConfigRequestType = 571,
  id_Unknown_572 = 572,
  id_MeasurementTimeOccasion = 573,
  id_MeasurementCharacteristicsRequestIndicator = 574,
  id_UEReportingInformation = 575,
  id_PosContextRevIndication = 576,
  id_TRPBeamAntennaInformation = 577,
  id_NRRedCapUEIndication = 578,
  id_Redcap_Bcast_Information = 579,
  id_RANUEPagingDRX = 580,
  id_CNUEPagingDRX = 581,
  id_NRPagingeDRXInformation = 582,
  id_NRPagingeDRXInformationforRRCINACTIVE = 583,
  id_NR_TADV   = 584,
  id_QoEInformation = 585,
  id_CG_SDTQueryIndication = 586,
  id_SDT_MAC_PHY_CG_Config = 587,
  id_CG_SDTKeptIndicator = 588,
  id_CG_SDTindicatorSetup = 589,
  id_CG_SDTindicatorMod = 590,
  id_CG_SDTSessionInfoOld = 591,
  id_SDTInformation = 592,
  id_SDTRLCBearerConfiguration = 593,
  id_FiveG_ProSeAuthorized = 594,
  id_FiveG_ProSeUEPC5AggregateMaximumBitrate = 595,
  id_FiveG_ProSePC5LinkAMBR = 596,
  id_SRBMappingInfo = 597,
  id_DRBMappingInfo = 598,
  id_UuRLCChannelToBeSetupList = 599,
  id_UuRLCChannelToBeModifiedList = 600,
  id_UuRLCChannelToBeReleasedList = 601,
  id_UuRLCChannelSetupList = 602,
  id_UuRLCChannelFailedToBeSetupList = 603,
  id_UuRLCChannelModifiedList = 604,
  id_UuRLCChannelFailedToBeModifiedList = 605,
  id_UuRLCChannelRequiredToBeModifiedList = 606,
  id_UuRLCChannelRequiredToBeReleasedList = 607,
  id_PC5RLCChannelToBeSetupList = 608,
  id_PC5RLCChannelToBeModifiedList = 609,
  id_PC5RLCChannelToBeReleasedList = 610,
  id_PC5RLCChannelSetupList = 611,
  id_PC5RLCChannelFailedToBeSetupList = 612,
  id_PC5RLCChannelFailedToBeModifiedList = 613,
  id_PC5RLCChannelRequiredToBeModifiedList = 614,
  id_PC5RLCChannelRequiredToBeReleasedList = 615,
  id_PC5RLCChannelModifiedList = 616,
  id_SidelinkRelayConfiguration = 617,
  id_UpdatedRemoteUELocalID = 618,
  id_PathSwitchConfiguration = 619,
  id_PagingCause = 620,
  id_MUSIM_GapConfig = 621,
  id_PEIPSAssistanceInfo = 622,
  id_UEPagingCapability = 623,
  id_LastUsedCellIndication = 624,
  id_SIB17_message = 625,
  id_GNBDUUESliceMaximumBitRateList = 626,
  id_SIB20_message = 627,
  id_UE_MulticastMRBs_ToBeReleased_List = 628,
  id_UE_MulticastMRBs_ToBeReleased_Item = 629,
  id_UE_MulticastMRBs_ToBeSetup_List = 630,
  id_UE_MulticastMRBs_ToBeSetup_Item = 631,
  id_MulticastMBSSessionSetupList = 632,
  id_MulticastMBSSessionRemoveList = 633,
  id_PosMeasurementAmount = 634,
  id_SDT_Termination_Request = 635,
  id_pathPower = 636,
  id_DU_RX_MT_RX_Extend = 637,
  id_DU_TX_MT_TX_Extend = 638,
  id_DU_RX_MT_TX_Extend = 639,
  id_DU_TX_MT_RX_Extend = 640,
  id_BAP_Header_Rewriting_Removed_List = 641,
  id_BAP_Header_Rewriting_Removed_List_Item = 642,
  id_SLDRXCycleList = 643,
  id_TAINSAGSupportList = 644,
  id_SL_RLC_ChannelToAddModList = 645,
  id_BroadcastAreaScope = 646,
  id_ManagementBasedMDTPLMNModificationList = 647,
  id_SIB15_message = 648,
  id_ActivationRequestType = 649,
  id_PosMeasGapPreConfigList = 650,
  id_InterFrequencyConfig_NoGap = 651,
  id_MBSInterestIndication = 652,
  id_UE_MulticastMRBs_ConfirmedToBeModified_List = 653,
  id_UE_MulticastMRBs_ConfirmedToBeModified_Item = 654,
  id_UE_MulticastMRBs_RequiredToBeModified_List = 655,
  id_UE_MulticastMRBs_RequiredToBeModified_Item = 656,
  id_UE_MulticastMRBs_RequiredToBeReleased_List = 657,
  id_UE_MulticastMRBs_RequiredToBeReleased_Item = 658,
  id_L571Info  = 659,
  id_L1151Info = 660,
  id_SCS_480   = 661,
  id_SCS_960   = 662,
  id_SRSPortIndex = 663,
  id_PEISubgroupingSupportIndication = 664,
  id_NeedForGapsInfoNR = 665,
  id_NeedForGapNCSGInfoNR = 666,
  id_NeedForGapNCSGInfoEUTRA = 667,
  id_ProtocolIE_ID_668_not_to_be_used = 668,
  id_ProtocolIE_ID_669_not_to_be_used = 669,
  id_ProtocolIE_ID_670_not_to_be_used = 670,
  id_Source_MRB_ID = 671,
  id_PosMeasurementPeriodicityNR_AoA = 672,
  id_RedCapIndication = 673,
  id_SRSPosRRCInactiveConfig = 674,
  id_SDTBearerConfigurationQueryIndication = 675,
  id_SDTBearerConfigurationInfo = 676,
  id_UL_GapFR2_Config = 677,
  id_ConfigRestrictInfoDAPS = 678,
  id_UE_MulticastMRBs_Setup_List = 679,
  id_UE_MulticastMRBs_Setup_Item = 680,
  id_MulticastF1UContextReferenceCU = 681,
  id_PosSItypeList = 682,
  id_DAPS_HO_Status = 683,
  id_UplinkTxDirectCurrentTwoCarrierListInfo = 684,
  id_UE_MulticastMRBs_ToBeSetup_atModify_List = 685,
  id_UE_MulticastMRBs_ToBeSetup_atModify_Item = 686,
  id_MC_PagingCell_List = 687,
  id_MC_PagingCell_Item = 688,
  id_SRSPosRRCInactiveQueryIndication = 689,
  id_UlTxDirectCurrentMoreCarrierInformation = 690,
  id_CPACMCGInformation = 691,
  id_TwoPHRModeMCG = 692,
  id_TwoPHRModeSCG = 693,
  id_ExtendedUEIdentityIndexValue = 694,
  id_ServingCellMO_List = 695,
  id_ServingCellMO_List_Item = 696,
  id_ServingCellMO_encoded_in_CGC_List = 697,
  id_HashedUEIdentityIndexValue = 698,
  id_UE_MulticastMRBs_Setupnew_List = 699,
  id_UE_MulticastMRBs_Setupnew_Item = 700,
  id_ncd_SSB_RedCapInitialBWP_SDT = 701,
  id_nrofSymbolsExtended = 702,
  id_repetitionFactorExtended = 703,
  id_startRBHopping = 704,
  id_startRBIndex = 705,
  id_transmissionCombn8 = 706,
  id_ServCellInfoList = 707,
  id_DedicatedSIDeliveryIndication = 708,
  id_Configured_BWP_List = 709,
  id_Preconfigured_measurement_GAP_Request = 710,
  id_BWP_Id    = 711,
  id_NetworkControlledRepeaterAuthorized = 712,
  id_MT_SDT_Information = 713,
  id_ExtendedResourceSymbolOffset = 714,
  id_NeedForInterruptionInfoNR = 715,
  id_SDT_Volume_Threshold = 716,
  id_SupportedUETypeList = 717,
  id_MusimCapabilityRestrictionIndication = 718,
  id_duplicationIndication = 719,
  id_LTMInformation_Setup = 720,
  id_LTMConfigurationIDMappingList = 721,
  id_LTMInformation_Modify = 722,
  id_LTMCells_ToBeReleased_List = 723,
  id_ProtocolIE_ID_724_not_to_be_used = 724,
  id_LTMConfiguration = 725,
  id_EarlySyncInformation_Request = 726,
  id_EarlySyncInformation = 727,
  id_EarlySyncCandidateCellInformation_List = 728,
  id_LTMCellSwitchInformation = 729,
  id_DUtoCUTAInformation_List = 730,
  id_ProtocolIE_ID_731_not_to_be_used = 731,
  id_dRB_List  = 732,
  id_DeactivationIndication = 733,
  id_RAReportIndicationList = 734,
  id_ChannelOccupancyTimePercentageUL = 735,
  id_SuccessfulPSCellChangeReportInformationList = 736,
  id_RadioResourceStatusNR_U = 737,
  id_FiveG_ProSeLayer2Multipath = 738,
  id_FiveG_ProSeLayer2UEtoUERelay = 739,
  id_FiveG_ProSeLayer2UEtoUERemote = 740,
  id_PathAdditionInformation = 741,
  id_Recommended_SSBs_List = 742,
  id_Recommended_SSBs_for_Paging_List = 743,
  id_SSBs_withinTheCell_tobe_Activated_List = 744,
  id_Cells_With_SSBs_Activated_List = 745,
  id_Cells_Allowed_to_be_Deactivated_List = 746,
  id_Cells_Allowed_to_be_Deactivated_List_Item = 747,
  id_Coverage_Modification_Cause = 748,
  id_RANTSSRequestType = 749,
  id_RANTimingSynchronisationStatusInfo = 750,
  id_TSCTrafficCharacteristicsFeedback = 751,
  id_RANfeedbacktype = 752,
  id_Mobile_TRP_LocationInformation = 753,
  id_Mobile_IAB_MT_UE_ID = 754,
  id_Target_gNB_ID = 755,
  id_Target_gNB_IP_address = 756,
  id_Target_SeGW_IP_address = 757,
  id_Activated_Cells_Mapping_List = 758,
  id_Activated_Cells_Mapping_List_Item = 759,
  id_F1SetupOutcome = 760,
  id_RRC_Terminating_IAB_Donor_Related_Info = 761,
  id_RRC_Terminating_IAB_Donor_gNB_ID = 762,
  id_NCGI_to_be_Updated_List = 763,
  id_NCGI_to_be_Updated_List_Item = 764,
  id_Mobile_IAB_MTUserLocationInformation = 765,
  id_MobileAccessPointLocation = 766,
  id_AssociatedSessionID = 767,
  id_IndicationMCInactiveReception = 768,
  id_MulticastCU2DURRCInfo = 769,
  id_MBSMulticastSessionReceptionState = 770,
  id_F1UTunnelNotEstablished = 771,
  id_MulticastDU2CURRCInfo = 772,
  id_SIB24_message = 773,
  id_MulticastCU2DUCommonRRCInfo = 774,
  id_PDUSetQoSParameters = 775,
  id_N6JitterInformation = 776,
  id_ECNMarkingorCongestionInformationReportingRequest = 777,
  id_ECNMarkingorCongestionInformationReportingStatus = 778,
  id_NRA2XServicesAuthorized = 779,
  id_LTEA2XServicesAuthorized = 780,
  id_NRUESidelinkAggregateMaximumBitrateForA2X = 781,
  id_LTEUESidelinkAggregateMaximumBitrateForA2X = 782,
  id_NReRedCapUEIndication = 783,
  id_ERedcap_Bcast_Information = 784,
  id_NRPaginglongeDRXInformationforRRCINACTIVE = 785,
  id_SCPAC_Request = 786,
  id_Target_F1_Terminating_Donor_gNB_ID = 787,
  id_MobileIAB_Barred = 788,
  id_Broadcast_MRBs_Transport_Request_List = 789,
  id_Broadcast_MRBs_Transport_Request_Item = 790,
  id_S_CPACLowerLayerReferenceConfigRequest = 791,
  id_S_CPAC_Configuration = 792,
  id_MusimCandidateBandList = 793,
  id_DLLBTFailureInformationRequest = 794,
  id_DLLBTFailureInformationList = 795,
  id_PSIbasedSDUdiscardUL = 796,
  id_SIB22_message = 797,
  id_CUtoDUTAInformation_List = 798,
  id_U2URLCChannelQoS = 799,
  id_SL_PHY_MAC_RLC_ConfigExt = 800,
  id_SLPositioning_Ranging_Service_Info = 801,
  id_TimeWindowInformation_SRS_List = 802,
  id_TimeWindowInformation_Measurement_List = 803,
  id_UL_RSCP   = 804,
  id_BW_Aggregation_Request_Indication = 805,
  id_ReportingGranularitykminus1 = 806,
  id_ReportingGranularitykminus2 = 807,
  id_ReportingGranularitykminus1additionalpath = 808,
  id_ReportingGranularitykminus2additionalpath = 809,
  id_TimingReportingGranularityFactorExtended = 810,
  id_SRSPosRRCInactiveValidityAreaConfig = 811,
  id_PosValidityAreaCellList = 812,
  id_SRSReservationType = 813,
  id_SymbolIndex = 814,
  id_PRSBWAggregationRequestInfoList = 815,
  id_AggregatedPosSRSResourceIDList = 816,
  id_AggregatedPRSResourceSetList = 817,
  id_PhaseQuality = 818,
  id_MeasuredFrequencyHops = 819,
  id_TxHoppingConfiguration = 820,
  id_ReportingGranularitykminus3 = 821,
  id_ReportingGranularitykminus4 = 822,
  id_ReportingGranularitykminus5 = 823,
  id_ReportingGranularitykminus6 = 824,
  id_ReportingGranularitykminus3additionalpath = 825,
  id_ReportingGranularitykminus4additionalpath = 826,
  id_ReportingGranularitykminus5additionalpath = 827,
  id_ReportingGranularitykminus6additionalpath = 828,
  id_AggregatedPosSRSResourceSetList = 829,
  id_RequestedSRSPreconfigurationCharacteristics_List = 830,
  id_SRSPreconfiguration_List = 831,
  id_SRSInformation = 832,
  id_ValidityAreaSpecificSRSInformation = 833,
  id_E_CID_MeasuredResultsAssociatedInfoList = 834,
  id_XR_Bcast_Information = 835,
  id_MaxDataBurstVolume = 836,
  id_TAInformation_List = 837,
  id_NonIntegerDRXCycle = 838,
  id_PointA    = 839,
  id_SCS_SpecificCarrier = 840,
  id_NR_PCI    = 841,
  id_PeerUE_ID = 842,
  id_EarlySyncServingCellInformation = 843,
  id_RANSharingAssistanceInformation = 844,
  id_LTMCFRAResourceConfig_List = 845,
  id_F1U_PathFailure = 846,
  id_MeasBasedOnAggregatedResources = 847,
  id_SIB23_message = 848,
  id_BarringExemptionforEmerCallInfo = 849,
  id_SIB17bis_message = 850,
  id_ReportingIntervalIMs = 851,
  id_Transmission_Bandwidth_asymmetric = 852,
  id_TagIDPointer = 853,
  id_LocalOrigin = 854,
  id_LTMResetInformation = 855,
  id_SRSPosPeriodicConfigHyperSFNIndex = 856,
  id_PreconfiguredSRSInformation = 857,
  id_candidatePSCellsToCancel = 858,
  id_MobilityInitiation = 859,
  id_ValidityAreaSpecificSRSInformationExtended = 860,
  id_PLMNIndexNRAssistanceInfoForNetShar = 861
} ProtocolIE_ID_enum;

/* Initialize the protocol and registered fields */
static int proto_f1ap;

static int hf_f1ap_transportLayerAddressIPv4;
static int hf_f1ap_transportLayerAddressIPv6;
static int hf_f1ap_IABTNLAddressIPv4;
static int hf_f1ap_IABTNLAddressIPv6;
static int hf_f1ap_IABTNLAddressIPv6Prefix;
static int hf_f1ap_interfacesToTrace_NG_C;
static int hf_f1ap_interfacesToTrace_Xn_C;
static int hf_f1ap_interfacesToTrace_Uu;
static int hf_f1ap_interfacesToTrace_F1_C;
static int hf_f1ap_interfacesToTrace_E1;
static int hf_f1ap_interfacesToTrace_Reserved;
static int hf_f1ap_MeasurementsToActivate_Reserved1;
static int hf_f1ap_MeasurementsToActivate_M2;
static int hf_f1ap_MeasurementsToActivate_Reserved2;
static int hf_f1ap_MeasurementsToActivate_M5;
static int hf_f1ap_MeasurementsToActivate_Reserved3;
static int hf_f1ap_MeasurementsToActivate_M6;
static int hf_f1ap_MeasurementsToActivate_M7;
static int hf_f1ap_ReportCharacteristics_PRBPeriodic;
static int hf_f1ap_ReportCharacteristics_TNLCapacityIndPeriodic;
static int hf_f1ap_ReportCharacteristics_CompositeAvailableCapacityPeriodic;
static int hf_f1ap_ReportCharacteristics_HWLoadIndPeriodic;
static int hf_f1ap_ReportCharacteristics_NumberOfActiveUEs;
static int hf_f1ap_ReportCharacteristics_Reserved;
static int hf_f1ap_AbortTransmission_PDU;         /* AbortTransmission */
static int hf_f1ap_Activated_Cells_Mapping_List_Item_PDU;  /* Activated_Cells_Mapping_List_Item */
static int hf_f1ap_Activated_Cells_to_be_Updated_List_PDU;  /* Activated_Cells_to_be_Updated_List */
static int hf_f1ap_ActivationRequestType_PDU;     /* ActivationRequestType */
static int hf_f1ap_AdditionalDuplicationIndication_PDU;  /* AdditionalDuplicationIndication */
static int hf_f1ap_ExtendedAdditionalPathList_PDU;  /* ExtendedAdditionalPathList */
static int hf_f1ap_AdditionalPDCPDuplicationTNL_List_PDU;  /* AdditionalPDCPDuplicationTNL_List */
static int hf_f1ap_AdditionalSIBMessageList_PDU;  /* AdditionalSIBMessageList */
static int hf_f1ap_AdditionalRRMPriorityIndex_PDU;  /* AdditionalRRMPriorityIndex */
static int hf_f1ap_AggregatedPosSRSResourceIDList_PDU;  /* AggregatedPosSRSResourceIDList */
static int hf_f1ap_AggregatedPosSRSResourceSetList_PDU;  /* AggregatedPosSRSResourceSetList */
static int hf_f1ap_AggregatedPRSResourceSetList_PDU;  /* AggregatedPRSResourceSetList */
static int hf_f1ap_AggressorgNBSetID_PDU;         /* AggressorgNBSetID */
static int hf_f1ap_AlternativeQoSParaSetList_PDU;  /* AlternativeQoSParaSetList */
static int hf_f1ap_Associated_SCell_Item_PDU;     /* Associated_SCell_Item */
static int hf_f1ap_AssociatedSessionID_PDU;       /* AssociatedSessionID */
static int hf_f1ap_AvailablePLMNList_PDU;         /* AvailablePLMNList */
static int hf_f1ap_AvailableSNPN_ID_List_PDU;     /* AvailableSNPN_ID_List */
static int hf_f1ap_AreaScope_PDU;                 /* AreaScope */
static int hf_f1ap_AoA_AssistanceInfo_PDU;        /* AoA_AssistanceInfo */
static int hf_f1ap_ARP_ID_PDU;                    /* ARP_ID */
static int hf_f1ap_ARPLocationInformation_PDU;    /* ARPLocationInformation */
static int hf_f1ap_BAP_Header_Rewriting_Added_List_Item_PDU;  /* BAP_Header_Rewriting_Added_List_Item */
static int hf_f1ap_BAP_Header_Rewriting_Removed_List_Item_PDU;  /* BAP_Header_Rewriting_Removed_List_Item */
static int hf_f1ap_BAPAddress_PDU;                /* BAPAddress */
static int hf_f1ap_BarringExemptionforEmerCallInfo_PDU;  /* BarringExemptionforEmerCallInfo */
static int hf_f1ap_BitRate_PDU;                   /* BitRate */
static int hf_f1ap_BearerTypeChange_PDU;          /* BearerTypeChange */
static int hf_f1ap_BHChannels_FailedToBeModified_Item_PDU;  /* BHChannels_FailedToBeModified_Item */
static int hf_f1ap_BHChannels_FailedToBeSetup_Item_PDU;  /* BHChannels_FailedToBeSetup_Item */
static int hf_f1ap_BHChannels_FailedToBeSetupMod_Item_PDU;  /* BHChannels_FailedToBeSetupMod_Item */
static int hf_f1ap_BHChannels_Modified_Item_PDU;  /* BHChannels_Modified_Item */
static int hf_f1ap_BHChannels_Required_ToBeReleased_Item_PDU;  /* BHChannels_Required_ToBeReleased_Item */
static int hf_f1ap_BHChannels_Setup_Item_PDU;     /* BHChannels_Setup_Item */
static int hf_f1ap_BHChannels_SetupMod_Item_PDU;  /* BHChannels_SetupMod_Item */
static int hf_f1ap_BHChannels_ToBeModified_Item_PDU;  /* BHChannels_ToBeModified_Item */
static int hf_f1ap_BHChannels_ToBeReleased_Item_PDU;  /* BHChannels_ToBeReleased_Item */
static int hf_f1ap_BHChannels_ToBeSetup_Item_PDU;  /* BHChannels_ToBeSetup_Item */
static int hf_f1ap_BHChannels_ToBeSetupMod_Item_PDU;  /* BHChannels_ToBeSetupMod_Item */
static int hf_f1ap_BHInfo_PDU;                    /* BHInfo */
static int hf_f1ap_BH_Routing_Information_Added_List_Item_PDU;  /* BH_Routing_Information_Added_List_Item */
static int hf_f1ap_BH_Routing_Information_Removed_List_Item_PDU;  /* BH_Routing_Information_Removed_List_Item */
static int hf_f1ap_BPLMN_ID_Info_List_PDU;        /* BPLMN_ID_Info_List */
static int hf_f1ap_BroadcastMRBs_FailedToBeModified_Item_PDU;  /* BroadcastMRBs_FailedToBeModified_Item */
static int hf_f1ap_BroadcastMRBs_FailedToBeSetup_Item_PDU;  /* BroadcastMRBs_FailedToBeSetup_Item */
static int hf_f1ap_BroadcastMRBs_FailedToBeSetupMod_Item_PDU;  /* BroadcastMRBs_FailedToBeSetupMod_Item */
static int hf_f1ap_BroadcastMRBs_Modified_Item_PDU;  /* BroadcastMRBs_Modified_Item */
static int hf_f1ap_BroadcastMRBs_Setup_Item_PDU;  /* BroadcastMRBs_Setup_Item */
static int hf_f1ap_BroadcastMRBs_SetupMod_Item_PDU;  /* BroadcastMRBs_SetupMod_Item */
static int hf_f1ap_BroadcastMRBs_ToBeModified_Item_PDU;  /* BroadcastMRBs_ToBeModified_Item */
static int hf_f1ap_BroadcastMRBs_ToBeReleased_Item_PDU;  /* BroadcastMRBs_ToBeReleased_Item */
static int hf_f1ap_BroadcastMRBs_ToBeSetup_Item_PDU;  /* BroadcastMRBs_ToBeSetup_Item */
static int hf_f1ap_BroadcastMRBs_ToBeSetupMod_Item_PDU;  /* BroadcastMRBs_ToBeSetupMod_Item */
static int hf_f1ap_BroadcastAreaScope_PDU;        /* BroadcastAreaScope */
static int hf_f1ap_BufferSizeThresh_PDU;          /* BufferSizeThresh */
static int hf_f1ap_BW_Aggregation_Request_Indication_PDU;  /* BW_Aggregation_Request_Indication */
static int hf_f1ap_BWP_Id_PDU;                    /* BWP_Id */
static int hf_f1ap_Broadcast_MRBs_Transport_Request_Item_PDU;  /* Broadcast_MRBs_Transport_Request_Item */
static int hf_f1ap_Cancel_all_Warning_Messages_Indicator_PDU;  /* Cancel_all_Warning_Messages_Indicator */
static int hf_f1ap_Candidate_SpCell_Item_PDU;     /* Candidate_SpCell_Item */
static int hf_f1ap_Cause_PDU;                     /* Cause */
static int hf_f1ap_CellGroupConfig_PDU;           /* CellGroupConfig */
static int hf_f1ap_Cell_Direction_PDU;            /* Cell_Direction */
static int hf_f1ap_CellMeasurementResultList_PDU;  /* CellMeasurementResultList */
static int hf_f1ap_Cell_Portion_ID_PDU;           /* Cell_Portion_ID */
static int hf_f1ap_CellsForSON_List_PDU;          /* CellsForSON_List */
static int hf_f1ap_Cells_Failed_to_be_Activated_List_Item_PDU;  /* Cells_Failed_to_be_Activated_List_Item */
static int hf_f1ap_Cells_Status_Item_PDU;         /* Cells_Status_Item */
static int hf_f1ap_Cells_To_Be_Broadcast_Item_PDU;  /* Cells_To_Be_Broadcast_Item */
static int hf_f1ap_Cells_Broadcast_Completed_Item_PDU;  /* Cells_Broadcast_Completed_Item */
static int hf_f1ap_Broadcast_To_Be_Cancelled_Item_PDU;  /* Broadcast_To_Be_Cancelled_Item */
static int hf_f1ap_Cells_Broadcast_Cancelled_Item_PDU;  /* Cells_Broadcast_Cancelled_Item */
static int hf_f1ap_Cells_to_be_Activated_List_Item_PDU;  /* Cells_to_be_Activated_List_Item */
static int hf_f1ap_Cells_With_SSBs_Activated_List_PDU;  /* Cells_With_SSBs_Activated_List */
static int hf_f1ap_Cells_Allowed_to_be_Deactivated_List_Item_PDU;  /* Cells_Allowed_to_be_Deactivated_List_Item */
static int hf_f1ap_Cells_to_be_Deactivated_List_Item_PDU;  /* Cells_to_be_Deactivated_List_Item */
static int hf_f1ap_Cells_to_be_Barred_Item_PDU;   /* Cells_to_be_Barred_Item */
static int hf_f1ap_CellToReportList_PDU;          /* CellToReportList */
static int hf_f1ap_CellType_PDU;                  /* CellType */
static int hf_f1ap_CellULConfigured_PDU;          /* CellULConfigured */
static int hf_f1ap_CG_SDTQueryIndication_PDU;     /* CG_SDTQueryIndication */
static int hf_f1ap_CG_SDTKeptIndicator_PDU;       /* CG_SDTKeptIndicator */
static int hf_f1ap_CG_SDTindicatorSetup_PDU;      /* CG_SDTindicatorSetup */
static int hf_f1ap_CG_SDTindicatorMod_PDU;        /* CG_SDTindicatorMod */
static int hf_f1ap_CG_SDTSessionInfo_PDU;         /* CG_SDTSessionInfo */
static int hf_f1ap_ChannelOccupancyTimePercentage_PDU;  /* ChannelOccupancyTimePercentage */
static int hf_f1ap_Child_IAB_Nodes_NA_Resource_List_PDU;  /* Child_IAB_Nodes_NA_Resource_List */
static int hf_f1ap_Child_Nodes_List_PDU;          /* Child_Nodes_List */
static int hf_f1ap_CompositeAvailableCapacity_PDU;  /* CompositeAvailableCapacity */
static int hf_f1ap_CHO_Probability_PDU;           /* CHO_Probability */
static int hf_f1ap_ConditionalInterDUMobilityInformation_PDU;  /* ConditionalInterDUMobilityInformation */
static int hf_f1ap_ConditionalIntraDUMobilityInformation_PDU;  /* ConditionalIntraDUMobilityInformation */
static int hf_f1ap_ConfigRestrictInfoDAPS_PDU;    /* ConfigRestrictInfoDAPS */
static int hf_f1ap_ConfiguredTACIndication_PDU;   /* ConfiguredTACIndication */
static int hf_f1ap_Configured_BWP_List_PDU;       /* Configured_BWP_List */
static int hf_f1ap_Coverage_Modification_Notification_PDU;  /* Coverage_Modification_Notification */
static int hf_f1ap_CCO_Assistance_Information_PDU;  /* CCO_Assistance_Information */
static int hf_f1ap_CCO_issue_detection_PDU;       /* CCO_issue_detection */
static int hf_f1ap_CP_TransportLayerAddress_PDU;  /* CP_TransportLayerAddress */
static int hf_f1ap_CPACMCGInformation_PDU;        /* CPACMCGInformation */
static int hf_f1ap_CriticalityDiagnostics_PDU;    /* CriticalityDiagnostics */
static int hf_f1ap_C_RNTI_PDU;                    /* C_RNTI */
static int hf_f1ap_CUDURadioInformationType_PDU;  /* CUDURadioInformationType */
static int hf_f1ap_CUtoDURRCInformation_PDU;      /* CUtoDURRCInformation */
static int hf_f1ap_CUtoDUTAInformation_List_PDU;  /* CUtoDUTAInformation_List */
static int hf_f1ap_DAPS_HO_Status_PDU;            /* DAPS_HO_Status */
static int hf_f1ap_DCBasedDuplicationConfigured_PDU;  /* DCBasedDuplicationConfigured */
static int hf_f1ap_DeactivationIndication_PDU;    /* DeactivationIndication */
static int hf_f1ap_Dedicated_SIDelivery_NeededUE_Item_PDU;  /* Dedicated_SIDelivery_NeededUE_Item */
static int hf_f1ap_DedicatedSIDeliveryIndication_PDU;  /* DedicatedSIDeliveryIndication */
static int hf_f1ap_DL_UP_TNL_Address_to_Update_List_Item_PDU;  /* DL_UP_TNL_Address_to_Update_List_Item */
static int hf_f1ap_DRB_Activity_Item_PDU;         /* DRB_Activity_Item */
static int hf_f1ap_DRBs_FailedToBeModified_Item_PDU;  /* DRBs_FailedToBeModified_Item */
static int hf_f1ap_DRBs_FailedToBeSetup_Item_PDU;  /* DRBs_FailedToBeSetup_Item */
static int hf_f1ap_DRBs_FailedToBeSetupMod_Item_PDU;  /* DRBs_FailedToBeSetupMod_Item */
static int hf_f1ap_DRB_Information_PDU;           /* DRB_Information */
static int hf_f1ap_DRBs_Modified_Item_PDU;        /* DRBs_Modified_Item */
static int hf_f1ap_DRBs_ModifiedConf_Item_PDU;    /* DRBs_ModifiedConf_Item */
static int hf_f1ap_DRB_Notify_Item_PDU;           /* DRB_Notify_Item */
static int hf_f1ap_DRBs_Required_ToBeModified_Item_PDU;  /* DRBs_Required_ToBeModified_Item */
static int hf_f1ap_DRBs_Required_ToBeReleased_Item_PDU;  /* DRBs_Required_ToBeReleased_Item */
static int hf_f1ap_DRBs_Setup_Item_PDU;           /* DRBs_Setup_Item */
static int hf_f1ap_DRBs_SetupMod_Item_PDU;        /* DRBs_SetupMod_Item */
static int hf_f1ap_DRBs_ToBeModified_Item_PDU;    /* DRBs_ToBeModified_Item */
static int hf_f1ap_DRBs_ToBeReleased_Item_PDU;    /* DRBs_ToBeReleased_Item */
static int hf_f1ap_DRBs_ToBeSetup_Item_PDU;       /* DRBs_ToBeSetup_Item */
static int hf_f1ap_DRBs_ToBeSetupMod_Item_PDU;    /* DRBs_ToBeSetupMod_Item */
static int hf_f1ap_DRB_List_PDU;                  /* DRB_List */
static int hf_f1ap_DRXCycle_PDU;                  /* DRXCycle */
static int hf_f1ap_NonIntegerDRXCycle_PDU;        /* NonIntegerDRXCycle */
static int hf_f1ap_DRX_Config_PDU;                /* DRX_Config */
static int hf_f1ap_DRXConfigurationIndicator_PDU;  /* DRXConfigurationIndicator */
static int hf_f1ap_DRX_LongCycleStartOffset_PDU;  /* DRX_LongCycleStartOffset */
static int hf_f1ap_DUtoCURRCContainer_PDU;        /* DUtoCURRCContainer */
static int hf_f1ap_DUCURadioInformationType_PDU;  /* DUCURadioInformationType */
static int hf_f1ap_DU_RX_MT_RX_Extend_PDU;        /* DU_RX_MT_RX_Extend */
static int hf_f1ap_DU_TX_MT_TX_Extend_PDU;        /* DU_TX_MT_TX_Extend */
static int hf_f1ap_DU_RX_MT_TX_Extend_PDU;        /* DU_RX_MT_TX_Extend */
static int hf_f1ap_DU_TX_MT_RX_Extend_PDU;        /* DU_TX_MT_RX_Extend */
static int hf_f1ap_DUtoCURRCInformation_PDU;      /* DUtoCURRCInformation */
static int hf_f1ap_DUtoCUTAInformation_List_PDU;  /* DUtoCUTAInformation_List */
static int hf_f1ap_DuplicationActivation_PDU;     /* DuplicationActivation */
static int hf_f1ap_DuplicationIndication_PDU;     /* DuplicationIndication */
static int hf_f1ap_DLLBTFailureInformationRequest_PDU;  /* DLLBTFailureInformationRequest */
static int hf_f1ap_DLLBTFailureInformationList_PDU;  /* DLLBTFailureInformationList */
static int hf_f1ap_EarlySyncInformation_Request_PDU;  /* EarlySyncInformation_Request */
static int hf_f1ap_EarlySyncInformation_PDU;      /* EarlySyncInformation */
static int hf_f1ap_EarlySyncCandidateCellInformation_List_PDU;  /* EarlySyncCandidateCellInformation_List */
static int hf_f1ap_EarlySyncServingCellInformation_PDU;  /* EarlySyncServingCellInformation */
static int hf_f1ap_E_CID_MeasurementQuantities_PDU;  /* E_CID_MeasurementQuantities */
static int hf_f1ap_E_CID_MeasurementQuantities_Item_PDU;  /* E_CID_MeasurementQuantities_Item */
static int hf_f1ap_E_CID_MeasurementResult_PDU;   /* E_CID_MeasurementResult */
static int hf_f1ap_E_CID_MeasuredResultsAssociatedInfoList_PDU;  /* E_CID_MeasuredResultsAssociatedInfoList */
static int hf_f1ap_E_CID_ReportCharacteristics_PDU;  /* E_CID_ReportCharacteristics */
static int hf_f1ap_EgressNonF1terminatingTopologyIndicator_PDU;  /* EgressNonF1terminatingTopologyIndicator */
static int hf_f1ap_ExtendedAvailablePLMN_List_PDU;  /* ExtendedAvailablePLMN_List */
static int hf_f1ap_ExtendedServedPLMNs_List_PDU;  /* ExtendedServedPLMNs_List */
static int hf_f1ap_ExtendedSliceSupportList_PDU;  /* ExtendedSliceSupportList */
static int hf_f1ap_ExtendedUEIdentityIndexValue_PDU;  /* ExtendedUEIdentityIndexValue */
static int hf_f1ap_ExecuteDuplication_PDU;        /* ExecuteDuplication */
static int hf_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container_PDU;  /* EUTRA_NR_CellResourceCoordinationReq_Container */
static int hf_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container_PDU;  /* EUTRA_NR_CellResourceCoordinationReqAck_Container */
static int hf_f1ap_ExtendedPacketDelayBudget_PDU;  /* ExtendedPacketDelayBudget */
static int hf_f1ap_ECNMarkingorCongestionInformationReportingRequest_PDU;  /* ECNMarkingorCongestionInformationReportingRequest */
static int hf_f1ap_ECNMarkingorCongestionInformationReportingStatus_PDU;  /* ECNMarkingorCongestionInformationReportingStatus */
static int hf_f1ap_F1CTransferPath_PDU;           /* F1CTransferPath */
static int hf_f1ap_F1CTransferPathNRDC_PDU;       /* F1CTransferPathNRDC */
static int hf_f1ap_F1U_PathFailure_PDU;           /* F1U_PathFailure */
static int hf_f1ap_F1UTunnelNotEstablished_PDU;   /* F1UTunnelNotEstablished */
static int hf_f1ap_FiveG_ProSeAuthorized_PDU;     /* FiveG_ProSeAuthorized */
static int hf_f1ap_FiveG_ProSeLayer2Multipath_PDU;  /* FiveG_ProSeLayer2Multipath */
static int hf_f1ap_FiveG_ProSeLayer2UEtoUERelay_PDU;  /* FiveG_ProSeLayer2UEtoUERelay */
static int hf_f1ap_FiveG_ProSeLayer2UEtoUERemote_PDU;  /* FiveG_ProSeLayer2UEtoUERemote */
static int hf_f1ap_FrequencyShift7p5khz_PDU;      /* FrequencyShift7p5khz */
static int hf_f1ap_Frequency_Domain_HSNA_Configuration_List_PDU;  /* Frequency_Domain_HSNA_Configuration_List */
static int hf_f1ap_FullConfiguration_PDU;         /* FullConfiguration */
static int hf_f1ap_CG_Config_PDU;                 /* CG_Config */
static int hf_f1ap_GlobalGNB_ID_PDU;              /* GlobalGNB_ID */
static int hf_f1ap_GNB_CU_MBS_F1AP_ID_PDU;        /* GNB_CU_MBS_F1AP_ID */
static int hf_f1ap_GNBCUMeasurementID_PDU;        /* GNBCUMeasurementID */
static int hf_f1ap_GNBDUMeasurementID_PDU;        /* GNBDUMeasurementID */
static int hf_f1ap_GNB_CUSystemInformation_PDU;   /* GNB_CUSystemInformation */
static int hf_f1ap_GNB_CU_TNL_Association_Setup_Item_PDU;  /* GNB_CU_TNL_Association_Setup_Item */
static int hf_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item_PDU;  /* GNB_CU_TNL_Association_Failed_To_Setup_Item */
static int hf_f1ap_GNB_CU_TNL_Association_To_Add_Item_PDU;  /* GNB_CU_TNL_Association_To_Add_Item */
static int hf_f1ap_GNB_CU_TNL_Association_To_Remove_Item_PDU;  /* GNB_CU_TNL_Association_To_Remove_Item */
static int hf_f1ap_GNB_CU_TNL_Association_To_Update_Item_PDU;  /* GNB_CU_TNL_Association_To_Update_Item */
static int hf_f1ap_GNB_CU_UE_F1AP_ID_PDU;         /* GNB_CU_UE_F1AP_ID */
static int hf_f1ap_GNB_DU_MBS_F1AP_ID_PDU;        /* GNB_DU_MBS_F1AP_ID */
static int hf_f1ap_GNB_DU_UE_F1AP_ID_PDU;         /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_GNB_DU_ID_PDU;                 /* GNB_DU_ID */
static int hf_f1ap_GNB_CU_Name_PDU;               /* GNB_CU_Name */
static int hf_f1ap_GNB_DU_Name_PDU;               /* GNB_DU_Name */
static int hf_f1ap_Extended_GNB_CU_Name_PDU;      /* Extended_GNB_CU_Name */
static int hf_f1ap_Extended_GNB_DU_Name_PDU;      /* Extended_GNB_DU_Name */
static int hf_f1ap_GNB_DU_Served_Cells_Item_PDU;  /* GNB_DU_Served_Cells_Item */
static int hf_f1ap_GNB_DUConfigurationQuery_PDU;  /* GNB_DUConfigurationQuery */
static int hf_f1ap_GNBDUOverloadInformation_PDU;  /* GNBDUOverloadInformation */
static int hf_f1ap_GNB_DU_TNL_Association_To_Remove_Item_PDU;  /* GNB_DU_TNL_Association_To_Remove_Item */
static int hf_f1ap_GNBDUUESliceMaximumBitRateList_PDU;  /* GNBDUUESliceMaximumBitRateList */
static int hf_f1ap_HandoverPreparationInformation_PDU;  /* HandoverPreparationInformation */
static int hf_f1ap_HardwareLoadIndicator_PDU;     /* HardwareLoadIndicator */
static int hf_f1ap_HashedUEIdentityIndexValue_PDU;  /* HashedUEIdentityIndexValue */
static int hf_f1ap_IAB_Barred_PDU;                /* IAB_Barred */
static int hf_f1ap_IABConditionalRRCMessageDeliveryIndication_PDU;  /* IABConditionalRRCMessageDeliveryIndication */
static int hf_f1ap_IABCongestionIndication_PDU;   /* IABCongestionIndication */
static int hf_f1ap_IAB_Info_IAB_donor_CU_PDU;     /* IAB_Info_IAB_donor_CU */
static int hf_f1ap_IAB_Info_IAB_DU_PDU;           /* IAB_Info_IAB_DU */
static int hf_f1ap_IAB_Allocated_TNL_Address_Item_PDU;  /* IAB_Allocated_TNL_Address_Item */
static int hf_f1ap_IABIPv6RequestType_PDU;        /* IABIPv6RequestType */
static int hf_f1ap_IAB_TNL_Addresses_To_Remove_Item_PDU;  /* IAB_TNL_Addresses_To_Remove_Item */
static int hf_f1ap_IAB_TNL_Addresses_Exception_PDU;  /* IAB_TNL_Addresses_Exception */
static int hf_f1ap_IABv4AddressesRequested_PDU;   /* IABv4AddressesRequested */
static int hf_f1ap_Mobile_IAB_MTUserLocationInformation_PDU;  /* Mobile_IAB_MTUserLocationInformation */
static int hf_f1ap_IgnorePRACHConfiguration_PDU;  /* IgnorePRACHConfiguration */
static int hf_f1ap_IgnoreResourceCoordinationContainer_PDU;  /* IgnoreResourceCoordinationContainer */
static int hf_f1ap_InactivityMonitoringRequest_PDU;  /* InactivityMonitoringRequest */
static int hf_f1ap_InactivityMonitoringResponse_PDU;  /* InactivityMonitoringResponse */
static int hf_f1ap_IntendedTDD_DL_ULConfig_PDU;   /* IntendedTDD_DL_ULConfig */
static int hf_f1ap_InterFrequencyConfig_NoGap_PDU;  /* InterFrequencyConfig_NoGap */
static int hf_f1ap_IngressNonF1terminatingTopologyIndicator_PDU;  /* IngressNonF1terminatingTopologyIndicator */
static int hf_f1ap_IndicationMCInactiveReception_PDU;  /* IndicationMCInactiveReception */
static int hf_f1ap_LTMResetInformation_PDU;       /* LTMResetInformation */
static int hf_f1ap_LTEA2XServicesAuthorized_PDU;  /* LTEA2XServicesAuthorized */
static int hf_f1ap_L571Info_PDU;                  /* L571Info */
static int hf_f1ap_L1151Info_PDU;                 /* L1151Info */
static int hf_f1ap_LastUsedCellIndication_PDU;    /* LastUsedCellIndication */
static int hf_f1ap_LMF_MeasurementID_PDU;         /* LMF_MeasurementID */
static int hf_f1ap_LMF_UE_MeasurementID_PDU;      /* LMF_UE_MeasurementID */
static int hf_f1ap_LocationMeasurementInformation_PDU;  /* LocationMeasurementInformation */
static int hf_f1ap_LowerLayerPresenceStatusChange_PDU;  /* LowerLayerPresenceStatusChange */
static int hf_f1ap_LoS_NLoSInformation_PDU;       /* LoS_NLoSInformation */
static int hf_f1ap_LTEUESidelinkAggregateMaximumBitrate_PDU;  /* LTEUESidelinkAggregateMaximumBitrate */
static int hf_f1ap_LTEV2XServicesAuthorized_PDU;  /* LTEV2XServicesAuthorized */
static int hf_f1ap_LTMCells_ToBeReleased_List_PDU;  /* LTMCells_ToBeReleased_List */
static int hf_f1ap_LTMInformation_Setup_PDU;      /* LTMInformation_Setup */
static int hf_f1ap_LTMConfigurationIDMappingList_PDU;  /* LTMConfigurationIDMappingList */
static int hf_f1ap_LTMInformation_Modify_PDU;     /* LTMInformation_Modify */
static int hf_f1ap_LTMConfiguration_PDU;          /* LTMConfiguration */
static int hf_f1ap_LTMCellSwitchInformation_PDU;  /* LTMCellSwitchInformation */
static int hf_f1ap_LTMCFRAResourceConfig_List_PDU;  /* LTMCFRAResourceConfig_List */
static int hf_f1ap_MaskedIMEISV_PDU;              /* MaskedIMEISV */
static int hf_f1ap_MaxDataBurstVolume_PDU;        /* MaxDataBurstVolume */
static int hf_f1ap_MBS_Broadcast_NeighbourCellList_PDU;  /* MBS_Broadcast_NeighbourCellList */
static int hf_f1ap_MBSInterestIndication_PDU;     /* MBSInterestIndication */
static int hf_f1ap_MBS_CUtoDURRCInformation_PDU;  /* MBS_CUtoDURRCInformation */
static int hf_f1ap_MBSMulticastF1UContextDescriptor_PDU;  /* MBSMulticastF1UContextDescriptor */
static int hf_f1ap_MT_SDT_Information_PDU;        /* MT_SDT_Information */
static int hf_f1ap_MBSMulticastSessionReceptionState_PDU;  /* MBSMulticastSessionReceptionState */
static int hf_f1ap_MulticastCU2DURRCInfo_PDU;     /* MulticastCU2DURRCInfo */
static int hf_f1ap_MulticastCU2DUCommonRRCInfo_PDU;  /* MulticastCU2DUCommonRRCInfo */
static int hf_f1ap_MulticastDU2CURRCInfo_PDU;     /* MulticastDU2CURRCInfo */
static int hf_f1ap_MulticastF1UContext_ToBeSetup_Item_PDU;  /* MulticastF1UContext_ToBeSetup_Item */
static int hf_f1ap_MulticastF1UContext_Setup_Item_PDU;  /* MulticastF1UContext_Setup_Item */
static int hf_f1ap_MulticastF1UContext_FailedToBeSetup_Item_PDU;  /* MulticastF1UContext_FailedToBeSetup_Item */
static int hf_f1ap_MBS_ServiceArea_PDU;           /* MBS_ServiceArea */
static int hf_f1ap_MC_PagingCell_Item_PDU;        /* MC_PagingCell_Item */
static int hf_f1ap_MeasGapSharingConfig_PDU;      /* MeasGapSharingConfig */
static int hf_f1ap_PosMeasurementAmount_PDU;      /* PosMeasurementAmount */
static int hf_f1ap_MeasurementBeamInfoRequest_PDU;  /* MeasurementBeamInfoRequest */
static int hf_f1ap_MeasurementTimingConfiguration_PDU;  /* MeasurementTimingConfiguration */
static int hf_f1ap_MeasurementTimeOccasion_PDU;   /* MeasurementTimeOccasion */
static int hf_f1ap_MeasurementCharacteristicsRequestIndicator_PDU;  /* MeasurementCharacteristicsRequestIndicator */
static int hf_f1ap_MulticastF1UContextReferenceCU_PDU;  /* MulticastF1UContextReferenceCU */
static int hf_f1ap_MultipleULAoA_PDU;             /* MultipleULAoA */
static int hf_f1ap_MDTPollutedMeasurementIndicator_PDU;  /* MDTPollutedMeasurementIndicator */
static int hf_f1ap_MRB_ID_PDU;                    /* MRB_ID */
static int hf_f1ap_MulticastMBSSessionList_PDU;   /* MulticastMBSSessionList */
static int hf_f1ap_MulticastMRBs_FailedToBeModified_Item_PDU;  /* MulticastMRBs_FailedToBeModified_Item */
static int hf_f1ap_MulticastMRBs_FailedToBeSetup_Item_PDU;  /* MulticastMRBs_FailedToBeSetup_Item */
static int hf_f1ap_MulticastMRBs_FailedToBeSetupMod_Item_PDU;  /* MulticastMRBs_FailedToBeSetupMod_Item */
static int hf_f1ap_MulticastMRBs_Modified_Item_PDU;  /* MulticastMRBs_Modified_Item */
static int hf_f1ap_MulticastMRBs_Setup_Item_PDU;  /* MulticastMRBs_Setup_Item */
static int hf_f1ap_MulticastMRBs_SetupMod_Item_PDU;  /* MulticastMRBs_SetupMod_Item */
static int hf_f1ap_MulticastMRBs_ToBeModified_Item_PDU;  /* MulticastMRBs_ToBeModified_Item */
static int hf_f1ap_MulticastMRBs_ToBeReleased_Item_PDU;  /* MulticastMRBs_ToBeReleased_Item */
static int hf_f1ap_MulticastMRBs_ToBeSetup_Item_PDU;  /* MulticastMRBs_ToBeSetup_Item */
static int hf_f1ap_MulticastMRBs_ToBeSetupMod_Item_PDU;  /* MulticastMRBs_ToBeSetupMod_Item */
static int hf_f1ap_MusimCapabilityRestrictionIndication_PDU;  /* MusimCapabilityRestrictionIndication */
static int hf_f1ap_MusimCandidateBandList_PDU;    /* MusimCandidateBandList */
static int hf_f1ap_M5ReportAmount_PDU;            /* M5ReportAmount */
static int hf_f1ap_M6ReportAmount_PDU;            /* M6ReportAmount */
static int hf_f1ap_M7ReportAmount_PDU;            /* M7ReportAmount */
static int hf_f1ap_MDTConfiguration_PDU;          /* MDTConfiguration */
static int hf_f1ap_MDTPLMNList_PDU;               /* MDTPLMNList */
static int hf_f1ap_MDTPLMNModificationList_PDU;   /* MDTPLMNModificationList */
static int hf_f1ap_MeasuredFrequencyHops_PDU;     /* MeasuredFrequencyHops */
static int hf_f1ap_Mobile_TRP_LocationInformation_PDU;  /* Mobile_TRP_LocationInformation */
static int hf_f1ap_Mobile_IAB_MT_UE_ID_PDU;       /* Mobile_IAB_MT_UE_ID */
static int hf_f1ap_MUSIM_GapConfig_PDU;           /* MUSIM_GapConfig */
static int hf_f1ap_MobileIAB_Barred_PDU;          /* MobileIAB_Barred */
static int hf_f1ap_MeasBasedOnAggregatedResources_PDU;  /* MeasBasedOnAggregatedResources */
static int hf_f1ap_MobilityInitiation_PDU;        /* MobilityInitiation */
static int hf_f1ap_NRA2XServicesAuthorized_PDU;   /* NRA2XServicesAuthorized */
static int hf_f1ap_Ncd_SSB_RedCapInitialBWP_SDT_PDU;  /* Ncd_SSB_RedCapInitialBWP_SDT */
static int hf_f1ap_NetworkControlledRepeaterAuthorized_PDU;  /* NetworkControlledRepeaterAuthorized */
static int hf_f1ap_NCGI_to_be_Updated_List_Item_PDU;  /* NCGI_to_be_Updated_List_Item */
static int hf_f1ap_Neighbour_Node_Cells_List_PDU;  /* Neighbour_Node_Cells_List */
static int hf_f1ap_NeedforGap_PDU;                /* NeedforGap */
static int hf_f1ap_NeedForGapsInfoNR_PDU;         /* NeedForGapsInfoNR */
static int hf_f1ap_NeedForGapNCSGInfoNR_PDU;      /* NeedForGapNCSGInfoNR */
static int hf_f1ap_NeedForGapNCSGInfoEUTRA_PDU;   /* NeedForGapNCSGInfoEUTRA */
static int hf_f1ap_NeedForInterruptionInfoNR_PDU;  /* NeedForInterruptionInfoNR */
static int hf_f1ap_Neighbour_Cell_Information_Item_PDU;  /* Neighbour_Cell_Information_Item */
static int hf_f1ap_NID_PDU;                       /* NID */
static int hf_f1ap_NonF1terminatingTopologyIndicator_PDU;  /* NonF1terminatingTopologyIndicator */
static int hf_f1ap_NR_CGI_List_For_Restart_Item_PDU;  /* NR_CGI_List_For_Restart_Item */
static int hf_f1ap_NrofSymbolsExtended_PDU;       /* NrofSymbolsExtended */
static int hf_f1ap_NR_TADV_PDU;                   /* NR_TADV */
static int hf_f1ap_NReRedCapUEIndication_PDU;     /* NReRedCapUEIndication */
static int hf_f1ap_ERedcap_Bcast_Information_PDU;  /* ERedcap_Bcast_Information */
static int hf_f1ap_NRRedCapUEIndication_PDU;      /* NRRedCapUEIndication */
static int hf_f1ap_NRPagingeDRXInformation_PDU;   /* NRPagingeDRXInformation */
static int hf_f1ap_NRPagingeDRXInformationforRRCINACTIVE_PDU;  /* NRPagingeDRXInformationforRRCINACTIVE */
static int hf_f1ap_NRPaginglongeDRXInformationforRRCINACTIVE_PDU;  /* NRPaginglongeDRXInformationforRRCINACTIVE */
static int hf_f1ap_NotificationInformation_PDU;   /* NotificationInformation */
static int hf_f1ap_NPNBroadcastInformation_PDU;   /* NPNBroadcastInformation */
static int hf_f1ap_NPNSupportInfo_PDU;            /* NPNSupportInfo */
static int hf_f1ap_NRCarrierList_PDU;             /* NRCarrierList */
static int hf_f1ap_NRFreqInfo_PDU;                /* NRFreqInfo */
static int hf_f1ap_NRCGI_PDU;                     /* NRCGI */
static int hf_f1ap_f1ap_NRPRACHConfig_PDU;        /* NRPRACHConfig */
static int hf_f1ap_NRPCI_PDU;                     /* NRPCI */
static int hf_f1ap_NR_U_Channel_Info_List_PDU;    /* NR_U_Channel_Info_List */
static int hf_f1ap_NR_U_Channel_List_PDU;         /* NR_U_Channel_List */
static int hf_f1ap_NumberofBroadcastRequest_PDU;  /* NumberofBroadcastRequest */
static int hf_f1ap_NumberOfTRPRxTEG_PDU;          /* NumberOfTRPRxTEG */
static int hf_f1ap_NumberOfTRPRxTxTEG_PDU;        /* NumberOfTRPRxTxTEG */
static int hf_f1ap_NRV2XServicesAuthorized_PDU;   /* NRV2XServicesAuthorized */
static int hf_f1ap_NRUESidelinkAggregateMaximumBitrate_PDU;  /* NRUESidelinkAggregateMaximumBitrate */
static int hf_f1ap_N6JitterInformation_PDU;       /* N6JitterInformation */
static int hf_f1ap_OnDemandPRS_Info_PDU;          /* OnDemandPRS_Info */
static int hf_f1ap_PathAdditionInformation_PDU;   /* PathAdditionInformation */
static int hf_f1ap_PagingCell_Item_PDU;           /* PagingCell_Item */
static int hf_f1ap_Recommended_SSBs_List_PDU;     /* Recommended_SSBs_List */
static int hf_f1ap_PagingDRX_PDU;                 /* PagingDRX */
static int hf_f1ap_PagingIdentity_PDU;            /* PagingIdentity */
static int hf_f1ap_PagingCause_PDU;               /* PagingCause */
static int hf_f1ap_PagingOrigin_PDU;              /* PagingOrigin */
static int hf_f1ap_PagingPriority_PDU;            /* PagingPriority */
static int hf_f1ap_PEIPSAssistanceInfo_PDU;       /* PEIPSAssistanceInfo */
static int hf_f1ap_Parent_IAB_Nodes_NA_Resource_Configuration_List_PDU;  /* Parent_IAB_Nodes_NA_Resource_Configuration_List */
static int hf_f1ap_PathSwitchConfiguration_PDU;   /* PathSwitchConfiguration */
static int hf_f1ap_PC5QoSParameters_PDU;          /* PC5QoSParameters */
static int hf_f1ap_PC5RLCChannelToBeSetupList_PDU;  /* PC5RLCChannelToBeSetupList */
static int hf_f1ap_PeerUE_ID_PDU;                 /* PeerUE_ID */
static int hf_f1ap_PC5RLCChannelToBeModifiedList_PDU;  /* PC5RLCChannelToBeModifiedList */
static int hf_f1ap_PC5RLCChannelToBeReleasedList_PDU;  /* PC5RLCChannelToBeReleasedList */
static int hf_f1ap_PC5RLCChannelSetupList_PDU;    /* PC5RLCChannelSetupList */
static int hf_f1ap_PC5RLCChannelFailedToBeSetupList_PDU;  /* PC5RLCChannelFailedToBeSetupList */
static int hf_f1ap_PC5RLCChannelModifiedList_PDU;  /* PC5RLCChannelModifiedList */
static int hf_f1ap_PC5RLCChannelFailedToBeModifiedList_PDU;  /* PC5RLCChannelFailedToBeModifiedList */
static int hf_f1ap_PC5RLCChannelRequiredToBeModifiedList_PDU;  /* PC5RLCChannelRequiredToBeModifiedList */
static int hf_f1ap_PC5RLCChannelRequiredToBeReleasedList_PDU;  /* PC5RLCChannelRequiredToBeReleasedList */
static int hf_f1ap_PDCCH_BlindDetectionSCG_PDU;   /* PDCCH_BlindDetectionSCG */
static int hf_f1ap_PDCMeasurementPeriodicity_PDU;  /* PDCMeasurementPeriodicity */
static int hf_f1ap_PDCMeasurementQuantities_PDU;  /* PDCMeasurementQuantities */
static int hf_f1ap_PDCMeasurementQuantities_Item_PDU;  /* PDCMeasurementQuantities_Item */
static int hf_f1ap_PDCMeasurementResult_PDU;      /* PDCMeasurementResult */
static int hf_f1ap_PDCReportType_PDU;             /* PDCReportType */
static int hf_f1ap_PDCPSNLength_PDU;              /* PDCPSNLength */
static int hf_f1ap_PDUSessionID_PDU;              /* PDUSessionID */
static int hf_f1ap_PEISubgroupingSupportIndication_PDU;  /* PEISubgroupingSupportIndication */
static int hf_f1ap_Permutation_PDU;               /* Permutation */
static int hf_f1ap_Ph_InfoMCG_PDU;                /* Ph_InfoMCG */
static int hf_f1ap_Ph_InfoSCG_PDU;                /* Ph_InfoSCG */
static int hf_f1ap_PLMN_Identity_PDU;             /* PLMN_Identity */
static int hf_f1ap_PLMNIndexNR_PDU;               /* PLMNIndexNR */
static int hf_f1ap_PortNumber_PDU;                /* PortNumber */
static int hf_f1ap_PosAssistance_Information_PDU;  /* PosAssistance_Information */
static int hf_f1ap_PosAssistanceInformationFailureList_PDU;  /* PosAssistanceInformationFailureList */
static int hf_f1ap_PosBroadcast_PDU;              /* PosBroadcast */
static int hf_f1ap_PosContextRevIndication_PDU;   /* PosContextRevIndication */
static int hf_f1ap_PositioningBroadcastCells_PDU;  /* PositioningBroadcastCells */
static int hf_f1ap_PosMeasGapPreConfigList_PDU;   /* PosMeasGapPreConfigList */
static int hf_f1ap_MeasurementPeriodicity_PDU;    /* MeasurementPeriodicity */
static int hf_f1ap_MeasurementPeriodicityExtended_PDU;  /* MeasurementPeriodicityExtended */
static int hf_f1ap_PosMeasurementPeriodicityNR_AoA_PDU;  /* PosMeasurementPeriodicityNR_AoA */
static int hf_f1ap_PosMeasurementQuantities_PDU;  /* PosMeasurementQuantities */
static int hf_f1ap_PosMeasurementResultList_PDU;  /* PosMeasurementResultList */
static int hf_f1ap_PosReportCharacteristics_PDU;  /* PosReportCharacteristics */
static int hf_f1ap_PosSItypeList_PDU;             /* PosSItypeList */
static int hf_f1ap_PosValidityAreaCellList_PDU;   /* PosValidityAreaCellList */
static int hf_f1ap_Preconfigured_measurement_GAP_Request_PDU;  /* Preconfigured_measurement_GAP_Request */
static int hf_f1ap_Protected_EUTRA_Resources_Item_PDU;  /* Protected_EUTRA_Resources_Item */
static int hf_f1ap_PRS_Measurement_Info_List_PDU;  /* PRS_Measurement_Info_List */
static int hf_f1ap_Potential_SpCell_Item_PDU;     /* Potential_SpCell_Item */
static int hf_f1ap_PRSConfigRequestType_PDU;      /* PRSConfigRequestType */
static int hf_f1ap_PRS_Resource_ID_PDU;           /* PRS_Resource_ID */
static int hf_f1ap_PRSBWAggregationRequestInfoList_PDU;  /* PRSBWAggregationRequestInfoList */
static int hf_f1ap_ExtendedResourceSymbolOffset_PDU;  /* ExtendedResourceSymbolOffset */
static int hf_f1ap_PWS_Failed_NR_CGI_Item_PDU;    /* PWS_Failed_NR_CGI_Item */
static int hf_f1ap_PWSSystemInformation_PDU;      /* PWSSystemInformation */
static int hf_f1ap_PrivacyIndicator_PDU;          /* PrivacyIndicator */
static int hf_f1ap_PRSTRPList_PDU;                /* PRSTRPList */
static int hf_f1ap_PRSTransmissionTRPList_PDU;    /* PRSTransmissionTRPList */
static int hf_f1ap_PDUSetQoSParameters_PDU;       /* PDUSetQoSParameters */
static int hf_f1ap_PSIbasedSDUdiscardUL_PDU;      /* PSIbasedSDUdiscardUL */
static int hf_f1ap_PointA_PDU;                    /* PointA */
static int hf_f1ap_PSCellList_PDU;                /* PSCellList */
static int hf_f1ap_QoEInformation_PDU;            /* QoEInformation */
static int hf_f1ap_QoSFlowMappingIndication_PDU;  /* QoSFlowMappingIndication */
static int hf_f1ap_QosMonitoringRequest_PDU;      /* QosMonitoringRequest */
static int hf_f1ap_QoSParaSetNotifyIndex_PDU;     /* QoSParaSetNotifyIndex */
static int hf_f1ap_RAReportList_PDU;              /* RAReportList */
static int hf_f1ap_RAReportIndicationList_PDU;    /* RAReportIndicationList */
static int hf_f1ap_RadioResourceStatusNR_U_PDU;   /* RadioResourceStatusNR_U */
static int hf_f1ap_MIMOPRBusageInformation_PDU;   /* MIMOPRBusageInformation */
static int hf_f1ap_RANfeedbacktype_PDU;           /* RANfeedbacktype */
static int hf_f1ap_RANSharingAssistanceInformation_PDU;  /* RANSharingAssistanceInformation */
static int hf_f1ap_RANTSSRequestType_PDU;         /* RANTSSRequestType */
static int hf_f1ap_RANTimingSynchronisationStatusInfo_PDU;  /* RANTimingSynchronisationStatusInfo */
static int hf_f1ap_RANAC_PDU;                     /* RANAC */
static int hf_f1ap_RAN_MeasurementID_PDU;         /* RAN_MeasurementID */
static int hf_f1ap_RAN_UE_MeasurementID_PDU;      /* RAN_UE_MeasurementID */
static int hf_f1ap_RAN_UE_PDC_MeasID_PDU;         /* RAN_UE_PDC_MeasID */
static int hf_f1ap_RANUEID_PDU;                   /* RANUEID */
static int hf_f1ap_RAT_FrequencyPriorityInformation_PDU;  /* RAT_FrequencyPriorityInformation */
static int hf_f1ap_RBSetConfiguration_PDU;        /* RBSetConfiguration */
static int hf_f1ap_Re_routingEnableIndicator_PDU;  /* Re_routingEnableIndicator */
static int hf_f1ap_Recommended_SSBs_for_Paging_List_PDU;  /* Recommended_SSBs_for_Paging_List */
static int hf_f1ap_Redcap_Bcast_Information_PDU;  /* Redcap_Bcast_Information */
static int hf_f1ap_RedCapIndication_PDU;          /* RedCapIndication */
static int hf_f1ap_LocalOrigin_PDU;               /* LocalOrigin */
static int hf_f1ap_RemoteUELocalID_PDU;           /* RemoteUELocalID */
static int hf_f1ap_RegistrationRequest_PDU;       /* RegistrationRequest */
static int hf_f1ap_ReportCharacteristics_PDU;     /* ReportCharacteristics */
static int hf_f1ap_ReportingGranularitykminus1_PDU;  /* ReportingGranularitykminus1 */
static int hf_f1ap_ReportingGranularitykminus2_PDU;  /* ReportingGranularitykminus2 */
static int hf_f1ap_ReportingGranularitykminus3_PDU;  /* ReportingGranularitykminus3 */
static int hf_f1ap_ReportingGranularitykminus4_PDU;  /* ReportingGranularitykminus4 */
static int hf_f1ap_ReportingGranularitykminus5_PDU;  /* ReportingGranularitykminus5 */
static int hf_f1ap_ReportingGranularitykminus6_PDU;  /* ReportingGranularitykminus6 */
static int hf_f1ap_ReportingGranularitykminus1AdditionalPath_PDU;  /* ReportingGranularitykminus1AdditionalPath */
static int hf_f1ap_ReportingGranularitykminus2AdditionalPath_PDU;  /* ReportingGranularitykminus2AdditionalPath */
static int hf_f1ap_ReportingGranularitykminus3AdditionalPath_PDU;  /* ReportingGranularitykminus3AdditionalPath */
static int hf_f1ap_ReportingGranularitykminus4AdditionalPath_PDU;  /* ReportingGranularitykminus4AdditionalPath */
static int hf_f1ap_ReportingGranularitykminus5AdditionalPath_PDU;  /* ReportingGranularitykminus5AdditionalPath */
static int hf_f1ap_ReportingGranularitykminus6AdditionalPath_PDU;  /* ReportingGranularitykminus6AdditionalPath */
static int hf_f1ap_ReportingPeriodicity_PDU;      /* ReportingPeriodicity */
static int hf_f1ap_RequestedBandCombinationIndex_PDU;  /* RequestedBandCombinationIndex */
static int hf_f1ap_RequestedFeatureSetEntryIndex_PDU;  /* RequestedFeatureSetEntryIndex */
static int hf_f1ap_RequestedP_MaxFR2_PDU;         /* RequestedP_MaxFR2 */
static int hf_f1ap_Requested_PDCCH_BlindDetectionSCG_PDU;  /* Requested_PDCCH_BlindDetectionSCG */
static int hf_f1ap_RequestedSRSPreconfigurationCharacteristics_List_PDU;  /* RequestedSRSPreconfigurationCharacteristics_List */
static int hf_f1ap_RequestedSRSTransmissionCharacteristics_PDU;  /* RequestedSRSTransmissionCharacteristics */
static int hf_f1ap_RequestType_PDU;               /* RequestType */
static int hf_f1ap_ResourceCoordinationTransferInformation_PDU;  /* ResourceCoordinationTransferInformation */
static int hf_f1ap_ResourceCoordinationTransferContainer_PDU;  /* ResourceCoordinationTransferContainer */
static int hf_f1ap_RepetitionFactorExtended_PDU;  /* RepetitionFactorExtended */
static int hf_f1ap_RepetitionPeriod_PDU;          /* RepetitionPeriod */
static int hf_f1ap_ReportingRequestType_PDU;      /* ReportingRequestType */
static int hf_f1ap_RLCDuplicationInformation_PDU;  /* RLCDuplicationInformation */
static int hf_f1ap_RLCFailureIndication_PDU;      /* RLCFailureIndication */
static int hf_f1ap_RLCMode_PDU;                   /* RLCMode */
static int hf_f1ap_RLC_Status_PDU;                /* RLC_Status */
static int hf_f1ap_RLFReportInformationList_PDU;  /* RLFReportInformationList */
static int hf_f1ap_RRCContainer_PDU;              /* RRCContainer */
static int hf_f1ap_RRCContainer_RRCSetupComplete_PDU;  /* RRCContainer_RRCSetupComplete */
static int hf_f1ap_RRCDeliveryStatus_PDU;         /* RRCDeliveryStatus */
static int hf_f1ap_RRCDeliveryStatusRequest_PDU;  /* RRCDeliveryStatusRequest */
static int hf_f1ap_RRCReconfigurationCompleteIndicator_PDU;  /* RRCReconfigurationCompleteIndicator */
static int hf_f1ap_RRC_Terminating_IAB_Donor_Related_Info_PDU;  /* RRC_Terminating_IAB_Donor_Related_Info */
static int hf_f1ap_RRC_Version_PDU;               /* RRC_Version */
static int hf_f1ap_Latest_RRC_Version_Enhanced_PDU;  /* Latest_RRC_Version_Enhanced */
static int hf_f1ap_RoutingID_PDU;                 /* RoutingID */
static int hf_f1ap_ResponseTime_PDU;              /* ResponseTime */
static int hf_f1ap_ReportingIntervalIMs_PDU;      /* ReportingIntervalIMs */
static int hf_f1ap_SCell_FailedtoSetup_Item_PDU;  /* SCell_FailedtoSetup_Item */
static int hf_f1ap_SCell_FailedtoSetupMod_Item_PDU;  /* SCell_FailedtoSetupMod_Item */
static int hf_f1ap_SCell_ToBeRemoved_Item_PDU;    /* SCell_ToBeRemoved_Item */
static int hf_f1ap_SCell_ToBeSetup_Item_PDU;      /* SCell_ToBeSetup_Item */
static int hf_f1ap_SCell_ToBeSetupMod_Item_PDU;   /* SCell_ToBeSetupMod_Item */
static int hf_f1ap_SCGActivationRequest_PDU;      /* SCGActivationRequest */
static int hf_f1ap_SCGActivationStatus_PDU;       /* SCGActivationStatus */
static int hf_f1ap_SCGIndicator_PDU;              /* SCGIndicator */
static int hf_f1ap_SCPAC_Request_PDU;             /* SCPAC_Request */
static int hf_f1ap_S_CPAC_Configuration_PDU;      /* S_CPAC_Configuration */
static int hf_f1ap_S_CPACLowerLayerReferenceConfigRequest_PDU;  /* S_CPACLowerLayerReferenceConfigRequest */
static int hf_f1ap_SCS_480_PDU;                   /* SCS_480 */
static int hf_f1ap_SCS_960_PDU;                   /* SCS_960 */
static int hf_f1ap_SCS_SpecificCarrier_PDU;       /* SCS_SpecificCarrier */
static int hf_f1ap_SDTBearerConfigurationQueryIndication_PDU;  /* SDTBearerConfigurationQueryIndication */
static int hf_f1ap_SDTBearerConfigurationInfo_PDU;  /* SDTBearerConfigurationInfo */
static int hf_f1ap_SDT_MAC_PHY_CG_Config_PDU;     /* SDT_MAC_PHY_CG_Config */
static int hf_f1ap_SDTInformation_PDU;            /* SDTInformation */
static int hf_f1ap_SDTRLCBearerConfiguration_PDU;  /* SDTRLCBearerConfiguration */
static int hf_f1ap_SDT_Termination_Request_PDU;   /* SDT_Termination_Request */
static int hf_f1ap_SDT_Volume_Threshold_PDU;      /* SDT_Volume_Threshold */
static int hf_f1ap_SelectedBandCombinationIndex_PDU;  /* SelectedBandCombinationIndex */
static int hf_f1ap_SelectedFeatureSetEntryIndex_PDU;  /* SelectedFeatureSetEntryIndex */
static int hf_f1ap_ServCellInfoList_PDU;          /* ServCellInfoList */
static int hf_f1ap_ServCellIndex_PDU;             /* ServCellIndex */
static int hf_f1ap_ServingCellMO_PDU;             /* ServingCellMO */
static int hf_f1ap_ServingCellMO_List_Item_PDU;   /* ServingCellMO_List_Item */
static int hf_f1ap_ServingCellMO_encoded_in_CGC_List_PDU;  /* ServingCellMO_encoded_in_CGC_List */
static int hf_f1ap_Serving_Cells_List_PDU;        /* Serving_Cells_List */
static int hf_f1ap_Supported_MBS_FSA_ID_List_PDU;  /* Supported_MBS_FSA_ID_List */
static int hf_f1ap_SFN_Offset_PDU;                /* SFN_Offset */
static int hf_f1ap_Served_Cells_To_Add_Item_PDU;  /* Served_Cells_To_Add_Item */
static int hf_f1ap_Served_Cells_To_Delete_Item_PDU;  /* Served_Cells_To_Delete_Item */
static int hf_f1ap_Served_Cells_To_Modify_Item_PDU;  /* Served_Cells_To_Modify_Item */
static int hf_f1ap_RelativeTime1900_PDU;          /* RelativeTime1900 */
static int hf_f1ap_SIB10_message_PDU;             /* SIB10_message */
static int hf_f1ap_SIB12_message_PDU;             /* SIB12_message */
static int hf_f1ap_SIB13_message_PDU;             /* SIB13_message */
static int hf_f1ap_SIB14_message_PDU;             /* SIB14_message */
static int hf_f1ap_SIB15_message_PDU;             /* SIB15_message */
static int hf_f1ap_SIB17_message_PDU;             /* SIB17_message */
static int hf_f1ap_SIB20_message_PDU;             /* SIB20_message */
static int hf_f1ap_SIB24_message_PDU;             /* SIB24_message */
static int hf_f1ap_SIB22_message_PDU;             /* SIB22_message */
static int hf_f1ap_SIB23_message_PDU;             /* SIB23_message */
static int hf_f1ap_SIB17bis_message_PDU;          /* SIB17bis_message */
static int hf_f1ap_SItype_List_PDU;               /* SItype_List */
static int hf_f1ap_SidelinkRelayConfiguration_PDU;  /* SidelinkRelayConfiguration */
static int hf_f1ap_SLDRBs_FailedToBeModified_Item_PDU;  /* SLDRBs_FailedToBeModified_Item */
static int hf_f1ap_SLDRBs_FailedToBeSetup_Item_PDU;  /* SLDRBs_FailedToBeSetup_Item */
static int hf_f1ap_SLDRBs_FailedToBeSetupMod_Item_PDU;  /* SLDRBs_FailedToBeSetupMod_Item */
static int hf_f1ap_SLDRBs_Modified_Item_PDU;      /* SLDRBs_Modified_Item */
static int hf_f1ap_SLDRBs_ModifiedConf_Item_PDU;  /* SLDRBs_ModifiedConf_Item */
static int hf_f1ap_SLDRBs_Required_ToBeModified_Item_PDU;  /* SLDRBs_Required_ToBeModified_Item */
static int hf_f1ap_SLDRBs_Required_ToBeReleased_Item_PDU;  /* SLDRBs_Required_ToBeReleased_Item */
static int hf_f1ap_SLDRBs_Setup_Item_PDU;         /* SLDRBs_Setup_Item */
static int hf_f1ap_SLDRBs_SetupMod_Item_PDU;      /* SLDRBs_SetupMod_Item */
static int hf_f1ap_SLDRBs_ToBeModified_Item_PDU;  /* SLDRBs_ToBeModified_Item */
static int hf_f1ap_SLDRBs_ToBeReleased_Item_PDU;  /* SLDRBs_ToBeReleased_Item */
static int hf_f1ap_SLDRBs_ToBeSetup_Item_PDU;     /* SLDRBs_ToBeSetup_Item */
static int hf_f1ap_SLDRBs_ToBeSetupMod_Item_PDU;  /* SLDRBs_ToBeSetupMod_Item */
static int hf_f1ap_SLDRXCycleList_PDU;            /* SLDRXCycleList */
static int hf_f1ap_SL_PHY_MAC_RLC_Config_PDU;     /* SL_PHY_MAC_RLC_Config */
static int hf_f1ap_SL_PHY_MAC_RLC_ConfigExt_PDU;  /* SL_PHY_MAC_RLC_ConfigExt */
static int hf_f1ap_SL_RLC_ChannelToAddModList_PDU;  /* SL_RLC_ChannelToAddModList */
static int hf_f1ap_SL_ConfigDedicatedEUTRA_Info_PDU;  /* SL_ConfigDedicatedEUTRA_Info */
static int hf_f1ap_SliceRadioResourceStatus_PDU;  /* SliceRadioResourceStatus */
static int hf_f1ap_SliceSupportList_PDU;          /* SliceSupportList */
static int hf_f1ap_SlotNumber_PDU;                /* SlotNumber */
static int hf_f1ap_SLPositioning_Ranging_Service_Info_PDU;  /* SLPositioning_Ranging_Service_Info */
static int hf_f1ap_SNSSAI_PDU;                    /* SNSSAI */
static int hf_f1ap_SpatialRelationPerSRSResource_PDU;  /* SpatialRelationPerSRSResource */
static int hf_f1ap_SRBID_PDU;                     /* SRBID */
static int hf_f1ap_SRBs_FailedToBeSetup_Item_PDU;  /* SRBs_FailedToBeSetup_Item */
static int hf_f1ap_SRBs_FailedToBeSetupMod_Item_PDU;  /* SRBs_FailedToBeSetupMod_Item */
static int hf_f1ap_SRBs_Modified_Item_PDU;        /* SRBs_Modified_Item */
static int hf_f1ap_SRBs_Required_ToBeReleased_Item_PDU;  /* SRBs_Required_ToBeReleased_Item */
static int hf_f1ap_SRBs_Setup_Item_PDU;           /* SRBs_Setup_Item */
static int hf_f1ap_SRBs_SetupMod_Item_PDU;        /* SRBs_SetupMod_Item */
static int hf_f1ap_SRBs_ToBeReleased_Item_PDU;    /* SRBs_ToBeReleased_Item */
static int hf_f1ap_SRBs_ToBeSetup_Item_PDU;       /* SRBs_ToBeSetup_Item */
static int hf_f1ap_SRBs_ToBeSetupMod_Item_PDU;    /* SRBs_ToBeSetupMod_Item */
static int hf_f1ap_SRSConfiguration_PDU;          /* SRSConfiguration */
static int hf_f1ap_SrsFrequency_PDU;              /* SrsFrequency */
static int hf_f1ap_SRSPortIndex_PDU;              /* SRSPortIndex */
static int hf_f1ap_SRSPosPeriodicConfigHyperSFNIndex_PDU;  /* SRSPosPeriodicConfigHyperSFNIndex */
static int hf_f1ap_SRSPreconfiguration_List_PDU;  /* SRSPreconfiguration_List */
static int hf_f1ap_SRSResourcetype_PDU;           /* SRSResourcetype */
static int hf_f1ap_SRSPosRRCInactiveConfig_PDU;   /* SRSPosRRCInactiveConfig */
static int hf_f1ap_SRSPosRRCInactiveValidityAreaConfig_PDU;  /* SRSPosRRCInactiveValidityAreaConfig */
static int hf_f1ap_SRSPosRRCInactiveQueryIndication_PDU;  /* SRSPosRRCInactiveQueryIndication */
static int hf_f1ap_SRSReservationType_PDU;        /* SRSReservationType */
static int hf_f1ap_SSB_PositionsInBurst_PDU;      /* SSB_PositionsInBurst */
static int hf_f1ap_SSBs_toBeActivated_List_PDU;   /* SSBs_toBeActivated_List */
static int hf_f1ap_StartRBIndex_PDU;              /* StartRBIndex */
static int hf_f1ap_StartRBHopping_PDU;            /* StartRBHopping */
static int hf_f1ap_SuccessfulHOReportInformationList_PDU;  /* SuccessfulHOReportInformationList */
static int hf_f1ap_SuccessfulPSCellChangeReportInformationList_PDU;  /* SuccessfulPSCellChangeReportInformationList */
static int hf_f1ap_SULAccessIndication_PDU;       /* SULAccessIndication */
static int hf_f1ap_SupportedUETypeList_PDU;       /* SupportedUETypeList */
static int hf_f1ap_SurvivalTime_PDU;              /* SurvivalTime */
static int hf_f1ap_SymbolIndex_PDU;               /* SymbolIndex */
static int hf_f1ap_SystemFrameNumber_PDU;         /* SystemFrameNumber */
static int hf_f1ap_SystemInformationAreaID_PDU;   /* SystemInformationAreaID */
static int hf_f1ap_TagIDPointer_PDU;              /* TagIDPointer */
static int hf_f1ap_TargetCellList_PDU;            /* TargetCellList */
static int hf_f1ap_NSAGSupportList_PDU;           /* NSAGSupportList */
static int hf_f1ap_TDD_UL_DLConfigCommonNR_PDU;   /* TDD_UL_DLConfigCommonNR */
static int hf_f1ap_TRPTEGInformation_PDU;         /* TRPTEGInformation */
static int hf_f1ap_TimeReferenceInformation_PDU;  /* TimeReferenceInformation */
static int hf_f1ap_TimeToWait_PDU;                /* TimeToWait */
static int hf_f1ap_TimingReportingGranularityFactorExtended_PDU;  /* TimingReportingGranularityFactorExtended */
static int hf_f1ap_TimeWindowInformation_Measurement_List_PDU;  /* TimeWindowInformation_Measurement_List */
static int hf_f1ap_TimeWindowInformation_SRS_List_PDU;  /* TimeWindowInformation_SRS_List */
static int hf_f1ap_TNLCapacityIndicator_PDU;      /* TNLCapacityIndicator */
static int hf_f1ap_TraceActivation_PDU;           /* TraceActivation */
static int hf_f1ap_TraceID_PDU;                   /* TraceID */
static int hf_f1ap_TrafficMappingInfo_PDU;        /* TrafficMappingInfo */
static int hf_f1ap_TransportLayerAddress_PDU;     /* TransportLayerAddress */
static int hf_f1ap_TransactionID_PDU;             /* TransactionID */
static int hf_f1ap_Transmission_Bandwidth_PDU;    /* Transmission_Bandwidth */
static int hf_f1ap_Transmission_Bandwidth_asymmetric_PDU;  /* Transmission_Bandwidth_asymmetric */
static int hf_f1ap_TransmissionCombn8_PDU;        /* TransmissionCombn8 */
static int hf_f1ap_TransmissionStopIndicator_PDU;  /* TransmissionStopIndicator */
static int hf_f1ap_TransmissionActionIndicator_PDU;  /* TransmissionActionIndicator */
static int hf_f1ap_TRPBeamAntennaInformation_PDU;  /* TRPBeamAntennaInformation */
static int hf_f1ap_TRPInformationItem_PDU;        /* TRPInformationItem */
static int hf_f1ap_TRPInformationTypeItem_PDU;    /* TRPInformationTypeItem */
static int hf_f1ap_TRPList_PDU;                   /* TRPList */
static int hf_f1ap_PhaseQuality_PDU;              /* PhaseQuality */
static int hf_f1ap_TRP_MeasurementRequestList_PDU;  /* TRP_MeasurementRequestList */
static int hf_f1ap_TRP_PRS_Info_List_PDU;         /* TRP_PRS_Info_List */
static int hf_f1ap_TRP_Rx_TEGInformation_PDU;     /* TRP_Rx_TEGInformation */
static int hf_f1ap_TRPTxTEGAssociation_PDU;       /* TRPTxTEGAssociation */
static int hf_f1ap_Transport_Layer_Address_Info_PDU;  /* Transport_Layer_Address_Info */
static int hf_f1ap_TRPType_PDU;                   /* TRPType */
static int hf_f1ap_TSCTrafficCharacteristics_PDU;  /* TSCTrafficCharacteristics */
static int hf_f1ap_TSCTrafficCharacteristicsFeedback_PDU;  /* TSCTrafficCharacteristicsFeedback */
static int hf_f1ap_TRP_MeasurementUpdateList_PDU;  /* TRP_MeasurementUpdateList */
static int hf_f1ap_TwoPHRModeMCG_PDU;             /* TwoPHRModeMCG */
static int hf_f1ap_TwoPHRModeSCG_PDU;             /* TwoPHRModeSCG */
static int hf_f1ap_TxHoppingConfiguration_PDU;    /* TxHoppingConfiguration */
static int hf_f1ap_TAInformation_List_PDU;        /* TAInformation_List */
static int hf_f1ap_UAC_Assistance_Info_PDU;       /* UAC_Assistance_Info */
static int hf_f1ap_UE_associatedLogicalF1_ConnectionItem_PDU;  /* UE_associatedLogicalF1_ConnectionItem */
static int hf_f1ap_UEAssistanceInformation_PDU;   /* UEAssistanceInformation */
static int hf_f1ap_UEAssistanceInformationEUTRA_PDU;  /* UEAssistanceInformationEUTRA */
static int hf_f1ap_UEContextNotRetrievable_PDU;   /* UEContextNotRetrievable */
static int hf_f1ap_UEIdentityIndexValue_PDU;      /* UEIdentityIndexValue */
static int hf_f1ap_UEIdentity_List_For_Paging_Item_PDU;  /* UEIdentity_List_For_Paging_Item */
static int hf_f1ap_UE_MulticastMRBs_ConfirmedToBeModified_Item_PDU;  /* UE_MulticastMRBs_ConfirmedToBeModified_Item */
static int hf_f1ap_UE_MulticastMRBs_RequiredToBeModified_Item_PDU;  /* UE_MulticastMRBs_RequiredToBeModified_Item */
static int hf_f1ap_UE_MulticastMRBs_RequiredToBeReleased_Item_PDU;  /* UE_MulticastMRBs_RequiredToBeReleased_Item */
static int hf_f1ap_UE_MulticastMRBs_Setup_Item_PDU;  /* UE_MulticastMRBs_Setup_Item */
static int hf_f1ap_UE_MulticastMRBs_Setupnew_Item_PDU;  /* UE_MulticastMRBs_Setupnew_Item */
static int hf_f1ap_UE_MulticastMRBs_ToBeReleased_Item_PDU;  /* UE_MulticastMRBs_ToBeReleased_Item */
static int hf_f1ap_UE_MulticastMRBs_ToBeSetup_Item_PDU;  /* UE_MulticastMRBs_ToBeSetup_Item */
static int hf_f1ap_UE_MulticastMRBs_ToBeSetup_atModify_Item_PDU;  /* UE_MulticastMRBs_ToBeSetup_atModify_Item */
static int hf_f1ap_UEPagingCapability_PDU;        /* UEPagingCapability */
static int hf_f1ap_UEReportingInformation_PDU;    /* UEReportingInformation */
static int hf_f1ap_UlTxDirectCurrentMoreCarrierInformation_PDU;  /* UlTxDirectCurrentMoreCarrierInformation */
static int hf_f1ap_UL_BH_Non_UP_Traffic_Mapping_PDU;  /* UL_BH_Non_UP_Traffic_Mapping */
static int hf_f1ap_UL_GapFR2_Config_PDU;          /* UL_GapFR2_Config */
static int hf_f1ap_UL_SRS_RSRPP_PDU;              /* UL_SRS_RSRPP */
static int hf_f1ap_UL_RSCP_PDU;                   /* UL_RSCP */
static int hf_f1ap_UL_UP_TNL_Information_to_Update_List_Item_PDU;  /* UL_UP_TNL_Information_to_Update_List_Item */
static int hf_f1ap_UL_UP_TNL_Address_to_Update_List_Item_PDU;  /* UL_UP_TNL_Address_to_Update_List_Item */
static int hf_f1ap_UplinkTxDirectCurrentListInformation_PDU;  /* UplinkTxDirectCurrentListInformation */
static int hf_f1ap_UplinkTxDirectCurrentTwoCarrierListInfo_PDU;  /* UplinkTxDirectCurrentTwoCarrierListInfo */
static int hf_f1ap_URI_address_PDU;               /* URI_address */
static int hf_f1ap_UuRLCChannelID_PDU;            /* UuRLCChannelID */
static int hf_f1ap_UuRLCChannelToBeSetupList_PDU;  /* UuRLCChannelToBeSetupList */
static int hf_f1ap_UuRLCChannelToBeModifiedList_PDU;  /* UuRLCChannelToBeModifiedList */
static int hf_f1ap_UuRLCChannelToBeReleasedList_PDU;  /* UuRLCChannelToBeReleasedList */
static int hf_f1ap_UuRLCChannelSetupList_PDU;     /* UuRLCChannelSetupList */
static int hf_f1ap_UuRLCChannelFailedToBeSetupList_PDU;  /* UuRLCChannelFailedToBeSetupList */
static int hf_f1ap_UuRLCChannelModifiedList_PDU;  /* UuRLCChannelModifiedList */
static int hf_f1ap_UuRLCChannelFailedToBeModifiedList_PDU;  /* UuRLCChannelFailedToBeModifiedList */
static int hf_f1ap_UuRLCChannelRequiredToBeModifiedList_PDU;  /* UuRLCChannelRequiredToBeModifiedList */
static int hf_f1ap_UuRLCChannelRequiredToBeReleasedList_PDU;  /* UuRLCChannelRequiredToBeReleasedList */
static int hf_f1ap_VictimgNBSetID_PDU;            /* VictimgNBSetID */
static int hf_f1ap_ValidityAreaSpecificSRSInformation_PDU;  /* ValidityAreaSpecificSRSInformation */
static int hf_f1ap_ValidityAreaSpecificSRSInformationExtended_PDU;  /* ValidityAreaSpecificSRSInformationExtended */
static int hf_f1ap_XR_Bcast_Information_PDU;      /* XR_Bcast_Information */
static int hf_f1ap_ZoAInformation_PDU;            /* ZoAInformation */
static int hf_f1ap_Reset_PDU;                     /* Reset */
static int hf_f1ap_ResetType_PDU;                 /* ResetType */
static int hf_f1ap_ResetAcknowledge_PDU;          /* ResetAcknowledge */
static int hf_f1ap_UE_associatedLogicalF1_ConnectionListResAck_PDU;  /* UE_associatedLogicalF1_ConnectionListResAck */
static int hf_f1ap_ErrorIndication_PDU;           /* ErrorIndication */
static int hf_f1ap_F1SetupRequest_PDU;            /* F1SetupRequest */
static int hf_f1ap_GNB_DU_Served_Cells_List_PDU;  /* GNB_DU_Served_Cells_List */
static int hf_f1ap_F1SetupResponse_PDU;           /* F1SetupResponse */
static int hf_f1ap_Cells_to_be_Activated_List_PDU;  /* Cells_to_be_Activated_List */
static int hf_f1ap_NCGI_to_be_Updated_List_PDU;   /* NCGI_to_be_Updated_List */
static int hf_f1ap_F1SetupFailure_PDU;            /* F1SetupFailure */
static int hf_f1ap_GNBDUConfigurationUpdate_PDU;  /* GNBDUConfigurationUpdate */
static int hf_f1ap_Served_Cells_To_Add_List_PDU;  /* Served_Cells_To_Add_List */
static int hf_f1ap_Served_Cells_To_Modify_List_PDU;  /* Served_Cells_To_Modify_List */
static int hf_f1ap_Served_Cells_To_Delete_List_PDU;  /* Served_Cells_To_Delete_List */
static int hf_f1ap_Cells_Status_List_PDU;         /* Cells_Status_List */
static int hf_f1ap_Dedicated_SIDelivery_NeededUE_List_PDU;  /* Dedicated_SIDelivery_NeededUE_List */
static int hf_f1ap_GNB_DU_TNL_Association_To_Remove_List_PDU;  /* GNB_DU_TNL_Association_To_Remove_List */
static int hf_f1ap_GNBDUConfigurationUpdateAcknowledge_PDU;  /* GNBDUConfigurationUpdateAcknowledge */
static int hf_f1ap_GNBDUConfigurationUpdateFailure_PDU;  /* GNBDUConfigurationUpdateFailure */
static int hf_f1ap_GNBCUConfigurationUpdate_PDU;  /* GNBCUConfigurationUpdate */
static int hf_f1ap_Cells_to_be_Deactivated_List_PDU;  /* Cells_to_be_Deactivated_List */
static int hf_f1ap_GNB_CU_TNL_Association_To_Add_List_PDU;  /* GNB_CU_TNL_Association_To_Add_List */
static int hf_f1ap_GNB_CU_TNL_Association_To_Remove_List_PDU;  /* GNB_CU_TNL_Association_To_Remove_List */
static int hf_f1ap_GNB_CU_TNL_Association_To_Update_List_PDU;  /* GNB_CU_TNL_Association_To_Update_List */
static int hf_f1ap_Cells_to_be_Barred_List_PDU;   /* Cells_to_be_Barred_List */
static int hf_f1ap_Cells_Allowed_to_be_Deactivated_List_PDU;  /* Cells_Allowed_to_be_Deactivated_List */
static int hf_f1ap_Protected_EUTRA_Resources_List_PDU;  /* Protected_EUTRA_Resources_List */
static int hf_f1ap_Neighbour_Cell_Information_List_PDU;  /* Neighbour_Cell_Information_List */
static int hf_f1ap_GNBCUConfigurationUpdateAcknowledge_PDU;  /* GNBCUConfigurationUpdateAcknowledge */
static int hf_f1ap_Cells_Failed_to_be_Activated_List_PDU;  /* Cells_Failed_to_be_Activated_List */
static int hf_f1ap_GNB_CU_TNL_Association_Setup_List_PDU;  /* GNB_CU_TNL_Association_Setup_List */
static int hf_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List_PDU;  /* GNB_CU_TNL_Association_Failed_To_Setup_List */
static int hf_f1ap_GNBCUConfigurationUpdateFailure_PDU;  /* GNBCUConfigurationUpdateFailure */
static int hf_f1ap_GNBDUResourceCoordinationRequest_PDU;  /* GNBDUResourceCoordinationRequest */
static int hf_f1ap_GNBDUResourceCoordinationResponse_PDU;  /* GNBDUResourceCoordinationResponse */
static int hf_f1ap_UEContextSetupRequest_PDU;     /* UEContextSetupRequest */
static int hf_f1ap_Candidate_SpCell_List_PDU;     /* Candidate_SpCell_List */
static int hf_f1ap_SCell_ToBeSetup_List_PDU;      /* SCell_ToBeSetup_List */
static int hf_f1ap_SRBs_ToBeSetup_List_PDU;       /* SRBs_ToBeSetup_List */
static int hf_f1ap_DRBs_ToBeSetup_List_PDU;       /* DRBs_ToBeSetup_List */
static int hf_f1ap_BHChannels_ToBeSetup_List_PDU;  /* BHChannels_ToBeSetup_List */
static int hf_f1ap_SLDRBs_ToBeSetup_List_PDU;     /* SLDRBs_ToBeSetup_List */
static int hf_f1ap_UE_MulticastMRBs_ToBeSetup_List_PDU;  /* UE_MulticastMRBs_ToBeSetup_List */
static int hf_f1ap_ServingCellMO_List_PDU;        /* ServingCellMO_List */
static int hf_f1ap_UEContextSetupResponse_PDU;    /* UEContextSetupResponse */
static int hf_f1ap_DRBs_Setup_List_PDU;           /* DRBs_Setup_List */
static int hf_f1ap_SRBs_FailedToBeSetup_List_PDU;  /* SRBs_FailedToBeSetup_List */
static int hf_f1ap_DRBs_FailedToBeSetup_List_PDU;  /* DRBs_FailedToBeSetup_List */
static int hf_f1ap_SCell_FailedtoSetup_List_PDU;  /* SCell_FailedtoSetup_List */
static int hf_f1ap_SRBs_Setup_List_PDU;           /* SRBs_Setup_List */
static int hf_f1ap_BHChannels_Setup_List_PDU;     /* BHChannels_Setup_List */
static int hf_f1ap_BHChannels_FailedToBeSetup_List_PDU;  /* BHChannels_FailedToBeSetup_List */
static int hf_f1ap_SLDRBs_Setup_List_PDU;         /* SLDRBs_Setup_List */
static int hf_f1ap_SLDRBs_FailedToBeSetup_List_PDU;  /* SLDRBs_FailedToBeSetup_List */
static int hf_f1ap_UE_MulticastMRBs_Setupnew_List_PDU;  /* UE_MulticastMRBs_Setupnew_List */
static int hf_f1ap_UEContextSetupFailure_PDU;     /* UEContextSetupFailure */
static int hf_f1ap_Potential_SpCell_List_PDU;     /* Potential_SpCell_List */
static int hf_f1ap_UEContextReleaseRequest_PDU;   /* UEContextReleaseRequest */
static int hf_f1ap_UEContextReleaseCommand_PDU;   /* UEContextReleaseCommand */
static int hf_f1ap_UEContextReleaseComplete_PDU;  /* UEContextReleaseComplete */
static int hf_f1ap_UEContextModificationRequest_PDU;  /* UEContextModificationRequest */
static int hf_f1ap_SCell_ToBeSetupMod_List_PDU;   /* SCell_ToBeSetupMod_List */
static int hf_f1ap_SCell_ToBeRemoved_List_PDU;    /* SCell_ToBeRemoved_List */
static int hf_f1ap_SRBs_ToBeSetupMod_List_PDU;    /* SRBs_ToBeSetupMod_List */
static int hf_f1ap_DRBs_ToBeSetupMod_List_PDU;    /* DRBs_ToBeSetupMod_List */
static int hf_f1ap_BHChannels_ToBeSetupMod_List_PDU;  /* BHChannels_ToBeSetupMod_List */
static int hf_f1ap_DRBs_ToBeModified_List_PDU;    /* DRBs_ToBeModified_List */
static int hf_f1ap_BHChannels_ToBeModified_List_PDU;  /* BHChannels_ToBeModified_List */
static int hf_f1ap_SRBs_ToBeReleased_List_PDU;    /* SRBs_ToBeReleased_List */
static int hf_f1ap_DRBs_ToBeReleased_List_PDU;    /* DRBs_ToBeReleased_List */
static int hf_f1ap_BHChannels_ToBeReleased_List_PDU;  /* BHChannels_ToBeReleased_List */
static int hf_f1ap_UE_MulticastMRBs_ToBeSetup_atModify_List_PDU;  /* UE_MulticastMRBs_ToBeSetup_atModify_List */
static int hf_f1ap_UE_MulticastMRBs_ToBeReleased_List_PDU;  /* UE_MulticastMRBs_ToBeReleased_List */
static int hf_f1ap_SLDRBs_ToBeSetupMod_List_PDU;  /* SLDRBs_ToBeSetupMod_List */
static int hf_f1ap_SLDRBs_ToBeModified_List_PDU;  /* SLDRBs_ToBeModified_List */
static int hf_f1ap_SLDRBs_ToBeReleased_List_PDU;  /* SLDRBs_ToBeReleased_List */
static int hf_f1ap_UEContextModificationResponse_PDU;  /* UEContextModificationResponse */
static int hf_f1ap_DRBs_SetupMod_List_PDU;        /* DRBs_SetupMod_List */
static int hf_f1ap_DRBs_Modified_List_PDU;        /* DRBs_Modified_List */
static int hf_f1ap_SRBs_SetupMod_List_PDU;        /* SRBs_SetupMod_List */
static int hf_f1ap_SRBs_Modified_List_PDU;        /* SRBs_Modified_List */
static int hf_f1ap_DRBs_FailedToBeModified_List_PDU;  /* DRBs_FailedToBeModified_List */
static int hf_f1ap_SRBs_FailedToBeSetupMod_List_PDU;  /* SRBs_FailedToBeSetupMod_List */
static int hf_f1ap_DRBs_FailedToBeSetupMod_List_PDU;  /* DRBs_FailedToBeSetupMod_List */
static int hf_f1ap_SCell_FailedtoSetupMod_List_PDU;  /* SCell_FailedtoSetupMod_List */
static int hf_f1ap_BHChannels_SetupMod_List_PDU;  /* BHChannels_SetupMod_List */
static int hf_f1ap_BHChannels_Modified_List_PDU;  /* BHChannels_Modified_List */
static int hf_f1ap_BHChannels_FailedToBeModified_List_PDU;  /* BHChannels_FailedToBeModified_List */
static int hf_f1ap_BHChannels_FailedToBeSetupMod_List_PDU;  /* BHChannels_FailedToBeSetupMod_List */
static int hf_f1ap_Associated_SCell_List_PDU;     /* Associated_SCell_List */
static int hf_f1ap_SLDRBs_SetupMod_List_PDU;      /* SLDRBs_SetupMod_List */
static int hf_f1ap_SLDRBs_Modified_List_PDU;      /* SLDRBs_Modified_List */
static int hf_f1ap_SLDRBs_FailedToBeModified_List_PDU;  /* SLDRBs_FailedToBeModified_List */
static int hf_f1ap_SLDRBs_FailedToBeSetupMod_List_PDU;  /* SLDRBs_FailedToBeSetupMod_List */
static int hf_f1ap_UE_MulticastMRBs_Setup_List_PDU;  /* UE_MulticastMRBs_Setup_List */
static int hf_f1ap_UEContextModificationFailure_PDU;  /* UEContextModificationFailure */
static int hf_f1ap_UEContextModificationRequired_PDU;  /* UEContextModificationRequired */
static int hf_f1ap_DRBs_Required_ToBeModified_List_PDU;  /* DRBs_Required_ToBeModified_List */
static int hf_f1ap_DRBs_Required_ToBeReleased_List_PDU;  /* DRBs_Required_ToBeReleased_List */
static int hf_f1ap_SRBs_Required_ToBeReleased_List_PDU;  /* SRBs_Required_ToBeReleased_List */
static int hf_f1ap_BHChannels_Required_ToBeReleased_List_PDU;  /* BHChannels_Required_ToBeReleased_List */
static int hf_f1ap_SLDRBs_Required_ToBeModified_List_PDU;  /* SLDRBs_Required_ToBeModified_List */
static int hf_f1ap_SLDRBs_Required_ToBeReleased_List_PDU;  /* SLDRBs_Required_ToBeReleased_List */
static int hf_f1ap_UE_MulticastMRBs_RequiredToBeModified_List_PDU;  /* UE_MulticastMRBs_RequiredToBeModified_List */
static int hf_f1ap_UE_MulticastMRBs_RequiredToBeReleased_List_PDU;  /* UE_MulticastMRBs_RequiredToBeReleased_List */
static int hf_f1ap_UEContextModificationConfirm_PDU;  /* UEContextModificationConfirm */
static int hf_f1ap_DRBs_ModifiedConf_List_PDU;    /* DRBs_ModifiedConf_List */
static int hf_f1ap_SLDRBs_ModifiedConf_List_PDU;  /* SLDRBs_ModifiedConf_List */
static int hf_f1ap_UE_MulticastMRBs_ConfirmedToBeModified_List_PDU;  /* UE_MulticastMRBs_ConfirmedToBeModified_List */
static int hf_f1ap_UEContextModificationRefuse_PDU;  /* UEContextModificationRefuse */
static int hf_f1ap_WriteReplaceWarningRequest_PDU;  /* WriteReplaceWarningRequest */
static int hf_f1ap_Cells_To_Be_Broadcast_List_PDU;  /* Cells_To_Be_Broadcast_List */
static int hf_f1ap_WriteReplaceWarningResponse_PDU;  /* WriteReplaceWarningResponse */
static int hf_f1ap_Cells_Broadcast_Completed_List_PDU;  /* Cells_Broadcast_Completed_List */
static int hf_f1ap_PWSCancelRequest_PDU;          /* PWSCancelRequest */
static int hf_f1ap_Broadcast_To_Be_Cancelled_List_PDU;  /* Broadcast_To_Be_Cancelled_List */
static int hf_f1ap_PWSCancelResponse_PDU;         /* PWSCancelResponse */
static int hf_f1ap_Cells_Broadcast_Cancelled_List_PDU;  /* Cells_Broadcast_Cancelled_List */
static int hf_f1ap_UEInactivityNotification_PDU;  /* UEInactivityNotification */
static int hf_f1ap_DRB_Activity_List_PDU;         /* DRB_Activity_List */
static int hf_f1ap_InitialULRRCMessageTransfer_PDU;  /* InitialULRRCMessageTransfer */
static int hf_f1ap_DLRRCMessageTransfer_PDU;      /* DLRRCMessageTransfer */
static int hf_f1ap_RedirectedRRCmessage_PDU;      /* RedirectedRRCmessage */
static int hf_f1ap_ULRRCMessageTransfer_PDU;      /* ULRRCMessageTransfer */
static int hf_f1ap_PrivateMessage_PDU;            /* PrivateMessage */
static int hf_f1ap_SystemInformationDeliveryCommand_PDU;  /* SystemInformationDeliveryCommand */
static int hf_f1ap_Paging_PDU;                    /* Paging */
static int hf_f1ap_PagingCell_list_PDU;           /* PagingCell_list */
static int hf_f1ap_Notify_PDU;                    /* Notify */
static int hf_f1ap_DRB_Notify_List_PDU;           /* DRB_Notify_List */
static int hf_f1ap_NetworkAccessRateReduction_PDU;  /* NetworkAccessRateReduction */
static int hf_f1ap_PWSRestartIndication_PDU;      /* PWSRestartIndication */
static int hf_f1ap_NR_CGI_List_For_Restart_List_PDU;  /* NR_CGI_List_For_Restart_List */
static int hf_f1ap_PWSFailureIndication_PDU;      /* PWSFailureIndication */
static int hf_f1ap_PWS_Failed_NR_CGI_List_PDU;    /* PWS_Failed_NR_CGI_List */
static int hf_f1ap_GNBDUStatusIndication_PDU;     /* GNBDUStatusIndication */
static int hf_f1ap_RRCDeliveryReport_PDU;         /* RRCDeliveryReport */
static int hf_f1ap_F1RemovalRequest_PDU;          /* F1RemovalRequest */
static int hf_f1ap_F1RemovalResponse_PDU;         /* F1RemovalResponse */
static int hf_f1ap_F1RemovalFailure_PDU;          /* F1RemovalFailure */
static int hf_f1ap_TraceStart_PDU;                /* TraceStart */
static int hf_f1ap_DeactivateTrace_PDU;           /* DeactivateTrace */
static int hf_f1ap_CellTrafficTrace_PDU;          /* CellTrafficTrace */
static int hf_f1ap_DUCURadioInformationTransfer_PDU;  /* DUCURadioInformationTransfer */
static int hf_f1ap_CUDURadioInformationTransfer_PDU;  /* CUDURadioInformationTransfer */
static int hf_f1ap_BAPMappingConfiguration_PDU;   /* BAPMappingConfiguration */
static int hf_f1ap_BH_Routing_Information_Added_List_PDU;  /* BH_Routing_Information_Added_List */
static int hf_f1ap_BH_Routing_Information_Removed_List_PDU;  /* BH_Routing_Information_Removed_List */
static int hf_f1ap_BAP_Header_Rewriting_Added_List_PDU;  /* BAP_Header_Rewriting_Added_List */
static int hf_f1ap_BAP_Header_Rewriting_Removed_List_PDU;  /* BAP_Header_Rewriting_Removed_List */
static int hf_f1ap_BAPMappingConfigurationAcknowledge_PDU;  /* BAPMappingConfigurationAcknowledge */
static int hf_f1ap_BAPMappingConfigurationFailure_PDU;  /* BAPMappingConfigurationFailure */
static int hf_f1ap_GNBDUResourceConfiguration_PDU;  /* GNBDUResourceConfiguration */
static int hf_f1ap_GNBDUResourceConfigurationAcknowledge_PDU;  /* GNBDUResourceConfigurationAcknowledge */
static int hf_f1ap_GNBDUResourceConfigurationFailure_PDU;  /* GNBDUResourceConfigurationFailure */
static int hf_f1ap_IABTNLAddressRequest_PDU;      /* IABTNLAddressRequest */
static int hf_f1ap_IAB_TNL_Addresses_To_Remove_List_PDU;  /* IAB_TNL_Addresses_To_Remove_List */
static int hf_f1ap_IABTNLAddressResponse_PDU;     /* IABTNLAddressResponse */
static int hf_f1ap_IAB_Allocated_TNL_Address_List_PDU;  /* IAB_Allocated_TNL_Address_List */
static int hf_f1ap_IABTNLAddressFailure_PDU;      /* IABTNLAddressFailure */
static int hf_f1ap_IABUPConfigurationUpdateRequest_PDU;  /* IABUPConfigurationUpdateRequest */
static int hf_f1ap_UL_UP_TNL_Information_to_Update_List_PDU;  /* UL_UP_TNL_Information_to_Update_List */
static int hf_f1ap_UL_UP_TNL_Address_to_Update_List_PDU;  /* UL_UP_TNL_Address_to_Update_List */
static int hf_f1ap_IABUPConfigurationUpdateResponse_PDU;  /* IABUPConfigurationUpdateResponse */
static int hf_f1ap_DL_UP_TNL_Address_to_Update_List_PDU;  /* DL_UP_TNL_Address_to_Update_List */
static int hf_f1ap_IABUPConfigurationUpdateFailure_PDU;  /* IABUPConfigurationUpdateFailure */
static int hf_f1ap_MIABF1SetupTriggering_PDU;     /* MIABF1SetupTriggering */
static int hf_f1ap_MIABF1SetupOutcomeNotification_PDU;  /* MIABF1SetupOutcomeNotification */
static int hf_f1ap_F1SetupOutcome_PDU;            /* F1SetupOutcome */
static int hf_f1ap_Activated_Cells_Mapping_List_PDU;  /* Activated_Cells_Mapping_List */
static int hf_f1ap_ResourceStatusRequest_PDU;     /* ResourceStatusRequest */
static int hf_f1ap_ResourceStatusResponse_PDU;    /* ResourceStatusResponse */
static int hf_f1ap_ResourceStatusFailure_PDU;     /* ResourceStatusFailure */
static int hf_f1ap_ResourceStatusUpdate_PDU;      /* ResourceStatusUpdate */
static int hf_f1ap_AccessAndMobilityIndication_PDU;  /* AccessAndMobilityIndication */
static int hf_f1ap_ReferenceTimeInformationReportingControl_PDU;  /* ReferenceTimeInformationReportingControl */
static int hf_f1ap_ReferenceTimeInformationReport_PDU;  /* ReferenceTimeInformationReport */
static int hf_f1ap_AccessSuccess_PDU;             /* AccessSuccess */
static int hf_f1ap_PositioningAssistanceInformationControl_PDU;  /* PositioningAssistanceInformationControl */
static int hf_f1ap_PositioningAssistanceInformationFeedback_PDU;  /* PositioningAssistanceInformationFeedback */
static int hf_f1ap_PositioningMeasurementRequest_PDU;  /* PositioningMeasurementRequest */
static int hf_f1ap_PositioningMeasurementResponse_PDU;  /* PositioningMeasurementResponse */
static int hf_f1ap_PositioningMeasurementFailure_PDU;  /* PositioningMeasurementFailure */
static int hf_f1ap_PositioningMeasurementReport_PDU;  /* PositioningMeasurementReport */
static int hf_f1ap_PositioningMeasurementAbort_PDU;  /* PositioningMeasurementAbort */
static int hf_f1ap_PositioningMeasurementFailureIndication_PDU;  /* PositioningMeasurementFailureIndication */
static int hf_f1ap_PositioningMeasurementUpdate_PDU;  /* PositioningMeasurementUpdate */
static int hf_f1ap_TRPInformationRequest_PDU;     /* TRPInformationRequest */
static int hf_f1ap_TRPInformationTypeListTRPReq_PDU;  /* TRPInformationTypeListTRPReq */
static int hf_f1ap_TRPInformationResponse_PDU;    /* TRPInformationResponse */
static int hf_f1ap_TRPInformationListTRPResp_PDU;  /* TRPInformationListTRPResp */
static int hf_f1ap_TRPInformationFailure_PDU;     /* TRPInformationFailure */
static int hf_f1ap_PositioningInformationRequest_PDU;  /* PositioningInformationRequest */
static int hf_f1ap_PositioningInformationResponse_PDU;  /* PositioningInformationResponse */
static int hf_f1ap_PositioningInformationFailure_PDU;  /* PositioningInformationFailure */
static int hf_f1ap_PositioningActivationRequest_PDU;  /* PositioningActivationRequest */
static int hf_f1ap_SRSType_PDU;                   /* SRSType */
static int hf_f1ap_PositioningActivationResponse_PDU;  /* PositioningActivationResponse */
static int hf_f1ap_PositioningActivationFailure_PDU;  /* PositioningActivationFailure */
static int hf_f1ap_PositioningDeactivation_PDU;   /* PositioningDeactivation */
static int hf_f1ap_PositioningInformationUpdate_PDU;  /* PositioningInformationUpdate */
static int hf_f1ap_SRSInformationReservationNotification_PDU;  /* SRSInformationReservationNotification */
static int hf_f1ap_E_CIDMeasurementInitiationRequest_PDU;  /* E_CIDMeasurementInitiationRequest */
static int hf_f1ap_E_CIDMeasurementInitiationResponse_PDU;  /* E_CIDMeasurementInitiationResponse */
static int hf_f1ap_E_CIDMeasurementInitiationFailure_PDU;  /* E_CIDMeasurementInitiationFailure */
static int hf_f1ap_E_CIDMeasurementFailureIndication_PDU;  /* E_CIDMeasurementFailureIndication */
static int hf_f1ap_E_CIDMeasurementReport_PDU;    /* E_CIDMeasurementReport */
static int hf_f1ap_E_CIDMeasurementTerminationCommand_PDU;  /* E_CIDMeasurementTerminationCommand */
static int hf_f1ap_BroadcastContextSetupRequest_PDU;  /* BroadcastContextSetupRequest */
static int hf_f1ap_BroadcastMRBs_ToBeSetup_List_PDU;  /* BroadcastMRBs_ToBeSetup_List */
static int hf_f1ap_BroadcastContextSetupResponse_PDU;  /* BroadcastContextSetupResponse */
static int hf_f1ap_BroadcastMRBs_Setup_List_PDU;  /* BroadcastMRBs_Setup_List */
static int hf_f1ap_BroadcastMRBs_FailedToBeSetup_List_PDU;  /* BroadcastMRBs_FailedToBeSetup_List */
static int hf_f1ap_BroadcastContextSetupFailure_PDU;  /* BroadcastContextSetupFailure */
static int hf_f1ap_BroadcastContextReleaseCommand_PDU;  /* BroadcastContextReleaseCommand */
static int hf_f1ap_BroadcastContextReleaseComplete_PDU;  /* BroadcastContextReleaseComplete */
static int hf_f1ap_BroadcastContextReleaseRequest_PDU;  /* BroadcastContextReleaseRequest */
static int hf_f1ap_BroadcastContextModificationRequest_PDU;  /* BroadcastContextModificationRequest */
static int hf_f1ap_BroadcastMRBs_ToBeSetupMod_List_PDU;  /* BroadcastMRBs_ToBeSetupMod_List */
static int hf_f1ap_BroadcastMRBs_ToBeModified_List_PDU;  /* BroadcastMRBs_ToBeModified_List */
static int hf_f1ap_BroadcastMRBs_ToBeReleased_List_PDU;  /* BroadcastMRBs_ToBeReleased_List */
static int hf_f1ap_BroadcastContextModificationResponse_PDU;  /* BroadcastContextModificationResponse */
static int hf_f1ap_BroadcastMRBs_SetupMod_List_PDU;  /* BroadcastMRBs_SetupMod_List */
static int hf_f1ap_BroadcastMRBs_FailedToBeSetupMod_List_PDU;  /* BroadcastMRBs_FailedToBeSetupMod_List */
static int hf_f1ap_BroadcastMRBs_Modified_List_PDU;  /* BroadcastMRBs_Modified_List */
static int hf_f1ap_BroadcastMRBs_FailedToBeModified_List_PDU;  /* BroadcastMRBs_FailedToBeModified_List */
static int hf_f1ap_BroadcastContextModificationFailure_PDU;  /* BroadcastContextModificationFailure */
static int hf_f1ap_BroadcastTransportResourceRequest_PDU;  /* BroadcastTransportResourceRequest */
static int hf_f1ap_Broadcast_MRBs_Transport_Request_List_PDU;  /* Broadcast_MRBs_Transport_Request_List */
static int hf_f1ap_MulticastGroupPaging_PDU;      /* MulticastGroupPaging */
static int hf_f1ap_UEIdentity_List_For_Paging_List_PDU;  /* UEIdentity_List_For_Paging_List */
static int hf_f1ap_MC_PagingCell_list_PDU;        /* MC_PagingCell_list */
static int hf_f1ap_MulticastContextSetupRequest_PDU;  /* MulticastContextSetupRequest */
static int hf_f1ap_MulticastMRBs_ToBeSetup_List_PDU;  /* MulticastMRBs_ToBeSetup_List */
static int hf_f1ap_MulticastContextSetupResponse_PDU;  /* MulticastContextSetupResponse */
static int hf_f1ap_MulticastMRBs_Setup_List_PDU;  /* MulticastMRBs_Setup_List */
static int hf_f1ap_MulticastMRBs_FailedToBeSetup_List_PDU;  /* MulticastMRBs_FailedToBeSetup_List */
static int hf_f1ap_MulticastContextSetupFailure_PDU;  /* MulticastContextSetupFailure */
static int hf_f1ap_MulticastContextReleaseCommand_PDU;  /* MulticastContextReleaseCommand */
static int hf_f1ap_MulticastContextReleaseComplete_PDU;  /* MulticastContextReleaseComplete */
static int hf_f1ap_MulticastContextReleaseRequest_PDU;  /* MulticastContextReleaseRequest */
static int hf_f1ap_MulticastContextModificationRequest_PDU;  /* MulticastContextModificationRequest */
static int hf_f1ap_MulticastMRBs_ToBeSetupMod_List_PDU;  /* MulticastMRBs_ToBeSetupMod_List */
static int hf_f1ap_MulticastMRBs_ToBeModified_List_PDU;  /* MulticastMRBs_ToBeModified_List */
static int hf_f1ap_MulticastMRBs_ToBeReleased_List_PDU;  /* MulticastMRBs_ToBeReleased_List */
static int hf_f1ap_MulticastContextModificationResponse_PDU;  /* MulticastContextModificationResponse */
static int hf_f1ap_MulticastMRBs_SetupMod_List_PDU;  /* MulticastMRBs_SetupMod_List */
static int hf_f1ap_MulticastMRBs_FailedToBeSetupMod_List_PDU;  /* MulticastMRBs_FailedToBeSetupMod_List */
static int hf_f1ap_MulticastMRBs_Modified_List_PDU;  /* MulticastMRBs_Modified_List */
static int hf_f1ap_MulticastMRBs_FailedToBeModified_List_PDU;  /* MulticastMRBs_FailedToBeModified_List */
static int hf_f1ap_MulticastContextModificationFailure_PDU;  /* MulticastContextModificationFailure */
static int hf_f1ap_MulticastContextNotificationIndication_PDU;  /* MulticastContextNotificationIndication */
static int hf_f1ap_MulticastContextNotificationConfirm_PDU;  /* MulticastContextNotificationConfirm */
static int hf_f1ap_MulticastContextNotificationRefuse_PDU;  /* MulticastContextNotificationRefuse */
static int hf_f1ap_MulticastCommonConfigurationRequest_PDU;  /* MulticastCommonConfigurationRequest */
static int hf_f1ap_MulticastCommonConfigurationResponse_PDU;  /* MulticastCommonConfigurationResponse */
static int hf_f1ap_MulticastCommonConfigurationRefuse_PDU;  /* MulticastCommonConfigurationRefuse */
static int hf_f1ap_MulticastDistributionSetupRequest_PDU;  /* MulticastDistributionSetupRequest */
static int hf_f1ap_MulticastF1UContext_ToBeSetup_List_PDU;  /* MulticastF1UContext_ToBeSetup_List */
static int hf_f1ap_MulticastDistributionSetupResponse_PDU;  /* MulticastDistributionSetupResponse */
static int hf_f1ap_MulticastF1UContext_Setup_List_PDU;  /* MulticastF1UContext_Setup_List */
static int hf_f1ap_MulticastF1UContext_FailedToBeSetup_List_PDU;  /* MulticastF1UContext_FailedToBeSetup_List */
static int hf_f1ap_MulticastDistributionSetupFailure_PDU;  /* MulticastDistributionSetupFailure */
static int hf_f1ap_MulticastDistributionReleaseCommand_PDU;  /* MulticastDistributionReleaseCommand */
static int hf_f1ap_MulticastDistributionReleaseComplete_PDU;  /* MulticastDistributionReleaseComplete */
static int hf_f1ap_PDCMeasurementInitiationRequest_PDU;  /* PDCMeasurementInitiationRequest */
static int hf_f1ap_PDCMeasurementInitiationResponse_PDU;  /* PDCMeasurementInitiationResponse */
static int hf_f1ap_PDCMeasurementInitiationFailure_PDU;  /* PDCMeasurementInitiationFailure */
static int hf_f1ap_PDCMeasurementReport_PDU;      /* PDCMeasurementReport */
static int hf_f1ap_PDCMeasurementTerminationCommand_PDU;  /* PDCMeasurementTerminationCommand */
static int hf_f1ap_PDCMeasurementFailureIndication_PDU;  /* PDCMeasurementFailureIndication */
static int hf_f1ap_PRSConfigurationRequest_PDU;   /* PRSConfigurationRequest */
static int hf_f1ap_PRSConfigurationResponse_PDU;  /* PRSConfigurationResponse */
static int hf_f1ap_PRSConfigurationFailure_PDU;   /* PRSConfigurationFailure */
static int hf_f1ap_MeasurementPreconfigurationRequired_PDU;  /* MeasurementPreconfigurationRequired */
static int hf_f1ap_MeasurementPreconfigurationConfirm_PDU;  /* MeasurementPreconfigurationConfirm */
static int hf_f1ap_MeasurementPreconfigurationRefuse_PDU;  /* MeasurementPreconfigurationRefuse */
static int hf_f1ap_MeasurementActivation_PDU;     /* MeasurementActivation */
static int hf_f1ap_QoEInformationTransfer_PDU;    /* QoEInformationTransfer */
static int hf_f1ap_PosSystemInformationDeliveryCommand_PDU;  /* PosSystemInformationDeliveryCommand */
static int hf_f1ap_DUCUCellSwitchNotification_PDU;  /* DUCUCellSwitchNotification */
static int hf_f1ap_CUDUCellSwitchNotification_PDU;  /* CUDUCellSwitchNotification */
static int hf_f1ap_DUCUTAInformationTransfer_PDU;  /* DUCUTAInformationTransfer */
static int hf_f1ap_CUDUTAInformationTransfer_PDU;  /* CUDUTAInformationTransfer */
static int hf_f1ap_QoEInformationTransferControl_PDU;  /* QoEInformationTransferControl */
static int hf_f1ap_RachIndication_PDU;            /* RachIndication */
static int hf_f1ap_TimingSynchronisationStatusRequest_PDU;  /* TimingSynchronisationStatusRequest */
static int hf_f1ap_TimingSynchronisationStatusResponse_PDU;  /* TimingSynchronisationStatusResponse */
static int hf_f1ap_TimingSynchronisationStatusFailure_PDU;  /* TimingSynchronisationStatusFailure */
static int hf_f1ap_TimingSynchronisationStatusReport_PDU;  /* TimingSynchronisationStatusReport */
static int hf_f1ap_DUCUAccessAndMobilityIndication_PDU;  /* DUCUAccessAndMobilityIndication */
static int hf_f1ap_CUDUMobilityInitiationRequest_PDU;  /* CUDUMobilityInitiationRequest */
static int hf_f1ap_F1AP_PDU_PDU;                  /* F1AP_PDU */
static int hf_f1ap_local;                         /* INTEGER_0_65535 */
static int hf_f1ap_global;                        /* T_global */
static int hf_f1ap_ProtocolIE_Container_item;     /* ProtocolIE_Field */
static int hf_f1ap_id;                            /* ProtocolIE_ID */
static int hf_f1ap_criticality;                   /* Criticality */
static int hf_f1ap_ie_field_value;                /* T_ie_field_value */
static int hf_f1ap_ProtocolExtensionContainer_item;  /* ProtocolExtensionField */
static int hf_f1ap_ext_id;                        /* ProtocolExtensionID */
static int hf_f1ap_extensionValue;                /* T_extensionValue */
static int hf_f1ap_PrivateIE_Container_item;      /* PrivateIE_Field */
static int hf_f1ap_private_id;                    /* PrivateIE_ID */
static int hf_f1ap_value;                         /* T_value */
static int hf_f1ap_sRSResourceSetID;              /* SRSResourceSetID */
static int hf_f1ap_releaseALL;                    /* NULL */
static int hf_f1ap_choice_extension;              /* ProtocolIE_SingleContainer */
static int hf_f1ap_latitudeSign;                  /* T_latitudeSign */
static int hf_f1ap_latitude;                      /* INTEGER_0_8388607 */
static int hf_f1ap_longitude;                     /* INTEGER_M8388608_8388607 */
static int hf_f1ap_directionOfAltitude;           /* T_directionOfAltitude */
static int hf_f1ap_altitude;                      /* INTEGER_0_32767 */
static int hf_f1ap_uncertaintySemi_major;         /* INTEGER_0_127 */
static int hf_f1ap_uncertaintySemi_minor;         /* INTEGER_0_127 */
static int hf_f1ap_orientationOfMajorAxis;        /* INTEGER_0_179 */
static int hf_f1ap_uncertaintyAltitude;           /* INTEGER_0_127 */
static int hf_f1ap_confidence;                    /* INTEGER_0_100 */
static int hf_f1ap_iE_Extensions;                 /* ProtocolExtensionContainer */
static int hf_f1ap_nRCGIforTargetLogicalDU;       /* NRCGI */
static int hf_f1ap_nRCGIforSourceLogicalDU;       /* NRCGI */
static int hf_f1ap_Activated_Cells_to_be_Updated_List_item;  /* Activated_Cells_to_be_Updated_List_Item */
static int hf_f1ap_nRCGI;                         /* NRCGI */
static int hf_f1ap_iAB_DU_Cell_Resource_Configuration_Mode_Info;  /* IAB_DU_Cell_Resource_Configuration_Mode_Info */
static int hf_f1ap_locationAndBandwidth;          /* INTEGER_0_37949_ */
static int hf_f1ap_subcarrierSpacing;             /* T_subcarrierSpacing */
static int hf_f1ap_cyclicPrefix;                  /* T_cyclicPrefix */
static int hf_f1ap_txDirectCurrentLocation;       /* INTEGER_0_3301_ */
static int hf_f1ap_shift7dot5kHz;                 /* T_shift7dot5kHz */
static int hf_f1ap_sRSConfig;                     /* SRSConfig */
static int hf_f1ap_AdditionalPath_List_item;      /* AdditionalPath_Item */
static int hf_f1ap_relativePathDelay;             /* RelativePathDelay */
static int hf_f1ap_pathQuality;                   /* TRPMeasurementQuality */
static int hf_f1ap_ExtendedAdditionalPathList_item;  /* ExtendedAdditionalPathList_Item */
static int hf_f1ap_relativeTimeOfPath;            /* RelativePathDelay */
static int hf_f1ap_multipleULAoA;                 /* MultipleULAoA */
static int hf_f1ap_pathPower;                     /* UL_SRS_RSRPP */
static int hf_f1ap_AdditionalPDCPDuplicationTNL_List_item;  /* AdditionalPDCPDuplicationTNL_Item */
static int hf_f1ap_additionalPDCPDuplicationUPTNLInformation;  /* UPTransportLayerInformation */
static int hf_f1ap_AdditionalSIBMessageList_item;  /* AdditionalSIBMessageList_Item */
static int hf_f1ap_additionalSIB;                 /* T_additionalSIB */
static int hf_f1ap_AffectedCellsAndBeams_List_item;  /* AffectedCellsAndBeams_Item */
static int hf_f1ap_affectedSSB_List;              /* AffectedSSB_List */
static int hf_f1ap_AffectedSSB_List_item;         /* AffectedSSB_Item */
static int hf_f1ap_sSB_Index;                     /* INTEGER_0_63 */
static int hf_f1ap_AggregatedPosSRSResourceIDList_item;  /* Aggregated_PosSRS_Resource_ID_Item */
static int hf_f1ap_positioningSRS;                /* SRSPosResourceID */
static int hf_f1ap_AggregatedPosSRSResourceSetList_item;  /* AggregatedPosSRSResourceSet_Item */
static int hf_f1ap_combined_posSRSResourceSet_List;  /* Combined_PosSRSResourceSet_List */
static int hf_f1ap_Combined_PosSRSResourceSet_List_item;  /* Combined_PosSRSResourceSet_Item */
static int hf_f1ap_pointA;                        /* INTEGER_0_3279165 */
static int hf_f1ap_nRPCI;                         /* NRPCI */
static int hf_f1ap_posSRSResourceSetID;           /* INTEGER_0_15 */
static int hf_f1ap_scs_specificCarrier;           /* SCS_SpecificCarrier */
static int hf_f1ap_AggregatedPRSResourceSetList_item;  /* AggregatedPRSResourceSet_Item */
static int hf_f1ap_dl_PRS_ResourceSet_List;       /* DL_PRS_ResourceSet_List */
static int hf_f1ap_DL_PRS_ResourceSet_List_item;  /* DL_PRS_ResourceSet_Item */
static int hf_f1ap_dl_prs_ResourceSetIndex;       /* INTEGER_1_8 */
static int hf_f1ap_AggressorCellList_item;        /* AggressorCellList_Item */
static int hf_f1ap_aggressorCell_ID;              /* NRCGI */
static int hf_f1ap_aggressorgNBSetID;             /* GNBSetID */
static int hf_f1ap_priorityLevel;                 /* PriorityLevel */
static int hf_f1ap_pre_emptionCapability;         /* Pre_emptionCapability */
static int hf_f1ap_pre_emptionVulnerability;      /* Pre_emptionVulnerability */
static int hf_f1ap_AlternativeQoSParaSetList_item;  /* AlternativeQoSParaSetItem */
static int hf_f1ap_alternativeQoSParaSetIndex;    /* QoSParaSetIndex */
static int hf_f1ap_guaranteedFlowBitRateDL;       /* BitRate */
static int hf_f1ap_guaranteedFlowBitRateUL;       /* BitRate */
static int hf_f1ap_packetDelayBudget;             /* PacketDelayBudget */
static int hf_f1ap_packetErrorRate;               /* PacketErrorRate */
static int hf_f1ap_azimuthQuality;                /* INTEGER_0_255 */
static int hf_f1ap_zenithQuality;                 /* INTEGER_0_255 */
static int hf_f1ap_resolution;                    /* T_resolution */
static int hf_f1ap_AperiodicSRSResourceTriggerList_item;  /* AperiodicSRSResourceTrigger */
static int hf_f1ap_sCell_ID;                      /* NRCGI */
static int hf_f1ap_AvailablePLMNList_item;        /* AvailablePLMNList_Item */
static int hf_f1ap_pLMNIdentity;                  /* PLMN_Identity */
static int hf_f1ap_AvailableSNPN_ID_List_item;    /* AvailableSNPN_ID_List_Item */
static int hf_f1ap_pLMN_Identity;                 /* PLMN_Identity */
static int hf_f1ap_availableNIDList;              /* BroadcastNIDList */
static int hf_f1ap_angleMeasurement;              /* AngleMeasurementType */
static int hf_f1ap_lCS_to_GCS_Translation;        /* LCS_to_GCS_Translation */
static int hf_f1ap_expected_ULAoA;                /* Expected_UL_AoA */
static int hf_f1ap_expected_ZoA;                  /* Expected_ZoA_only */
static int hf_f1ap_ARPLocationInformation_item;   /* ARPLocationInformation_Item */
static int hf_f1ap_aRP_ID;                        /* ARP_ID */
static int hf_f1ap_aRPLocationType;               /* ARPLocationType */
static int hf_f1ap_aRPPositionRelativeGeodetic;   /* RelativeGeodeticLocation */
static int hf_f1ap_aRPPositionRelativeCartesian;  /* RelativeCartesianLocation */
static int hf_f1ap_ingressBAPRoutingID;           /* BAPRoutingID */
static int hf_f1ap_egressBAPRoutingID;            /* BAPRoutingID */
static int hf_f1ap_nonF1terminatingTopologyIndicator;  /* NonF1terminatingTopologyIndicator */
static int hf_f1ap_fR1;                           /* FR1_Bandwidth */
static int hf_f1ap_fR2;                           /* FR2_Bandwidth */
static int hf_f1ap_bAPlayerBHRLCchannelMappingInfoToAdd;  /* BAPlayerBHRLCchannelMappingInfoList */
static int hf_f1ap_bAPlayerBHRLCchannelMappingInfoToRemove;  /* MappingInformationtoRemove */
static int hf_f1ap_BAPlayerBHRLCchannelMappingInfoList_item;  /* BAPlayerBHRLCchannelMappingInfo_Item */
static int hf_f1ap_mappingInformationIndex;       /* MappingInformationIndex */
static int hf_f1ap_priorHopBAPAddress;            /* BAPAddress */
static int hf_f1ap_ingressbHRLCChannelID;         /* BHRLCChannelID */
static int hf_f1ap_nextHopBAPAddress;             /* BAPAddress */
static int hf_f1ap_egressbHRLCChannelID;          /* BHRLCChannelID */
static int hf_f1ap_bAPAddress;                    /* BAPAddress */
static int hf_f1ap_bAPPathID;                     /* BAPPathID */
static int hf_f1ap_locationindpendent;            /* MBSF1UInformation */
static int hf_f1ap_locationdependent;             /* LocationDependentMBSF1UInformation */
static int hf_f1ap_bHRLCChannelID;                /* BHRLCChannelID */
static int hf_f1ap_cause;                         /* Cause */
static int hf_f1ap_bHQoSInformation;              /* BHQoSInformation */
static int hf_f1ap_rLCmode;                       /* RLCMode */
static int hf_f1ap_bAPCtrlPDUChannel;             /* BAPCtrlPDUChannel */
static int hf_f1ap_trafficMappingInfo;            /* TrafficMappingInfo */
static int hf_f1ap_bAProutingID;                  /* BAPRoutingID */
static int hf_f1ap_egressBHRLCCHList;             /* EgressBHRLCCHList */
static int hf_f1ap_bHRLCCHQoS;                    /* QoSFlowLevelQoSParameters */
static int hf_f1ap_eUTRANBHRLCCHQoS;              /* EUTRANQoS */
static int hf_f1ap_cPTrafficType;                 /* CPTrafficType */
static int hf_f1ap_BHRLCCHList_item;              /* BHRLCCHItem */
static int hf_f1ap_bAPRoutingID;                  /* BAPRoutingID */
static int hf_f1ap_BPLMN_ID_Info_List_item;       /* BPLMN_ID_Info_Item */
static int hf_f1ap_pLMN_Identity_List;            /* AvailablePLMNList */
static int hf_f1ap_extended_PLMN_Identity_List;   /* ExtendedAvailablePLMN_List */
static int hf_f1ap_fiveGS_TAC;                    /* FiveGS_TAC */
static int hf_f1ap_nr_cell_ID;                    /* NRCellIdentity */
static int hf_f1ap_ranac;                         /* RANAC */
static int hf_f1ap_ServedPLMNs_List_item;         /* ServedPLMNs_Item */
static int hf_f1ap_BroadcastCAGList_item;         /* CAGID */
static int hf_f1ap_mRB_ID;                        /* MRB_ID */
static int hf_f1ap_bcBearerCtxtF1U_TNLInfoatDU;   /* BCBearerContextF1U_TNLInfo */
static int hf_f1ap_mRB_QoSInformation;            /* QoSFlowLevelQoSParameters */
static int hf_f1ap_mBS_Flows_Mapped_To_MRB_List;  /* MBS_Flows_Mapped_To_MRB_List */
static int hf_f1ap_bcBearerCtxtF1U_TNLInfoatCU;   /* BCBearerContextF1U_TNLInfo */
static int hf_f1ap_BroadcastNIDList_item;         /* NID */
static int hf_f1ap_BroadcastSNPN_ID_List_item;    /* BroadcastSNPN_ID_List_Item */
static int hf_f1ap_broadcastNIDList;              /* BroadcastNIDList */
static int hf_f1ap_BroadcastPNI_NPN_ID_List_item;  /* BroadcastPNI_NPN_ID_List_Item */
static int hf_f1ap_broadcastCAGList;              /* BroadcastCAGList */
static int hf_f1ap_completeSuccess;               /* NULL */
static int hf_f1ap_partialSuccess;                /* PartialSuccessCell */
static int hf_f1ap_BroadcastCellList_item;        /* Broadcast_Cell_List_Item */
static int hf_f1ap_cellID;                        /* NRCGI */
static int hf_f1ap_burstArrivalTimeWindowStart;   /* INTEGER_0_640000_ */
static int hf_f1ap_burstArrivalTimeWindowEnd;     /* INTEGER_0_640000_ */
static int hf_f1ap_iE_Extension;                  /* ProtocolExtensionContainer */
static int hf_f1ap_candidate_SpCell_ID;           /* NRCGI */
static int hf_f1ap_sSBIndex;                      /* SSBIndex */
static int hf_f1ap_CandidateCellwithBeamInfoList_item;  /* CandidateCellwithBeamInfo_Item */
static int hf_f1ap_sSBIndexList;                  /* SSBIndexList */
static int hf_f1ap_CandidateCellwithMeasurementsList_item;  /* CandidateCellwithMeasurements_Item */
static int hf_f1ap_sSBIndexwithMeasurementsList;  /* SSBIndexwithMeasurementsList */
static int hf_f1ap_capacityValue;                 /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaCapacityValueList;      /* SSBAreaCapacityValueList */
static int hf_f1ap_radioNetwork;                  /* CauseRadioNetwork */
static int hf_f1ap_transport;                     /* CauseTransport */
static int hf_f1ap_protocol;                      /* CauseProtocol */
static int hf_f1ap_misc;                          /* CauseMisc */
static int hf_f1ap_CellMeasurementResultList_item;  /* CellMeasurementResultItem */
static int hf_f1ap_radioResourceStatus;           /* RadioResourceStatus */
static int hf_f1ap_compositeAvailableCapacityGroup;  /* CompositeAvailableCapacityGroup */
static int hf_f1ap_sliceAvailableCapacity;        /* SliceAvailableCapacity */
static int hf_f1ap_numberofActiveUEs;             /* NumberofActiveUEs */
static int hf_f1ap_CellsForSON_List_item;         /* CellsForSON_Item */
static int hf_f1ap_neighbourNR_CellsForSON_List;  /* NeighbourNR_CellsForSON_List */
static int hf_f1ap_service_status;                /* Service_Status */
static int hf_f1ap_numberOfBroadcasts;            /* NumberOfBroadcasts */
static int hf_f1ap_Cells_With_SSBs_Activated_List_item;  /* Cells_With_SSBs_Activated_List_Item */
static int hf_f1ap_sSBs_activated_List;           /* SSBs_activated_List */
static int hf_f1ap_cellBarred;                    /* CellBarred */
static int hf_f1ap_CellToReportList_item;         /* CellToReportItem */
static int hf_f1ap_sSBToReportList;               /* SSBToReportList */
static int hf_f1ap_sliceToReportList;             /* SliceToReportList */
static int hf_f1ap_cellSize;                      /* CellSize */
static int hf_f1ap_gNB_CU_UE_F1AP_ID;             /* GNB_CU_UE_F1AP_ID */
static int hf_f1ap_gNB_DU_UE_F1AP_ID;             /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_Child_IAB_Nodes_NA_Resource_List_item;  /* Child_IAB_Nodes_NA_Resource_List_Item */
static int hf_f1ap_nA_Resource_Configuration_List;  /* NA_Resource_Configuration_List */
static int hf_f1ap_Child_Node_Cells_List_item;    /* Child_Node_Cells_List_Item */
static int hf_f1ap_iAB_STC_Info;                  /* IAB_STC_Info */
static int hf_f1ap_rACH_Config_Common;            /* RACH_Config_Common */
static int hf_f1ap_rACH_Config_Common_IAB;        /* RACH_Config_Common_IAB */
static int hf_f1ap_cSI_RS_Configuration;          /* T_cSI_RS_Configuration */
static int hf_f1ap_sR_Configuration;              /* T_sR_Configuration */
static int hf_f1ap_pDCCH_ConfigSIB1;              /* T_pDCCH_ConfigSIB1 */
static int hf_f1ap_sCS_Common;                    /* T_sCS_Common */
static int hf_f1ap_multiplexingInfo;              /* MultiplexingInfo */
static int hf_f1ap_Child_Nodes_List_item;         /* Child_Nodes_List_Item */
static int hf_f1ap_child_Node_Cells_List;         /* Child_Node_Cells_List */
static int hf_f1ap_fiveG_S_TMSI;                  /* BIT_STRING_SIZE_48 */
static int hf_f1ap_compositeAvailableCapacityDownlink;  /* CompositeAvailableCapacity */
static int hf_f1ap_compositeAvailableCapacityUplink;  /* CompositeAvailableCapacity */
static int hf_f1ap_cellCapacityClassValue;        /* CellCapacityClassValue */
static int hf_f1ap_capacityValue_01;              /* CapacityValue */
static int hf_f1ap_cho_trigger;                   /* CHOtrigger_InterDU */
static int hf_f1ap_targetgNB_DUUEF1APID;          /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_cho_trigger_01;                /* CHOtrigger_IntraDU */
static int hf_f1ap_targetCellsTocancel;           /* TargetCellList */
static int hf_f1ap_Configured_BWP_List_item;      /* Configured_BWP_Item */
static int hf_f1ap_bWP_Id;                        /* BWP_Id */
static int hf_f1ap_bWP_Location_and_bandwidth;    /* INTEGER_0_37949 */
static int hf_f1ap_coverage_Modification_List;    /* Coverage_Modification_List */
static int hf_f1ap_Coverage_Modification_List_item;  /* Coverage_Modification_Item */
static int hf_f1ap_cellCoverageState;             /* CellCoverageState */
static int hf_f1ap_sSBCoverageModificationList;   /* SSBCoverageModification_List */
static int hf_f1ap_cCO_issue_detection;           /* CCO_issue_detection */
static int hf_f1ap_affectedCellsAndBeams_List;    /* AffectedCellsAndBeams_List */
static int hf_f1ap_endpoint_IP_address;           /* TransportLayerAddress */
static int hf_f1ap_endpoint_IP_address_and_port;  /* Endpoint_IP_address_and_port */
static int hf_f1ap_cpac_trigger;                  /* CPAC_trigger */
static int hf_f1ap_pscellid;                      /* NRCGI */
static int hf_f1ap_procedureCode;                 /* ProcedureCode */
static int hf_f1ap_triggeringMessage;             /* TriggeringMessage */
static int hf_f1ap_procedureCriticality;          /* Criticality */
static int hf_f1ap_transactionID;                 /* TransactionID */
static int hf_f1ap_iEsCriticalityDiagnostics;     /* CriticalityDiagnostics_IE_List */
static int hf_f1ap_CriticalityDiagnostics_IE_List_item;  /* CriticalityDiagnostics_IE_Item */
static int hf_f1ap_iECriticality;                 /* Criticality */
static int hf_f1ap_iE_ID;                         /* ProtocolIE_ID */
static int hf_f1ap_typeOfError;                   /* TypeOfError */
static int hf_f1ap_rIM;                           /* CUDURIMInformation */
static int hf_f1ap_victimgNBSetID;                /* GNBSetID */
static int hf_f1ap_rIMRSDetectionStatus;          /* RIMRSDetectionStatus */
static int hf_f1ap_cG_ConfigInfo;                 /* CG_ConfigInfo */
static int hf_f1ap_uE_CapabilityRAT_ContainerList;  /* UE_CapabilityRAT_ContainerList */
static int hf_f1ap_measConfig;                    /* MeasConfig */
static int hf_f1ap_CUtoDUTAInformation_List_item;  /* CUtoDUTAInformation_Item */
static int hf_f1ap_tAValue;                       /* TAValue */
static int hf_f1ap_preambleIndex;                 /* PreambleIndex */
static int hf_f1ap_rA_RNTI;                       /* RA_RNTI */
static int hf_f1ap_tagIDPointer;                  /* TagIDPointer */
static int hf_f1ap_cSIResourceConfigToAddModList;  /* T_cSIResourceConfigToAddModList */
static int hf_f1ap_cSIResourceConfigToReleaseList;  /* T_cSIResourceConfigToReleaseList */
static int hf_f1ap_perUE;                         /* DeactivationIndicationList */
static int hf_f1ap_deactivateAll;                 /* NULL */
static int hf_f1ap_DeactivationIndicationList_item;  /* DeactivationIndicationList_Item */
static int hf_f1ap_prsid;                         /* INTEGER_0_255 */
static int hf_f1ap_dl_PRSResourceSetID;           /* PRS_Resource_Set_ID */
static int hf_f1ap_dl_PRSResourceID;              /* PRS_Resource_ID */
static int hf_f1ap_two;                           /* BIT_STRING_SIZE_2 */
static int hf_f1ap_four;                          /* BIT_STRING_SIZE_4 */
static int hf_f1ap_six;                           /* BIT_STRING_SIZE_6 */
static int hf_f1ap_eight;                         /* BIT_STRING_SIZE_8 */
static int hf_f1ap_sixteen;                       /* BIT_STRING_SIZE_16 */
static int hf_f1ap_thirty_two;                    /* BIT_STRING_SIZE_32 */
static int hf_f1ap_listofDL_PRSResourceSetARP;    /* SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP */
static int hf_f1ap_listofDL_PRSResourceSetARP_item;  /* DLPRSResourceSetARP */
static int hf_f1ap_dL_PRSResourceSetARPLocation;  /* DL_PRSResourceSetARPLocation */
static int hf_f1ap_listofDL_PRSResourceARP;       /* SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP */
static int hf_f1ap_listofDL_PRSResourceARP_item;  /* DLPRSResourceARP */
static int hf_f1ap_relativeGeodeticLocation;      /* RelativeGeodeticLocation */
static int hf_f1ap_relativeCartesianLocation;     /* RelativeCartesianLocation */
static int hf_f1ap_choice_Extension;              /* ProtocolIE_SingleContainer */
static int hf_f1ap_dL_PRSResourceARPLocation;     /* DL_PRSResourceARPLocation */
static int hf_f1ap_oldIPAdress;                   /* TransportLayerAddress */
static int hf_f1ap_newIPAdress;                   /* TransportLayerAddress */
static int hf_f1ap_DLUPTNLInformation_ToBeSetup_List_item;  /* DLUPTNLInformation_ToBeSetup_Item */
static int hf_f1ap_dLUPTNLInformation;            /* UPTransportLayerInformation */
static int hf_f1ap_dRBID;                         /* DRBID */
static int hf_f1ap_dRB_Activity;                  /* DRB_Activity */
static int hf_f1ap_dRB_QoS;                       /* QoSFlowLevelQoSParameters */
static int hf_f1ap_sNSSAI;                        /* SNSSAI */
static int hf_f1ap_notificationControl;           /* NotificationControl */
static int hf_f1ap_flows_Mapped_To_DRB_List;      /* Flows_Mapped_To_DRB_List */
static int hf_f1ap_lCID;                          /* LCID */
static int hf_f1ap_dLUPTNLInformation_ToBeSetup_List;  /* DLUPTNLInformation_ToBeSetup_List */
static int hf_f1ap_uLUPTNLInformation_ToBeSetup_List;  /* ULUPTNLInformation_ToBeSetup_List */
static int hf_f1ap_notification_Cause;            /* Notification_Cause */
static int hf_f1ap_qoSInformation;                /* QoSInformation */
static int hf_f1ap_uLConfiguration;               /* ULConfiguration */
static int hf_f1ap_rLCMode;                       /* RLCMode */
static int hf_f1ap_duplicationActivation;         /* DuplicationActivation */
static int hf_f1ap_DRB_List_item;                 /* DRB_List_Item */
static int hf_f1ap_longDRXCycleLength;            /* LongDRXCycleLength */
static int hf_f1ap_shortDRXCycleLength;           /* ShortDRXCycleLength */
static int hf_f1ap_shortDRXCycleTimer;            /* ShortDRXCycleTimer */
static int hf_f1ap_longNonIntegerDRXCycleLength;  /* LongNonIntegerDRXCycleLength */
static int hf_f1ap_shortNonIntegerDRXCycleLength;  /* ShortNonIntegerDRXCycleLength */
static int hf_f1ap_DSInformationList_item;        /* DSCP */
static int hf_f1ap_rIM_01;                        /* DUCURIMInformation */
static int hf_f1ap_aggressorCellList;             /* AggressorCellList */
static int hf_f1ap_explicitFormat;                /* ExplicitFormat */
static int hf_f1ap_implicitFormat;                /* ImplicitFormat */
static int hf_f1ap_DUF_Slot_Config_List_item;     /* DUF_Slot_Config_Item */
static int hf_f1ap_cellGroupConfig;               /* CellGroupConfig */
static int hf_f1ap_measGapConfig;                 /* MeasGapConfig */
static int hf_f1ap_requestedP_MaxFR1;             /* T_requestedP_MaxFR1 */
static int hf_f1ap_DUtoCUTAInformation_List_item;  /* DUtoCUTAInformation_Item */
static int hf_f1ap_sourceGNB_DU_ID;               /* GNB_DU_ID */
static int hf_f1ap_qoSPriorityLevel;              /* INTEGER_1_127 */
static int hf_f1ap_fiveQI;                        /* INTEGER_0_255_ */
static int hf_f1ap_delayCritical;                 /* T_delayCritical */
static int hf_f1ap_averagingWindow;               /* AveragingWindow */
static int hf_f1ap_maxDataBurstVolume;            /* MaxDataBurstVolume */
static int hf_f1ap_resourceType;                  /* T_resourceType */
static int hf_f1ap_qoSPriorityLevel_01;           /* INTEGER_1_8_ */
static int hf_f1ap_DLLBTFailureInformationList_item;  /* DLLBTFailureInformationList_Item */
static int hf_f1ap_uEAssistantIdentifier;         /* GNB_CU_UE_F1AP_ID */
static int hf_f1ap_numberOfDLLBTFailures;         /* INTEGER_1_1000_ */
static int hf_f1ap_rACH;                          /* RACHConfiguration */
static int hf_f1ap_lTMgNB_DU_IDs_PreambleIndexList;  /* LTMgNB_DU_IDs_PreambleIndexList */
static int hf_f1ap_requestforRACHConfiguration;   /* RequestforRACHConfiguration */
static int hf_f1ap_lTMgNB_DU_IDsList;             /* LTMgNB_DU_IDsList */
static int hf_f1ap_tCIStatesConfigurationsList;   /* TCIStatesConfigurationsList */
static int hf_f1ap_earlyULSyncConfig;             /* EarlyULSyncConfig */
static int hf_f1ap_earlyULSyncConfigSUL;          /* EarlyULSyncConfig */
static int hf_f1ap_EarlySyncCandidateCellInformation_List_item;  /* EarlySyncCandidateCellInformation_Item */
static int hf_f1ap_tAAssistanceInfo;              /* TAAssistanceInfo */
static int hf_f1ap_uEbasedTAmeasurementConfig;    /* OCTET_STRING */
static int hf_f1ap_E_CID_MeasurementQuantities_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_e_CIDmeasurementQuantitiesValue;  /* E_CID_MeasurementQuantitiesValue */
static int hf_f1ap_geographicalCoordinates;       /* GeographicalCoordinates */
static int hf_f1ap_measuredResults_List;          /* E_CID_MeasuredResults_List */
static int hf_f1ap_E_CID_MeasuredResults_List_item;  /* E_CID_MeasuredResults_Item */
static int hf_f1ap_e_CID_MeasuredResults_Value;   /* E_CID_MeasuredResults_Value */
static int hf_f1ap_valueAngleofArrivalNR;         /* UL_AoA */
static int hf_f1ap_E_CID_MeasuredResultsAssociatedInfoList_item;  /* E_CID_MeasuredResultsAssociatedInfoItem */
static int hf_f1ap_timeStamp;                     /* TimeStamp */
static int hf_f1ap_measurementQuality;            /* TRPMeasurementQuality */
static int hf_f1ap_EgressBHRLCCHList_item;        /* EgressBHRLCCHItem */
static int hf_f1ap_endpointIPAddress;             /* TransportLayerAddress */
static int hf_f1ap_ExtendedAvailablePLMN_List_item;  /* ExtendedAvailablePLMN_Item */
static int hf_f1ap_permutation;                   /* Permutation */
static int hf_f1ap_noofDownlinkSymbols;           /* NoofDownlinkSymbols */
static int hf_f1ap_noofUplinkSymbols;             /* NoofUplinkSymbols */
static int hf_f1ap_ExtendedServedPLMNs_List_item;  /* ExtendedServedPLMNs_Item */
static int hf_f1ap_tAISliceSupportList;           /* SliceSupportList */
static int hf_f1ap_ExtendedSliceSupportList_item;  /* SliceSupportItem */
static int hf_f1ap_EUTRACells_List_item;          /* EUTRACells_List_item */
static int hf_f1ap_eUTRA_Cell_ID;                 /* EUTRA_Cell_ID */
static int hf_f1ap_served_EUTRA_Cells_Information;  /* Served_EUTRA_Cells_Information */
static int hf_f1ap_uL_EARFCN;                     /* ExtendedEARFCN */
static int hf_f1ap_dL_EARFCN;                     /* ExtendedEARFCN */
static int hf_f1ap_uL_Transmission_Bandwidth;     /* EUTRA_Transmission_Bandwidth */
static int hf_f1ap_dL_Transmission_Bandwidth;     /* EUTRA_Transmission_Bandwidth */
static int hf_f1ap_fDD;                           /* EUTRA_Coex_FDD_Info */
static int hf_f1ap_tDD;                           /* EUTRA_Coex_TDD_Info */
static int hf_f1ap_eARFCN;                        /* ExtendedEARFCN */
static int hf_f1ap_transmission_Bandwidth;        /* EUTRA_Transmission_Bandwidth */
static int hf_f1ap_subframeAssignment;            /* EUTRA_SubframeAssignment */
static int hf_f1ap_specialSubframe_Info;          /* EUTRA_SpecialSubframe_Info */
static int hf_f1ap_rootSequenceIndex;             /* INTEGER_0_837 */
static int hf_f1ap_zeroCorrelationIndex;          /* INTEGER_0_15 */
static int hf_f1ap_highSpeedFlag;                 /* BOOLEAN */
static int hf_f1ap_prach_FreqOffset;              /* INTEGER_0_94 */
static int hf_f1ap_prach_ConfigIndex;             /* INTEGER_0_63 */
static int hf_f1ap_specialSubframePatterns;       /* EUTRA_SpecialSubframePatterns */
static int hf_f1ap_cyclicPrefixDL;                /* EUTRA_CyclicPrefixDL */
static int hf_f1ap_cyclicPrefixUL;                /* EUTRA_CyclicPrefixUL */
static int hf_f1ap_qCI;                           /* QCI */
static int hf_f1ap_allocationAndRetentionPriority;  /* AllocationAndRetentionPriority */
static int hf_f1ap_gbrQosInformation;             /* GBR_QosInformation */
static int hf_f1ap_eUTRAFDD;                      /* EUTRA_FDD_Info */
static int hf_f1ap_eUTRATDD;                      /* EUTRA_TDD_Info */
static int hf_f1ap_uL_offsetToPointA;             /* OffsetToPointA */
static int hf_f1ap_dL_offsetToPointA;             /* OffsetToPointA */
static int hf_f1ap_offsetToPointA;                /* OffsetToPointA */
static int hf_f1ap_expected_Azimuth_AoA;          /* Expected_Azimuth_AoA */
static int hf_f1ap_expected_Zenith_AoA;           /* Expected_Zenith_AoA */
static int hf_f1ap_iE_extensions;                 /* ProtocolExtensionContainer */
static int hf_f1ap_expected_ZoA_only;             /* Expected_Zenith_AoA */
static int hf_f1ap_expected_Azimuth_AoA_value;    /* Expected_Value_AoA */
static int hf_f1ap_expected_Azimuth_AoA_uncertainty;  /* Uncertainty_range_AoA */
static int hf_f1ap_expected_Zenith_AoA_value;     /* Expected_Value_ZoA */
static int hf_f1ap_expected_Zenith_AoA_uncertainty;  /* Uncertainty_range_ZoA */
static int hf_f1ap_ecnMarking;                    /* ECNmarkingRequest */
static int hf_f1ap_congestionInformation;         /* CongestionInformationRequest */
static int hf_f1ap_f1CPathNSA;                    /* F1CPathNSA */
static int hf_f1ap_f1CPathNRDC;                   /* F1CPathNRDC */
static int hf_f1ap_uL_NRFreqInfo;                 /* NRFreqInfo */
static int hf_f1ap_dL_NRFreqInfo;                 /* NRFreqInfo */
static int hf_f1ap_uL_Transmission_Bandwidth_01;  /* Transmission_Bandwidth */
static int hf_f1ap_dL_Transmission_Bandwidth_01;  /* Transmission_Bandwidth */
static int hf_f1ap_uL_FreqInfo;                   /* FreqInfoRel16 */
static int hf_f1ap_sUL_FreqInfo;                  /* FreqInfoRel16 */
static int hf_f1ap_fiveG_proSeDirectDiscovery;    /* FiveG_ProSeDirectDiscovery */
static int hf_f1ap_fiveG_proSeDirectCommunication;  /* FiveG_ProSeDirectCommunication */
static int hf_f1ap_fiveG_ProSeLayer2UEtoNetworkRelay;  /* FiveG_ProSeLayer2UEtoNetworkRelay */
static int hf_f1ap_fiveG_ProSeLayer3UEtoNetworkRelay;  /* FiveG_ProSeLayer3UEtoNetworkRelay */
static int hf_f1ap_fiveG_ProSeLayer2RemoteUE;     /* FiveG_ProSeLayer2RemoteUE */
static int hf_f1ap_Flows_Mapped_To_DRB_List_item;  /* Flows_Mapped_To_DRB_Item */
static int hf_f1ap_qoSFlowIdentifier;             /* QoSFlowIdentifier */
static int hf_f1ap_qoSFlowLevelQoSParameters;     /* QoSFlowLevelQoSParameters */
static int hf_f1ap_freqBandIndicatorNr;           /* INTEGER_1_1024_ */
static int hf_f1ap_supportedSULBandList;          /* SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem */
static int hf_f1ap_supportedSULBandList_item;     /* SupportedSULFreqBandItem */
static int hf_f1ap_l839;                          /* L839Info */
static int hf_f1ap_l139;                          /* L139Info */
static int hf_f1ap_nRARFCN;                       /* INTEGER_0_maxNRARFCN */
static int hf_f1ap_frequencyShift7p5khz;          /* FrequencyShift7p5khz */
static int hf_f1ap_carrierList;                   /* NRCarrierList */
static int hf_f1ap_Frequency_Domain_HSNA_Configuration_List_item;  /* Frequency_Domain_HSNA_Configuration_Item */
static int hf_f1ap_rBSetIndex;                    /* INTEGER_0_maxnoofRBsetsPerCell_1_ */
static int hf_f1ap_frequency_Domain_HSNA_Slot_Configuration_List;  /* Frequency_Domain_HSNA_Slot_Configuration_List */
static int hf_f1ap_Frequency_Domain_HSNA_Slot_Configuration_List_item;  /* Frequency_Domain_HSNA_Slot_Configuration_Item */
static int hf_f1ap_slotIndex;                     /* INTEGER_0_5119 */
static int hf_f1ap_hSNADownlink;                  /* HSNADownlink */
static int hf_f1ap_hSNAUplink;                    /* HSNAUplink */
static int hf_f1ap_hSNAFlexible;                  /* HSNAFlexible */
static int hf_f1ap_FlowsMappedToSLDRB_List_item;  /* FlowsMappedToSLDRB_Item */
static int hf_f1ap_pc5QoSFlowIdentifier;          /* PC5QoSFlowIdentifier */
static int hf_f1ap_e_RAB_MaximumBitrateDL;        /* BitRate */
static int hf_f1ap_e_RAB_MaximumBitrateUL;        /* BitRate */
static int hf_f1ap_e_RAB_GuaranteedBitrateDL;     /* BitRate */
static int hf_f1ap_e_RAB_GuaranteedBitrateUL;     /* BitRate */
static int hf_f1ap_maxFlowBitRateDownlink;        /* BitRate */
static int hf_f1ap_maxFlowBitRateUplink;          /* BitRate */
static int hf_f1ap_guaranteedFlowBitRateDownlink;  /* BitRate */
static int hf_f1ap_guaranteedFlowBitRateUplink;   /* BitRate */
static int hf_f1ap_maxPacketLossRateDownlink;     /* MaxPacketLossRate */
static int hf_f1ap_maxPacketLossRateUplink;       /* MaxPacketLossRate */
static int hf_f1ap_tRPPositionDefinitionType;     /* TRPPositionDefinitionType */
static int hf_f1ap_dLPRSResourceCoordinates;      /* DLPRSResourceCoordinates */
static int hf_f1ap_gnb_id_choice;                 /* GNB_ID */
static int hf_f1ap_gNB_ID;                        /* BIT_STRING_SIZE_22_32 */
static int hf_f1ap_choice_Extensions;             /* ProtocolIE_SingleContainer */
static int hf_f1ap_sibtypetobeupdatedlist;        /* SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem */
static int hf_f1ap_sibtypetobeupdatedlist_item;   /* SibtypetobeupdatedListItem */
static int hf_f1ap_tNLAssociationTransportLayerAddress;  /* CP_TransportLayerAddress */
static int hf_f1ap_tNLAssociationUsage;           /* TNLAssociationUsage */
static int hf_f1ap_subcarrierSpacing_01;          /* SubcarrierSpacing */
static int hf_f1ap_dUFTransmissionPeriodicity;    /* DUFTransmissionPeriodicity */
static int hf_f1ap_dUF_Slot_Config_List;          /* DUF_Slot_Config_List */
static int hf_f1ap_hSNATransmissionPeriodicity;   /* HSNATransmissionPeriodicity */
static int hf_f1ap_hsNSASlotConfigList;           /* HSNASlotConfigList */
static int hf_f1ap_gNB_CU_NameVisibleString;      /* GNB_CU_NameVisibleString */
static int hf_f1ap_gNB_CU_NameUTF8String;         /* GNB_CU_NameUTF8String */
static int hf_f1ap_gNB_DU_NameVisibleString;      /* GNB_DU_NameVisibleString */
static int hf_f1ap_gNB_DU_NameUTF8String;         /* GNB_DU_NameUTF8String */
static int hf_f1ap_served_Cell_Information;       /* Served_Cell_Information */
static int hf_f1ap_gNB_DU_System_Information;     /* GNB_DU_System_Information */
static int hf_f1ap_mIB_message;                   /* MIB_message */
static int hf_f1ap_sIB1_message;                  /* SIB1_message */
static int hf_f1ap_tNLAssociationTransportLayerAddressgNBCU;  /* CP_TransportLayerAddress */
static int hf_f1ap_GNBDUUESliceMaximumBitRateList_item;  /* GNBDUUESliceMaximumBitRateItem */
static int hf_f1ap_uESliceMaximumBitRateUL;       /* BitRate */
static int hf_f1ap_rxTxTimeDiff;                  /* GNBRxTxTimeDiffMeas */
static int hf_f1ap_additionalPath_List;           /* AdditionalPath_List */
static int hf_f1ap_k0;                            /* INTEGER_0_1970049 */
static int hf_f1ap_k1;                            /* INTEGER_0_985025 */
static int hf_f1ap_k2;                            /* INTEGER_0_492513 */
static int hf_f1ap_k3;                            /* INTEGER_0_246257 */
static int hf_f1ap_k4;                            /* INTEGER_0_123129 */
static int hf_f1ap_k5;                            /* INTEGER_0_61565 */
static int hf_f1ap_GTPTLAs_item;                  /* GTPTLA_Item */
static int hf_f1ap_gTPTransportLayerAddress;      /* TransportLayerAddress */
static int hf_f1ap_transportLayerAddress;         /* TransportLayerAddress */
static int hf_f1ap_gTP_TEID;                      /* GTP_TEID */
static int hf_f1ap_dLHardwareLoadIndicator;       /* INTEGER_0_100_ */
static int hf_f1ap_uLHardwareLoadIndicator;       /* INTEGER_0_100_ */
static int hf_f1ap_HSNASlotConfigList_item;       /* HSNASlotConfigItem */
static int hf_f1ap_iAB_Congestion_Indication_List;  /* IAB_Congestion_Indication_List */
static int hf_f1ap_IAB_Congestion_Indication_List_item;  /* IAB_Congestion_Indication_Item */
static int hf_f1ap_childNodeIdentifier;           /* BAPAddress */
static int hf_f1ap_bHRLCCHList;                   /* BHRLCCHList */
static int hf_f1ap_IAB_MT_Cell_List_item;         /* IAB_MT_Cell_List_Item */
static int hf_f1ap_nRCellIdentity;                /* NRCellIdentity */
static int hf_f1ap_dU_RX_MT_RX;                   /* DU_RX_MT_RX */
static int hf_f1ap_dU_TX_MT_TX;                   /* DU_TX_MT_TX */
static int hf_f1ap_dU_RX_MT_TX;                   /* DU_RX_MT_TX */
static int hf_f1ap_dU_TX_MT_RX;                   /* DU_TX_MT_RX */
static int hf_f1ap_fDD_01;                        /* IAB_MT_Cell_NA_Resource_Configuration_FDD_Info */
static int hf_f1ap_tDD_01;                        /* IAB_MT_Cell_NA_Resource_Configuration_TDD_Info */
static int hf_f1ap_gNB_DU_Cell_NA_Resource_Configuration_FDD_UL;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_gNB_DU_Cell_NA_Resource_Configuration_FDD_DL;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_uL_FreqInfo_01;                /* NRFreqInfo */
static int hf_f1ap_uL_NR_Carrier_List;            /* NRCarrierList */
static int hf_f1ap_dL_FreqInfo;                   /* NRFreqInfo */
static int hf_f1ap_dL_NR_Carrier_List;            /* NRCarrierList */
static int hf_f1ap_gNB_DU_Cell_NA_Resourc_Configuration_TDD;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_nRFreqInfo;                    /* NRFreqInfo */
static int hf_f1ap_transmission_Bandwidth_01;     /* Transmission_Bandwidth */
static int hf_f1ap_nR_Carrier_List;               /* NRCarrierList */
static int hf_f1ap_iAB_STC_Info_List;             /* IAB_STC_Info_List */
static int hf_f1ap_IAB_STC_Info_List_item;        /* IAB_STC_Info_Item */
static int hf_f1ap_sSB_freqInfo;                  /* SSB_freqInfo */
static int hf_f1ap_sSB_subcarrierSpacing;         /* SSB_subcarrierSpacing */
static int hf_f1ap_sSB_transmissionPeriodicity;   /* SSB_transmissionPeriodicity */
static int hf_f1ap_sSB_transmissionTimingOffset;  /* SSB_transmissionTimingOffset */
static int hf_f1ap_sSB_transmissionBitmap;        /* SSB_transmissionBitmap */
static int hf_f1ap_iABTNLAddress;                 /* IABTNLAddress */
static int hf_f1ap_iABTNLAddressUsage;            /* IABTNLAddressUsage */
static int hf_f1ap_fDD_02;                        /* IAB_DU_Cell_Resource_Configuration_FDD_Info */
static int hf_f1ap_tDD_02;                        /* IAB_DU_Cell_Resource_Configuration_TDD_Info */
static int hf_f1ap_gNB_DU_Cell_Resource_Configuration_FDD_UL;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_gNB_DU_Cell_Resource_Configuration_FDD_DL;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_gNB_DU_Cell_Resourc_Configuration_TDD;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_f1ap_iPv6Address;                   /* IABTNLAddressesRequested */
static int hf_f1ap_iPv6Prefix;                    /* IABTNLAddressesRequested */
static int hf_f1ap_iPv4Address;                   /* T_iPv4Address */
static int hf_f1ap_iPv6Address_01;                /* T_iPv6Address */
static int hf_f1ap_iPv6Prefix_01;                 /* T_iPv6Prefix */
static int hf_f1ap_tNLAddressesOrPrefixesRequestedAllTraffic;  /* INTEGER_1_256 */
static int hf_f1ap_tNLAddressesOrPrefixesRequestedF1_C;  /* INTEGER_1_256 */
static int hf_f1ap_tNLAddressesOrPrefixesRequestedF1_U;  /* INTEGER_1_256 */
static int hf_f1ap_tNLAddressesOrPrefixesRequestedNoNF1;  /* INTEGER_1_256 */
static int hf_f1ap_iABTNLAddressList;             /* IABTNLAddressList */
static int hf_f1ap_IABTNLAddressList_item;        /* IABTNLAddress_Item */
static int hf_f1ap_iABv4AddressesRequested;       /* IABTNLAddressesRequested */
static int hf_f1ap_tAI;                           /* TAI */
static int hf_f1ap_dUFSlotformatIndex;            /* DUFSlotformatIndex */
static int hf_f1ap_targetRelayUEID_bit_string;    /* BIT_STRING_SIZE_24 */
static int hf_f1ap_remoteUELocalID;               /* RemoteUELocalID */
static int hf_f1ap_nRSCS;                         /* T_nRSCS */
static int hf_f1ap_nRCP;                          /* T_nRCP */
static int hf_f1ap_nRDLULTxPeriodicity;           /* T_nRDLULTxPeriodicity */
static int hf_f1ap_slot_Configuration_List;       /* Slot_Configuration_List */
static int hf_f1ap_servingCellL2ResetConfiguration;  /* OCTET_STRING */
static int hf_f1ap_lTML2ResetConfigurationList;   /* LTML2ResetConfigurationList */
static int hf_f1ap_LTML2ResetConfigurationList_item;  /* LTML2ResetConfiguration_Item */
static int hf_f1ap_ltmL2ResetConfiguration;       /* OCTET_STRING */
static int hf_f1ap_destinationIABTNLAddress;      /* IABTNLAddress */
static int hf_f1ap_dsInformationList;             /* DSInformationList */
static int hf_f1ap_iPv6FlowLabel;                 /* BIT_STRING_SIZE_20 */
static int hf_f1ap_iPtolayer2TrafficMappingInfoToAdd;  /* IPtolayer2TrafficMappingInfoList */
static int hf_f1ap_iPtolayer2TrafficMappingInfoToRemove;  /* MappingInformationtoRemove */
static int hf_f1ap_IPtolayer2TrafficMappingInfoList_item;  /* IPtolayer2TrafficMappingInfo_Item */
static int hf_f1ap_iPHeaderInformation;           /* IPHeaderInformation */
static int hf_f1ap_bHInfo;                        /* BHInfo */
static int hf_f1ap_aerialUE;                      /* AerialUE */
static int hf_f1ap_controllerUE;                  /* ControllerUE */
static int hf_f1ap_prachSCS;                      /* T_prachSCS */
static int hf_f1ap_rootSequenceIndex_01;          /* INTEGER_0_137 */
static int hf_f1ap_restrictedSetConfig;           /* T_restrictedSetConfig */
static int hf_f1ap_prachSCSForL571;               /* T_prachSCSForL571 */
static int hf_f1ap_rootSequenceIndex_02;          /* INTEGER_0_569 */
static int hf_f1ap_prachSCSForL1151;              /* T_prachSCSForL1151 */
static int hf_f1ap_rootSequenceIndex_03;          /* INTEGER_0_1149 */
static int hf_f1ap_alpha;                         /* INTEGER_0_3599 */
static int hf_f1ap_beta;                          /* INTEGER_0_3599 */
static int hf_f1ap_gamma;                         /* INTEGER_0_3599 */
static int hf_f1ap_LCStoGCSTranslationList_item;  /* LCStoGCSTranslation */
static int hf_f1ap_alpha_01;                      /* INTEGER_0_359 */
static int hf_f1ap_alpha_fine;                    /* INTEGER_0_9 */
static int hf_f1ap_beta_01;                       /* INTEGER_0_359 */
static int hf_f1ap_beta_fine;                     /* INTEGER_0_9 */
static int hf_f1ap_gamma_01;                      /* INTEGER_0_359 */
static int hf_f1ap_gamma_fine;                    /* INTEGER_0_9 */
static int hf_f1ap_LocationDependentMBSF1UInformation_item;  /* LocationDependentMBSF1UInformation_Item */
static int hf_f1ap_mbsAreaSession_ID;             /* MBS_Area_Session_ID */
static int hf_f1ap_mbs_f1u_info_at_CU;            /* UPTransportLayerInformation */
static int hf_f1ap_horizontalUncertainty;         /* INTEGER_0_255 */
static int hf_f1ap_horizontalConfidence;          /* INTEGER_0_100 */
static int hf_f1ap_verticalUncertainty;           /* INTEGER_0_255 */
static int hf_f1ap_verticalConfidence;            /* INTEGER_0_100 */
static int hf_f1ap_loS_NLoSIndicatorSoft;         /* LoS_NLoSIndicatorSoft */
static int hf_f1ap_loS_NLoSIndicatorHard;         /* LoS_NLoSIndicatorHard */
static int hf_f1ap_uELTESidelinkAggregateMaximumBitrate;  /* BitRate */
static int hf_f1ap_vehicleUE;                     /* VehicleUE */
static int hf_f1ap_pedestrianUE;                  /* PedestrianUE */
static int hf_f1ap_LTMCells_ToBeReleased_List_item;  /* LTMCells_ToBeReleased_Item */
static int hf_f1ap_lTMIndicator;                  /* LTMIndicator */
static int hf_f1ap_referenceConfiguration;        /* ReferenceConfiguration */
static int hf_f1ap_cSIResourceConfiguration;      /* CSIResourceConfiguration */
static int hf_f1ap_LTMConfigurationIDMappingList_item;  /* LTMConfigurationIDMapping_Item */
static int hf_f1ap_lTMCellID;                     /* NRCGI */
static int hf_f1ap_lTMConfigurationID;            /* LTMConfigurationID */
static int hf_f1ap_sSBInformation;                /* SSBInformation */
static int hf_f1ap_referenceConfigurationInformation;  /* ReferenceConfigurationInformation */
static int hf_f1ap_completeCandidateConfigurationIndicator;  /* CompleteCandidateConfigurationIndicator */
static int hf_f1ap_lTMCFRAResourceConfig;         /* LTMCFRAResourceConfig */
static int hf_f1ap_lTMCFRAResourceConfigSUL;      /* LTMCFRAResourceConfig */
static int hf_f1ap_jointorDLTCIStateID;           /* JointorDLTCIStateID */
static int hf_f1ap_uLTCIStateID;                  /* ULTCIStateID */
static int hf_f1ap_LTMgNB_DU_IDsList_item;        /* LTMgNB_DU_IDs_Item */
static int hf_f1ap_lTMgNB_DU_ID;                  /* GNB_DU_ID */
static int hf_f1ap_LTMgNB_DU_IDs_PreambleIndexList_item;  /* LTMgNB_DU_IDs_PreambleIndex_Item */
static int hf_f1ap_preambleIndexList;             /* PreambleIndexList */
static int hf_f1ap_LTMCFRAResourceConfig_List_item;  /* LTMCFRAResourceConfig_Item */
static int hf_f1ap_MappingInformationtoRemove_item;  /* MappingInformationIndex */
static int hf_f1ap_MBS_Flows_Mapped_To_MRB_List_item;  /* MBS_Flows_Mapped_To_MRB_Item */
static int hf_f1ap_mBS_QoSFlowIdentifier;         /* QoSFlowIdentifier */
static int hf_f1ap_mbs_QoSFlowLevelQoSParameters;  /* QoSFlowLevelQoSParameters */
static int hf_f1ap_mbs_f1u_info;                  /* UPTransportLayerInformation */
static int hf_f1ap_tMGI;                          /* TMGI */
static int hf_f1ap_nID;                           /* NID */
static int hf_f1ap_mBS_Broadcast_Cell_List;       /* MBS_Broadcast_Cell_List */
static int hf_f1ap_mBS_Broadcast_MRB_List;        /* MBS_Broadcast_MRB_List */
static int hf_f1ap_MBS_Broadcast_Cell_List_item;  /* MBS_Broadcast_Cell_Item */
static int hf_f1ap_mtch_neighbourCell;            /* OCTET_STRING */
static int hf_f1ap_MBS_Broadcast_MRB_List_item;   /* MBS_Broadcast_MRB_Item */
static int hf_f1ap_mRB_PDCP_Config_Broadcast;     /* T_mRB_PDCP_Config_Broadcast */
static int hf_f1ap_multicastF1UContextReferenceF1;  /* MulticastF1UContextReferenceF1 */
static int hf_f1ap_mc_F1UCtxtusage;               /* T_mc_F1UCtxtusage */
static int hf_f1ap_mbsAreaSession;                /* MBS_Area_Session_ID */
static int hf_f1ap_mt_SDT_Indicator;              /* MT_SDT_Indicator */
static int hf_f1ap_mBS_Multicast_CU2DU_Cell_List;  /* MBS_Multicast_CU2DU_Cell_List */
static int hf_f1ap_mBS_Multicast_MRB_List;        /* MBS_Multicast_MRB_List */
static int hf_f1ap_MBS_Multicast_CU2DU_Cell_List_item;  /* MBS_Multicast_CU2DU_Cell_Item */
static int hf_f1ap_mbsMulticastRRC_INACTIVEReceptionMode;  /* MBSMulticastRRCINACTIVEReceptionMode */
static int hf_f1ap_mbsMulticastConfigurationRequest;  /* T_mbsMulticastConfigurationRequest */
static int hf_f1ap_MBS_Multicast_MRB_List_item;   /* MBS_Multicast_MRB_Item */
static int hf_f1ap_mRB_PDCP_Config_Broadcast_01;  /* T_mRB_PDCP_Config_Broadcast_01 */
static int hf_f1ap_multicastCommonCU2DUCellList;  /* MulticastCommonCU2DUCellList */
static int hf_f1ap_MulticastCommonCU2DUCellList_item;  /* MulticastCommonCU2DUCell_Item */
static int hf_f1ap_multicastCommonCu2DUCellInformation;  /* MulticastCommonCu2DUCellInformation */
static int hf_f1ap_mBSMulticastNeighbourCellListItem;  /* MBSMulticastNeighbourCellListItem */
static int hf_f1ap_thresholdMBS_ListItem;         /* ThresholdMBS_ListItem */
static int hf_f1ap_mbsMulticastNeighbourCellListInformationprovided;  /* UpdateMBSMulticastNeighbourCellListInformation */
static int hf_f1ap_nombsMulticastNeighbourCellListInformationprovided;  /* NULL */
static int hf_f1ap_thresholdMBS_ListInformationprovided;  /* UpdateThresholdMBS_ListInformation */
static int hf_f1ap_nothresholdMBSListInformationprovided;  /* NULL */
static int hf_f1ap_mbs_NeighbourCellList;         /* T_mbs_NeighbourCellList */
static int hf_f1ap_mbs_MulticastSessionList;      /* MTCH_NeighbourCellSessionList */
static int hf_f1ap_MTCH_NeighbourCellSessionList_item;  /* MTCH_NeighbourCellSession_Item */
static int hf_f1ap_mbsSessionID;                  /* MBS_Session_ID */
static int hf_f1ap_mtch_NeighbourCellInformation;  /* MTCH_NeighbourCellInformation */
static int hf_f1ap_mtch_NeighbourCellprovided;    /* T_mtch_NeighbourCellprovided */
static int hf_f1ap_mtch_NeighbourCellnotprovided;  /* NULL */
static int hf_f1ap_thresholdMBSList;              /* T_thresholdMBSList */
static int hf_f1ap_thresholdIndexSessionList;     /* ThresholdIndexSessionList */
static int hf_f1ap_ThresholdIndexSessionList_item;  /* ThresholdIndexSession_Item */
static int hf_f1ap_thresholdIndexInformation;     /* ThresholdIndexInformation */
static int hf_f1ap_thresholdIndexprovided;        /* ThresholdIndex */
static int hf_f1ap_thresholdIndexnotprovided;     /* NULL */
static int hf_f1ap_mBS_Multicast_DU2CU_Cell_List;  /* MBS_Multicast_DU2CU_Cell_List */
static int hf_f1ap_MBS_Multicast_DU2CU_Cell_List_item;  /* MBS_Multicast_DU2CU_Cell_Item */
static int hf_f1ap_mbsMulticastConfigurationResponseInfo;  /* MBSMulticastConfigurationResponseInfo */
static int hf_f1ap_mbsMulticastConfigurationNotification;  /* MBSMulticastConfigurationNotification */
static int hf_f1ap_mbsMulticastConfiguration_available;  /* MBSMulticastConfiguration_available */
static int hf_f1ap_mbsMulticastConfiguration_notavailable;  /* MBSMulticastConfiguration_notavailable */
static int hf_f1ap_mBSMulticastConfiguration;     /* T_mBSMulticastConfiguration */
static int hf_f1ap_mBSMulticastConfiguration_notavailable;  /* T_mBSMulticastConfiguration_notavailable */
static int hf_f1ap_mbsMulticastConfigurationNotificationInfo;  /* MBSMulticastConfigurationNotificationInfo */
static int hf_f1ap_mbsMulticastConfigurationChanged;  /* T_mbsMulticastConfigurationChanged */
static int hf_f1ap_mbsMulticastConfigurationRemoved;  /* NULL */
static int hf_f1ap_mbs_f1u_info_at_DU;            /* UPTransportLayerInformation */
static int hf_f1ap_mbsProgressInformation;        /* MRB_ProgressInformation */
static int hf_f1ap_locationindependent;           /* MBS_ServiceAreaInformation */
static int hf_f1ap_locationdependent_01;          /* MBS_ServiceAreaInformationList */
static int hf_f1ap_mBS_ServiceAreaCellList;       /* MBS_ServiceAreaCellList */
static int hf_f1ap_mBS_ServiceAreaTAIList;        /* MBS_ServiceAreaTAIList */
static int hf_f1ap_MBS_ServiceAreaCellList_item;  /* NRCGI */
static int hf_f1ap_MBS_ServiceAreaTAIList_item;   /* MBS_ServiceAreaTAIList_Item */
static int hf_f1ap_plmn_ID;                       /* PLMN_Identity */
static int hf_f1ap_MBS_ServiceAreaInformationList_item;  /* MBS_ServiceAreaInformationItem */
static int hf_f1ap_mBS_AreaSessionID;             /* MBS_Area_Session_ID */
static int hf_f1ap_mBS_ServiceAreaInformation;    /* MBS_ServiceAreaInformation */
static int hf_f1ap_pRS_Resource_ID;               /* PRS_Resource_ID */
static int hf_f1ap_pRS_Resource_Set_ID;           /* PRS_Resource_Set_ID */
static int hf_f1ap_sSB_Index_01;                  /* SSB_Index */
static int hf_f1ap_pdcp_SN12;                     /* INTEGER_0_4095 */
static int hf_f1ap_pdcp_SN18;                     /* INTEGER_0_262143 */
static int hf_f1ap_multipleULAoA_01;              /* MultipleULAoA_List */
static int hf_f1ap_MultipleULAoA_List_item;       /* MultipleULAoA_Item */
static int hf_f1ap_uL_AoA;                        /* UL_AoA */
static int hf_f1ap_ul_ZoA;                        /* ZoAInformation */
static int hf_f1ap_MulticastMBSSessionList_item;  /* MulticastMBSSessionList_Item */
static int hf_f1ap_mbsSessionId;                  /* MBS_Session_ID */
static int hf_f1ap_mBS_DL_PDCP_SN_Length;         /* PDCPSNLength */
static int hf_f1ap_iAB_MT_Cell_List;              /* IAB_MT_Cell_List */
static int hf_f1ap_m5period;                      /* M5period */
static int hf_f1ap_m5_links_to_log;               /* M5_Links_to_log */
static int hf_f1ap_m6report_Interval;             /* M6report_Interval */
static int hf_f1ap_m6_links_to_log;               /* M6_Links_to_log */
static int hf_f1ap_m7period;                      /* M7period */
static int hf_f1ap_m7_links_to_log;               /* M7_Links_to_log */
static int hf_f1ap_mdt_Activation;                /* MDT_Activation */
static int hf_f1ap_measurementsToActivate;        /* MeasurementsToActivate */
static int hf_f1ap_m2Configuration;               /* M2Configuration */
static int hf_f1ap_m5Configuration;               /* M5Configuration */
static int hf_f1ap_m6Configuration;               /* M6Configuration */
static int hf_f1ap_m7Configuration;               /* M7Configuration */
static int hf_f1ap_MDTPLMNList_item;              /* PLMN_Identity */
static int hf_f1ap_MDTPLMNModificationList_item;  /* PLMN_Identity */
static int hf_f1ap_uL_AngleOfArrival;             /* UL_AoA */
static int hf_f1ap_uL_SRS_RSRP;                   /* UL_SRS_RSRP */
static int hf_f1ap_uL_RTOA;                       /* UL_RTOA_Measurement */
static int hf_f1ap_gNB_RxTxTimeDiff;              /* GNB_RxTxTimeDiff */
static int hf_f1ap_location_Information;          /* T_location_Information */
static int hf_f1ap_velocity_Information;          /* T_velocity_Information */
static int hf_f1ap_location_time_stamp;           /* TimeStamp */
static int hf_f1ap_mobilityTrigger;               /* MobilityTrigger */
static int hf_f1ap_mobilityInitiation_AssistanceInfo;  /* MobilityInitiation_AssistanceInfo */
static int hf_f1ap_mobilityTriggeringIndication;  /* MobilityTriggeringIndication */
static int hf_f1ap_mobilityInitiation_CellSwitchInfo;  /* MobilityInitiation_CellSwitchInfo */
static int hf_f1ap_mobilityInitiation_EarlyULSyncInfo;  /* MobilityInitiation_EarlyULSyncInfo */
static int hf_f1ap_mobilityInitiation_EarlyDLSyncInfo;  /* MobilityInitiation_EarlyDLSyncInfo */
static int hf_f1ap_candidateCellwithBeamInfo;     /* CandidateCellwithBeamInfo */
static int hf_f1ap_candidateCellwithBeamInfoList;  /* CandidateCellwithBeamInfoList */
static int hf_f1ap_servingCellMeasurements;       /* ServingCellMeasurements */
static int hf_f1ap_candidateCellwithMeasurementsList;  /* CandidateCellwithMeasurementsList */
static int hf_f1ap_targetRelayUEID;               /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_NA_Resource_Configuration_List_item;  /* NA_Resource_Configuration_Item */
static int hf_f1ap_nADownlink;                    /* NADownlink */
static int hf_f1ap_nAUplink;                      /* NAUplink */
static int hf_f1ap_nAFlexible;                    /* NAFlexible */
static int hf_f1ap_oLDNCGI;                       /* NRCGI */
static int hf_f1ap_nEWNCGI;                       /* NRCGI */
static int hf_f1ap_Neighbour_Node_Cells_List_item;  /* Neighbour_Node_Cells_List_Item */
static int hf_f1ap_peer_Parent_Node_Indicator;    /* T_peer_Parent_Node_Indicator */
static int hf_f1ap_cSI_RS_Configuration_01;       /* T_cSI_RS_Configuration_01 */
static int hf_f1ap_sR_Configuration_01;           /* T_sR_Configuration_01 */
static int hf_f1ap_pDCCH_ConfigSIB1_01;           /* T_pDCCH_ConfigSIB1_01 */
static int hf_f1ap_sCS_Common_01;                 /* T_sCS_Common_01 */
static int hf_f1ap_intendedTDD_DL_ULConfig;       /* IntendedTDD_DL_ULConfig */
static int hf_f1ap_NeighbourNR_CellsForSON_List_item;  /* NeighbourNR_CellsForSON_Item */
static int hf_f1ap_nR_ModeInfoRel16;              /* NR_ModeInfoRel16 */
static int hf_f1ap_sSB_PositionsInBurst;          /* SSB_PositionsInBurst */
static int hf_f1ap_nRPRACHConfig;                 /* NRPRACHConfig */
static int hf_f1ap_latitude_01;                   /* INTEGER_M2147483648_2147483647 */
static int hf_f1ap_longitude_01;                  /* INTEGER_M2147483648_2147483647 */
static int hf_f1ap_altitude_01;                   /* INTEGER_M64000_1280000 */
static int hf_f1ap_uncertaintySemi_major_01;      /* INTEGER_0_255 */
static int hf_f1ap_uncertaintySemi_minor_01;      /* INTEGER_0_255 */
static int hf_f1ap_uncertaintyAltitude_01;        /* INTEGER_0_255 */
static int hf_f1ap_nR_PRSBeamInformationList;     /* NR_PRSBeamInformationList */
static int hf_f1ap_lCStoGCSTranslationList;       /* LCStoGCSTranslationList */
static int hf_f1ap_NR_PRSBeamInformationList_item;  /* NR_PRSBeamInformationItem */
static int hf_f1ap_pRSResourceSetID;              /* PRS_Resource_Set_ID */
static int hf_f1ap_pRSAngleList;                  /* PRSAngleList */
static int hf_f1ap_nrpaging_eDRX_Cycle_Idle;      /* NRPaging_eDRX_Cycle_Idle */
static int hf_f1ap_nrpaging_Time_Window;          /* NRPaging_Time_Window */
static int hf_f1ap_nrpaging_eDRX_Cycle_Inactive;  /* NRPaging_eDRX_Cycle_Inactive */
static int hf_f1ap_nRPaging_long_eDRX_Cycle_Inactive;  /* NRPaging_long_eDRX_Cycle_Inactive */
static int hf_f1ap_nRPaging_Time_Window_Inactive;  /* NRPaging_Time_Window_Inactive */
static int hf_f1ap_message_Identifier;            /* MessageIdentifier */
static int hf_f1ap_serialNumber;                  /* SerialNumber */
static int hf_f1ap_sNPN_Broadcast_Information;    /* NPN_Broadcast_Information_SNPN */
static int hf_f1ap_pNI_NPN_Broadcast_Information;  /* NPN_Broadcast_Information_PNI_NPN */
static int hf_f1ap_broadcastSNPNID_List;          /* BroadcastSNPN_ID_List */
static int hf_f1ap_broadcastPNI_NPN_ID_Information;  /* BroadcastPNI_NPN_ID_List */
static int hf_f1ap_sNPN_Information;              /* NID */
static int hf_f1ap_NRCarrierList_item;            /* NRCarrierItem */
static int hf_f1ap_carrierSCS;                    /* NRSCS */
static int hf_f1ap_offsetToCarrier;               /* INTEGER_0_2199_ */
static int hf_f1ap_carrierBandwidth;              /* INTEGER_0_maxnoofPhysicalResourceBlocks_ */
static int hf_f1ap_sul_Information;               /* SUL_Information */
static int hf_f1ap_freqBandListNr;                /* SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem */
static int hf_f1ap_freqBandListNr_item;           /* FreqBandNrItem */
static int hf_f1ap_fDD_03;                        /* FDD_Info */
static int hf_f1ap_tDD_03;                        /* TDD_Info */
static int hf_f1ap_fDD_04;                        /* FDD_InfoRel16 */
static int hf_f1ap_tDD_04;                        /* TDD_InfoRel16 */
static int hf_f1ap_ulPRACHConfigList;             /* NRPRACHConfigList */
static int hf_f1ap_sulPRACHConfigList;            /* NRPRACHConfigList */
static int hf_f1ap_NRPRACHConfigList_item;        /* NRPRACHConfigItem */
static int hf_f1ap_nRSCS_01;                      /* NRSCS */
static int hf_f1ap_prachFreqStartfromCarrier;     /* INTEGER_0_maxnoofPhysicalResourceBlocks_1_ */
static int hf_f1ap_prachFDM;                      /* T_prachFDM */
static int hf_f1ap_prachConfigIndex;              /* INTEGER_0_255_ */
static int hf_f1ap_ssb_perRACH_Occasion;          /* T_ssb_perRACH_Occasion */
static int hf_f1ap_freqDomainLength;              /* FreqDomainLength */
static int hf_f1ap_zeroCorrelZoneConfig;          /* INTEGER_0_15 */
static int hf_f1ap_NR_U_Channel_Info_List_item;   /* NR_U_Channel_Info_Item */
static int hf_f1ap_nr_U_channel_ID;               /* INTEGER_1_maxnoofNR_UChannelIDs_ */
static int hf_f1ap_nR_ARFCN;                      /* INTEGER_0_maxNRARFCN */
static int hf_f1ap_bandwidth;                     /* T_bandwidth */
static int hf_f1ap_NR_U_Channel_List_item;        /* NR_U_Channel_Item */
static int hf_f1ap_nR_U_ChannelID;                /* INTEGER_1_maxnoofNR_UChannelIDs */
static int hf_f1ap_channelOccupancyTimePercentageDL;  /* ChannelOccupancyTimePercentage */
static int hf_f1ap_energyDetectionThreshold;      /* EnergyDetectionThreshold */
static int hf_f1ap_numDLSymbols;                  /* INTEGER_0_13_ */
static int hf_f1ap_numULSymbols;                  /* INTEGER_0_13_ */
static int hf_f1ap_uENRSidelinkAggregateMaximumBitrate;  /* BitRate */
static int hf_f1ap_n6JitterLowerBound;            /* INTEGER_M127_127 */
static int hf_f1ap_n6JitterUpperBound;            /* INTEGER_M127_127 */
static int hf_f1ap_onDemandPRSRequestAllowed;     /* BIT_STRING_SIZE_16 */
static int hf_f1ap_allowedResourceSetPeriodicityValues;  /* BIT_STRING_SIZE_24 */
static int hf_f1ap_allowedPRSBandwidthValues;     /* BIT_STRING_SIZE_64 */
static int hf_f1ap_allowedResourceRepetitionFactorValues;  /* BIT_STRING_SIZE_8 */
static int hf_f1ap_allowedResourceNumberOfSymbolsValues;  /* BIT_STRING_SIZE_8 */
static int hf_f1ap_allowedCombSizeValues;         /* BIT_STRING_SIZE_8 */
static int hf_f1ap_pER_Scalar;                    /* PER_Scalar */
static int hf_f1ap_pER_Exponent;                  /* PER_Exponent */
static int hf_f1ap_indirectPathAddition;          /* IndirectPathAddition */
static int hf_f1ap_directPathAddition;            /* NULL */
static int hf_f1ap_n3C_indirectPathAddition;      /* N3CIndirectPathAddition */
static int hf_f1ap_Recommended_SSBs_List_item;    /* RecommendedSSBItem_List_Item */
static int hf_f1ap_rANUEPagingIdentity;           /* RANUEPagingIdentity */
static int hf_f1ap_cNUEPagingIdentity;            /* CNUEPagingIdentity */
static int hf_f1ap_cNSubgroupID;                  /* CNSubgroupID */
static int hf_f1ap_k0_01;                         /* INTEGER_0_16351 */
static int hf_f1ap_k1_01;                         /* INTEGER_0_8176 */
static int hf_f1ap_k2_01;                         /* INTEGER_0_4088 */
static int hf_f1ap_k3_01;                         /* INTEGER_0_2044 */
static int hf_f1ap_k4_01;                         /* INTEGER_0_1022 */
static int hf_f1ap_k5_01;                         /* INTEGER_0_511 */
static int hf_f1ap_Parent_IAB_Nodes_NA_Resource_Configuration_List_item;  /* Parent_IAB_Nodes_NA_Resource_Configuration_Item */
static int hf_f1ap_broadcastCellList;             /* BroadcastCellList */
static int hf_f1ap_pathlossReferenceSignal;       /* PathlossReferenceSignal */
static int hf_f1ap_sSB;                           /* SSB */
static int hf_f1ap_dL_PRS;                        /* DL_PRS */
static int hf_f1ap_t420;                          /* T_t420 */
static int hf_f1ap_non_Dynamic_PQI;               /* NonDynamicPQIDescriptor */
static int hf_f1ap_dynamic_PQI;                   /* DynamicPQIDescriptor */
static int hf_f1ap_pC5_QoS_Characteristics;       /* PC5_QoS_Characteristics */
static int hf_f1ap_pC5_QoS_Flow_Bit_Rates;        /* PC5FlowBitRates */
static int hf_f1ap_guaranteedFlowBitRate;         /* BitRate */
static int hf_f1ap_maximumFlowBitRate;            /* BitRate */
static int hf_f1ap_pC5RLCChannelQoS;              /* QoSFlowLevelQoSParameters */
static int hf_f1ap_pC5ControlPlaneTrafficType;    /* T_pC5ControlPlaneTrafficType */
static int hf_f1ap_PC5RLCChannelToBeSetupList_item;  /* PC5RLCChannelToBeSetupItem */
static int hf_f1ap_pC5RLCChannelID;               /* PC5RLCChannelID */
static int hf_f1ap_pC5RLCChannelQoSInformation;   /* PC5RLCChannelQoSInformation */
static int hf_f1ap_PC5RLCChannelToBeModifiedList_item;  /* PC5RLCChannelToBeModifiedItem */
static int hf_f1ap_PC5RLCChannelToBeReleasedList_item;  /* PC5RLCChannelToBeReleasedItem */
static int hf_f1ap_PC5RLCChannelSetupList_item;   /* PC5RLCChannelSetupItem */
static int hf_f1ap_PC5RLCChannelFailedToBeSetupList_item;  /* PC5RLCChannelFailedToBeSetupItem */
static int hf_f1ap_PC5RLCChannelModifiedList_item;  /* PC5RLCChannelModifiedItem */
static int hf_f1ap_PC5RLCChannelFailedToBeModifiedList_item;  /* PC5RLCChannelFailedToBeModifiedItem */
static int hf_f1ap_PC5RLCChannelRequiredToBeModifiedList_item;  /* PC5RLCChannelRequiredToBeModifiedItem */
static int hf_f1ap_PC5RLCChannelRequiredToBeReleasedList_item;  /* PC5RLCChannelRequiredToBeReleasedItem */
static int hf_f1ap_PDCMeasurementQuantities_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_pDCmeasurementQuantitiesValue;  /* PDCMeasurementQuantitiesValue */
static int hf_f1ap_pDCMeasuredResultsList;        /* PDCMeasuredResultsList */
static int hf_f1ap_PDCMeasuredResultsList_item;   /* PDCMeasuredResults_Item */
static int hf_f1ap_pDCMeasuredResults_Value;      /* PDCMeasuredResults_Value */
static int hf_f1ap_pDC_TADV_NR;                   /* PDC_TADV_NR */
static int hf_f1ap_pDC_RxTxTimeDiff;              /* PDC_RxTxTimeDiff */
static int hf_f1ap_PeriodicityList_item;          /* PeriodicityList_Item */
static int hf_f1ap_periodicitySRS;                /* PeriodicitySRS */
static int hf_f1ap_periodicityLowerBound;         /* Periodicity */
static int hf_f1ap_periodicityUpperBound;         /* Periodicity */
static int hf_f1ap_AllowedPeriodicityList_item;   /* Periodicity */
static int hf_f1ap_periodicityBound;              /* PeriodicityBound */
static int hf_f1ap_periodicityList;               /* AllowedPeriodicityList */
static int hf_f1ap_choice_extensions;             /* ProtocolIE_SingleContainer */
static int hf_f1ap_PositioningBroadcastCells_item;  /* NRCGI */
static int hf_f1ap_posMeasGapPreConfigToAddModList;  /* T_posMeasGapPreConfigToAddModList */
static int hf_f1ap_posMeasGapPreConfigToReleaseList;  /* T_posMeasGapPreConfigToReleaseList */
static int hf_f1ap_PosMeasurementQuantities_item;  /* PosMeasurementQuantities_Item */
static int hf_f1ap_posMeasurementType;            /* PosMeasurementType */
static int hf_f1ap_timingReportingGranularityFactor;  /* INTEGER_0_5 */
static int hf_f1ap_PosMeasurementResult_item;     /* PosMeasurementResultItem */
static int hf_f1ap_measuredResultsValue;          /* MeasuredResultsValue */
static int hf_f1ap_measurementBeamInfo;           /* MeasurementBeamInfo */
static int hf_f1ap_PosMeasurementResultList_item;  /* PosMeasurementResultList_Item */
static int hf_f1ap_posMeasurementResult;          /* PosMeasurementResult */
static int hf_f1ap_tRPID;                         /* TRPID */
static int hf_f1ap_periodic;                      /* PosResourceSetTypePR */
static int hf_f1ap_semi_persistent;               /* PosResourceSetTypeSP */
static int hf_f1ap_aperiodic;                     /* PosResourceSetTypeAP */
static int hf_f1ap_posperiodicSet;                /* T_posperiodicSet */
static int hf_f1ap_possemi_persistentSet;         /* T_possemi_persistentSet */
static int hf_f1ap_sRSResourceTrigger_List;       /* INTEGER_1_3 */
static int hf_f1ap_PosSItypeList_item;            /* PosSItype_Item */
static int hf_f1ap_posItype;                      /* PosSItype */
static int hf_f1ap_PosSRSResourceID_List_item;    /* SRSPosResourceID */
static int hf_f1ap_srs_PosResourceId;             /* SRSPosResourceID */
static int hf_f1ap_transmissionCombPos;           /* TransmissionCombPos */
static int hf_f1ap_startPosition;                 /* INTEGER_0_13 */
static int hf_f1ap_nrofSymbols;                   /* T_nrofSymbols */
static int hf_f1ap_freqDomainShift;               /* INTEGER_0_268 */
static int hf_f1ap_c_SRS;                         /* INTEGER_0_63 */
static int hf_f1ap_groupOrSequenceHopping;        /* T_groupOrSequenceHopping */
static int hf_f1ap_resourceTypePos;               /* ResourceTypePos */
static int hf_f1ap_sequenceId;                    /* INTEGER_0_65535 */
static int hf_f1ap_spatialRelationPos;            /* SpatialRelationPos */
static int hf_f1ap_PosSRSResource_List_item;      /* PosSRSResource_Item */
static int hf_f1ap_possrsResourceSetID;           /* INTEGER_0_15 */
static int hf_f1ap_possRSResourceID_List;         /* PosSRSResourceID_List */
static int hf_f1ap_posresourceSetType;            /* PosResourceSetType */
static int hf_f1ap_PosValidityAreaCellList_item;  /* PosValidityAreaCellList_Item */
static int hf_f1ap_nRPCI_01;                      /* INTEGER_0_1007 */
static int hf_f1ap_PosSRSResourceSet_List_item;   /* PosSRSResourceSet_Item */
static int hf_f1ap_PreambleIndexList_item;        /* PreambleIndexList_Item */
static int hf_f1ap_preambleIndex_01;              /* INTEGER_0_63 */
static int hf_f1ap_spectrumSharingGroupID;        /* SpectrumSharingGroupID */
static int hf_f1ap_eUTRACells_List;               /* EUTRACells_List */
static int hf_f1ap_pRSResourceSet_List;           /* PRSResourceSet_List */
static int hf_f1ap_pRS_IDPos;                     /* INTEGER_0_255 */
static int hf_f1ap_pRS_Resource_Set_IDPos;        /* INTEGER_0_7 */
static int hf_f1ap_pRS_Resource_IDPos;            /* INTEGER_0_63 */
static int hf_f1ap_PRS_Measurement_Info_List_item;  /* PRS_Measurement_Info_List_Item */
static int hf_f1ap_measPRSPeriodicity;            /* T_measPRSPeriodicity */
static int hf_f1ap_measPRSOffset;                 /* INTEGER_0_159_ */
static int hf_f1ap_measurementPRSLength;          /* T_measurementPRSLength */
static int hf_f1ap_potential_SpCell_ID;           /* NRCGI */
static int hf_f1ap_PRSAngleList_item;             /* PRSAngleItem */
static int hf_f1ap_nR_PRS_Azimuth;                /* INTEGER_0_359 */
static int hf_f1ap_nR_PRS_Azimuth_fine;           /* INTEGER_0_9 */
static int hf_f1ap_nR_PRS_Elevation;              /* INTEGER_0_180 */
static int hf_f1ap_nR_PRS_Elevation_fine;         /* INTEGER_0_9 */
static int hf_f1ap_pRSMutingOption1;              /* PRSMutingOption1 */
static int hf_f1ap_pRSMutingOption2;              /* PRSMutingOption2 */
static int hf_f1ap_mutingPattern;                 /* DL_PRSMutingPattern */
static int hf_f1ap_mutingBitRepetitionFactor;     /* T_mutingBitRepetitionFactor */
static int hf_f1ap_PRSResource_List_item;         /* PRSResource_Item */
static int hf_f1ap_pRSResourceID;                 /* PRS_Resource_ID */
static int hf_f1ap_sequenceID;                    /* INTEGER_0_4095 */
static int hf_f1ap_rEOffset;                      /* INTEGER_0_11_ */
static int hf_f1ap_resourceSlotOffset;            /* INTEGER_0_511 */
static int hf_f1ap_resourceSymbolOffset;          /* INTEGER_0_12 */
static int hf_f1ap_qCLInfo;                       /* PRSResource_QCLInfo */
static int hf_f1ap_PRSBWAggregationRequestInfoList_item;  /* PRSBWAggregationRequestInfo_Item */
static int hf_f1ap_dl_PRSBWAggregationRequestInfo_List;  /* DL_PRSBWAggregationRequestInfo_List */
static int hf_f1ap_DL_PRSBWAggregationRequestInfo_List_item;  /* DL_PRSBWAggregationRequestInfo_Item */
static int hf_f1ap_qCLSourceSSB;                  /* PRSResource_QCLSourceSSB */
static int hf_f1ap_qCLSourcePRS;                  /* PRSResource_QCLSourcePRS */
static int hf_f1ap_pCI_NR;                        /* INTEGER_0_1007 */
static int hf_f1ap_qCLSourcePRSResourceSetID;     /* PRS_Resource_Set_ID */
static int hf_f1ap_qCLSourcePRSResourceID;        /* PRS_Resource_ID */
static int hf_f1ap_PRSResourceSet_List_item;      /* PRSResourceSet_Item */
static int hf_f1ap_subcarrierSpacing_02;          /* T_subcarrierSpacing_01 */
static int hf_f1ap_pRSbandwidth;                  /* INTEGER_1_63 */
static int hf_f1ap_startPRB;                      /* INTEGER_0_2176 */
static int hf_f1ap_combSize;                      /* T_combSize */
static int hf_f1ap_cPType;                        /* T_cPType */
static int hf_f1ap_resourceSetPeriodicity;        /* T_resourceSetPeriodicity */
static int hf_f1ap_resourceSetSlotOffset;         /* INTEGER_0_81919_ */
static int hf_f1ap_resourceRepetitionFactor;      /* T_resourceRepetitionFactor */
static int hf_f1ap_resourceTimeGap;               /* T_resourceTimeGap */
static int hf_f1ap_resourceNumberofSymbols;       /* T_resourceNumberofSymbols */
static int hf_f1ap_pRSMuting;                     /* PRSMuting */
static int hf_f1ap_pRSResourceTransmitPower;      /* INTEGER_M60_50 */
static int hf_f1ap_pRSResource_List;              /* PRSResource_List */
static int hf_f1ap_pRSTransmissionOffPerTRP;      /* NULL */
static int hf_f1ap_pRSTransmissionOffPerResourceSet;  /* PRSTransmissionOffPerResourceSet */
static int hf_f1ap_pRSTransmissionOffPerResource;  /* PRSTransmissionOffPerResource */
static int hf_f1ap_PRSTransmissionOffPerResource_item;  /* PRSTransmissionOffPerResource_Item */
static int hf_f1ap_pRSTransmissionOffIndicationPerResourceList;  /* SEQUENCE_SIZE_1_maxnoofPRSresources_OF_PRSTransmissionOffIndicationPerResource_Item */
static int hf_f1ap_pRSTransmissionOffIndicationPerResourceList_item;  /* PRSTransmissionOffIndicationPerResource_Item */
static int hf_f1ap_pRSTransmissionOffIndication;  /* PRSTransmissionOffIndication */
static int hf_f1ap_PRSTransmissionOffPerResourceSet_item;  /* PRSTransmissionOffPerResourceSet_Item */
static int hf_f1ap_sIBtype;                       /* SIBType_PWS */
static int hf_f1ap_sIBmessage;                    /* T_sIBmessage */
static int hf_f1ap_PRSTRPList_item;               /* PRSTRPItem */
static int hf_f1ap_tRP_ID;                        /* TRPID */
static int hf_f1ap_requestedDLPRSTransmissionCharacteristics;  /* RequestedDLPRSTransmissionCharacteristics */
static int hf_f1ap_pRSTransmissionOffInformation;  /* PRSTransmissionOffInformation */
static int hf_f1ap_requestedDLPRSResourceSet_List;  /* RequestedDLPRSResourceSet_List */
static int hf_f1ap_numberofFrequencyLayers;       /* INTEGER_1_4 */
static int hf_f1ap_startTimeAndDuration;          /* StartTimeAndDuration */
static int hf_f1ap_RequestedDLPRSResourceSet_List_item;  /* RequestedDLPRSResourceSet_Item */
static int hf_f1ap_combSize_01;                   /* T_combSize_01 */
static int hf_f1ap_resourceSetPeriodicity_01;     /* T_resourceSetPeriodicity_01 */
static int hf_f1ap_resourceRepetitionFactor_01;   /* T_resourceRepetitionFactor_01 */
static int hf_f1ap_resourceNumberofSymbols_01;    /* T_resourceNumberofSymbols_01 */
static int hf_f1ap_requestedDLPRSResource_List;   /* RequestedDLPRSResource_List */
static int hf_f1ap_resourceSetStartTimeAndDuration;  /* StartTimeAndDuration */
static int hf_f1ap_RequestedDLPRSResource_List_item;  /* RequestedDLPRSResource_Item */
static int hf_f1ap_PRSTransmissionTRPList_item;   /* PRSTransmissionTRPItem */
static int hf_f1ap_pRSConfiguration;              /* PRSConfiguration */
static int hf_f1ap_ulPDUSetQoSInformation;        /* PDUSetQoSInformation */
static int hf_f1ap_dlPDUSetQoSInformation;        /* PDUSetQoSInformation */
static int hf_f1ap_pduSetDelayBudget;             /* ExtendedPacketDelayBudget */
static int hf_f1ap_pduSetErrorRate;               /* PacketErrorRate */
static int hf_f1ap_pduSetIntegratedHandlingInformation;  /* T_pduSetIntegratedHandlingInformation */
static int hf_f1ap_PSCellList_item;               /* PSCellList_Item */
static int hf_f1ap_pscell;                        /* NRCGI */
static int hf_f1ap_qoEInformationList;            /* QoEInformationList */
static int hf_f1ap_QoEInformationList_item;       /* QoEInformationList_Item */
static int hf_f1ap_qoEMetrics;                    /* QoEMetrics */
static int hf_f1ap_appLayerBufferLevelList;       /* AppLayerBufferLevelList */
static int hf_f1ap_playoutDelayForMediaStartup;   /* PlayoutDelayForMediaStartup */
static int hf_f1ap_non_Dynamic_5QI;               /* NonDynamic5QIDescriptor */
static int hf_f1ap_dynamic_5QI;                   /* Dynamic5QIDescriptor */
static int hf_f1ap_qoS_Characteristics;           /* QoS_Characteristics */
static int hf_f1ap_nGRANallocationRetentionPriority;  /* NGRANAllocationAndRetentionPriority */
static int hf_f1ap_gBR_QoS_Flow_Information;      /* GBR_QoSFlowInformation */
static int hf_f1ap_reflective_QoS_Attribute;      /* T_reflective_QoS_Attribute */
static int hf_f1ap_eUTRANQoS;                     /* EUTRANQoS */
static int hf_f1ap_RAReportList_item;             /* RAReportItem */
static int hf_f1ap_rAReportContainer;             /* RAReportContainer */
static int hf_f1ap_uEAssitantIdentifier;          /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_RAReportIndicationList_item;   /* RAReportIndicationList_Item */
static int hf_f1ap_sSBAreaRadioResourceStatusList;  /* SSBAreaRadioResourceStatusList */
static int hf_f1ap_dl_Total_PRB_usage;            /* INTEGER_0_100 */
static int hf_f1ap_ul_Total_PRB_usage;            /* INTEGER_0_100 */
static int hf_f1ap_dl_GBR_PRB_usage_for_MIMO;     /* INTEGER_0_100 */
static int hf_f1ap_ul_GBR_PRB_usage_for_MIMO;     /* INTEGER_0_100 */
static int hf_f1ap_dl_non_GBR_PRB_usage_for_MIMO;  /* INTEGER_0_100 */
static int hf_f1ap_ul_non_GBR_PRB_usage_for_MIMO;  /* INTEGER_0_100 */
static int hf_f1ap_dl_Total_PRB_usage_for_MIMO;   /* INTEGER_0_100 */
static int hf_f1ap_ul_Total_PRB_usage_for_MIMO;   /* INTEGER_0_100 */
static int hf_f1ap_proactive;                     /* RANfeedbacktype_proactive */
static int hf_f1ap_reactive;                      /* RANfeedbacktype_reactive */
static int hf_f1ap_burstArrivalTimeWindow;        /* BurstArrivalTimeWindow */
static int hf_f1ap_periodicityRange;              /* PeriodicityRange */
static int hf_f1ap_capabilityForBATAdaptation;    /* T_capabilityForBATAdaptation */
static int hf_f1ap_synchronisationstate;          /* T_synchronisationstate */
static int hf_f1ap_traceabletoUTC;                /* T_traceabletoUTC */
static int hf_f1ap_traceabletoGNSS;               /* T_traceabletoGNSS */
static int hf_f1ap_clockFrequencyStability;       /* BIT_STRING_SIZE_16 */
static int hf_f1ap_clockAccuracy;                 /* ClockAccuracy */
static int hf_f1ap_parentTimeSource;              /* ParentTImeSource */
static int hf_f1ap_clockAccuracyValue;            /* INTEGER_1_40000000_ */
static int hf_f1ap_clockAccuracyIndex;            /* INTEGER_32_47_ */
static int hf_f1ap_iRNTI;                         /* BIT_STRING_SIZE_40 */
static int hf_f1ap_eNDC;                          /* SubscriberProfileIDforRFP */
static int hf_f1ap_nGRAN;                         /* RAT_FrequencySelectionPriority */
static int hf_f1ap_rBSetSize;                     /* RBSetSize */
static int hf_f1ap_nUmberRBsets;                  /* INTEGER_1_maxnoofRBsetsPerCell */
static int hf_f1ap_Recommended_SSBs_for_Paging_List_item;  /* Recommended_SSBs_for_Paging_List_Item */
static int hf_f1ap_sSBs_forPaging_List;           /* SSBs_forPaging_List */
static int hf_f1ap_coordinateID;                  /* CoordinateID */
static int hf_f1ap_referencePointCoordinate;      /* AccessPointPosition */
static int hf_f1ap_referencePointCoordinateHA;    /* NGRANHighAccuracyAccessPointPosition */
static int hf_f1ap_relativeCoordinateID;          /* CoordinateID */
static int hf_f1ap_horizontalAxesOrientation;     /* INTEGER_0_3599 */
static int hf_f1ap_nZP_CSI_RS;                    /* NZP_CSI_RS_ResourceID */
static int hf_f1ap_sRS;                           /* SRSResourceID */
static int hf_f1ap_rEQUESTforLowerLayerConfiguration;  /* RequestforLowerLayerConfiguration */
static int hf_f1ap_referenceConfiguration_item;   /* ReferenceConfigurationInformation */
static int hf_f1ap_xYZunit;                       /* T_xYZunit */
static int hf_f1ap_xvalue;                        /* INTEGER_M65536_65535 */
static int hf_f1ap_yvalue;                        /* INTEGER_M65536_65535 */
static int hf_f1ap_zvalue;                        /* INTEGER_M32768_32767 */
static int hf_f1ap_locationUncertainty;           /* LocationUncertainty */
static int hf_f1ap_milli_Arc_SecondUnits;         /* T_milli_Arc_SecondUnits */
static int hf_f1ap_heightUnits;                   /* T_heightUnits */
static int hf_f1ap_deltaLatitude;                 /* INTEGER_M1024_1023 */
static int hf_f1ap_deltaLongitude;                /* INTEGER_M1024_1023 */
static int hf_f1ap_deltaHeight;                   /* INTEGER_M1024_1023 */
static int hf_f1ap_RequestedSRSPreconfigurationCharacteristics_List_item;  /* RequestedSRSPreconfigurationCharacteristics_Item */
static int hf_f1ap_requestedSRSTransmissionCharacteristics;  /* RequestedSRSTransmissionCharacteristics */
static int hf_f1ap_numberOfTransmissions;         /* INTEGER_0_500_ */
static int hf_f1ap_resourceType_01;               /* T_resourceType_01 */
static int hf_f1ap_bandwidthSRS;                  /* BandwidthSRS */
static int hf_f1ap_sRSResourceSetList;            /* SRSResourceSetList */
static int hf_f1ap_eUTRA_Mode_Info;               /* EUTRA_Coex_Mode_Info */
static int hf_f1ap_eUTRA_PRACH_Configuration;     /* EUTRA_PRACH_Configuration */
static int hf_f1ap_meNB_Cell_ID;                  /* EUTRA_Cell_ID */
static int hf_f1ap_resourceCoordinationEUTRACellInfo;  /* ResourceCoordinationEUTRACellInfo */
static int hf_f1ap_nrofSumbols;                   /* T_nrofSumbols */
static int hf_f1ap_periodic_01;                   /* ResourceSetTypePeriodic */
static int hf_f1ap_semi_persistent_01;            /* ResourceSetTypeSemi_persistent */
static int hf_f1ap_aperiodic_01;                  /* ResourceSetTypeAperiodic */
static int hf_f1ap_periodicSet;                   /* T_periodicSet */
static int hf_f1ap_semi_persistentSet;            /* T_semi_persistentSet */
static int hf_f1ap_slotoffset;                    /* INTEGER_0_32 */
static int hf_f1ap_eventType;                     /* EventType */
static int hf_f1ap_reportingPeriodicityValue;     /* ReportingPeriodicityValue */
static int hf_f1ap_periodic_02;                   /* ResourceTypePeriodic */
static int hf_f1ap_semi_persistent_02;            /* ResourceTypeSemi_persistent */
static int hf_f1ap_aperiodic_02;                  /* ResourceTypeAperiodic */
static int hf_f1ap_periodicity;                   /* T_periodicity */
static int hf_f1ap_offset;                        /* INTEGER_0_2559_ */
static int hf_f1ap_periodicity_01;                /* T_periodicity_01 */
static int hf_f1ap_aperiodicResourceType;         /* T_aperiodicResourceType */
static int hf_f1ap_periodic_03;                   /* ResourceTypePeriodicPos */
static int hf_f1ap_semi_persistent_03;            /* ResourceTypeSemi_persistentPos */
static int hf_f1ap_aperiodic_03;                  /* ResourceTypeAperiodicPos */
static int hf_f1ap_periodicity_02;                /* SRS_Periodicity */
static int hf_f1ap_offset_01;                     /* INTEGER_0_81919_ */
static int hf_f1ap_slotOffset;                    /* INTEGER_0_32 */
static int hf_f1ap_rLCDuplicationStateList;       /* RLCDuplicationStateList */
static int hf_f1ap_primaryPathIndication;         /* PrimaryPathIndication */
static int hf_f1ap_RLCDuplicationStateList_item;  /* RLCDuplicationState_Item */
static int hf_f1ap_duplicationState;              /* DuplicationState */
static int hf_f1ap_assocatedLCID;                 /* LCID */
static int hf_f1ap_reestablishment_Indication;    /* Reestablishment_Indication */
static int hf_f1ap_RLFReportInformationList_item;  /* RLFReportInformationItem */
static int hf_f1ap_nRUERLFReportContainer;        /* NRUERLFReportContainer */
static int hf_f1ap_delivery_status;               /* PDCP_SN */
static int hf_f1ap_triggering_message;            /* PDCP_SN */
static int hf_f1ap_rRC_TerminatingIAB_Donor_gNB_ID;  /* GlobalGNB_ID */
static int hf_f1ap_mobileIAB_MT_BAP_Address;      /* BAPAddress */
static int hf_f1ap_latest_RRC_Version;            /* BIT_STRING_SIZE_3 */
static int hf_f1ap_time;                          /* INTEGER_1_128_ */
static int hf_f1ap_timeUnit;                      /* T_timeUnit */
static int hf_f1ap_sCellIndex;                    /* SCellIndex */
static int hf_f1ap_sCellULConfigured;             /* CellULConfigured */
static int hf_f1ap_subcarrierSpacing_03;          /* T_subcarrierSpacing_02 */
static int hf_f1ap_carrierBandwidth_01;           /* INTEGER_1_275_ */
static int hf_f1ap_sDTBearerConfig_List;          /* SDTBearerConfig_List */
static int hf_f1ap_SDTBearerConfig_List_item;     /* SDTBearerConfig_List_Item */
static int hf_f1ap_sDTBearerType;                 /* SDTBearerType */
static int hf_f1ap_sDTRLCBearerConfiguration;     /* SDTRLCBearerConfiguration */
static int hf_f1ap_sRB;                           /* SRBID */
static int hf_f1ap_dRB;                           /* DRBID */
static int hf_f1ap_sdtIndicator;                  /* T_sdtIndicator */
static int hf_f1ap_sdtAssistantInformation;       /* T_sdtAssistantInformation */
static int hf_f1ap_expectedPropagationDelay;      /* INTEGER_M3841_3841_ */
static int hf_f1ap_delayUncertainty;              /* INTEGER_1_246_ */
static int hf_f1ap_servingCellMO;                 /* ServingCellMO */
static int hf_f1ap_sSB_Frequency;                 /* INTEGER_0_3279165 */
static int hf_f1ap_ServingCellMO_encoded_in_CGC_List_item;  /* ServingCellMO_encoded_in_CGC_Item */
static int hf_f1ap_configured_EPS_TAC;            /* Configured_EPS_TAC */
static int hf_f1ap_servedPLMNs;                   /* ServedPLMNs_List */
static int hf_f1ap_nR_Mode_Info;                  /* NR_Mode_Info */
static int hf_f1ap_measurementTimingConfiguration;  /* T_measurementTimingConfiguration */
static int hf_f1ap_Serving_Cells_List_item;       /* Serving_Cells_List_Item */
static int hf_f1ap_iAB_MT_Cell_NA_Resource_Configuration_Mode_Info;  /* IAB_MT_Cell_NA_Resource_Configuration_Mode_Info */
static int hf_f1ap_Supported_MBS_FSA_ID_List_item;  /* MBS_FrequencySelectionArea_Identity */
static int hf_f1ap_sFN_Time_Offset;               /* BIT_STRING_SIZE_24 */
static int hf_f1ap_oldNRCGI;                      /* NRCGI */
static int hf_f1ap_eUTRA_Mode_Info_01;            /* EUTRA_Mode_Info */
static int hf_f1ap_protectedEUTRAResourceIndication;  /* ProtectedEUTRAResourceIndication */
static int hf_f1ap_service_state;                 /* Service_State */
static int hf_f1ap_switchingOffOngoing;           /* T_switchingOffOngoing */
static int hf_f1ap_rSRP;                          /* INTEGER_0_127 */
static int hf_f1ap_rSRQ;                          /* INTEGER_0_127 */
static int hf_f1ap_sINR;                          /* INTEGER_0_127 */
static int hf_f1ap_sSBIndexwithMeasurements;      /* SSBIndexwithMeasurements_Item */
static int hf_f1ap_SSBIndexList_item;             /* SSBIndexList_Item */
static int hf_f1ap_SSBIndexwithMeasurementsList_item;  /* SSBIndexwithMeasurements_Item */
static int hf_f1ap_selectedMeasurementQuantities;  /* SelectedMeasurementQuantities */
static int hf_f1ap_SItype_List_item;              /* SItype_Item */
static int hf_f1ap_sItype;                        /* SItype */
static int hf_f1ap_sIBtype_01;                    /* T_sIBtype */
static int hf_f1ap_sIBmessage_01;                 /* T_sIBmessage_01 */
static int hf_f1ap_valueTag;                      /* INTEGER_0_31_ */
static int hf_f1ap_gNB_DU_UE_F1APIDofRelayUE;     /* GNB_DU_UE_F1AP_ID */
static int hf_f1ap_sidelinkConfigurationContainer;  /* SidelinkConfigurationContainer */
static int hf_f1ap_sLDRB_QoS;                     /* PC5QoSParameters */
static int hf_f1ap_flowsMappedToSLDRB_List;       /* FlowsMappedToSLDRB_List */
static int hf_f1ap_sLDRBID;                       /* SLDRBID */
static int hf_f1ap_sLDRBInformation;              /* SLDRBInformation */
static int hf_f1ap_SLDRXCycleList_item;           /* SLDRXCycleItem */
static int hf_f1ap_rXUEID;                        /* BIT_STRING_SIZE_24 */
static int hf_f1ap_sLDRXInformation;              /* SLDRXInformation */
static int hf_f1ap_sLDRXCycle;                    /* SLDRXCycleLength */
static int hf_f1ap_nosLDRX;                       /* SLDRXConfigurationIndicator */
static int hf_f1ap_sliceAvailableCapacityList;    /* SliceAvailableCapacityList */
static int hf_f1ap_SliceAvailableCapacityList_item;  /* SliceAvailableCapacityItem */
static int hf_f1ap_sNSSAIAvailableCapacity_List;  /* SNSSAIAvailableCapacity_List */
static int hf_f1ap_SNSSAIAvailableCapacity_List_item;  /* SNSSAIAvailableCapacity_Item */
static int hf_f1ap_sliceAvailableCapacityValueDownlink;  /* INTEGER_0_100 */
static int hf_f1ap_sliceAvailableCapacityValueUplink;  /* INTEGER_0_100 */
static int hf_f1ap_sliceRadioResourceStatus;      /* SliceRadioResourceStatus_List */
static int hf_f1ap_SliceRadioResourceStatus_List_item;  /* SliceRadioResourceStatus_Item */
static int hf_f1ap_sNSSAIRadioResourceStatus_List;  /* SNSSAIRadioResourceStatus_List */
static int hf_f1ap_SNSSAIRadioResourceStatus_List_item;  /* SNSSAIRadioResourceStatus_Item */
static int hf_f1ap_sNSSAIdlGBRPRBusage;           /* INTEGER_0_100 */
static int hf_f1ap_sNSSAIulGBRPRBusage;           /* INTEGER_0_100 */
static int hf_f1ap_sNSSAIdlNonGBRPRBusage;        /* INTEGER_0_100 */
static int hf_f1ap_sNSSAIulNonGBRPRBusage;        /* INTEGER_0_100 */
static int hf_f1ap_sNSSAIdlTotalPRBallocation;    /* INTEGER_0_100 */
static int hf_f1ap_sNSSAIulTotalPRBallocation;    /* INTEGER_0_100 */
static int hf_f1ap_SliceSupportList_item;         /* SliceSupportItem */
static int hf_f1ap_SliceToReportList_item;        /* SliceToReportItem */
static int hf_f1ap_sNSSAIlist;                    /* SNSSAI_list */
static int hf_f1ap_sLPositioning_Ranging_Authorized;  /* SLPositioning_Ranging_Authorized */
static int hf_f1ap_rSPP_transport_QoS_parameters;  /* RSPP_transport_QoS_parameters */
static int hf_f1ap_rSPPQoSFlowList;               /* RSPPQoSFlowList */
static int hf_f1ap_rSPPLinkAggregateBitRates;     /* BitRate */
static int hf_f1ap_RSPPQoSFlowList_item;          /* RSPPQoSFlowItem */
static int hf_f1ap_pQI;                           /* FiveQI */
static int hf_f1ap_rSPPFlowBitRates;              /* RSPPFlowBitRates */
static int hf_f1ap_range;                         /* Range */
static int hf_f1ap_SNSSAI_list_item;              /* SNSSAI_Item */
static int hf_f1ap_Slot_Configuration_List_item;  /* Slot_Configuration_Item */
static int hf_f1ap_slotIndex_01;                  /* INTEGER_0_5119_ */
static int hf_f1ap_symbolAllocInSlot;             /* SymbolAllocInSlot */
static int hf_f1ap_SlotOffsetForRemainingHopsList_item;  /* SlotOffsetForRemainingHopsItem */
static int hf_f1ap_slotOffsetRemainingHops;       /* SlotOffsetRemainingHops */
static int hf_f1ap_aperiodic_04;                  /* SlotOffsetRemainingHopsAperiodic */
static int hf_f1ap_semi_persistent_04;            /* SlotOffsetRemainingHopsSemiPersistent */
static int hf_f1ap_periodic_04;                   /* SlotOffsetRemainingHopsPeriodic */
static int hf_f1ap_slotOffset_01;                 /* INTEGER_1_32 */
static int hf_f1ap_sRSperiodicity;                /* SRS_Periodicity */
static int hf_f1ap_sST;                           /* OCTET_STRING_SIZE_1 */
static int hf_f1ap_sD;                            /* OCTET_STRING_SIZE_3 */
static int hf_f1ap_nR_PRSBeamInformation;         /* NR_PRSBeamInformation */
static int hf_f1ap_spatialRelationforResourceID;  /* SpatialRelationforResourceID */
static int hf_f1ap_SpatialRelationforResourceID_item;  /* SpatialRelationforResourceIDItem */
static int hf_f1ap_referenceSignal;               /* ReferenceSignal */
static int hf_f1ap_spatialRelationPerSRSResource_List;  /* SpatialRelationPerSRSResource_List */
static int hf_f1ap_SpatialRelationPerSRSResource_List_item;  /* SpatialRelationPerSRSResourceItem */
static int hf_f1ap_sSBPos;                        /* SSB */
static int hf_f1ap_pRSInformationPos;             /* PRSInformationPos */
static int hf_f1ap_sRBID;                         /* SRBID */
static int hf_f1ap_duplicationIndication;         /* DuplicationIndication */
static int hf_f1ap_SRSCarrier_List_item;          /* SRSCarrier_List_Item */
static int hf_f1ap_uplinkChannelBW_PerSCS_List;   /* UplinkChannelBW_PerSCS_List */
static int hf_f1ap_activeULBWP;                   /* ActiveULBWP */
static int hf_f1ap_pci;                           /* NRPCI */
static int hf_f1ap_sRSResource_List;              /* SRSResource_List */
static int hf_f1ap_posSRSResource_List;           /* PosSRSResource_List */
static int hf_f1ap_sRSResourceSet_List;           /* SRSResourceSet_List */
static int hf_f1ap_posSRSResourceSet_List;        /* PosSRSResourceSet_List */
static int hf_f1ap_sRSCarrier_List;               /* SRSCarrier_List */
static int hf_f1ap_SRSPreconfiguration_List_item;  /* SRSPreconfiguration_Item */
static int hf_f1ap_sRSPosRRCInactiveValidityAreaConfig;  /* SRSPosRRCInactiveValidityAreaConfig */
static int hf_f1ap_posValidityAreaCellList;       /* PosValidityAreaCellList */
static int hf_f1ap_sRSResourceID;                 /* SRSResourceID */
static int hf_f1ap_nrofSRS_Ports;                 /* T_nrofSRS_Ports */
static int hf_f1ap_transmissionComb;              /* TransmissionComb */
static int hf_f1ap_nrofSymbols_01;                /* T_nrofSymbols_01 */
static int hf_f1ap_repetitionFactor;              /* T_repetitionFactor */
static int hf_f1ap_freqDomainPosition;            /* INTEGER_0_67 */
static int hf_f1ap_b_SRS;                         /* INTEGER_0_3 */
static int hf_f1ap_b_hop;                         /* INTEGER_0_3 */
static int hf_f1ap_groupOrSequenceHopping_01;     /* T_groupOrSequenceHopping_01 */
static int hf_f1ap_resourceType_02;               /* ResourceType */
static int hf_f1ap_sequenceId_01;                 /* INTEGER_0_1023 */
static int hf_f1ap_SRSResourceID_List_item;       /* SRSResourceID */
static int hf_f1ap_SRSResource_List_item;         /* SRSResource */
static int hf_f1ap_sRSResourceID_List;            /* SRSResourceID_List */
static int hf_f1ap_resourceSetType;               /* ResourceSetType */
static int hf_f1ap_SRSResourceSetList_item;       /* SRSResourceSetItem */
static int hf_f1ap_numSRSresourcesperset;         /* INTEGER_1_16_ */
static int hf_f1ap_periodicityList_01;            /* PeriodicityList */
static int hf_f1ap_spatialRelationInfo;           /* SpatialRelationInfo */
static int hf_f1ap_pathlossReferenceInfo;         /* PathlossReferenceInfo */
static int hf_f1ap_SRSResourceSet_List_item;      /* SRSResourceSet */
static int hf_f1ap_aperiodicSRSResourceTriggerList;  /* AperiodicSRSResourceTriggerList */
static int hf_f1ap_sRSResourceTypeChoice;         /* SRSResourceTypeChoice */
static int hf_f1ap_sRSResourceInfo;               /* SRSInfo */
static int hf_f1ap_posSRSResourceInfo;            /* PosSRSInfo */
static int hf_f1ap_sRSResource;                   /* SRSResourceID */
static int hf_f1ap_posSRSResourceID;              /* SRSPosResourceID */
static int hf_f1ap_pCI_NR_01;                     /* NRPCI */
static int hf_f1ap_ssb_index;                     /* SSB_Index */
static int hf_f1ap_SSBCoverageModification_List_item;  /* SSBCoverageModification_Item */
static int hf_f1ap_sSBIndex_01;                   /* INTEGER_0_63 */
static int hf_f1ap_sSBCoverageState;              /* SSBCoverageState */
static int hf_f1ap_shortBitmap;                   /* BIT_STRING_SIZE_4 */
static int hf_f1ap_mediumBitmap;                  /* BIT_STRING_SIZE_8 */
static int hf_f1ap_longBitmap;                    /* BIT_STRING_SIZE_64 */
static int hf_f1ap_SSBAreaCapacityValueList_item;  /* SSBAreaCapacityValueItem */
static int hf_f1ap_sSBAreaCapacityValue;          /* INTEGER_0_100 */
static int hf_f1ap_SSBAreaRadioResourceStatusList_item;  /* SSBAreaRadioResourceStatusItem */
static int hf_f1ap_sSBAreaDLGBRPRBusage;          /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaULGBRPRBusage;          /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaDLnon_GBRPRBusage;      /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaULnon_GBRPRBusage;      /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaDLTotalPRBusage;        /* INTEGER_0_100 */
static int hf_f1ap_sSBAreaULTotalPRBusage;        /* INTEGER_0_100 */
static int hf_f1ap_dLschedulingPDCCHCCEusage;     /* INTEGER_0_100 */
static int hf_f1ap_uLschedulingPDCCHCCEusage;     /* INTEGER_0_100 */
static int hf_f1ap_sSBInformationList;            /* SSBInformationList */
static int hf_f1ap_SSBInformationList_item;       /* SSBInformationItem */
static int hf_f1ap_sSB_Configuration;             /* SSB_TF_Configuration */
static int hf_f1ap_SSBs_activated_List_item;      /* SSB_Index */
static int hf_f1ap_SSBs_forPaging_List_item;      /* SSB_Index */
static int hf_f1ap_SSBs_toBeActivated_List_item;  /* SSB_Index */
static int hf_f1ap_sSB_frequency;                 /* INTEGER_0_3279165 */
static int hf_f1ap_sSB_subcarrier_spacing;        /* T_sSB_subcarrier_spacing */
static int hf_f1ap_sSB_Transmit_power;            /* INTEGER_M60_50 */
static int hf_f1ap_sSB_periodicity;               /* T_sSB_periodicity */
static int hf_f1ap_sSB_half_frame_offset;         /* INTEGER_0_1 */
static int hf_f1ap_sSB_SFN_offset;                /* INTEGER_0_15 */
static int hf_f1ap_sSB_position_in_burst;         /* SSB_PositionsInBurst */
static int hf_f1ap_sFNInitialisationTime;         /* RelativeTime1900 */
static int hf_f1ap_SSBToReportList_item;          /* SSBToReportItem */
static int hf_f1ap_freqScalingFactor2;            /* INTEGER_0_1 */
static int hf_f1ap_freqScalingFactor4;            /* INTEGER_0_3 */
static int hf_f1ap_startTime;                     /* RelativeTime1900 */
static int hf_f1ap_duration;                      /* INTEGER_0_90060_ */
static int hf_f1ap_sUL_NRARFCN;                   /* INTEGER_0_maxNRARFCN */
static int hf_f1ap_sUL_transmission_Bandwidth;    /* Transmission_Bandwidth */
static int hf_f1ap_SuccessfulHOReportInformationList_item;  /* SuccessfulHOReportInformation_Item */
static int hf_f1ap_successfulHOReportContainer;   /* T_successfulHOReportContainer */
static int hf_f1ap_SuccessfulPSCellChangeReportInformationList_item;  /* SuccessfulPSCellChangeReportInformation_Item */
static int hf_f1ap_successfulPSCellChangeReportContainer;  /* T_successfulPSCellChangeReportContainer */
static int hf_f1ap_SupportedUETypeList_item;      /* SupportedUETypeList_Item */
static int hf_f1ap_supportedUEtype;               /* T_supportedUEtype */
static int hf_f1ap_all_DL;                        /* NULL */
static int hf_f1ap_all_UL;                        /* NULL */
static int hf_f1ap_both_DL_and_UL;                /* NumDLULSymbols */
static int hf_f1ap_TargetCellList_item;           /* TargetCellList_Item */
static int hf_f1ap_target_cell;                   /* NRCGI */
static int hf_f1ap_NSAGSupportList_item;          /* NSAGSupportItem */
static int hf_f1ap_nSAG_ID;                       /* NSAG_ID */
static int hf_f1ap_nSAGSliceSupport;              /* ExtendedSliceSupportList */
static int hf_f1ap_tDD_FreqInfo;                  /* FreqInfoRel16 */
static int hf_f1ap_tDD_UL_DLConfigCommonNR;       /* TDD_UL_DLConfigCommonNR */
static int hf_f1ap_rxTx_TEG;                      /* RxTxTEG */
static int hf_f1ap_rx_TEG;                        /* RxTEG */
static int hf_f1ap_tRP_RxTx_TEGInformation;       /* TRP_RxTx_TEGInformation */
static int hf_f1ap_tRP_Tx_TEGInformation;         /* TRP_Tx_TEGInformation */
static int hf_f1ap_tRP_Rx_TEGInformation;         /* TRP_Rx_TEGInformation */
static int hf_f1ap_referenceTime;                 /* ReferenceTime */
static int hf_f1ap_referenceSFN;                  /* ReferenceSFN */
static int hf_f1ap_uncertainty;                   /* Uncertainty */
static int hf_f1ap_timeInformationType;           /* TimeInformationType */
static int hf_f1ap_systemFrameNumber;             /* SystemFrameNumber */
static int hf_f1ap_slotIndex_02;                  /* TimeStampSlotIndex */
static int hf_f1ap_measurementTime;               /* RelativeTime1900 */
static int hf_f1ap_sCS_15;                        /* INTEGER_0_9 */
static int hf_f1ap_sCS_30;                        /* INTEGER_0_19 */
static int hf_f1ap_sCS_60;                        /* INTEGER_0_39 */
static int hf_f1ap_sCS_120;                       /* INTEGER_0_79 */
static int hf_f1ap_measurementQuality_01;         /* INTEGER_0_31 */
static int hf_f1ap_resolution_01;                 /* T_resolution_01 */
static int hf_f1ap_slotNumber;                    /* SlotNumber */
static int hf_f1ap_symbolIndex;                   /* INTEGER_0_13 */
static int hf_f1ap_TimeWindowInformation_Measurement_List_item;  /* TimeWindowInformation_Measurement_Item */
static int hf_f1ap_timeWindowDurationMeasurement;  /* TimeWindowDurationMeasurement */
static int hf_f1ap_timeWindowType;                /* T_timeWindowType */
static int hf_f1ap_timeWindowPeriodicityMeasurement;  /* TimeWindowPeriodicityMeasurement */
static int hf_f1ap_timeWindowStart;               /* TimeWindowStart */
static int hf_f1ap_TimeWindowInformation_SRS_List_item;  /* TimeWindowInformation_SRS_Item */
static int hf_f1ap_timeWindowStartSRS;            /* TimeWindowStartSRS */
static int hf_f1ap_timeWindowDurationSRS;         /* TimeWindowDurationSRS */
static int hf_f1ap_timeWindowType_01;             /* T_timeWindowType_01 */
static int hf_f1ap_timeWindowPeriodicitySRS;      /* TimeWindowPeriodicitySRS */
static int hf_f1ap_durationSlots;                 /* T_durationSlots */
static int hf_f1ap_durationSymbols;               /* T_durationSymbols */
static int hf_f1ap_durationSlots_01;              /* T_durationSlots_01 */
static int hf_f1ap_symbolIndex_01;                /* SymbolIndex */
static int hf_f1ap_dLTNLOfferedCapacity;          /* INTEGER_1_16777216_ */
static int hf_f1ap_dLTNLAvailableCapacity;        /* INTEGER_0_100_ */
static int hf_f1ap_uLTNLOfferedCapacity;          /* INTEGER_1_16777216_ */
static int hf_f1ap_uLTNLAvailableCapacity;        /* INTEGER_0_100_ */
static int hf_f1ap_traceID;                       /* TraceID */
static int hf_f1ap_interfacesToTrace;             /* InterfacesToTrace */
static int hf_f1ap_traceDepth;                    /* TraceDepth */
static int hf_f1ap_traceCollectionEntityIPAddress;  /* TransportLayerAddress */
static int hf_f1ap_iPtolayer2TrafficMappingInfo;  /* IPtolayer2TrafficMappingInfo */
static int hf_f1ap_bAPlayerBHRLCchannelMappingInfo;  /* BAPlayerBHRLCchannelMappingInfo */
static int hf_f1ap_nRNRB;                         /* NRNRB */
static int hf_f1ap_ul_Transmission_Bandwidth;     /* Transmission_Bandwidth */
static int hf_f1ap_dl_Transmission_Bandwidth;     /* Transmission_Bandwidth */
static int hf_f1ap_n2;                            /* T_n2 */
static int hf_f1ap_combOffset_n2;                 /* INTEGER_0_1 */
static int hf_f1ap_cyclicShift_n2;                /* INTEGER_0_7 */
static int hf_f1ap_n4;                            /* T_n4 */
static int hf_f1ap_combOffset_n4;                 /* INTEGER_0_3 */
static int hf_f1ap_cyclicShift_n4;                /* INTEGER_0_11 */
static int hf_f1ap_combOffset_n8;                 /* INTEGER_0_7 */
static int hf_f1ap_cyclicShift_n8;                /* INTEGER_0_5 */
static int hf_f1ap_n2_01;                         /* T_n2_01 */
static int hf_f1ap_n4_01;                         /* T_n4_01 */
static int hf_f1ap_n8;                            /* T_n8 */
static int hf_f1ap_Transport_UP_Layer_Address_Info_To_Add_List_item;  /* Transport_UP_Layer_Address_Info_To_Add_Item */
static int hf_f1ap_iP_SecTransportLayerAddress;   /* TransportLayerAddress */
static int hf_f1ap_gTPTransportLayerAddressToAdd;  /* GTPTLAs */
static int hf_f1ap_Transport_UP_Layer_Address_Info_To_Remove_List_item;  /* Transport_UP_Layer_Address_Info_To_Remove_Item */
static int hf_f1ap_gTPTransportLayerAddressToRemove;  /* GTPTLAs */
static int hf_f1ap_choice_TRP_Beam_Antenna_Info_Item;  /* Choice_TRP_Beam_Antenna_Info_Item */
static int hf_f1ap_reference;                     /* TRPID */
static int hf_f1ap_explicit;                      /* TRP_BeamAntennaExplicitInformation */
static int hf_f1ap_noChange;                      /* NULL */
static int hf_f1ap_trp_BeamAntennaAngles;         /* TRP_BeamAntennaAngles */
static int hf_f1ap_lcs_to_gcs_translation;        /* LCS_to_GCS_Translation */
static int hf_f1ap_TRP_BeamAntennaAngles_item;    /* TRP_BeamAntennaAnglesList_Item */
static int hf_f1ap_trp_azimuth_angle;             /* INTEGER_0_359 */
static int hf_f1ap_trp_azimuth_angle_fine;        /* INTEGER_0_9 */
static int hf_f1ap_trp_elevation_angle_list;      /* SEQUENCE_SIZE_1_maxnoElevationAngles_OF_TRP_ElevationAngleList_Item */
static int hf_f1ap_trp_elevation_angle_list_item;  /* TRP_ElevationAngleList_Item */
static int hf_f1ap_trp_elevation_angle;           /* INTEGER_0_180 */
static int hf_f1ap_trp_elevation_angle_fine;      /* INTEGER_0_9 */
static int hf_f1ap_trp_beam_power_list;           /* SEQUENCE_SIZE_2_maxNumResourcesPerAngle_OF_TRP_Beam_Power_Item */
static int hf_f1ap_trp_beam_power_list_item;      /* TRP_Beam_Power_Item */
static int hf_f1ap_relativePower;                 /* INTEGER_0_30 */
static int hf_f1ap_relativePowerFine;             /* INTEGER_0_9 */
static int hf_f1ap_tRPInformationTypeResponseList;  /* TRPInformationTypeResponseList */
static int hf_f1ap_tRPInformation;                /* TRPInformation */
static int hf_f1ap_TRPInformationTypeResponseList_item;  /* TRPInformationTypeResponseItem */
static int hf_f1ap_nG_RAN_CGI;                    /* NRCGI */
static int hf_f1ap_sSBinformation;                /* SSBInformation */
static int hf_f1ap_spatialDirectionInformation;   /* SpatialDirectionInformation */
static int hf_f1ap_TRPList_item;                  /* TRPListItem */
static int hf_f1ap_tRPmeasurementQuality_Item;    /* TRPMeasurementQuality_Item */
static int hf_f1ap_timingMeasurementQuality;      /* TimingMeasurementQuality */
static int hf_f1ap_angleMeasurementQuality;       /* AngleMeasurementQuality */
static int hf_f1ap_phaseQualityIndex;             /* INTEGER_0_179 */
static int hf_f1ap_phaseQualityResolution;        /* T_phaseQualityResolution */
static int hf_f1ap_TRP_MeasurementRequestList_item;  /* TRP_MeasurementRequestItem */
static int hf_f1ap_search_window_information;     /* Search_window_information */
static int hf_f1ap_TRP_PRS_Info_List_item;        /* TRP_PRS_Info_List_Item */
static int hf_f1ap_nR_PCI;                        /* NRPCI */
static int hf_f1ap_cGI_NR;                        /* NRCGI */
static int hf_f1ap_direct;                        /* TRPPositionDirect */
static int hf_f1ap_referenced;                    /* TRPPositionReferenced */
static int hf_f1ap_accuracy;                      /* TRPPositionDirectAccuracy */
static int hf_f1ap_tRPPosition;                   /* AccessPointPosition */
static int hf_f1ap_tRPHAposition;                 /* NGRANHighAccuracyAccessPointPosition */
static int hf_f1ap_referencePoint;                /* ReferencePoint */
static int hf_f1ap_referencePointType;            /* TRPReferencePointType */
static int hf_f1ap_tRPPositionRelativeGeodetic;   /* RelativeGeodeticLocation */
static int hf_f1ap_tRPPositionRelativeCartesian;  /* RelativeCartesianLocation */
static int hf_f1ap_tRP_Rx_TEGID;                  /* INTEGER_0_31 */
static int hf_f1ap_tRP_Rx_TimingErrorMargin;      /* TimingErrorMargin */
static int hf_f1ap_tRP_RxTx_TEGID;                /* INTEGER_0_255 */
static int hf_f1ap_tRP_RxTx_TimingErrorMargin;    /* RxTxTimingErrorMargin */
static int hf_f1ap_tRP_Tx_TEGID;                  /* INTEGER_0_7 */
static int hf_f1ap_tRP_Tx_TimingErrorMargin;      /* TimingErrorMargin */
static int hf_f1ap_TRPTxTEGAssociation_item;      /* TRPTEG_Item */
static int hf_f1ap_dl_PRSResourceID_List;         /* SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceID_Item */
static int hf_f1ap_dl_PRSResourceID_List_item;    /* DLPRSResourceID_Item */
static int hf_f1ap_transport_UP_Layer_Address_Info_To_Add_List;  /* Transport_UP_Layer_Address_Info_To_Add_List */
static int hf_f1ap_transport_UP_Layer_Address_Info_To_Remove_List;  /* Transport_UP_Layer_Address_Info_To_Remove_List */
static int hf_f1ap_periodicity_03;                /* Periodicity */
static int hf_f1ap_burstArrivalTime;              /* BurstArrivalTime */
static int hf_f1ap_tSCAssistanceInformationDL;    /* TSCAssistanceInformation */
static int hf_f1ap_tSCAssistanceInformationUL;    /* TSCAssistanceInformation */
static int hf_f1ap_tSCFeedbackInformationDL;      /* TSCFeedbackInformation */
static int hf_f1ap_tSCFeedbackInformationUL;      /* TSCFeedbackInformation */
static int hf_f1ap_burstArrivalTimeOffset;        /* INTEGER_M640000_640000_ */
static int hf_f1ap_adjustedPeriodicity;           /* Periodicity */
static int hf_f1ap_TRP_MeasurementUpdateList_item;  /* TRP_MeasurementUpdateItem */
static int hf_f1ap_aoA_window_information;        /* AoA_AssistanceInfo */
static int hf_f1ap_overlapValue;                  /* T_overlapValue */
static int hf_f1ap_numberOfHops;                  /* INTEGER_2_6 */
static int hf_f1ap_slotOffsetForRemainingHopsList;  /* SlotOffsetForRemainingHopsList */
static int hf_f1ap_TAInformation_List_item;       /* TAInformation_Item */
static int hf_f1ap_uACPLMN_List;                  /* UACPLMN_List */
static int hf_f1ap_UACPLMN_List_item;             /* UACPLMN_Item */
static int hf_f1ap_uACType_List;                  /* UACType_List */
static int hf_f1ap_UACType_List_item;             /* UACType_Item */
static int hf_f1ap_uACReductionIndication;        /* UACReductionIndication */
static int hf_f1ap_uACCategoryType;               /* UACCategoryType */
static int hf_f1ap_uACstandardized;               /* UACAction */
static int hf_f1ap_uACOperatorDefined;            /* UACOperatorDefined */
static int hf_f1ap_accessCategory;                /* INTEGER_32_63_ */
static int hf_f1ap_accessIdentity;                /* BIT_STRING_SIZE_7 */
static int hf_f1ap_indexLength10;                 /* BIT_STRING_SIZE_10 */
static int hf_f1ap_uEIdentityIndexValue;          /* UEIdentityIndexValue */
static int hf_f1ap_pagingDRX;                     /* PagingDRX */
static int hf_f1ap_mrb_type_reconfiguration;      /* MBSPTPRetransmissionTunnelRequired */
static int hf_f1ap_mrb_type_reconfiguration_01;   /* T_mrb_type_reconfiguration */
static int hf_f1ap_mrb_reconfigured_RLCtype;      /* T_mrb_reconfigured_RLCtype */
static int hf_f1ap_multicastF1UContextReferenceCU;  /* MulticastF1UContextReferenceCU */
static int hf_f1ap_mbsPTPRetransmissionTunnelRequired;  /* MBSPTPRetransmissionTunnelRequired */
static int hf_f1ap_mbsPTPForwardingRequiredInformation;  /* MRB_ProgressInformation */
static int hf_f1ap_iNACTIVEStatePODetermination;  /* T_iNACTIVEStatePODetermination */
static int hf_f1ap_reportingAmount;               /* T_reportingAmount */
static int hf_f1ap_reportingInterval;             /* T_reportingInterval */
static int hf_f1ap_azimuthAoA;                    /* INTEGER_0_3599 */
static int hf_f1ap_zenithAoA;                     /* INTEGER_0_1799 */
static int hf_f1ap_uL_BH_Non_UP_Traffic_Mapping_List;  /* UL_BH_Non_UP_Traffic_Mapping_List */
static int hf_f1ap_UL_BH_Non_UP_Traffic_Mapping_List_item;  /* UL_BH_Non_UP_Traffic_Mapping_Item */
static int hf_f1ap_nonUPTrafficType;              /* NonUPTrafficType */
static int hf_f1ap_uLUEConfiguration;             /* ULUEConfiguration */
static int hf_f1ap_uL_RTOA_MeasurementItem;       /* UL_RTOA_MeasurementItem */
static int hf_f1ap_firstPathRSRPP;                /* INTEGER_0_126 */
static int hf_f1ap_uLRSCP;                        /* INTEGER_0_3599 */
static int hf_f1ap_uLUPTNLInformation;            /* UPTransportLayerInformation */
static int hf_f1ap_newULUPTNLInformation;         /* UPTransportLayerInformation */
static int hf_f1ap_ULUPTNLInformation_ToBeSetup_List_item;  /* ULUPTNLInformation_ToBeSetup_Item */
static int hf_f1ap_UplinkChannelBW_PerSCS_List_item;  /* SCS_SpecificCarrier */
static int hf_f1ap_gTPTunnel;                     /* GTPTunnel */
static int hf_f1ap_uuRLCChannelQoS;               /* QoSFlowLevelQoSParameters */
static int hf_f1ap_uuControlPlaneTrafficType;     /* T_uuControlPlaneTrafficType */
static int hf_f1ap_UuRLCChannelToBeSetupList_item;  /* UuRLCChannelToBeSetupItem */
static int hf_f1ap_uuRLCChannelID;                /* UuRLCChannelID */
static int hf_f1ap_uuRLCChannelQoSInformation;    /* UuRLCChannelQoSInformation */
static int hf_f1ap_UuRLCChannelToBeModifiedList_item;  /* UuRLCChannelToBeModifiedItem */
static int hf_f1ap_UuRLCChannelToBeReleasedList_item;  /* UuRLCChannelToBeReleasedItem */
static int hf_f1ap_UuRLCChannelSetupList_item;    /* UuRLCChannelSetupItem */
static int hf_f1ap_UuRLCChannelFailedToBeSetupList_item;  /* UuRLCChannelFailedToBeSetupItem */
static int hf_f1ap_UuRLCChannelModifiedList_item;  /* UuRLCChannelModifiedItem */
static int hf_f1ap_UuRLCChannelFailedToBeModifiedList_item;  /* UuRLCChannelFailedToBeModifiedItem */
static int hf_f1ap_UuRLCChannelRequiredToBeModifiedList_item;  /* UuRLCChannelRequiredToBeModifiedItem */
static int hf_f1ap_UuRLCChannelRequiredToBeReleasedList_item;  /* UuRLCChannelRequiredToBeReleasedItem */
static int hf_f1ap_resourceMapping;               /* ResourceMapping */
static int hf_f1ap_sequenceIDPos;                 /* INTEGER_0_65535 */
static int hf_f1ap_protocolIEs;                   /* ProtocolIE_Container */
static int hf_f1ap_f1_Interface;                  /* ResetAll */
static int hf_f1ap_partOfF1_Interface;            /* UE_associatedLogicalF1_ConnectionListRes */
static int hf_f1ap_UE_associatedLogicalF1_ConnectionListRes_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_associatedLogicalF1_ConnectionListResAck_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_DU_Served_Cells_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_to_be_Activated_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_NCGI_to_be_Updated_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Served_Cells_To_Add_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Served_Cells_To_Modify_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Served_Cells_To_Delete_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Status_List_item;        /* ProtocolIE_SingleContainer */
static int hf_f1ap_Dedicated_SIDelivery_NeededUE_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_DU_TNL_Association_To_Remove_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_to_be_Deactivated_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_To_Add_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_To_Remove_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_To_Update_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_to_be_Barred_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Allowed_to_be_Deactivated_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Protected_EUTRA_Resources_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Neighbour_Cell_Information_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Failed_to_be_Activated_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_Setup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Candidate_SpCell_List_item;    /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_ToBeSetup_List_item;     /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_ToBeSetup_List_item;      /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ToBeSetup_List_item;      /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_ToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ToBeSetup_List_item;    /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_MulticastMRBs_ToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_ServingCellMO_List_item;       /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_Setup_List_item;          /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_FailedToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_FailedToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_FailedtoSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_Setup_List_item;          /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_Setup_List_item;    /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_FailedToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_Setup_List_item;        /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_FailedToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_MulticastMRBs_Setupnew_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Potential_SpCell_List_item;    /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_ToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_ToBeRemoved_List_item;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_ToBeSetupMod_List_item;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ToBeSetupMod_List_item;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_ToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ToBeModified_List_item;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_ToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_ToBeReleased_List_item;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ToBeReleased_List_item;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_MulticastMRBs_ToBeSetup_atModify_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_MulticastMRBs_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_SetupMod_List_item;       /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_Modified_List_item;       /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_SetupMod_List_item;       /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_Modified_List_item;       /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_FailedToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_FailedToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_FailedToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SCell_FailedtoSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_SetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_Modified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_FailedToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_FailedToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Associated_SCell_List_item;    /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_SetupMod_List_item;     /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_Modified_List_item;     /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_FailedToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_FailedToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_MulticastMRBs_Setup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_Required_ToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_Required_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SRBs_Required_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BHChannels_Required_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_Required_ToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_Required_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_MulticastMRBs_RequiredToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_MulticastMRBs_RequiredToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRBs_ModifiedConf_List_item;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_SLDRBs_ModifiedConf_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UE_MulticastMRBs_ConfirmedToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_To_Be_Broadcast_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Broadcast_Completed_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Broadcast_To_Be_Cancelled_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Cells_Broadcast_Cancelled_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRB_Activity_List_item;        /* ProtocolIE_SingleContainer */
static int hf_f1ap_privateIEs;                    /* PrivateIE_Container */
static int hf_f1ap_PagingCell_list_item;          /* ProtocolIE_SingleContainer */
static int hf_f1ap_DRB_Notify_List_item;          /* ProtocolIE_SingleContainer */
static int hf_f1ap_NR_CGI_List_For_Restart_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_PWS_Failed_NR_CGI_List_item;   /* ProtocolIE_SingleContainer */
static int hf_f1ap_BH_Routing_Information_Added_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BH_Routing_Information_Removed_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BAP_Header_Rewriting_Added_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BAP_Header_Rewriting_Removed_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_IAB_TNL_Addresses_To_Remove_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_IAB_Allocated_TNL_Address_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UL_UP_TNL_Information_to_Update_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UL_UP_TNL_Address_to_Update_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_DL_UP_TNL_Address_to_Update_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Activated_Cells_Mapping_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_TRPInformationTypeListTRPReq_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_TRPInformationListTRPResp_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_semipersistentSRS;             /* SemipersistentSRS */
static int hf_f1ap_aperiodicSRS;                  /* AperiodicSRS */
static int hf_f1ap_sRSSpatialRelation;            /* SpatialRelationInfo */
static int hf_f1ap_aperiodic_05;                  /* T_aperiodic */
static int hf_f1ap_sRSResourceTrigger;            /* SRSResourceTrigger */
static int hf_f1ap_BroadcastMRBs_ToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_Setup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_FailedToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_ToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_ToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_SetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_FailedToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_Modified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_BroadcastMRBs_FailedToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_Broadcast_MRBs_Transport_Request_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_UEIdentity_List_For_Paging_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MC_PagingCell_list_item;       /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_ToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_Setup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_FailedToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_ToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_ToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_ToBeReleased_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_SetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_FailedToBeSetupMod_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_Modified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastMRBs_FailedToBeModified_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastF1UContext_ToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastF1UContext_Setup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_MulticastF1UContext_FailedToBeSetup_List_item;  /* ProtocolIE_SingleContainer */
static int hf_f1ap_initiatingMessage;             /* InitiatingMessage */
static int hf_f1ap_successfulOutcome;             /* SuccessfulOutcome */
static int hf_f1ap_unsuccessfulOutcome;           /* UnsuccessfulOutcome */
static int hf_f1ap_initiatingMessagevalue;        /* InitiatingMessage_value */
static int hf_f1ap_successfulOutcome_value;       /* SuccessfulOutcome_value */
static int hf_f1ap_unsuccessfulOutcome_value;     /* UnsuccessfulOutcome_value */

/* Initialize the subtree pointers */
static int ett_f1ap;
static int ett_f1ap_ResourceCoordinationTransferContainer;
static int ett_f1ap_PLMN_Identity;
static int ett_f1ap_MIB_message;
static int ett_f1ap_SIB1_message;
static int ett_f1ap_CG_ConfigInfo;
static int ett_f1ap_CellGroupConfig;
static int ett_f1ap_TransportLayerAddress;
static int ett_f1ap_UE_CapabilityRAT_ContainerList;
static int ett_f1ap_measurementTimingConfiguration;
static int ett_f1ap_DUtoCURRCContainer;
static int ett_f1ap_requestedP_MaxFR1;
static int ett_f1ap_HandoverPreparationInformation;
static int ett_f1ap_MeasConfig;
static int ett_f1ap_MeasGapConfig;
static int ett_f1ap_MeasGapSharingConfig;
static int ett_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container;
static int ett_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container;
static int ett_f1ap_ProtectedEUTRAResourceIndication;
static int ett_f1ap_RRCContainer;
static int ett_f1ap_RRCContainer_RRCSetupComplete;
static int ett_f1ap_sIBmessage;
static int ett_f1ap_UplinkTxDirectCurrentListInformation;
static int ett_f1ap_DRX_Config;
static int ett_f1ap_Ph_InfoSCG;
static int ett_f1ap_RequestedBandCombinationIndex;
static int ett_f1ap_RequestedFeatureSetEntryIndex;
static int ett_f1ap_RequestedP_MaxFR2;
static int ett_f1ap_UEAssistanceInformation;
static int ett_f1ap_CG_Config;
static int ett_f1ap_Ph_InfoMCG;
static int ett_f1ap_BurstArrivalTime;
static int ett_f1ap_cSI_RS_Configuration;
static int ett_f1ap_sR_Configuration;
static int ett_f1ap_pDCCH_ConfigSIB1;
static int ett_f1ap_sCS_Common;
static int ett_f1ap_IABTNLAddressIPv4Address;
static int ett_f1ap_IABTNLAddressIPv6Address;
static int ett_f1ap_IABTNLAddressIPv6Prefix;
static int ett_f1ap_InterfacesToTrace;
static int ett_f1ap_MeasurementsToActivate;
static int ett_f1ap_NRUERLFReportContainer;
static int ett_f1ap_RACH_Config_Common;
static int ett_f1ap_RACH_Config_Common_IAB;
static int ett_f1ap_RAReportContainer;
static int ett_f1ap_ReferenceTime;
static int ett_f1ap_ReportCharacteristics;
static int ett_f1ap_SIB10_message;
static int ett_f1ap_SIB12_message;
static int ett_f1ap_SIB13_message;
static int ett_f1ap_SIB14_message;
static int ett_f1ap_SIB15_message;
static int ett_f1ap_SIB17_message;
static int ett_f1ap_SIB17bis_message;
static int ett_f1ap_SIB20_message;
static int ett_f1ap_SIB22_message;
static int ett_f1ap_SIB23_message;
static int ett_f1ap_SIB24_message;
static int ett_f1ap_SL_PHY_MAC_RLC_Config;
static int ett_f1ap_SL_PHY_MAC_RLC_ConfigExt;
static int ett_f1ap_SL_RLC_ChannelToAddModList;
static int ett_f1ap_SL_ConfigDedicatedEUTRA_Info;
static int ett_f1ap_TDD_UL_DLConfigCommonNR;
static int ett_f1ap_UEAssistanceInformationEUTRA;
static int ett_f1ap_PosAssistance_Information;
static int ett_f1ap_LocationMeasurementInformation;
static int ett_f1ap_MUSIM_GapConfig;
static int ett_f1ap_SDT_MAC_PHY_CG_Config;
static int ett_f1ap_SDTRLCBearerConfiguration;
static int ett_f1ap_MBSInterestIndication;
static int ett_f1ap_NeedForGapsInfoNR;
static int ett_f1ap_NeedForGapNCSGInfoNR;
static int ett_f1ap_NeedForGapNCSGInfoEUTRA;
static int ett_f1ap_MBS_Broadcast_NeighbourCellList;
static int ett_f1ap_mRB_PDCP_Config_Broadcast;
static int ett_f1ap_posMeasGapPreConfigToAddModList;
static int ett_f1ap_posMeasGapPreConfigToReleaseList;
static int ett_f1ap_SidelinkConfigurationContainer;
static int ett_f1ap_SRSPosRRCInactiveConfig;
static int ett_f1ap_successfulHOReportContainer;
static int ett_f1ap_UL_GapFR2_Config;
static int ett_f1ap_ConfigRestrictInfoDAPS;
static int ett_f1ap_UplinkTxDirectCurrentTwoCarrierListInfo;
static int ett_f1ap_Ncd_SSB_RedCapInitialBWP_SDT;
static int ett_f1ap_JointorDLTCIStateID;
static int ett_f1ap_ULTCIStateID;
static int ett_f1ap_ReferenceConfigurationInformation;
static int ett_f1ap_LTMCFRAResourceConfig;
static int ett_f1ap_location_Information;
static int ett_f1ap_velocity_Information;
static int ett_f1ap_successfulPSCellChangeReportContainer;
static int ett_f1ap_cSIResourceConfigToAddModList;
static int ett_f1ap_cSIResourceConfigToReleaseList;
static int ett_f1ap_mbs_NeighbourCellList;
static int ett_f1ap_mtch_NeighbourCellprovided;
static int ett_f1ap_thresholdMBSList;
static int ett_f1ap_mBSMulticastConfiguration;
static int ett_f1ap_MusimCandidateBandList;
static int ett_f1ap_NeedForInterruptionInfoNR;
static int ett_f1ap_RACHConfiguration;
static int ett_f1ap_SRSPosRRCInactiveValidityAreaConfig;
static int ett_f1ap_TCIStatesConfigurationsList;
static int ett_f1ap_PrivateIE_ID;
static int ett_f1ap_ProtocolIE_Container;
static int ett_f1ap_ProtocolIE_Field;
static int ett_f1ap_ProtocolExtensionContainer;
static int ett_f1ap_ProtocolExtensionField;
static int ett_f1ap_PrivateIE_Container;
static int ett_f1ap_PrivateIE_Field;
static int ett_f1ap_AbortTransmission;
static int ett_f1ap_AccessPointPosition;
static int ett_f1ap_Activated_Cells_Mapping_List_Item;
static int ett_f1ap_Activated_Cells_to_be_Updated_List;
static int ett_f1ap_Activated_Cells_to_be_Updated_List_Item;
static int ett_f1ap_ActiveULBWP;
static int ett_f1ap_AdditionalPath_List;
static int ett_f1ap_AdditionalPath_Item;
static int ett_f1ap_ExtendedAdditionalPathList;
static int ett_f1ap_ExtendedAdditionalPathList_Item;
static int ett_f1ap_AdditionalPDCPDuplicationTNL_List;
static int ett_f1ap_AdditionalPDCPDuplicationTNL_Item;
static int ett_f1ap_AdditionalSIBMessageList;
static int ett_f1ap_AdditionalSIBMessageList_Item;
static int ett_f1ap_AffectedCellsAndBeams_List;
static int ett_f1ap_AffectedCellsAndBeams_Item;
static int ett_f1ap_AffectedSSB_List;
static int ett_f1ap_AffectedSSB_Item;
static int ett_f1ap_AggregatedPosSRSResourceIDList;
static int ett_f1ap_Aggregated_PosSRS_Resource_ID_Item;
static int ett_f1ap_AggregatedPosSRSResourceSetList;
static int ett_f1ap_AggregatedPosSRSResourceSet_Item;
static int ett_f1ap_Combined_PosSRSResourceSet_List;
static int ett_f1ap_Combined_PosSRSResourceSet_Item;
static int ett_f1ap_AggregatedPRSResourceSetList;
static int ett_f1ap_AggregatedPRSResourceSet_Item;
static int ett_f1ap_DL_PRS_ResourceSet_List;
static int ett_f1ap_DL_PRS_ResourceSet_Item;
static int ett_f1ap_AggressorCellList;
static int ett_f1ap_AggressorCellList_Item;
static int ett_f1ap_AggressorgNBSetID;
static int ett_f1ap_AllocationAndRetentionPriority;
static int ett_f1ap_AlternativeQoSParaSetList;
static int ett_f1ap_AlternativeQoSParaSetItem;
static int ett_f1ap_AngleMeasurementQuality;
static int ett_f1ap_AperiodicSRSResourceTriggerList;
static int ett_f1ap_Associated_SCell_Item;
static int ett_f1ap_AvailablePLMNList;
static int ett_f1ap_AvailablePLMNList_Item;
static int ett_f1ap_AvailableSNPN_ID_List;
static int ett_f1ap_AvailableSNPN_ID_List_Item;
static int ett_f1ap_AoA_AssistanceInfo;
static int ett_f1ap_AngleMeasurementType;
static int ett_f1ap_ARPLocationInformation;
static int ett_f1ap_ARPLocationInformation_Item;
static int ett_f1ap_ARPLocationType;
static int ett_f1ap_BAP_Header_Rewriting_Added_List_Item;
static int ett_f1ap_BAP_Header_Rewriting_Removed_List_Item;
static int ett_f1ap_BandwidthSRS;
static int ett_f1ap_BAPlayerBHRLCchannelMappingInfo;
static int ett_f1ap_BAPlayerBHRLCchannelMappingInfoList;
static int ett_f1ap_BAPlayerBHRLCchannelMappingInfo_Item;
static int ett_f1ap_BAPRoutingID;
static int ett_f1ap_BCBearerContextF1U_TNLInfo;
static int ett_f1ap_BHChannels_FailedToBeModified_Item;
static int ett_f1ap_BHChannels_FailedToBeSetup_Item;
static int ett_f1ap_BHChannels_FailedToBeSetupMod_Item;
static int ett_f1ap_BHChannels_Modified_Item;
static int ett_f1ap_BHChannels_Required_ToBeReleased_Item;
static int ett_f1ap_BHChannels_Setup_Item;
static int ett_f1ap_BHChannels_SetupMod_Item;
static int ett_f1ap_BHChannels_ToBeModified_Item;
static int ett_f1ap_BHChannels_ToBeReleased_Item;
static int ett_f1ap_BHChannels_ToBeSetup_Item;
static int ett_f1ap_BHChannels_ToBeSetupMod_Item;
static int ett_f1ap_BHInfo;
static int ett_f1ap_BHQoSInformation;
static int ett_f1ap_BHRLCCHList;
static int ett_f1ap_BHRLCCHItem;
static int ett_f1ap_BH_Routing_Information_Added_List_Item;
static int ett_f1ap_BH_Routing_Information_Removed_List_Item;
static int ett_f1ap_BPLMN_ID_Info_List;
static int ett_f1ap_BPLMN_ID_Info_Item;
static int ett_f1ap_ServedPLMNs_List;
static int ett_f1ap_ServedPLMNs_Item;
static int ett_f1ap_BroadcastCAGList;
static int ett_f1ap_BroadcastMRBs_FailedToBeModified_Item;
static int ett_f1ap_BroadcastMRBs_FailedToBeSetup_Item;
static int ett_f1ap_BroadcastMRBs_FailedToBeSetupMod_Item;
static int ett_f1ap_BroadcastMRBs_Modified_Item;
static int ett_f1ap_BroadcastMRBs_Setup_Item;
static int ett_f1ap_BroadcastMRBs_SetupMod_Item;
static int ett_f1ap_BroadcastMRBs_ToBeModified_Item;
static int ett_f1ap_BroadcastMRBs_ToBeReleased_Item;
static int ett_f1ap_BroadcastMRBs_ToBeSetup_Item;
static int ett_f1ap_BroadcastMRBs_ToBeSetupMod_Item;
static int ett_f1ap_BroadcastNIDList;
static int ett_f1ap_BroadcastSNPN_ID_List;
static int ett_f1ap_BroadcastSNPN_ID_List_Item;
static int ett_f1ap_BroadcastPNI_NPN_ID_List;
static int ett_f1ap_BroadcastPNI_NPN_ID_List_Item;
static int ett_f1ap_BroadcastAreaScope;
static int ett_f1ap_BroadcastCellList;
static int ett_f1ap_Broadcast_Cell_List_Item;
static int ett_f1ap_BurstArrivalTimeWindow;
static int ett_f1ap_Broadcast_MRBs_Transport_Request_Item;
static int ett_f1ap_Candidate_SpCell_Item;
static int ett_f1ap_CandidateCellwithBeamInfo;
static int ett_f1ap_CandidateCellwithBeamInfoList;
static int ett_f1ap_CandidateCellwithBeamInfo_Item;
static int ett_f1ap_CandidateCellwithMeasurementsList;
static int ett_f1ap_CandidateCellwithMeasurements_Item;
static int ett_f1ap_CapacityValue;
static int ett_f1ap_Cause;
static int ett_f1ap_CellMeasurementResultList;
static int ett_f1ap_CellMeasurementResultItem;
static int ett_f1ap_CellsForSON_List;
static int ett_f1ap_CellsForSON_Item;
static int ett_f1ap_Cells_Failed_to_be_Activated_List_Item;
static int ett_f1ap_Cells_Status_Item;
static int ett_f1ap_Cells_To_Be_Broadcast_Item;
static int ett_f1ap_Cells_Broadcast_Completed_Item;
static int ett_f1ap_Broadcast_To_Be_Cancelled_Item;
static int ett_f1ap_Cells_Broadcast_Cancelled_Item;
static int ett_f1ap_Cells_to_be_Activated_List_Item;
static int ett_f1ap_Cells_With_SSBs_Activated_List;
static int ett_f1ap_Cells_With_SSBs_Activated_List_Item;
static int ett_f1ap_Cells_Allowed_to_be_Deactivated_List_Item;
static int ett_f1ap_Cells_to_be_Deactivated_List_Item;
static int ett_f1ap_Cells_to_be_Barred_Item;
static int ett_f1ap_CellToReportList;
static int ett_f1ap_CellToReportItem;
static int ett_f1ap_CellType;
static int ett_f1ap_CG_SDTSessionInfo;
static int ett_f1ap_Child_IAB_Nodes_NA_Resource_List;
static int ett_f1ap_Child_IAB_Nodes_NA_Resource_List_Item;
static int ett_f1ap_Child_Node_Cells_List;
static int ett_f1ap_Child_Node_Cells_List_Item;
static int ett_f1ap_Child_Nodes_List;
static int ett_f1ap_Child_Nodes_List_Item;
static int ett_f1ap_CNUEPagingIdentity;
static int ett_f1ap_CompositeAvailableCapacityGroup;
static int ett_f1ap_CompositeAvailableCapacity;
static int ett_f1ap_ConditionalInterDUMobilityInformation;
static int ett_f1ap_ConditionalIntraDUMobilityInformation;
static int ett_f1ap_Configured_BWP_List;
static int ett_f1ap_Configured_BWP_Item;
static int ett_f1ap_Coverage_Modification_Notification;
static int ett_f1ap_Coverage_Modification_List;
static int ett_f1ap_Coverage_Modification_Item;
static int ett_f1ap_CCO_Assistance_Information;
static int ett_f1ap_CP_TransportLayerAddress;
static int ett_f1ap_CPACMCGInformation;
static int ett_f1ap_CriticalityDiagnostics;
static int ett_f1ap_CriticalityDiagnostics_IE_List;
static int ett_f1ap_CriticalityDiagnostics_IE_Item;
static int ett_f1ap_CUDURadioInformationType;
static int ett_f1ap_CUDURIMInformation;
static int ett_f1ap_CUtoDURRCInformation;
static int ett_f1ap_CUtoDUTAInformation_List;
static int ett_f1ap_CUtoDUTAInformation_Item;
static int ett_f1ap_CSIResourceConfiguration;
static int ett_f1ap_DeactivationIndication;
static int ett_f1ap_DeactivationIndicationList;
static int ett_f1ap_DeactivationIndicationList_Item;
static int ett_f1ap_Dedicated_SIDelivery_NeededUE_Item;
static int ett_f1ap_DL_PRS;
static int ett_f1ap_DL_PRSMutingPattern;
static int ett_f1ap_DLPRSResourceCoordinates;
static int ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP;
static int ett_f1ap_DLPRSResourceSetARP;
static int ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP;
static int ett_f1ap_DL_PRSResourceSetARPLocation;
static int ett_f1ap_DLPRSResourceARP;
static int ett_f1ap_DL_PRSResourceARPLocation;
static int ett_f1ap_DL_UP_TNL_Address_to_Update_List_Item;
static int ett_f1ap_DLUPTNLInformation_ToBeSetup_List;
static int ett_f1ap_DLUPTNLInformation_ToBeSetup_Item;
static int ett_f1ap_DRB_Activity_Item;
static int ett_f1ap_DRBs_FailedToBeModified_Item;
static int ett_f1ap_DRBs_FailedToBeSetup_Item;
static int ett_f1ap_DRBs_FailedToBeSetupMod_Item;
static int ett_f1ap_DRB_Information;
static int ett_f1ap_DRBs_Modified_Item;
static int ett_f1ap_DRBs_ModifiedConf_Item;
static int ett_f1ap_DRB_Notify_Item;
static int ett_f1ap_DRBs_Required_ToBeModified_Item;
static int ett_f1ap_DRBs_Required_ToBeReleased_Item;
static int ett_f1ap_DRBs_Setup_Item;
static int ett_f1ap_DRBs_SetupMod_Item;
static int ett_f1ap_DRBs_ToBeModified_Item;
static int ett_f1ap_DRBs_ToBeReleased_Item;
static int ett_f1ap_DRBs_ToBeSetup_Item;
static int ett_f1ap_DRBs_ToBeSetupMod_Item;
static int ett_f1ap_DRB_List;
static int ett_f1ap_DRB_List_Item;
static int ett_f1ap_DRXCycle;
static int ett_f1ap_NonIntegerDRXCycle;
static int ett_f1ap_DSInformationList;
static int ett_f1ap_DUCURadioInformationType;
static int ett_f1ap_DUCURIMInformation;
static int ett_f1ap_DUF_Slot_Config_Item;
static int ett_f1ap_DUF_Slot_Config_List;
static int ett_f1ap_DUtoCURRCInformation;
static int ett_f1ap_DUtoCUTAInformation_List;
static int ett_f1ap_DUtoCUTAInformation_Item;
static int ett_f1ap_Dynamic5QIDescriptor;
static int ett_f1ap_DynamicPQIDescriptor;
static int ett_f1ap_DLLBTFailureInformationList;
static int ett_f1ap_DLLBTFailureInformationList_Item;
static int ett_f1ap_EarlyULSyncConfig;
static int ett_f1ap_EarlySyncInformation_Request;
static int ett_f1ap_EarlySyncInformation;
static int ett_f1ap_EarlySyncCandidateCellInformation_List;
static int ett_f1ap_EarlySyncCandidateCellInformation_Item;
static int ett_f1ap_EarlySyncServingCellInformation;
static int ett_f1ap_E_CID_MeasurementQuantities;
static int ett_f1ap_E_CID_MeasurementQuantities_Item;
static int ett_f1ap_E_CID_MeasurementResult;
static int ett_f1ap_E_CID_MeasuredResults_List;
static int ett_f1ap_E_CID_MeasuredResults_Item;
static int ett_f1ap_E_CID_MeasuredResults_Value;
static int ett_f1ap_E_CID_MeasuredResultsAssociatedInfoList;
static int ett_f1ap_E_CID_MeasuredResultsAssociatedInfoItem;
static int ett_f1ap_EgressBHRLCCHList;
static int ett_f1ap_EgressBHRLCCHItem;
static int ett_f1ap_Endpoint_IP_address_and_port;
static int ett_f1ap_ExtendedAvailablePLMN_List;
static int ett_f1ap_ExtendedAvailablePLMN_Item;
static int ett_f1ap_ExplicitFormat;
static int ett_f1ap_ExtendedServedPLMNs_List;
static int ett_f1ap_ExtendedServedPLMNs_Item;
static int ett_f1ap_ExtendedSliceSupportList;
static int ett_f1ap_EUTRACells_List;
static int ett_f1ap_EUTRACells_List_item;
static int ett_f1ap_EUTRA_Coex_FDD_Info;
static int ett_f1ap_EUTRA_Coex_Mode_Info;
static int ett_f1ap_EUTRA_Coex_TDD_Info;
static int ett_f1ap_EUTRA_PRACH_Configuration;
static int ett_f1ap_EUTRA_SpecialSubframe_Info;
static int ett_f1ap_EUTRANQoS;
static int ett_f1ap_EUTRA_Mode_Info;
static int ett_f1ap_EUTRA_FDD_Info;
static int ett_f1ap_EUTRA_TDD_Info;
static int ett_f1ap_Expected_UL_AoA;
static int ett_f1ap_Expected_ZoA_only;
static int ett_f1ap_Expected_Azimuth_AoA;
static int ett_f1ap_Expected_Zenith_AoA;
static int ett_f1ap_ECNMarkingorCongestionInformationReportingRequest;
static int ett_f1ap_F1CTransferPath;
static int ett_f1ap_F1CTransferPathNRDC;
static int ett_f1ap_FDD_Info;
static int ett_f1ap_FDD_InfoRel16;
static int ett_f1ap_FiveG_ProSeAuthorized;
static int ett_f1ap_Flows_Mapped_To_DRB_List;
static int ett_f1ap_Flows_Mapped_To_DRB_Item;
static int ett_f1ap_FreqBandNrItem;
static int ett_f1ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem;
static int ett_f1ap_FreqDomainLength;
static int ett_f1ap_FreqInfoRel16;
static int ett_f1ap_Frequency_Domain_HSNA_Configuration_List;
static int ett_f1ap_Frequency_Domain_HSNA_Configuration_Item;
static int ett_f1ap_Frequency_Domain_HSNA_Slot_Configuration_List;
static int ett_f1ap_Frequency_Domain_HSNA_Slot_Configuration_Item;
static int ett_f1ap_FlowsMappedToSLDRB_List;
static int ett_f1ap_FlowsMappedToSLDRB_Item;
static int ett_f1ap_GBR_QosInformation;
static int ett_f1ap_GBR_QoSFlowInformation;
static int ett_f1ap_GeographicalCoordinates;
static int ett_f1ap_GlobalGNB_ID;
static int ett_f1ap_GNB_ID;
static int ett_f1ap_GNB_CUSystemInformation;
static int ett_f1ap_SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem;
static int ett_f1ap_GNB_CU_TNL_Association_Setup_Item;
static int ett_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item;
static int ett_f1ap_GNB_CU_TNL_Association_To_Add_Item;
static int ett_f1ap_GNB_CU_TNL_Association_To_Remove_Item;
static int ett_f1ap_GNB_CU_TNL_Association_To_Update_Item;
static int ett_f1ap_GNB_DU_Cell_Resource_Configuration;
static int ett_f1ap_Extended_GNB_CU_Name;
static int ett_f1ap_Extended_GNB_DU_Name;
static int ett_f1ap_GNB_DU_Served_Cells_Item;
static int ett_f1ap_GNB_DU_System_Information;
static int ett_f1ap_GNB_DU_TNL_Association_To_Remove_Item;
static int ett_f1ap_GNBDUUESliceMaximumBitRateList;
static int ett_f1ap_GNBDUUESliceMaximumBitRateItem;
static int ett_f1ap_GNB_RxTxTimeDiff;
static int ett_f1ap_GNBRxTxTimeDiffMeas;
static int ett_f1ap_GTPTLAs;
static int ett_f1ap_GTPTLA_Item;
static int ett_f1ap_GTPTunnel;
static int ett_f1ap_HardwareLoadIndicator;
static int ett_f1ap_HSNASlotConfigList;
static int ett_f1ap_HSNASlotConfigItem;
static int ett_f1ap_IABCongestionIndication;
static int ett_f1ap_IAB_Congestion_Indication_List;
static int ett_f1ap_IAB_Congestion_Indication_Item;
static int ett_f1ap_IAB_Info_IAB_donor_CU;
static int ett_f1ap_IAB_Info_IAB_DU;
static int ett_f1ap_IAB_MT_Cell_List;
static int ett_f1ap_IAB_MT_Cell_List_Item;
static int ett_f1ap_IAB_MT_Cell_NA_Resource_Configuration_Mode_Info;
static int ett_f1ap_IAB_MT_Cell_NA_Resource_Configuration_FDD_Info;
static int ett_f1ap_IAB_MT_Cell_NA_Resource_Configuration_TDD_Info;
static int ett_f1ap_IAB_STC_Info;
static int ett_f1ap_IAB_STC_Info_List;
static int ett_f1ap_IAB_STC_Info_Item;
static int ett_f1ap_IAB_Allocated_TNL_Address_Item;
static int ett_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info;
static int ett_f1ap_IAB_DU_Cell_Resource_Configuration_FDD_Info;
static int ett_f1ap_IAB_DU_Cell_Resource_Configuration_TDD_Info;
static int ett_f1ap_IABIPv6RequestType;
static int ett_f1ap_IABTNLAddress;
static int ett_f1ap_IABTNLAddressesRequested;
static int ett_f1ap_IAB_TNL_Addresses_To_Remove_Item;
static int ett_f1ap_IAB_TNL_Addresses_Exception;
static int ett_f1ap_IABTNLAddressList;
static int ett_f1ap_IABTNLAddress_Item;
static int ett_f1ap_IABv4AddressesRequested;
static int ett_f1ap_Mobile_IAB_MTUserLocationInformation;
static int ett_f1ap_ImplicitFormat;
static int ett_f1ap_IndirectPathAddition;
static int ett_f1ap_IntendedTDD_DL_ULConfig;
static int ett_f1ap_LTMResetInformation;
static int ett_f1ap_LTML2ResetConfigurationList;
static int ett_f1ap_LTML2ResetConfiguration_Item;
static int ett_f1ap_IPHeaderInformation;
static int ett_f1ap_IPtolayer2TrafficMappingInfo;
static int ett_f1ap_IPtolayer2TrafficMappingInfoList;
static int ett_f1ap_IPtolayer2TrafficMappingInfo_Item;
static int ett_f1ap_LTEA2XServicesAuthorized;
static int ett_f1ap_L139Info;
static int ett_f1ap_L839Info;
static int ett_f1ap_L571Info;
static int ett_f1ap_L1151Info;
static int ett_f1ap_LCS_to_GCS_Translation;
static int ett_f1ap_LCStoGCSTranslationList;
static int ett_f1ap_LCStoGCSTranslation;
static int ett_f1ap_LocationDependentMBSF1UInformation;
static int ett_f1ap_LocationDependentMBSF1UInformation_Item;
static int ett_f1ap_LocationUncertainty;
static int ett_f1ap_LoS_NLoSInformation;
static int ett_f1ap_LTEUESidelinkAggregateMaximumBitrate;
static int ett_f1ap_LTEV2XServicesAuthorized;
static int ett_f1ap_LTMCells_ToBeReleased_List;
static int ett_f1ap_LTMCells_ToBeReleased_Item;
static int ett_f1ap_LTMInformation_Setup;
static int ett_f1ap_LTMConfigurationIDMappingList;
static int ett_f1ap_LTMConfigurationIDMapping_Item;
static int ett_f1ap_LTMInformation_Modify;
static int ett_f1ap_LTMConfiguration;
static int ett_f1ap_LTMCellSwitchInformation;
static int ett_f1ap_LTMgNB_DU_IDsList;
static int ett_f1ap_LTMgNB_DU_IDs_Item;
static int ett_f1ap_LTMgNB_DU_IDs_PreambleIndexList;
static int ett_f1ap_LTMgNB_DU_IDs_PreambleIndex_Item;
static int ett_f1ap_LTMCFRAResourceConfig_List;
static int ett_f1ap_LTMCFRAResourceConfig_Item;
static int ett_f1ap_MappingInformationtoRemove;
static int ett_f1ap_MBS_Flows_Mapped_To_MRB_List;
static int ett_f1ap_MBS_Flows_Mapped_To_MRB_Item;
static int ett_f1ap_MBSF1UInformation;
static int ett_f1ap_MBS_Session_ID;
static int ett_f1ap_MBS_CUtoDURRCInformation;
static int ett_f1ap_MBS_Broadcast_Cell_List;
static int ett_f1ap_MBS_Broadcast_Cell_Item;
static int ett_f1ap_MBS_Broadcast_MRB_List;
static int ett_f1ap_MBS_Broadcast_MRB_Item;
static int ett_f1ap_MBSMulticastF1UContextDescriptor;
static int ett_f1ap_MT_SDT_Information;
static int ett_f1ap_MulticastCU2DURRCInfo;
static int ett_f1ap_MBS_Multicast_CU2DU_Cell_List;
static int ett_f1ap_MBS_Multicast_CU2DU_Cell_Item;
static int ett_f1ap_MBS_Multicast_MRB_List;
static int ett_f1ap_MBS_Multicast_MRB_Item;
static int ett_f1ap_MulticastCU2DUCommonRRCInfo;
static int ett_f1ap_MulticastCommonCU2DUCellList;
static int ett_f1ap_MulticastCommonCU2DUCell_Item;
static int ett_f1ap_MulticastCommonCu2DUCellInformation;
static int ett_f1ap_MBSMulticastNeighbourCellListItem;
static int ett_f1ap_ThresholdMBS_ListItem;
static int ett_f1ap_UpdateMBSMulticastNeighbourCellListInformation;
static int ett_f1ap_MTCH_NeighbourCellSessionList;
static int ett_f1ap_MTCH_NeighbourCellSession_Item;
static int ett_f1ap_MTCH_NeighbourCellInformation;
static int ett_f1ap_UpdateThresholdMBS_ListInformation;
static int ett_f1ap_ThresholdIndexSessionList;
static int ett_f1ap_ThresholdIndexSession_Item;
static int ett_f1ap_ThresholdIndexInformation;
static int ett_f1ap_MulticastDU2CURRCInfo;
static int ett_f1ap_MBS_Multicast_DU2CU_Cell_List;
static int ett_f1ap_MBS_Multicast_DU2CU_Cell_Item;
static int ett_f1ap_MBSMulticastConfigurationResponseInfo;
static int ett_f1ap_MBSMulticastConfiguration_available;
static int ett_f1ap_MBSMulticastConfiguration_notavailable;
static int ett_f1ap_MBSMulticastConfigurationNotification;
static int ett_f1ap_MBSMulticastConfigurationNotificationInfo;
static int ett_f1ap_MulticastF1UContext_ToBeSetup_Item;
static int ett_f1ap_MulticastF1UContext_Setup_Item;
static int ett_f1ap_MulticastF1UContext_FailedToBeSetup_Item;
static int ett_f1ap_MBS_ServiceArea;
static int ett_f1ap_MBS_ServiceAreaInformation;
static int ett_f1ap_MBS_ServiceAreaCellList;
static int ett_f1ap_MBS_ServiceAreaTAIList;
static int ett_f1ap_MBS_ServiceAreaTAIList_Item;
static int ett_f1ap_MBS_ServiceAreaInformationList;
static int ett_f1ap_MBS_ServiceAreaInformationItem;
static int ett_f1ap_MC_PagingCell_Item;
static int ett_f1ap_MeasurementBeamInfo;
static int ett_f1ap_MRB_ProgressInformation;
static int ett_f1ap_MultipleULAoA;
static int ett_f1ap_MultipleULAoA_List;
static int ett_f1ap_MultipleULAoA_Item;
static int ett_f1ap_MulticastMBSSessionList;
static int ett_f1ap_MulticastMBSSessionList_Item;
static int ett_f1ap_MulticastMRBs_FailedToBeModified_Item;
static int ett_f1ap_MulticastMRBs_FailedToBeSetup_Item;
static int ett_f1ap_MulticastMRBs_FailedToBeSetupMod_Item;
static int ett_f1ap_MulticastMRBs_Modified_Item;
static int ett_f1ap_MulticastMRBs_Setup_Item;
static int ett_f1ap_MulticastMRBs_SetupMod_Item;
static int ett_f1ap_MulticastMRBs_ToBeModified_Item;
static int ett_f1ap_MulticastMRBs_ToBeReleased_Item;
static int ett_f1ap_MulticastMRBs_ToBeSetup_Item;
static int ett_f1ap_MulticastMRBs_ToBeSetupMod_Item;
static int ett_f1ap_MultiplexingInfo;
static int ett_f1ap_M5Configuration;
static int ett_f1ap_M6Configuration;
static int ett_f1ap_M7Configuration;
static int ett_f1ap_MDTConfiguration;
static int ett_f1ap_MDTPLMNList;
static int ett_f1ap_MDTPLMNModificationList;
static int ett_f1ap_MeasuredResultsValue;
static int ett_f1ap_Mobile_TRP_LocationInformation;
static int ett_f1ap_MobilityInitiation;
static int ett_f1ap_MobilityTrigger;
static int ett_f1ap_MobilityInitiation_CellSwitchInfo;
static int ett_f1ap_MobilityInitiation_EarlyULSyncInfo;
static int ett_f1ap_MobilityInitiation_EarlyDLSyncInfo;
static int ett_f1ap_MobilityInitiation_AssistanceInfo;
static int ett_f1ap_NRA2XServicesAuthorized;
static int ett_f1ap_N3CIndirectPathAddition;
static int ett_f1ap_NA_Resource_Configuration_List;
static int ett_f1ap_NA_Resource_Configuration_Item;
static int ett_f1ap_NCGI_to_be_Updated_List_Item;
static int ett_f1ap_Neighbour_Node_Cells_List;
static int ett_f1ap_Neighbour_Node_Cells_List_Item;
static int ett_f1ap_Neighbour_Cell_Information_Item;
static int ett_f1ap_NeighbourNR_CellsForSON_List;
static int ett_f1ap_NeighbourNR_CellsForSON_Item;
static int ett_f1ap_NGRANAllocationAndRetentionPriority;
static int ett_f1ap_NGRANHighAccuracyAccessPointPosition;
static int ett_f1ap_NR_CGI_List_For_Restart_Item;
static int ett_f1ap_NR_PRSBeamInformation;
static int ett_f1ap_NR_PRSBeamInformationList;
static int ett_f1ap_NR_PRSBeamInformationItem;
static int ett_f1ap_NRPagingeDRXInformation;
static int ett_f1ap_NRPagingeDRXInformationforRRCINACTIVE;
static int ett_f1ap_NRPaginglongeDRXInformationforRRCINACTIVE;
static int ett_f1ap_NonDynamic5QIDescriptor;
static int ett_f1ap_NonDynamicPQIDescriptor;
static int ett_f1ap_NotificationInformation;
static int ett_f1ap_NPNBroadcastInformation;
static int ett_f1ap_NPN_Broadcast_Information_SNPN;
static int ett_f1ap_NPN_Broadcast_Information_PNI_NPN;
static int ett_f1ap_NPNSupportInfo;
static int ett_f1ap_NRCarrierList;
static int ett_f1ap_NRCarrierItem;
static int ett_f1ap_NRFreqInfo;
static int ett_f1ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem;
static int ett_f1ap_NRCGI;
static int ett_f1ap_NR_Mode_Info;
static int ett_f1ap_NR_ModeInfoRel16;
static int ett_f1ap_NRPRACHConfig;
static int ett_f1ap_NRPRACHConfigList;
static int ett_f1ap_NRPRACHConfigItem;
static int ett_f1ap_NR_U_Channel_Info_List;
static int ett_f1ap_NR_U_Channel_Info_Item;
static int ett_f1ap_NR_U_Channel_List;
static int ett_f1ap_NR_U_Channel_Item;
static int ett_f1ap_NumDLULSymbols;
static int ett_f1ap_NRV2XServicesAuthorized;
static int ett_f1ap_NRUESidelinkAggregateMaximumBitrate;
static int ett_f1ap_N6JitterInformation;
static int ett_f1ap_OnDemandPRS_Info;
static int ett_f1ap_PacketErrorRate;
static int ett_f1ap_PathAdditionInformation;
static int ett_f1ap_PagingCell_Item;
static int ett_f1ap_Recommended_SSBs_List;
static int ett_f1ap_RecommendedSSBItem_List_Item;
static int ett_f1ap_PagingIdentity;
static int ett_f1ap_PEIPSAssistanceInfo;
static int ett_f1ap_RelativePathDelay;
static int ett_f1ap_Parent_IAB_Nodes_NA_Resource_Configuration_List;
static int ett_f1ap_Parent_IAB_Nodes_NA_Resource_Configuration_Item;
static int ett_f1ap_PartialSuccessCell;
static int ett_f1ap_PathlossReferenceInfo;
static int ett_f1ap_PathlossReferenceSignal;
static int ett_f1ap_PathSwitchConfiguration;
static int ett_f1ap_PC5_QoS_Characteristics;
static int ett_f1ap_PC5QoSParameters;
static int ett_f1ap_PC5FlowBitRates;
static int ett_f1ap_PC5RLCChannelQoSInformation;
static int ett_f1ap_PC5RLCChannelToBeSetupList;
static int ett_f1ap_PC5RLCChannelToBeSetupItem;
static int ett_f1ap_PC5RLCChannelToBeModifiedList;
static int ett_f1ap_PC5RLCChannelToBeModifiedItem;
static int ett_f1ap_PC5RLCChannelToBeReleasedList;
static int ett_f1ap_PC5RLCChannelToBeReleasedItem;
static int ett_f1ap_PC5RLCChannelSetupList;
static int ett_f1ap_PC5RLCChannelSetupItem;
static int ett_f1ap_PC5RLCChannelFailedToBeSetupList;
static int ett_f1ap_PC5RLCChannelFailedToBeSetupItem;
static int ett_f1ap_PC5RLCChannelModifiedList;
static int ett_f1ap_PC5RLCChannelModifiedItem;
static int ett_f1ap_PC5RLCChannelFailedToBeModifiedList;
static int ett_f1ap_PC5RLCChannelFailedToBeModifiedItem;
static int ett_f1ap_PC5RLCChannelRequiredToBeModifiedList;
static int ett_f1ap_PC5RLCChannelRequiredToBeModifiedItem;
static int ett_f1ap_PC5RLCChannelRequiredToBeReleasedList;
static int ett_f1ap_PC5RLCChannelRequiredToBeReleasedItem;
static int ett_f1ap_PDCMeasurementQuantities;
static int ett_f1ap_PDCMeasurementQuantities_Item;
static int ett_f1ap_PDCMeasurementResult;
static int ett_f1ap_PDCMeasuredResultsList;
static int ett_f1ap_PDCMeasuredResults_Item;
static int ett_f1ap_PDCMeasuredResults_Value;
static int ett_f1ap_PeriodicityList;
static int ett_f1ap_PeriodicityList_Item;
static int ett_f1ap_PeriodicityBound;
static int ett_f1ap_AllowedPeriodicityList;
static int ett_f1ap_PeriodicityRange;
static int ett_f1ap_PositioningBroadcastCells;
static int ett_f1ap_PosMeasGapPreConfigList;
static int ett_f1ap_PosMeasurementQuantities;
static int ett_f1ap_PosMeasurementQuantities_Item;
static int ett_f1ap_PosMeasurementResult;
static int ett_f1ap_PosMeasurementResultItem;
static int ett_f1ap_PosMeasurementResultList;
static int ett_f1ap_PosMeasurementResultList_Item;
static int ett_f1ap_PosResourceSetType;
static int ett_f1ap_PosResourceSetTypePR;
static int ett_f1ap_PosResourceSetTypeSP;
static int ett_f1ap_PosResourceSetTypeAP;
static int ett_f1ap_PosSItypeList;
static int ett_f1ap_PosSItype_Item;
static int ett_f1ap_PosSRSResourceID_List;
static int ett_f1ap_PosSRSResource_Item;
static int ett_f1ap_PosSRSResource_List;
static int ett_f1ap_PosSRSResourceSet_Item;
static int ett_f1ap_PosValidityAreaCellList;
static int ett_f1ap_PosValidityAreaCellList_Item;
static int ett_f1ap_PosSRSResourceSet_List;
static int ett_f1ap_PreambleIndexList;
static int ett_f1ap_PreambleIndexList_Item;
static int ett_f1ap_Protected_EUTRA_Resources_Item;
static int ett_f1ap_PRSConfiguration;
static int ett_f1ap_PRSInformationPos;
static int ett_f1ap_PRS_Measurement_Info_List;
static int ett_f1ap_PRS_Measurement_Info_List_Item;
static int ett_f1ap_Potential_SpCell_Item;
static int ett_f1ap_PRSAngleList;
static int ett_f1ap_PRSAngleItem;
static int ett_f1ap_PRSMuting;
static int ett_f1ap_PRSMutingOption1;
static int ett_f1ap_PRSMutingOption2;
static int ett_f1ap_PRSResource_List;
static int ett_f1ap_PRSResource_Item;
static int ett_f1ap_PRSBWAggregationRequestInfoList;
static int ett_f1ap_PRSBWAggregationRequestInfo_Item;
static int ett_f1ap_DL_PRSBWAggregationRequestInfo_List;
static int ett_f1ap_DL_PRSBWAggregationRequestInfo_Item;
static int ett_f1ap_PRSResource_QCLInfo;
static int ett_f1ap_PRSResource_QCLSourceSSB;
static int ett_f1ap_PRSResource_QCLSourcePRS;
static int ett_f1ap_PRSResourceSet_List;
static int ett_f1ap_PRSResourceSet_Item;
static int ett_f1ap_PRSTransmissionOffIndication;
static int ett_f1ap_PRSTransmissionOffPerResource;
static int ett_f1ap_PRSTransmissionOffPerResource_Item;
static int ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRSresources_OF_PRSTransmissionOffIndicationPerResource_Item;
static int ett_f1ap_PRSTransmissionOffIndicationPerResource_Item;
static int ett_f1ap_PRSTransmissionOffInformation;
static int ett_f1ap_PRSTransmissionOffPerResourceSet;
static int ett_f1ap_PRSTransmissionOffPerResourceSet_Item;
static int ett_f1ap_PWS_Failed_NR_CGI_Item;
static int ett_f1ap_PWSSystemInformation;
static int ett_f1ap_PRSTRPList;
static int ett_f1ap_PRSTRPItem;
static int ett_f1ap_RequestedDLPRSTransmissionCharacteristics;
static int ett_f1ap_RequestedDLPRSResourceSet_List;
static int ett_f1ap_RequestedDLPRSResourceSet_Item;
static int ett_f1ap_RequestedDLPRSResource_List;
static int ett_f1ap_RequestedDLPRSResource_Item;
static int ett_f1ap_PRSTransmissionTRPList;
static int ett_f1ap_PRSTransmissionTRPItem;
static int ett_f1ap_PDUSetQoSParameters;
static int ett_f1ap_PDUSetQoSInformation;
static int ett_f1ap_PSCellList;
static int ett_f1ap_PSCellList_Item;
static int ett_f1ap_QoEInformation;
static int ett_f1ap_QoEInformationList;
static int ett_f1ap_QoEInformationList_Item;
static int ett_f1ap_QoEMetrics;
static int ett_f1ap_QoS_Characteristics;
static int ett_f1ap_QoSFlowLevelQoSParameters;
static int ett_f1ap_QoSInformation;
static int ett_f1ap_RAReportList;
static int ett_f1ap_RAReportItem;
static int ett_f1ap_RAReportIndicationList;
static int ett_f1ap_RAReportIndicationList_Item;
static int ett_f1ap_RadioResourceStatus;
static int ett_f1ap_RadioResourceStatusNR_U;
static int ett_f1ap_MIMOPRBusageInformation;
static int ett_f1ap_RANfeedbacktype;
static int ett_f1ap_RANfeedbacktype_proactive;
static int ett_f1ap_RANfeedbacktype_reactive;
static int ett_f1ap_RANTimingSynchronisationStatusInfo;
static int ett_f1ap_ClockAccuracy;
static int ett_f1ap_RANUEPagingIdentity;
static int ett_f1ap_RAT_FrequencyPriorityInformation;
static int ett_f1ap_RBSetConfiguration;
static int ett_f1ap_Recommended_SSBs_for_Paging_List;
static int ett_f1ap_Recommended_SSBs_for_Paging_List_Item;
static int ett_f1ap_ReferencePoint;
static int ett_f1ap_LocalOrigin;
static int ett_f1ap_ReferenceSignal;
static int ett_f1ap_ReferenceConfiguration;
static int ett_f1ap_RelativeCartesianLocation;
static int ett_f1ap_RelativeGeodeticLocation;
static int ett_f1ap_RequestedSRSPreconfigurationCharacteristics_List;
static int ett_f1ap_RequestedSRSPreconfigurationCharacteristics_Item;
static int ett_f1ap_RequestedSRSTransmissionCharacteristics;
static int ett_f1ap_ResourceCoordinationEUTRACellInfo;
static int ett_f1ap_ResourceCoordinationTransferInformation;
static int ett_f1ap_ResourceMapping;
static int ett_f1ap_ResourceSetType;
static int ett_f1ap_ResourceSetTypePeriodic;
static int ett_f1ap_ResourceSetTypeSemi_persistent;
static int ett_f1ap_ResourceSetTypeAperiodic;
static int ett_f1ap_ReportingRequestType;
static int ett_f1ap_ResourceType;
static int ett_f1ap_ResourceTypePeriodic;
static int ett_f1ap_ResourceTypeSemi_persistent;
static int ett_f1ap_ResourceTypeAperiodic;
static int ett_f1ap_ResourceTypePos;
static int ett_f1ap_ResourceTypePeriodicPos;
static int ett_f1ap_ResourceTypeSemi_persistentPos;
static int ett_f1ap_ResourceTypeAperiodicPos;
static int ett_f1ap_RLCDuplicationInformation;
static int ett_f1ap_RLCDuplicationStateList;
static int ett_f1ap_RLCDuplicationState_Item;
static int ett_f1ap_RLCFailureIndication;
static int ett_f1ap_RLC_Status;
static int ett_f1ap_RLFReportInformationList;
static int ett_f1ap_RLFReportInformationItem;
static int ett_f1ap_RRCDeliveryStatus;
static int ett_f1ap_RRC_Terminating_IAB_Donor_Related_Info;
static int ett_f1ap_RRC_Version;
static int ett_f1ap_ResponseTime;
static int ett_f1ap_SCell_FailedtoSetup_Item;
static int ett_f1ap_SCell_FailedtoSetupMod_Item;
static int ett_f1ap_SCell_ToBeRemoved_Item;
static int ett_f1ap_SCell_ToBeSetup_Item;
static int ett_f1ap_SCell_ToBeSetupMod_Item;
static int ett_f1ap_S_CPAC_Configuration;
static int ett_f1ap_SCS_SpecificCarrier;
static int ett_f1ap_SDTBearerConfigurationInfo;
static int ett_f1ap_SDTBearerConfig_List;
static int ett_f1ap_SDTBearerConfig_List_Item;
static int ett_f1ap_SDTBearerType;
static int ett_f1ap_SDTInformation;
static int ett_f1ap_Search_window_information;
static int ett_f1ap_ServingCellMO_List_Item;
static int ett_f1ap_ServingCellMO_encoded_in_CGC_List;
static int ett_f1ap_ServingCellMO_encoded_in_CGC_Item;
static int ett_f1ap_Served_Cell_Information;
static int ett_f1ap_Serving_Cells_List;
static int ett_f1ap_Serving_Cells_List_Item;
static int ett_f1ap_Supported_MBS_FSA_ID_List;
static int ett_f1ap_SFN_Offset;
static int ett_f1ap_Served_Cells_To_Add_Item;
static int ett_f1ap_Served_Cells_To_Delete_Item;
static int ett_f1ap_Served_Cells_To_Modify_Item;
static int ett_f1ap_Served_EUTRA_Cells_Information;
static int ett_f1ap_Service_Status;
static int ett_f1ap_SelectedMeasurementQuantities;
static int ett_f1ap_ServingCellMeasurements;
static int ett_f1ap_SSBIndexList;
static int ett_f1ap_SSBIndexList_Item;
static int ett_f1ap_SSBIndexwithMeasurementsList;
static int ett_f1ap_SSBIndexwithMeasurements_Item;
static int ett_f1ap_SItype_List;
static int ett_f1ap_SItype_Item;
static int ett_f1ap_SibtypetobeupdatedListItem;
static int ett_f1ap_SidelinkRelayConfiguration;
static int ett_f1ap_SLDRBInformation;
static int ett_f1ap_SLDRBs_FailedToBeModified_Item;
static int ett_f1ap_SLDRBs_FailedToBeSetup_Item;
static int ett_f1ap_SLDRBs_FailedToBeSetupMod_Item;
static int ett_f1ap_SLDRBs_Modified_Item;
static int ett_f1ap_SLDRBs_ModifiedConf_Item;
static int ett_f1ap_SLDRBs_Required_ToBeModified_Item;
static int ett_f1ap_SLDRBs_Required_ToBeReleased_Item;
static int ett_f1ap_SLDRBs_Setup_Item;
static int ett_f1ap_SLDRBs_SetupMod_Item;
static int ett_f1ap_SLDRBs_ToBeModified_Item;
static int ett_f1ap_SLDRBs_ToBeReleased_Item;
static int ett_f1ap_SLDRBs_ToBeSetup_Item;
static int ett_f1ap_SLDRBs_ToBeSetupMod_Item;
static int ett_f1ap_SLDRXCycleList;
static int ett_f1ap_SLDRXCycleItem;
static int ett_f1ap_SLDRXInformation;
static int ett_f1ap_SliceAvailableCapacity;
static int ett_f1ap_SliceAvailableCapacityList;
static int ett_f1ap_SliceAvailableCapacityItem;
static int ett_f1ap_SNSSAIAvailableCapacity_List;
static int ett_f1ap_SNSSAIAvailableCapacity_Item;
static int ett_f1ap_SliceRadioResourceStatus;
static int ett_f1ap_SliceRadioResourceStatus_List;
static int ett_f1ap_SliceRadioResourceStatus_Item;
static int ett_f1ap_SNSSAIRadioResourceStatus_List;
static int ett_f1ap_SNSSAIRadioResourceStatus_Item;
static int ett_f1ap_SliceSupportList;
static int ett_f1ap_SliceSupportItem;
static int ett_f1ap_SliceToReportList;
static int ett_f1ap_SliceToReportItem;
static int ett_f1ap_SLPositioning_Ranging_Service_Info;
static int ett_f1ap_RSPP_transport_QoS_parameters;
static int ett_f1ap_RSPPQoSFlowList;
static int ett_f1ap_RSPPQoSFlowItem;
static int ett_f1ap_RSPPFlowBitRates;
static int ett_f1ap_SNSSAI_list;
static int ett_f1ap_SNSSAI_Item;
static int ett_f1ap_Slot_Configuration_List;
static int ett_f1ap_Slot_Configuration_Item;
static int ett_f1ap_SlotOffsetForRemainingHopsList;
static int ett_f1ap_SlotOffsetForRemainingHopsItem;
static int ett_f1ap_SlotOffsetRemainingHops;
static int ett_f1ap_SlotOffsetRemainingHopsAperiodic;
static int ett_f1ap_SlotOffsetRemainingHopsSemiPersistent;
static int ett_f1ap_SlotOffsetRemainingHopsPeriodic;
static int ett_f1ap_SNSSAI;
static int ett_f1ap_SpatialDirectionInformation;
static int ett_f1ap_SpatialRelationInfo;
static int ett_f1ap_SpatialRelationforResourceID;
static int ett_f1ap_SpatialRelationforResourceIDItem;
static int ett_f1ap_SpatialRelationPerSRSResource;
static int ett_f1ap_SpatialRelationPerSRSResource_List;
static int ett_f1ap_SpatialRelationPerSRSResourceItem;
static int ett_f1ap_SpatialRelationPos;
static int ett_f1ap_SRBs_FailedToBeSetup_Item;
static int ett_f1ap_SRBs_FailedToBeSetupMod_Item;
static int ett_f1ap_SRBs_Modified_Item;
static int ett_f1ap_SRBs_Required_ToBeReleased_Item;
static int ett_f1ap_SRBs_Setup_Item;
static int ett_f1ap_SRBs_SetupMod_Item;
static int ett_f1ap_SRBs_ToBeReleased_Item;
static int ett_f1ap_SRBs_ToBeSetup_Item;
static int ett_f1ap_SRBs_ToBeSetupMod_Item;
static int ett_f1ap_SRSCarrier_List;
static int ett_f1ap_SRSCarrier_List_Item;
static int ett_f1ap_SRSConfig;
static int ett_f1ap_SRSConfiguration;
static int ett_f1ap_SRSPreconfiguration_List;
static int ett_f1ap_SRSPreconfiguration_Item;
static int ett_f1ap_SRSResource;
static int ett_f1ap_SRSResourceID_List;
static int ett_f1ap_SRSResource_List;
static int ett_f1ap_SRSResourceSet;
static int ett_f1ap_SRSResourceSetList;
static int ett_f1ap_SRSResourceSetItem;
static int ett_f1ap_SRSResourceSet_List;
static int ett_f1ap_SRSResourceTrigger;
static int ett_f1ap_SRSResourcetype;
static int ett_f1ap_SRSResourceTypeChoice;
static int ett_f1ap_SRSInfo;
static int ett_f1ap_PosSRSInfo;
static int ett_f1ap_SSB;
static int ett_f1ap_SSBCoverageModification_List;
static int ett_f1ap_SSBCoverageModification_Item;
static int ett_f1ap_SSB_transmissionBitmap;
static int ett_f1ap_SSBAreaCapacityValueList;
static int ett_f1ap_SSBAreaCapacityValueItem;
static int ett_f1ap_SSBAreaRadioResourceStatusList;
static int ett_f1ap_SSBAreaRadioResourceStatusItem;
static int ett_f1ap_SSBInformation;
static int ett_f1ap_SSBInformationList;
static int ett_f1ap_SSBInformationItem;
static int ett_f1ap_SSB_PositionsInBurst;
static int ett_f1ap_SSBs_activated_List;
static int ett_f1ap_SSBs_forPaging_List;
static int ett_f1ap_SSBs_toBeActivated_List;
static int ett_f1ap_SSB_TF_Configuration;
static int ett_f1ap_SSBToReportList;
static int ett_f1ap_SSBToReportItem;
static int ett_f1ap_StartRBIndex;
static int ett_f1ap_StartTimeAndDuration;
static int ett_f1ap_SUL_Information;
static int ett_f1ap_SuccessfulHOReportInformationList;
static int ett_f1ap_SuccessfulHOReportInformation_Item;
static int ett_f1ap_SuccessfulPSCellChangeReportInformationList;
static int ett_f1ap_SuccessfulPSCellChangeReportInformation_Item;
static int ett_f1ap_SupportedSULFreqBandItem;
static int ett_f1ap_SupportedUETypeList;
static int ett_f1ap_SupportedUETypeList_Item;
static int ett_f1ap_SymbolAllocInSlot;
static int ett_f1ap_TAI;
static int ett_f1ap_TargetCellList;
static int ett_f1ap_TargetCellList_Item;
static int ett_f1ap_NSAGSupportList;
static int ett_f1ap_NSAGSupportItem;
static int ett_f1ap_TDD_Info;
static int ett_f1ap_TDD_InfoRel16;
static int ett_f1ap_TRPTEGInformation;
static int ett_f1ap_RxTxTEG;
static int ett_f1ap_RxTEG;
static int ett_f1ap_TimeReferenceInformation;
static int ett_f1ap_TimeStamp;
static int ett_f1ap_TimeStampSlotIndex;
static int ett_f1ap_TimingMeasurementQuality;
static int ett_f1ap_TimeWindowStart;
static int ett_f1ap_TimeWindowInformation_Measurement_List;
static int ett_f1ap_TimeWindowInformation_Measurement_Item;
static int ett_f1ap_TimeWindowInformation_SRS_List;
static int ett_f1ap_TimeWindowInformation_SRS_Item;
static int ett_f1ap_TimeWindowDurationMeasurement;
static int ett_f1ap_TimeWindowDurationSRS;
static int ett_f1ap_TimeWindowStartSRS;
static int ett_f1ap_TNLCapacityIndicator;
static int ett_f1ap_TraceActivation;
static int ett_f1ap_TrafficMappingInfo;
static int ett_f1ap_Transmission_Bandwidth;
static int ett_f1ap_Transmission_Bandwidth_asymmetric;
static int ett_f1ap_TransmissionComb;
static int ett_f1ap_T_n2;
static int ett_f1ap_T_n4;
static int ett_f1ap_TransmissionCombn8;
static int ett_f1ap_TransmissionCombPos;
static int ett_f1ap_T_n2_01;
static int ett_f1ap_T_n4_01;
static int ett_f1ap_T_n8;
static int ett_f1ap_Transport_UP_Layer_Address_Info_To_Add_List;
static int ett_f1ap_Transport_UP_Layer_Address_Info_To_Add_Item;
static int ett_f1ap_Transport_UP_Layer_Address_Info_To_Remove_List;
static int ett_f1ap_Transport_UP_Layer_Address_Info_To_Remove_Item;
static int ett_f1ap_TRPBeamAntennaInformation;
static int ett_f1ap_Choice_TRP_Beam_Antenna_Info_Item;
static int ett_f1ap_TRP_BeamAntennaExplicitInformation;
static int ett_f1ap_TRP_BeamAntennaAngles;
static int ett_f1ap_TRP_BeamAntennaAnglesList_Item;
static int ett_f1ap_SEQUENCE_SIZE_1_maxnoElevationAngles_OF_TRP_ElevationAngleList_Item;
static int ett_f1ap_TRP_ElevationAngleList_Item;
static int ett_f1ap_SEQUENCE_SIZE_2_maxNumResourcesPerAngle_OF_TRP_Beam_Power_Item;
static int ett_f1ap_TRP_Beam_Power_Item;
static int ett_f1ap_TRPInformation;
static int ett_f1ap_TRPInformationItem;
static int ett_f1ap_TRPInformationTypeResponseList;
static int ett_f1ap_TRPInformationTypeResponseItem;
static int ett_f1ap_TRPList;
static int ett_f1ap_TRPListItem;
static int ett_f1ap_TRPMeasurementQuality;
static int ett_f1ap_TRPMeasurementQuality_Item;
static int ett_f1ap_PhaseQuality;
static int ett_f1ap_TRP_MeasurementRequestList;
static int ett_f1ap_TRP_MeasurementRequestItem;
static int ett_f1ap_TRP_PRS_Info_List;
static int ett_f1ap_TRP_PRS_Info_List_Item;
static int ett_f1ap_TRPPositionDefinitionType;
static int ett_f1ap_TRPPositionDirect;
static int ett_f1ap_TRPPositionDirectAccuracy;
static int ett_f1ap_TRPPositionReferenced;
static int ett_f1ap_TRPReferencePointType;
static int ett_f1ap_TRP_Rx_TEGInformation;
static int ett_f1ap_TRP_RxTx_TEGInformation;
static int ett_f1ap_TRP_Tx_TEGInformation;
static int ett_f1ap_TRPTxTEGAssociation;
static int ett_f1ap_TRPTEG_Item;
static int ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceID_Item;
static int ett_f1ap_DLPRSResourceID_Item;
static int ett_f1ap_Transport_Layer_Address_Info;
static int ett_f1ap_TSCAssistanceInformation;
static int ett_f1ap_TSCTrafficCharacteristics;
static int ett_f1ap_TSCTrafficCharacteristicsFeedback;
static int ett_f1ap_TSCFeedbackInformation;
static int ett_f1ap_TRP_MeasurementUpdateList;
static int ett_f1ap_TRP_MeasurementUpdateItem;
static int ett_f1ap_TxHoppingConfiguration;
static int ett_f1ap_TAInformation_List;
static int ett_f1ap_TAInformation_Item;
static int ett_f1ap_UAC_Assistance_Info;
static int ett_f1ap_UACPLMN_List;
static int ett_f1ap_UACPLMN_Item;
static int ett_f1ap_UACType_List;
static int ett_f1ap_UACType_Item;
static int ett_f1ap_UACCategoryType;
static int ett_f1ap_UACOperatorDefined;
static int ett_f1ap_UE_associatedLogicalF1_ConnectionItem;
static int ett_f1ap_UEIdentityIndexValue;
static int ett_f1ap_UEIdentity_List_For_Paging_Item;
static int ett_f1ap_UE_MulticastMRBs_ConfirmedToBeModified_Item;
static int ett_f1ap_UE_MulticastMRBs_RequiredToBeModified_Item;
static int ett_f1ap_UE_MulticastMRBs_RequiredToBeReleased_Item;
static int ett_f1ap_UE_MulticastMRBs_Setup_Item;
static int ett_f1ap_UE_MulticastMRBs_Setupnew_Item;
static int ett_f1ap_UE_MulticastMRBs_ToBeReleased_Item;
static int ett_f1ap_UE_MulticastMRBs_ToBeSetup_Item;
static int ett_f1ap_UE_MulticastMRBs_ToBeSetup_atModify_Item;
static int ett_f1ap_UEPagingCapability;
static int ett_f1ap_UEReportingInformation;
static int ett_f1ap_UL_AoA;
static int ett_f1ap_UL_BH_Non_UP_Traffic_Mapping;
static int ett_f1ap_UL_BH_Non_UP_Traffic_Mapping_List;
static int ett_f1ap_UL_BH_Non_UP_Traffic_Mapping_Item;
static int ett_f1ap_ULConfiguration;
static int ett_f1ap_UL_RTOA_Measurement;
static int ett_f1ap_UL_RTOA_MeasurementItem;
static int ett_f1ap_UL_SRS_RSRPP;
static int ett_f1ap_UL_RSCP;
static int ett_f1ap_UL_UP_TNL_Information_to_Update_List_Item;
static int ett_f1ap_UL_UP_TNL_Address_to_Update_List_Item;
static int ett_f1ap_ULUPTNLInformation_ToBeSetup_List;
static int ett_f1ap_ULUPTNLInformation_ToBeSetup_Item;
static int ett_f1ap_UplinkChannelBW_PerSCS_List;
static int ett_f1ap_UPTransportLayerInformation;
static int ett_f1ap_UuRLCChannelQoSInformation;
static int ett_f1ap_UuRLCChannelToBeSetupList;
static int ett_f1ap_UuRLCChannelToBeSetupItem;
static int ett_f1ap_UuRLCChannelToBeModifiedList;
static int ett_f1ap_UuRLCChannelToBeModifiedItem;
static int ett_f1ap_UuRLCChannelToBeReleasedList;
static int ett_f1ap_UuRLCChannelToBeReleasedItem;
static int ett_f1ap_UuRLCChannelSetupList;
static int ett_f1ap_UuRLCChannelSetupItem;
static int ett_f1ap_UuRLCChannelFailedToBeSetupList;
static int ett_f1ap_UuRLCChannelFailedToBeSetupItem;
static int ett_f1ap_UuRLCChannelModifiedList;
static int ett_f1ap_UuRLCChannelModifiedItem;
static int ett_f1ap_UuRLCChannelFailedToBeModifiedList;
static int ett_f1ap_UuRLCChannelFailedToBeModifiedItem;
static int ett_f1ap_UuRLCChannelRequiredToBeModifiedList;
static int ett_f1ap_UuRLCChannelRequiredToBeModifiedItem;
static int ett_f1ap_UuRLCChannelRequiredToBeReleasedList;
static int ett_f1ap_UuRLCChannelRequiredToBeReleasedItem;
static int ett_f1ap_VictimgNBSetID;
static int ett_f1ap_ValidityAreaSpecificSRSInformation;
static int ett_f1ap_ValidityAreaSpecificSRSInformationExtended;
static int ett_f1ap_ZoAInformation;
static int ett_f1ap_Reset;
static int ett_f1ap_ResetType;
static int ett_f1ap_UE_associatedLogicalF1_ConnectionListRes;
static int ett_f1ap_ResetAcknowledge;
static int ett_f1ap_UE_associatedLogicalF1_ConnectionListResAck;
static int ett_f1ap_ErrorIndication;
static int ett_f1ap_F1SetupRequest;
static int ett_f1ap_GNB_DU_Served_Cells_List;
static int ett_f1ap_F1SetupResponse;
static int ett_f1ap_Cells_to_be_Activated_List;
static int ett_f1ap_NCGI_to_be_Updated_List;
static int ett_f1ap_F1SetupFailure;
static int ett_f1ap_GNBDUConfigurationUpdate;
static int ett_f1ap_Served_Cells_To_Add_List;
static int ett_f1ap_Served_Cells_To_Modify_List;
static int ett_f1ap_Served_Cells_To_Delete_List;
static int ett_f1ap_Cells_Status_List;
static int ett_f1ap_Dedicated_SIDelivery_NeededUE_List;
static int ett_f1ap_GNB_DU_TNL_Association_To_Remove_List;
static int ett_f1ap_GNBDUConfigurationUpdateAcknowledge;
static int ett_f1ap_GNBDUConfigurationUpdateFailure;
static int ett_f1ap_GNBCUConfigurationUpdate;
static int ett_f1ap_Cells_to_be_Deactivated_List;
static int ett_f1ap_GNB_CU_TNL_Association_To_Add_List;
static int ett_f1ap_GNB_CU_TNL_Association_To_Remove_List;
static int ett_f1ap_GNB_CU_TNL_Association_To_Update_List;
static int ett_f1ap_Cells_to_be_Barred_List;
static int ett_f1ap_Cells_Allowed_to_be_Deactivated_List;
static int ett_f1ap_Protected_EUTRA_Resources_List;
static int ett_f1ap_Neighbour_Cell_Information_List;
static int ett_f1ap_GNBCUConfigurationUpdateAcknowledge;
static int ett_f1ap_Cells_Failed_to_be_Activated_List;
static int ett_f1ap_GNB_CU_TNL_Association_Setup_List;
static int ett_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_List;
static int ett_f1ap_GNBCUConfigurationUpdateFailure;
static int ett_f1ap_GNBDUResourceCoordinationRequest;
static int ett_f1ap_GNBDUResourceCoordinationResponse;
static int ett_f1ap_UEContextSetupRequest;
static int ett_f1ap_Candidate_SpCell_List;
static int ett_f1ap_SCell_ToBeSetup_List;
static int ett_f1ap_SRBs_ToBeSetup_List;
static int ett_f1ap_DRBs_ToBeSetup_List;
static int ett_f1ap_BHChannels_ToBeSetup_List;
static int ett_f1ap_SLDRBs_ToBeSetup_List;
static int ett_f1ap_UE_MulticastMRBs_ToBeSetup_List;
static int ett_f1ap_ServingCellMO_List;
static int ett_f1ap_UEContextSetupResponse;
static int ett_f1ap_DRBs_Setup_List;
static int ett_f1ap_SRBs_FailedToBeSetup_List;
static int ett_f1ap_DRBs_FailedToBeSetup_List;
static int ett_f1ap_SCell_FailedtoSetup_List;
static int ett_f1ap_SRBs_Setup_List;
static int ett_f1ap_BHChannels_Setup_List;
static int ett_f1ap_BHChannels_FailedToBeSetup_List;
static int ett_f1ap_SLDRBs_Setup_List;
static int ett_f1ap_SLDRBs_FailedToBeSetup_List;
static int ett_f1ap_UE_MulticastMRBs_Setupnew_List;
static int ett_f1ap_UEContextSetupFailure;
static int ett_f1ap_Potential_SpCell_List;
static int ett_f1ap_UEContextReleaseRequest;
static int ett_f1ap_UEContextReleaseCommand;
static int ett_f1ap_UEContextReleaseComplete;
static int ett_f1ap_UEContextModificationRequest;
static int ett_f1ap_SCell_ToBeSetupMod_List;
static int ett_f1ap_SCell_ToBeRemoved_List;
static int ett_f1ap_SRBs_ToBeSetupMod_List;
static int ett_f1ap_DRBs_ToBeSetupMod_List;
static int ett_f1ap_BHChannels_ToBeSetupMod_List;
static int ett_f1ap_DRBs_ToBeModified_List;
static int ett_f1ap_BHChannels_ToBeModified_List;
static int ett_f1ap_SRBs_ToBeReleased_List;
static int ett_f1ap_DRBs_ToBeReleased_List;
static int ett_f1ap_BHChannels_ToBeReleased_List;
static int ett_f1ap_UE_MulticastMRBs_ToBeSetup_atModify_List;
static int ett_f1ap_UE_MulticastMRBs_ToBeReleased_List;
static int ett_f1ap_SLDRBs_ToBeSetupMod_List;
static int ett_f1ap_SLDRBs_ToBeModified_List;
static int ett_f1ap_SLDRBs_ToBeReleased_List;
static int ett_f1ap_UEContextModificationResponse;
static int ett_f1ap_DRBs_SetupMod_List;
static int ett_f1ap_DRBs_Modified_List;
static int ett_f1ap_SRBs_SetupMod_List;
static int ett_f1ap_SRBs_Modified_List;
static int ett_f1ap_DRBs_FailedToBeModified_List;
static int ett_f1ap_SRBs_FailedToBeSetupMod_List;
static int ett_f1ap_DRBs_FailedToBeSetupMod_List;
static int ett_f1ap_SCell_FailedtoSetupMod_List;
static int ett_f1ap_BHChannels_SetupMod_List;
static int ett_f1ap_BHChannels_Modified_List;
static int ett_f1ap_BHChannels_FailedToBeModified_List;
static int ett_f1ap_BHChannels_FailedToBeSetupMod_List;
static int ett_f1ap_Associated_SCell_List;
static int ett_f1ap_SLDRBs_SetupMod_List;
static int ett_f1ap_SLDRBs_Modified_List;
static int ett_f1ap_SLDRBs_FailedToBeModified_List;
static int ett_f1ap_SLDRBs_FailedToBeSetupMod_List;
static int ett_f1ap_UE_MulticastMRBs_Setup_List;
static int ett_f1ap_UEContextModificationFailure;
static int ett_f1ap_UEContextModificationRequired;
static int ett_f1ap_DRBs_Required_ToBeModified_List;
static int ett_f1ap_DRBs_Required_ToBeReleased_List;
static int ett_f1ap_SRBs_Required_ToBeReleased_List;
static int ett_f1ap_BHChannels_Required_ToBeReleased_List;
static int ett_f1ap_SLDRBs_Required_ToBeModified_List;
static int ett_f1ap_SLDRBs_Required_ToBeReleased_List;
static int ett_f1ap_UE_MulticastMRBs_RequiredToBeModified_List;
static int ett_f1ap_UE_MulticastMRBs_RequiredToBeReleased_List;
static int ett_f1ap_UEContextModificationConfirm;
static int ett_f1ap_DRBs_ModifiedConf_List;
static int ett_f1ap_SLDRBs_ModifiedConf_List;
static int ett_f1ap_UE_MulticastMRBs_ConfirmedToBeModified_List;
static int ett_f1ap_UEContextModificationRefuse;
static int ett_f1ap_WriteReplaceWarningRequest;
static int ett_f1ap_Cells_To_Be_Broadcast_List;
static int ett_f1ap_WriteReplaceWarningResponse;
static int ett_f1ap_Cells_Broadcast_Completed_List;
static int ett_f1ap_PWSCancelRequest;
static int ett_f1ap_Broadcast_To_Be_Cancelled_List;
static int ett_f1ap_PWSCancelResponse;
static int ett_f1ap_Cells_Broadcast_Cancelled_List;
static int ett_f1ap_UEInactivityNotification;
static int ett_f1ap_DRB_Activity_List;
static int ett_f1ap_InitialULRRCMessageTransfer;
static int ett_f1ap_DLRRCMessageTransfer;
static int ett_f1ap_ULRRCMessageTransfer;
static int ett_f1ap_PrivateMessage;
static int ett_f1ap_SystemInformationDeliveryCommand;
static int ett_f1ap_Paging;
static int ett_f1ap_PagingCell_list;
static int ett_f1ap_Notify;
static int ett_f1ap_DRB_Notify_List;
static int ett_f1ap_NetworkAccessRateReduction;
static int ett_f1ap_PWSRestartIndication;
static int ett_f1ap_NR_CGI_List_For_Restart_List;
static int ett_f1ap_PWSFailureIndication;
static int ett_f1ap_PWS_Failed_NR_CGI_List;
static int ett_f1ap_GNBDUStatusIndication;
static int ett_f1ap_RRCDeliveryReport;
static int ett_f1ap_F1RemovalRequest;
static int ett_f1ap_F1RemovalResponse;
static int ett_f1ap_F1RemovalFailure;
static int ett_f1ap_TraceStart;
static int ett_f1ap_DeactivateTrace;
static int ett_f1ap_CellTrafficTrace;
static int ett_f1ap_DUCURadioInformationTransfer;
static int ett_f1ap_CUDURadioInformationTransfer;
static int ett_f1ap_BAPMappingConfiguration;
static int ett_f1ap_BH_Routing_Information_Added_List;
static int ett_f1ap_BH_Routing_Information_Removed_List;
static int ett_f1ap_BAP_Header_Rewriting_Added_List;
static int ett_f1ap_BAP_Header_Rewriting_Removed_List;
static int ett_f1ap_BAPMappingConfigurationAcknowledge;
static int ett_f1ap_BAPMappingConfigurationFailure;
static int ett_f1ap_GNBDUResourceConfiguration;
static int ett_f1ap_GNBDUResourceConfigurationAcknowledge;
static int ett_f1ap_GNBDUResourceConfigurationFailure;
static int ett_f1ap_IABTNLAddressRequest;
static int ett_f1ap_IAB_TNL_Addresses_To_Remove_List;
static int ett_f1ap_IABTNLAddressResponse;
static int ett_f1ap_IAB_Allocated_TNL_Address_List;
static int ett_f1ap_IABTNLAddressFailure;
static int ett_f1ap_IABUPConfigurationUpdateRequest;
static int ett_f1ap_UL_UP_TNL_Information_to_Update_List;
static int ett_f1ap_UL_UP_TNL_Address_to_Update_List;
static int ett_f1ap_IABUPConfigurationUpdateResponse;
static int ett_f1ap_DL_UP_TNL_Address_to_Update_List;
static int ett_f1ap_IABUPConfigurationUpdateFailure;
static int ett_f1ap_MIABF1SetupTriggering;
static int ett_f1ap_MIABF1SetupOutcomeNotification;
static int ett_f1ap_Activated_Cells_Mapping_List;
static int ett_f1ap_ResourceStatusRequest;
static int ett_f1ap_ResourceStatusResponse;
static int ett_f1ap_ResourceStatusFailure;
static int ett_f1ap_ResourceStatusUpdate;
static int ett_f1ap_AccessAndMobilityIndication;
static int ett_f1ap_ReferenceTimeInformationReportingControl;
static int ett_f1ap_ReferenceTimeInformationReport;
static int ett_f1ap_AccessSuccess;
static int ett_f1ap_PositioningAssistanceInformationControl;
static int ett_f1ap_PositioningAssistanceInformationFeedback;
static int ett_f1ap_PositioningMeasurementRequest;
static int ett_f1ap_PositioningMeasurementResponse;
static int ett_f1ap_PositioningMeasurementFailure;
static int ett_f1ap_PositioningMeasurementReport;
static int ett_f1ap_PositioningMeasurementAbort;
static int ett_f1ap_PositioningMeasurementFailureIndication;
static int ett_f1ap_PositioningMeasurementUpdate;
static int ett_f1ap_TRPInformationRequest;
static int ett_f1ap_TRPInformationTypeListTRPReq;
static int ett_f1ap_TRPInformationResponse;
static int ett_f1ap_TRPInformationListTRPResp;
static int ett_f1ap_TRPInformationFailure;
static int ett_f1ap_PositioningInformationRequest;
static int ett_f1ap_PositioningInformationResponse;
static int ett_f1ap_PositioningInformationFailure;
static int ett_f1ap_PositioningActivationRequest;
static int ett_f1ap_SRSType;
static int ett_f1ap_SemipersistentSRS;
static int ett_f1ap_AperiodicSRS;
static int ett_f1ap_PositioningActivationResponse;
static int ett_f1ap_PositioningActivationFailure;
static int ett_f1ap_PositioningDeactivation;
static int ett_f1ap_PositioningInformationUpdate;
static int ett_f1ap_SRSInformationReservationNotification;
static int ett_f1ap_E_CIDMeasurementInitiationRequest;
static int ett_f1ap_E_CIDMeasurementInitiationResponse;
static int ett_f1ap_E_CIDMeasurementInitiationFailure;
static int ett_f1ap_E_CIDMeasurementFailureIndication;
static int ett_f1ap_E_CIDMeasurementReport;
static int ett_f1ap_E_CIDMeasurementTerminationCommand;
static int ett_f1ap_BroadcastContextSetupRequest;
static int ett_f1ap_BroadcastMRBs_ToBeSetup_List;
static int ett_f1ap_BroadcastContextSetupResponse;
static int ett_f1ap_BroadcastMRBs_Setup_List;
static int ett_f1ap_BroadcastMRBs_FailedToBeSetup_List;
static int ett_f1ap_BroadcastContextSetupFailure;
static int ett_f1ap_BroadcastContextReleaseCommand;
static int ett_f1ap_BroadcastContextReleaseComplete;
static int ett_f1ap_BroadcastContextReleaseRequest;
static int ett_f1ap_BroadcastContextModificationRequest;
static int ett_f1ap_BroadcastMRBs_ToBeSetupMod_List;
static int ett_f1ap_BroadcastMRBs_ToBeModified_List;
static int ett_f1ap_BroadcastMRBs_ToBeReleased_List;
static int ett_f1ap_BroadcastContextModificationResponse;
static int ett_f1ap_BroadcastMRBs_SetupMod_List;
static int ett_f1ap_BroadcastMRBs_FailedToBeSetupMod_List;
static int ett_f1ap_BroadcastMRBs_Modified_List;
static int ett_f1ap_BroadcastMRBs_FailedToBeModified_List;
static int ett_f1ap_BroadcastContextModificationFailure;
static int ett_f1ap_BroadcastTransportResourceRequest;
static int ett_f1ap_Broadcast_MRBs_Transport_Request_List;
static int ett_f1ap_MulticastGroupPaging;
static int ett_f1ap_UEIdentity_List_For_Paging_List;
static int ett_f1ap_MC_PagingCell_list;
static int ett_f1ap_MulticastContextSetupRequest;
static int ett_f1ap_MulticastMRBs_ToBeSetup_List;
static int ett_f1ap_MulticastContextSetupResponse;
static int ett_f1ap_MulticastMRBs_Setup_List;
static int ett_f1ap_MulticastMRBs_FailedToBeSetup_List;
static int ett_f1ap_MulticastContextSetupFailure;
static int ett_f1ap_MulticastContextReleaseCommand;
static int ett_f1ap_MulticastContextReleaseComplete;
static int ett_f1ap_MulticastContextReleaseRequest;
static int ett_f1ap_MulticastContextModificationRequest;
static int ett_f1ap_MulticastMRBs_ToBeSetupMod_List;
static int ett_f1ap_MulticastMRBs_ToBeModified_List;
static int ett_f1ap_MulticastMRBs_ToBeReleased_List;
static int ett_f1ap_MulticastContextModificationResponse;
static int ett_f1ap_MulticastMRBs_SetupMod_List;
static int ett_f1ap_MulticastMRBs_FailedToBeSetupMod_List;
static int ett_f1ap_MulticastMRBs_Modified_List;
static int ett_f1ap_MulticastMRBs_FailedToBeModified_List;
static int ett_f1ap_MulticastContextModificationFailure;
static int ett_f1ap_MulticastContextNotificationIndication;
static int ett_f1ap_MulticastContextNotificationConfirm;
static int ett_f1ap_MulticastContextNotificationRefuse;
static int ett_f1ap_MulticastCommonConfigurationRequest;
static int ett_f1ap_MulticastCommonConfigurationResponse;
static int ett_f1ap_MulticastCommonConfigurationRefuse;
static int ett_f1ap_MulticastDistributionSetupRequest;
static int ett_f1ap_MulticastF1UContext_ToBeSetup_List;
static int ett_f1ap_MulticastDistributionSetupResponse;
static int ett_f1ap_MulticastF1UContext_Setup_List;
static int ett_f1ap_MulticastF1UContext_FailedToBeSetup_List;
static int ett_f1ap_MulticastDistributionSetupFailure;
static int ett_f1ap_MulticastDistributionReleaseCommand;
static int ett_f1ap_MulticastDistributionReleaseComplete;
static int ett_f1ap_PDCMeasurementInitiationRequest;
static int ett_f1ap_PDCMeasurementInitiationResponse;
static int ett_f1ap_PDCMeasurementInitiationFailure;
static int ett_f1ap_PDCMeasurementReport;
static int ett_f1ap_PDCMeasurementTerminationCommand;
static int ett_f1ap_PDCMeasurementFailureIndication;
static int ett_f1ap_PRSConfigurationRequest;
static int ett_f1ap_PRSConfigurationResponse;
static int ett_f1ap_PRSConfigurationFailure;
static int ett_f1ap_MeasurementPreconfigurationRequired;
static int ett_f1ap_MeasurementPreconfigurationConfirm;
static int ett_f1ap_MeasurementPreconfigurationRefuse;
static int ett_f1ap_MeasurementActivation;
static int ett_f1ap_QoEInformationTransfer;
static int ett_f1ap_PosSystemInformationDeliveryCommand;
static int ett_f1ap_DUCUCellSwitchNotification;
static int ett_f1ap_CUDUCellSwitchNotification;
static int ett_f1ap_DUCUTAInformationTransfer;
static int ett_f1ap_CUDUTAInformationTransfer;
static int ett_f1ap_QoEInformationTransferControl;
static int ett_f1ap_RachIndication;
static int ett_f1ap_TimingSynchronisationStatusRequest;
static int ett_f1ap_TimingSynchronisationStatusResponse;
static int ett_f1ap_TimingSynchronisationStatusFailure;
static int ett_f1ap_TimingSynchronisationStatusReport;
static int ett_f1ap_DUCUAccessAndMobilityIndication;
static int ett_f1ap_CUDUMobilityInitiationRequest;
static int ett_f1ap_F1AP_PDU;
static int ett_f1ap_InitiatingMessage;
static int ett_f1ap_SuccessfulOutcome;
static int ett_f1ap_UnsuccessfulOutcome;

enum{
  INITIATING_MESSAGE,
  SUCCESSFUL_OUTCOME,
  UNSUCCESSFUL_OUTCOME
};

/* F1AP stats - Tap interface */

static void set_stats_message_type(packet_info *pinfo, int type);

static const uint8_t *st_str_packets        = "Total Packets";
static const uint8_t *st_str_packet_types   = "F1AP Packet Types";

static int st_node_packets = -1;
static int st_node_packet_types = -1;
static int f1ap_tap;

struct f1ap_tap_t {
    int f1ap_mtype;
};

#define MTYPE_RESET                                        1
#define MTYPE_RESET_ACK                                    2
#define MTYPE_F1_SETUP_REQUEST                             3
#define MTYPE_F1_SETUP_RESPONSE                            4
#define MTYPE_F1_SETUP_FAILURE                             5
#define MTYPE_GNB_DU_CONFIGURATION_UPDATE                  6
#define MTYPE_GNB_DU_CONFIGURATION_UPDATE_ACKNOWLEDGE      7
#define MTYPE_GNB_DU_CONFIGURATION_UPDATE_FAILURE          8
#define MTYPE_GNB_CU_CONFIGURATION_UPDATE                  9
#define MTYPE_GNB_CU_CONFIGURATION_UPDATE_ACKNOWLEDGE      10
#define MTYPE_GNB_CU_CONFIGURATION_UPDATE_FAILURE          11
#define MTYPE_UE_CONTEXT_SETUP_REQUEST                     12
#define MTYPE_UE_CONTEXT_SETUP_RESPONSE                    13
#define MTYPE_UE_CONTEXT_SETUP_FAILURE                     14
#define MTYPE_UE_CONTEXT_RELEASE_COMMAND                   15
#define MTYPE_UE_CONTEXT_RELEASE_COMPLETE                  16
#define MTYPE_UE_CONTEXT_MODIFICATION_REQUEST              17
#define MTYPE_UE_CONTEXT_MODIFICATION_RESPONSE             18
#define MTYPE_UE_CONTEXT_MODIFICATION_FAILURE              19
#define MTYPE_UE_CONTEXT_MODIFICATION_REQUIRED             20
#define MTYPE_UE_CONTEXT_MODIFICATION_CONFIRM              21
#define MTYPE_UE_CONTEXT_MODIFICATION_REFUSE               22
#define MTYPE_WRITE_REPLACE_WARNING_REQUEST                23
#define MTYPE_WRITE_REPLACE_WARNING_RESPONSE               24
#define MTYPE_PWS_CANCEL_REQUEST                           25
#define MTYPE_PWS_CANCEL_RESPONSE                          26
#define MTYPE_ERROR_INDICATION                             27
#define MTYPE_UE_CONTEXT_RELEASE_REQUEST                   28
#define MTYPE_INITIAL_UL_RRC_MESSAGE_TRANSFER              29
#define MTYPE_DL_RRC_MESSAGE_TRANSFER                      30
#define MTYPE_UL_RRC_MESSAGE_TRANSFER                      31
#define MTYPE_UE_INACTIVITY_NOTIFICATION                   32
#define MTYPE_GNB_DU_RESOURCE_COORDINATION_REQUEST         33
#define MTYPE_GNB_DU_RESOURCE_COORDINATION_RESPONSE        34
#define MTYPE_PRIVATE_MESSAGE                              35
#define MTYPE_SYSTEM_INFORMATION_DELIVERY_COMMAND          36
#define MTYPE_PAGING                                       37
#define MTYPE_NOTIFY                                       38
#define MTYPE_NETWORK_ACCESS_RATE_REDUCTION                39
#define MTYPE_PWS_RESTART_INDICATION                       40
#define MTYPE_PWS_FAILURE_INDICATION                       41
#define MTYPE_GNB_DU_STATUS_INDICATION                     42
#define MTYPE_RRC_DELIVERY_REPORT                          43
#define MTYPE_F1_REMOVAL_REQUEST                           44
#define MTYPE_F1_REMOVAL_RESPONSE                          45
#define MTYPE_F1_REMOVAL_FAILURE                           46
#define MTYPE_TRACE_START                                  47
#define MTYPE_DEACTIVATE_TRACE                             48
#define MTYPE_DU_CU_RADIO_INFORMATION_TRANSFER             49
#define MTYPE_CU_DU_RADIO_INFORMATION_TRANSFER             50
#define MTYPE_BAP_MAPPING_CONFIGURATION                    51
#define MTYPE_BAP_MAPPING_CONFIGURATION_ACKNOWLEDGE        52
#define MTYPE_BAP_MAPPING_CONFIGURATION_FAILURE            53
#define MTYPE_GNB_DU_RESOURCE_CONFIGURATION                54
#define MTYPE_GNB_DU_RESOURCE_CONFIGURATION_ACKNOWLEDGE    55
#define MTYPE_GNB_DU_RESOURCE_CONFIGURATION_FAILURE        56
#define MTYPE_IAB_TNL_ADDRESS_REQUEST                      57
#define MTYPE_IAB_TNL_ADDRESS_RESPONSE                     58
#define MTYPE_IAB_TNL_ADDRESS_FAILURE                      59
#define MTYPE_IAB_UP_CONFIGURATION_UPDATE_REQUEST          60
#define MTYPE_IAB_UP_CONFIGURATION_UPDATE_RESPONSE         61
#define MTYPE_IAB_UP_CONFIGURATION_UPDATE_FAILURE          62
#define MTYPE_RESOURCE_STATUS_REQUEST                      63
#define MTYPE_RESOURCE_STATUS_RESPONSE                     64
#define MTYPE_RESOURCE_STATUS_FAILURE                      65
#define MTYPE_RESOURCE_STATUS_UPDATE                       66
#define MTYPE_ACCESS_AND_MOBILITY_INDICATION               67
#define MTYPE_REFERENCE_TIME_INFORMATION_REPORTING_CONTROL 68
#define MTYPE_REFERENCE_TIME_INFORMATION_REPORT            69
#define MTYPE_ACCESS_SUCCESS                               70
#define MTYPE_CELL_TRAFFIC_TRACE                           71
#define MTYPE_POSITIONING_ASSISTANCE_INFORMATION_CONTROL   72
#define MTYPE_POSITIONING_ASSISTANCE_INFORMATION_FEEDBACK  73
#define MTYPE_POSITIONING_MEASUREMENT_REQUEST              74
#define MTYPE_POSITIONING_MEASUREMENT_RESPONSE             75
#define MTYPE_POSITIONING_MEASUREMENT_FAILURE              76
#define MTYPE_POSITIONING_MEASUREMENT_REPORT               77
#define MTYPE_POSITIONING_MEASUREMENT_ABORT                78
#define MTYPE_POSITIONING_MEASUREMENT_FAILURE_INDICATION   79
#define MTYPE_POSITIONING_MEASUREMENT_UPDATE               80
#define MTYPE_TRP_INFORMATION_REQUEST                      81
#define MTYPE_TRP_INFORMATION_RESPONSE                     82
#define MTYPE_TRP_INFORMATION_FAILURE                      83
#define MTYPE_POSITIONING_INFORMATION_REQUEST              84
#define MTYPE_POSITIONING_INFORMATION_RESPONSE             85
#define MTYPE_POSITIONING_INFORMATION_FAILURE              86
#define MTYPE_POSITIONING_ACTIVATION_REQUEST               87
#define MTYPE_POSITIONING_ACTIVATION_RESPONSE              88
#define MTYPE_POSITIONING_ACTIVATION_FAILURE               89
#define MTYPE_POSITIONING_DEACTIVATION                     90
#define MTYPE_E_CID_MEASUREMENT_INITIATION_REQUEST         91
#define MTYPE_E_CID_MEASUREMENT_INITIATION_RESPONSE        92
#define MTYPE_E_CID_MEASUREMENT_INITIATION_FAILURE         93
#define MTYPE_E_CID_MEASUREMENT_FAILURE_INDICATION         94
#define MTYPE_E_CID_MEASUREMENT_REPORT                     95
#define MTYPE_E_CID_MEASUREMENT_TERMINATION_COMMAND        96
#define MTYPE_POSITIONING_INFORMATION_UPDATE               97
#define MTYPE_BROADCAST_CONTEXT_SETUP_REQUEST              98
#define MTYPE_BROADCAST_CONTEXT_SETUP_RESPONSE             99
#define MTYPE_BROADCAST_CONTEXT_SETUP_FAILURE              100
#define MTYPE_BROADCAST_CONTEXT_RELEASE_COMMAND            101
#define MTYPE_BROADCAST_CONTEXT_RELEASE_COMPLETE           102
#define MTYPE_BROADCAST_CONTEXT_RELEASE_REQUEST            103
#define MTYPE_BROADCAST_CONTEXT_MODIFICATION_REQUEST       104
#define MTYPE_BROADCAST_CONTEXT_MODIFICATION_RESPONSE      105
#define MTYPE_BROADCAST_CONTEXT_MODIFICATION_FAILURE       106
#define MTYPE_MULTICAST_GROUP_PAGING                       107
#define MTYPE_MULTICAST_CONTEXT_SETUP_REQUEST              108
#define MTYPE_MULTICAST_CONTEXT_SETUP_RESPONSE             109
#define MTYPE_MULTICAST_CONTEXT_SETUP_FAILURE              110
#define MTYPE_MULTICAST_CONTEXT_RELEASE_COMMAND            111
#define MTYPE_MULTICAST_CONTEXT_RELEASE_COMPLETE           112
#define MTYPE_MULTICAST_CONTEXT_RELEASE_REQUEST            113
#define MTYPE_MULTICAST_CONTEXT_MODIFICATION_REQUEST       114
#define MTYPE_MULTICAST_CONTEXT_MODIFICATION_RESPONSE      115
#define MTYPE_MULTICAST_CONTEXT_MODIFICATION_FAILURE       116
#define MTYPE_MULTICAST_DISTRIBUTION_SETUP_REQUEST         117
#define MTYPE_MULTICAST_DISTRIBUTION_SETUP_RESPONSE        118
#define MTYPE_MULTICAST_DISTRIBUTION_SETUP_FAILURE         119
#define MTYPE_MULTICAST_DISTRIBUTION_RELEASE_COMMAND       120
#define MTYPE_MULTICAST_DISTRIBUTION_RELEASE_COMPLETE      121
#define MTYPE_PDCP_MEASUREMENT_INITIATION_REQUEST          122
#define MTYPE_PDCP_MEASUREMENT_INITIATION_RESPONSE         123
#define MTYPE_PDCP_MEASUREMENT_INITIATION_FAILURE          124
#define MTYPE_PDCP_MEASUREMENT_REPORT                      125
#define MTYPE_PDCP_MEASUREMENT_TERMINATION_COMMAND         126
#define MTYPE_PDCP_MEASUREMENT_FAILURE_INDICATION          127
#define MTYPE_PRS_CONFIGURATION_REQUEST                    128
#define MTYPE_PRS_CONFIGURATION_RESPONSE                   129
#define MTYPE_PRS_CONFIGURATION_FAILURE                    130
#define MTYPE_MEASUREMENT_PRECONFIGURATION_REQUIRED        131
#define MTYPE_MEASUREMENT_PRECONFIGURATION_CONFIRM         132
#define MTYPE_MEASUREMENT_PRECONFIGURATION_REFUSE          133
#define MTYPE_MEASUREMENT_ACTIVATION                       134
#define MTYPE_QOE_INFORMATION_TRANSFER                     135
#define MTYPE_POS_SYSTEM_INFORMATION_DELIVERY_COMMAND      136
#define MTYPE_DU_CU_CELL_SWITCH_NOTIFICATION               137
#define MTYPE_CU_DU_CELL_SWITCH_NOTIFICATION               138
#define MTYPE_DU_CU_TA_INFORMATION_TRANSFER                139
#define MTYPE_CU_DU_TA_INFORMATION_TRANSFER                140
#define MTYPE_QOE_INFORMATION_TRANSFER_CONTROL             141
#define MTYPE_RACH_INDICATION                              142
#define MTYPE_TIMING_SYNCHRONISATION_STATUS_REQUEST        143
#define MTYPE_TIMING_SYNCHRONISATION_STATUS_RESPONSE       144
#define MTYPE_TIMING_SYNCHRONISATION_STATUS_FAILURE        145
#define MTYPE_TIMING_SYNCHRONISATION_STATUS_REPORT         146
#define MTYPE_MIAB_F1_SETUP_TRIGGERING                     147
#define MTYPE_MIAB_F1_SETUP_OUTCOME_NOTIFICATION           148
#define MTYPE_MULTICAST_CONTEXT_NOTIFICATION_INDICATION    149
#define MTYPE_MULTICAST_CONTEXT_NOTIFICATION_CONFIRM       150
#define MTYPE_MULTICAST_CONTEXT_NOTIFICATION_REFUSE        151
#define MTYPE_MULTICAST_COMMON_CONFIGURATION_REQUEST       152
#define MTYPE_MULTICAST_COMMON_CONFIGURATION_RESPONSE      153
#define MTYPE_MULTICAST_COMMON_CONFIGURATION_REFUSE        154
#define MTYPE_BROADCAST_TRANSPORT_RESOURCE_REQUEST         155
#define MTYPE_DU_CU_ACCESS_AND_MOBILITY_INDICATION         156
#define MTYPE_SRS_INFORMATION_RESERVATION_NOTIFICATION     157
#define MTYPE_CU_DU_MOBILITY_INITIATION_REQUEST            158

static const value_string mtype_names[] = {
    { MTYPE_RESET,     "Reset" },
    { MTYPE_RESET_ACK, "ResetAcknowledge" },
    { MTYPE_F1_SETUP_REQUEST,  "F1SetupRequest" },
    { MTYPE_F1_SETUP_RESPONSE, "F1SetupResponse" },
    { MTYPE_F1_SETUP_FAILURE,  "F1SetupFailure" },
    { MTYPE_GNB_DU_CONFIGURATION_UPDATE,             "GNBDUConfigurationUpdate" },
    { MTYPE_GNB_DU_CONFIGURATION_UPDATE_ACKNOWLEDGE, "GNBDUConfigurationUpdateAcknowledge" },
    { MTYPE_GNB_DU_CONFIGURATION_UPDATE_FAILURE,     "GNBDUConfigurationUpdateFailure" },
    { MTYPE_GNB_CU_CONFIGURATION_UPDATE,             "GNBCUConfigurationUpdate" },
    { MTYPE_GNB_CU_CONFIGURATION_UPDATE_ACKNOWLEDGE, "GNBCUConfigurationUpdateAcknowledge" },
    { MTYPE_GNB_CU_CONFIGURATION_UPDATE_FAILURE,     "GNBCUConfigurationUpdateFailure" },
    { MTYPE_UE_CONTEXT_SETUP_REQUEST,    "UEContextSetupRequest" },
    { MTYPE_UE_CONTEXT_SETUP_RESPONSE,   "UEContextSetupResponse" },
    { MTYPE_UE_CONTEXT_SETUP_FAILURE,    "UEContextSetupFailure" },
    { MTYPE_UE_CONTEXT_RELEASE_COMMAND,      "UEContextReleaseCommand"},
    { MTYPE_UE_CONTEXT_RELEASE_COMPLETE,     "UEContextReleaseComplete"},
    { MTYPE_UE_CONTEXT_MODIFICATION_REQUEST,   "UEContextModificationRequest" },
    { MTYPE_UE_CONTEXT_MODIFICATION_RESPONSE,  "UEContextModificationResponse" },
    { MTYPE_UE_CONTEXT_MODIFICATION_FAILURE,   "UEContextModificationFailure" },
    { MTYPE_UE_CONTEXT_MODIFICATION_REQUIRED,  "UEContextModificationRequired" },
    { MTYPE_UE_CONTEXT_MODIFICATION_CONFIRM,   "UEContextModificationConfirm" },
    { MTYPE_UE_CONTEXT_MODIFICATION_REFUSE,   "UEContextModificationRefuse" },
    { MTYPE_WRITE_REPLACE_WARNING_REQUEST,  "WriteReplaceWarningRequest" },
    { MTYPE_WRITE_REPLACE_WARNING_RESPONSE, "WriteReplaceWarningResponse" },
    { MTYPE_PWS_CANCEL_REQUEST,   "PWSCancelRequest" },
    { MTYPE_PWS_CANCEL_RESPONSE,  "PWSCancelResponse" },
    { MTYPE_ERROR_INDICATION, "ErrorIndication" },
    { MTYPE_UE_CONTEXT_RELEASE_REQUEST, "UEContextReleaseRequest" },
    { MTYPE_INITIAL_UL_RRC_MESSAGE_TRANSFER, "InitialULRRCMessageTransfer" },
    { MTYPE_DL_RRC_MESSAGE_TRANSFER,  "DLRRCMessageTransfer" },
    { MTYPE_UL_RRC_MESSAGE_TRANSFER,  "ULRRCMessageTransfer" },
    { MTYPE_UE_INACTIVITY_NOTIFICATION, "UEInactivityNotification" },
    { MTYPE_GNB_DU_RESOURCE_COORDINATION_REQUEST,  "GNBDUResourceCoordinationRequest" },
    { MTYPE_GNB_DU_RESOURCE_COORDINATION_RESPONSE, "GNBDUResourceCoordinationResponse" },
    { MTYPE_PRIVATE_MESSAGE, "PrivateMessage" },
    { MTYPE_SYSTEM_INFORMATION_DELIVERY_COMMAND, "SystemInformationDeliveryCommand" },
    { MTYPE_PAGING, "Paging" },
    { MTYPE_NOTIFY, "Notify" },
    { MTYPE_NETWORK_ACCESS_RATE_REDUCTION, "NetworkAccessRateReduction" },
    { MTYPE_PWS_RESTART_INDICATION, "PWSRestartIndication" },
    { MTYPE_PWS_FAILURE_INDICATION, "PWSFailureIndication" },
    { MTYPE_GNB_DU_STATUS_INDICATION, "GNBDUStatusIndication" },
    { MTYPE_RRC_DELIVERY_REPORT, "RRCDeliveryReport" },
    { MTYPE_F1_REMOVAL_REQUEST,  "F1RemovalRequest" },
    { MTYPE_F1_REMOVAL_RESPONSE, "F1RemovalResponse" },
    { MTYPE_F1_REMOVAL_FAILURE,  "F1RemovalFailure" },
    { MTYPE_TRACE_START, "TraceStart" },
    { MTYPE_DEACTIVATE_TRACE, "DeactivateTrace" },
    { MTYPE_DU_CU_RADIO_INFORMATION_TRANSFER, "DUCURadioInformationTransfer" },
    { MTYPE_CU_DU_RADIO_INFORMATION_TRANSFER, "CUDURadioInformationTransfer" },
    { MTYPE_BAP_MAPPING_CONFIGURATION,             "BAPMappingConfiguration" },
    { MTYPE_BAP_MAPPING_CONFIGURATION_ACKNOWLEDGE, "BAPMappingConfigurationAcknowledge" },
    { MTYPE_BAP_MAPPING_CONFIGURATION_FAILURE,     "BAPMappingConfigurationFailure" },
    { MTYPE_GNB_DU_RESOURCE_CONFIGURATION,             "GNBDUResourceConfiguration" },
    { MTYPE_GNB_DU_RESOURCE_CONFIGURATION_ACKNOWLEDGE, "GNBDUResourceConfigurationAcknowledge" },
    { MTYPE_GNB_DU_RESOURCE_CONFIGURATION_FAILURE,     "GNBDUResourceConfigurationFailure" },
    { MTYPE_IAB_TNL_ADDRESS_REQUEST,  "IABTNLAddressRequest" },
    { MTYPE_IAB_TNL_ADDRESS_RESPONSE, "IABTNLAddressResponse" },
    { MTYPE_IAB_TNL_ADDRESS_FAILURE,  "IABTNLAddressFailure" },
    { MTYPE_IAB_UP_CONFIGURATION_UPDATE_REQUEST,  "IABUPConfigurationUpdateRequest" },
    { MTYPE_IAB_UP_CONFIGURATION_UPDATE_RESPONSE, "IABUPConfigurationUpdateResponse" },
    { MTYPE_IAB_UP_CONFIGURATION_UPDATE_FAILURE,  "IABUPConfigurationUpdateFailure" },
    { MTYPE_RESOURCE_STATUS_REQUEST,   "ResourceStatusRequest" },
    { MTYPE_RESOURCE_STATUS_RESPONSE,  "ResourceStatusResponse" },
    { MTYPE_RESOURCE_STATUS_FAILURE,   "ResourceStatusFailure" },
    { MTYPE_RESOURCE_STATUS_UPDATE,    "ResourceStatusUpdate" },
    { MTYPE_ACCESS_AND_MOBILITY_INDICATION, "AccessAndMobilityIndication" },
    { MTYPE_REFERENCE_TIME_INFORMATION_REPORTING_CONTROL, "ReferenceTimeInformationReportingControl" },
    { MTYPE_REFERENCE_TIME_INFORMATION_REPORT,            "ReferenceTimeInformationReport" },
    { MTYPE_ACCESS_SUCCESS, "AccessSuccess" },
    { MTYPE_CELL_TRAFFIC_TRACE, "CellTrafficTrace" },
    { MTYPE_POSITIONING_ASSISTANCE_INFORMATION_CONTROL,  "PositioningAssistanceInformationControl" },
    { MTYPE_POSITIONING_ASSISTANCE_INFORMATION_FEEDBACK, "PositioningAssistanceInformationFeedback" },
    { MTYPE_POSITIONING_MEASUREMENT_REQUEST,            "PositioningMeasurementRequest" },
    { MTYPE_POSITIONING_MEASUREMENT_RESPONSE,           "PositioningMeasurementResponse" },
    { MTYPE_POSITIONING_MEASUREMENT_FAILURE,            "PositioningMeasurementFailure" },
    { MTYPE_POSITIONING_MEASUREMENT_REPORT,             "PositioningMeasurementReport" },
    { MTYPE_POSITIONING_MEASUREMENT_ABORT,              "PositioningMeasurementAbort" },
    { MTYPE_POSITIONING_MEASUREMENT_FAILURE_INDICATION, "PositioningMeasurementFailureIndication" },
    { MTYPE_POSITIONING_MEASUREMENT_UPDATE,             "PositioningMeasurementUpdate" },
    { MTYPE_TRP_INFORMATION_REQUEST,  "TRPInformationRequest" },
    { MTYPE_TRP_INFORMATION_RESPONSE, "TRPInformationResponse" },
    { MTYPE_TRP_INFORMATION_FAILURE,  "TRPInformationFailure" },
    { MTYPE_POSITIONING_INFORMATION_REQUEST,  "PositioningInformationRequest" },
    { MTYPE_POSITIONING_INFORMATION_RESPONSE, "PositioningInformationResponse" },
    { MTYPE_POSITIONING_INFORMATION_FAILURE,  "PositioningInformationFailure" },
    { MTYPE_POSITIONING_ACTIVATION_REQUEST,   "PositioningActivationRequest" },
    { MTYPE_POSITIONING_ACTIVATION_RESPONSE,  "PositioningActivationResponse" },
    { MTYPE_POSITIONING_ACTIVATION_FAILURE,   "PositioningActivationFailure" },
    { MTYPE_POSITIONING_DEACTIVATION, "PositioningDeactivation" },
    { MTYPE_E_CID_MEASUREMENT_INITIATION_REQUEST,  "E-CIDMeasurementInitiationRequest" },
    { MTYPE_E_CID_MEASUREMENT_INITIATION_RESPONSE, "E-CIDMeasurementInitiationResponse" },
    { MTYPE_E_CID_MEASUREMENT_INITIATION_FAILURE,  "E-CIDMeasurementInitiationFailure" },
    { MTYPE_E_CID_MEASUREMENT_FAILURE_INDICATION,  "E-CIDMeasurementFailureIndication" },
    { MTYPE_E_CID_MEASUREMENT_REPORT,              "E-CIDMeasurementReport" },
    { MTYPE_E_CID_MEASUREMENT_TERMINATION_COMMAND, "E-CIDMeasurementTerminationCommand" },
    { MTYPE_POSITIONING_INFORMATION_UPDATE, "PositioningInformationUpdate" },
    { MTYPE_BROADCAST_CONTEXT_SETUP_REQUEST, "BroadcastContextSetupRequest" },
    { MTYPE_BROADCAST_CONTEXT_SETUP_RESPONSE, "BroadcastContextSetupResponse" },
    { MTYPE_BROADCAST_CONTEXT_SETUP_FAILURE, "BroadcastContextSetupFailure" },
    { MTYPE_BROADCAST_CONTEXT_RELEASE_COMMAND, "BroadcastContextReleaseCommand" },
    { MTYPE_BROADCAST_CONTEXT_RELEASE_COMPLETE, "BroadcastContextReleaseComplete" },
    { MTYPE_BROADCAST_CONTEXT_RELEASE_REQUEST, "BroadcastContextReleaseRequest" },
    { MTYPE_BROADCAST_CONTEXT_MODIFICATION_REQUEST, "BroadcastContextModificationRequest" },
    { MTYPE_BROADCAST_CONTEXT_MODIFICATION_RESPONSE, "BroadcastContextModificationResponse" },
    { MTYPE_BROADCAST_CONTEXT_MODIFICATION_FAILURE, "BroadcastContextModificationFailure" },
    { MTYPE_MULTICAST_GROUP_PAGING, "MulticastGroupPaging" },
    { MTYPE_MULTICAST_CONTEXT_SETUP_REQUEST, "MulticastContextSetupRequest" },
    { MTYPE_MULTICAST_CONTEXT_SETUP_RESPONSE, "MulticastContextSetupResponse" },
    { MTYPE_MULTICAST_CONTEXT_SETUP_FAILURE, "MulticastContextSetupFailure" },
    { MTYPE_MULTICAST_CONTEXT_RELEASE_COMMAND, "MulticastContextReleaseCommand" },
    { MTYPE_MULTICAST_CONTEXT_RELEASE_COMPLETE, "MulticastContextReleaseComplete" },
    { MTYPE_MULTICAST_CONTEXT_RELEASE_REQUEST, "MulticastContextReleaseRequest" },
    { MTYPE_MULTICAST_CONTEXT_MODIFICATION_REQUEST, "MulticastContextModificationRequest" },
    { MTYPE_MULTICAST_CONTEXT_MODIFICATION_RESPONSE, "MulticastContextModificationResponse" },
    { MTYPE_MULTICAST_CONTEXT_MODIFICATION_FAILURE, "MulticastContextModificationFailure" },
    { MTYPE_MULTICAST_DISTRIBUTION_SETUP_REQUEST, "MulticastDistributionSetupRequest" },
    { MTYPE_MULTICAST_DISTRIBUTION_SETUP_RESPONSE, "MulticastDistributionSetupResponse" },
    { MTYPE_MULTICAST_DISTRIBUTION_SETUP_FAILURE, "MulticastDistributionSetupFailure" },
    { MTYPE_MULTICAST_DISTRIBUTION_RELEASE_COMMAND, "MulticastDistributionReleaseCommand" },
    { MTYPE_MULTICAST_DISTRIBUTION_RELEASE_COMPLETE, "MulticastDistributionReleaseComplete" },
    { MTYPE_PDCP_MEASUREMENT_INITIATION_REQUEST, "PDCMeasurementInitiationRequest" },
    { MTYPE_PDCP_MEASUREMENT_INITIATION_RESPONSE, "PDCMeasurementInitiationResponse" },
    { MTYPE_PDCP_MEASUREMENT_INITIATION_FAILURE, "PDCMeasurementInitiationFailure" },
    { MTYPE_PDCP_MEASUREMENT_REPORT, "PDCMeasurementReport" },
    { MTYPE_PDCP_MEASUREMENT_TERMINATION_COMMAND, "PDCMeasurementTerminationCommand" },
    { MTYPE_PDCP_MEASUREMENT_FAILURE_INDICATION, "PDCMeasurementFailureIndication" },
    { MTYPE_PRS_CONFIGURATION_REQUEST, "PRSConfigurationRequest" },
    { MTYPE_PRS_CONFIGURATION_RESPONSE, "PRSConfigurationResponse" },
    { MTYPE_PRS_CONFIGURATION_FAILURE, "PRSConfigurationFailure" },
    { MTYPE_MEASUREMENT_PRECONFIGURATION_REQUIRED, "MeasurementPreconfigurationRequired" },
    { MTYPE_MEASUREMENT_PRECONFIGURATION_CONFIRM, "MeasurementPreconfigurationConfirm" },
    { MTYPE_MEASUREMENT_PRECONFIGURATION_REFUSE, "MeasurementPreconfigurationRefuse" },
    { MTYPE_MEASUREMENT_ACTIVATION, "MeasurementActivation" },
    { MTYPE_QOE_INFORMATION_TRANSFER, "QoEInformationTransfer" },
    { MTYPE_POS_SYSTEM_INFORMATION_DELIVERY_COMMAND, "PosSystemInformationDeliveryCommand" },
    { MTYPE_DU_CU_CELL_SWITCH_NOTIFICATION, "DUCUCellSwitchNotification" },
    { MTYPE_CU_DU_CELL_SWITCH_NOTIFICATION, "CUDUCellSwitchNotification" },
    { MTYPE_DU_CU_TA_INFORMATION_TRANSFER, "DUCUTAInformationTransfer" },
    { MTYPE_CU_DU_TA_INFORMATION_TRANSFER, "CUDUTAInformationTransfer" },
    { MTYPE_QOE_INFORMATION_TRANSFER_CONTROL, "QoEInformationTransferControl" },
    { MTYPE_RACH_INDICATION, "RachIndication" },
    { MTYPE_TIMING_SYNCHRONISATION_STATUS_REQUEST, "TimingSynchronisationStatusRequest" },
    { MTYPE_TIMING_SYNCHRONISATION_STATUS_RESPONSE, "TimingSynchronisationStatusResponse" },
    { MTYPE_TIMING_SYNCHRONISATION_STATUS_FAILURE, "TimingSynchronisationStatusFailure" },
    { MTYPE_TIMING_SYNCHRONISATION_STATUS_REPORT, "TimingSynchronisationStatusReport" },
    { MTYPE_MIAB_F1_SETUP_TRIGGERING, "MIABF1SetupTriggering" },
    { MTYPE_MIAB_F1_SETUP_OUTCOME_NOTIFICATION, "MIABF1SetupOutcomeNotification" },
    { MTYPE_MULTICAST_CONTEXT_NOTIFICATION_INDICATION, "MulticastContextNotificationIndication" },
    { MTYPE_MULTICAST_CONTEXT_NOTIFICATION_CONFIRM, "MulticastContextNotificationConfirm" },
    { MTYPE_MULTICAST_CONTEXT_NOTIFICATION_REFUSE, "MulticastContextNotificationRefuse" },
    { MTYPE_MULTICAST_COMMON_CONFIGURATION_REQUEST, "MulticastCommonConfigurationRequest" },
    { MTYPE_MULTICAST_COMMON_CONFIGURATION_RESPONSE, "MulticastCommonConfigurationResponse" },
    { MTYPE_MULTICAST_COMMON_CONFIGURATION_REFUSE, "MulticastCommonConfigurationRefuse" },
    { MTYPE_BROADCAST_TRANSPORT_RESOURCE_REQUEST, "BroadcastTransportResourceRequest" },
    { MTYPE_DU_CU_ACCESS_AND_MOBILITY_INDICATION, "DUCUAccessAndMobilityIndication" },
    { MTYPE_SRS_INFORMATION_RESERVATION_NOTIFICATION, "SRSInformationReservationNotification" },
    { MTYPE_CU_DU_MOBILITY_INITIATION_REQUEST, "CUDUMobilityInitiationRequest" },
    { 0,  NULL }
};
static value_string_ext mtype_names_ext = VALUE_STRING_EXT_INIT(mtype_names);


typedef struct {
  uint32_t message_type;
  uint32_t procedure_code;
  uint32_t protocol_ie_id;
  uint32_t protocol_extension_id;
  const char *obj_id;
  uint32_t sib_type;
  uint32_t srb_id;
  uint32_t gdb_cu_ue_f1ap_id;
  e212_number_type_t number_type;
  struct f1ap_tap_t  *stats_tap;
} f1ap_private_data_t;

typedef struct {
  uint32_t message_type;
  uint32_t ProcedureCode;
  uint32_t ProtocolIE_ID;
  uint32_t ProtocolExtensionID;
} f1ap_ctx_t;

/* Global variables */
static dissector_handle_t f1ap_handle;
static dissector_handle_t nr_rrc_ul_ccch_handle;
static dissector_handle_t nr_rrc_ul_ccch1_handle;
static dissector_handle_t nr_rrc_dl_ccch_handle;
static dissector_handle_t nr_rrc_ul_dcch_handle;
static dissector_handle_t nr_pdcp_handle;
static dissector_handle_t lte_rrc_conn_reconf_handle;

/* Dissector tables */
static dissector_table_t f1ap_ies_dissector_table;
static dissector_table_t f1ap_extension_dissector_table;
static dissector_table_t f1ap_proc_imsg_dissector_table;
static dissector_table_t f1ap_proc_sout_dissector_table;
static dissector_table_t f1ap_proc_uout_dissector_table;

static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);


static proto_tree *top_tree;

static void set_message_label(asn1_ctx_t *actx, int type)
{
  const char *label = val_to_str_ext_const(type, &mtype_names_ext, "Unknown");
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, label);
  /* N.B. would like to be able to use actx->subTree.top_tree, but not easy to set.. */
  proto_item_append_text(top_tree, " (%s)", label);
}



static void
f1ap_MaxPacketLossRate_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1f%% (%u)", (float)v/10, v);
}

static void
f1ap_PacketDelayBudget_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/2, v);
}

static void
f1ap_ExtendedPacketDelayBudget_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.2fms (%u)", (float)v/100, v);
}

static void
f1ap_N6Jitter_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%d)", (float)v/2, (int32_t)v);
}

static f1ap_private_data_t*
f1ap_get_private_data(packet_info *pinfo)
{
  f1ap_private_data_t *f1ap_data = (f1ap_private_data_t*)p_get_proto_data(wmem_file_scope(), pinfo, proto_f1ap, 0);
  if (!f1ap_data) {
    f1ap_data = wmem_new0(wmem_file_scope(), f1ap_private_data_t);
    f1ap_data->srb_id = -1;
    f1ap_data->gdb_cu_ue_f1ap_id = 1;
    p_add_proto_data(wmem_file_scope(), pinfo, proto_f1ap, 0, f1ap_data);
  }
  return f1ap_data;
}

static void
add_nr_pdcp_meta_data(packet_info *pinfo, uint8_t direction, uint8_t srb_id)
{
  pdcp_nr_info *p_pdcp_nr_info;

  /* Only need to set info once per session. */
  if (get_pdcp_nr_proto_data(pinfo)) {
      return;
  }

  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(pinfo);

  p_pdcp_nr_info = wmem_new0(wmem_file_scope(), pdcp_nr_info);
  p_pdcp_nr_info->direction = direction;
  p_pdcp_nr_info->ueid = f1ap_data->gdb_cu_ue_f1ap_id;
  p_pdcp_nr_info->bearerType = Bearer_DCCH;
  p_pdcp_nr_info->bearerId = srb_id;
  p_pdcp_nr_info->plane = NR_SIGNALING_PLANE;
  p_pdcp_nr_info->seqnum_length = PDCP_NR_SN_LENGTH_12_BITS;
  p_pdcp_nr_info->maci_present = true;
  set_pdcp_nr_proto_data(pinfo, p_pdcp_nr_info);
}


static const value_string f1ap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_f1ap_Criticality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}



static int
dissect_f1ap_T_global(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_object_identifier_str(tvb, offset, actx, tree, hf_index, &f1ap_data->obj_id);



  return offset;
}


static const value_string f1ap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_f1ap_local          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_65535 },
  {   1, &hf_f1ap_global         , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_global },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_PrivateIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  f1ap_data->obj_id = NULL;

  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_ProcedureCode_vals[] = {
  { id_Reset, "id-Reset" },
  { id_F1Setup, "id-F1Setup" },
  { id_ErrorIndication, "id-ErrorIndication" },
  { id_gNBDUConfigurationUpdate, "id-gNBDUConfigurationUpdate" },
  { id_gNBCUConfigurationUpdate, "id-gNBCUConfigurationUpdate" },
  { id_UEContextSetup, "id-UEContextSetup" },
  { id_UEContextRelease, "id-UEContextRelease" },
  { id_UEContextModification, "id-UEContextModification" },
  { id_UEContextModificationRequired, "id-UEContextModificationRequired" },
  { id_procedure_code_9_not_to_be_used, "id-procedure-code-9-not-to-be-used" },
  { id_UEContextReleaseRequest, "id-UEContextReleaseRequest" },
  { id_InitialULRRCMessageTransfer, "id-InitialULRRCMessageTransfer" },
  { id_DLRRCMessageTransfer, "id-DLRRCMessageTransfer" },
  { id_ULRRCMessageTransfer, "id-ULRRCMessageTransfer" },
  { id_privateMessage, "id-privateMessage" },
  { id_UEInactivityNotification, "id-UEInactivityNotification" },
  { id_GNBDUResourceCoordination, "id-GNBDUResourceCoordination" },
  { id_SystemInformationDeliveryCommand, "id-SystemInformationDeliveryCommand" },
  { id_Paging, "id-Paging" },
  { id_Notify, "id-Notify" },
  { id_WriteReplaceWarning, "id-WriteReplaceWarning" },
  { id_PWSCancel, "id-PWSCancel" },
  { id_PWSRestartIndication, "id-PWSRestartIndication" },
  { id_PWSFailureIndication, "id-PWSFailureIndication" },
  { id_GNBDUStatusIndication, "id-GNBDUStatusIndication" },
  { id_RRCDeliveryReport, "id-RRCDeliveryReport" },
  { id_F1Removal, "id-F1Removal" },
  { id_NetworkAccessRateReduction, "id-NetworkAccessRateReduction" },
  { id_TraceStart, "id-TraceStart" },
  { id_DeactivateTrace, "id-DeactivateTrace" },
  { id_DUCURadioInformationTransfer, "id-DUCURadioInformationTransfer" },
  { id_CUDURadioInformationTransfer, "id-CUDURadioInformationTransfer" },
  { id_BAPMappingConfiguration, "id-BAPMappingConfiguration" },
  { id_GNBDUResourceConfiguration, "id-GNBDUResourceConfiguration" },
  { id_IABTNLAddressAllocation, "id-IABTNLAddressAllocation" },
  { id_IABUPConfigurationUpdate, "id-IABUPConfigurationUpdate" },
  { id_resourceStatusReportingInitiation, "id-resourceStatusReportingInitiation" },
  { id_resourceStatusReporting, "id-resourceStatusReporting" },
  { id_accessAndMobilityIndication, "id-accessAndMobilityIndication" },
  { id_accessSuccess, "id-accessSuccess" },
  { id_cellTrafficTrace, "id-cellTrafficTrace" },
  { id_PositioningMeasurementExchange, "id-PositioningMeasurementExchange" },
  { id_PositioningAssistanceInformationControl, "id-PositioningAssistanceInformationControl" },
  { id_PositioningAssistanceInformationFeedback, "id-PositioningAssistanceInformationFeedback" },
  { id_PositioningMeasurementReport, "id-PositioningMeasurementReport" },
  { id_PositioningMeasurementAbort, "id-PositioningMeasurementAbort" },
  { id_PositioningMeasurementFailureIndication, "id-PositioningMeasurementFailureIndication" },
  { id_PositioningMeasurementUpdate, "id-PositioningMeasurementUpdate" },
  { id_TRPInformationExchange, "id-TRPInformationExchange" },
  { id_PositioningInformationExchange, "id-PositioningInformationExchange" },
  { id_PositioningActivation, "id-PositioningActivation" },
  { id_PositioningDeactivation, "id-PositioningDeactivation" },
  { id_E_CIDMeasurementInitiation, "id-E-CIDMeasurementInitiation" },
  { id_E_CIDMeasurementFailureIndication, "id-E-CIDMeasurementFailureIndication" },
  { id_E_CIDMeasurementReport, "id-E-CIDMeasurementReport" },
  { id_E_CIDMeasurementTermination, "id-E-CIDMeasurementTermination" },
  { id_PositioningInformationUpdate, "id-PositioningInformationUpdate" },
  { id_ReferenceTimeInformationReport, "id-ReferenceTimeInformationReport" },
  { id_ReferenceTimeInformationReportingControl, "id-ReferenceTimeInformationReportingControl" },
  { id_BroadcastContextSetup, "id-BroadcastContextSetup" },
  { id_BroadcastContextRelease, "id-BroadcastContextRelease" },
  { id_BroadcastContextReleaseRequest, "id-BroadcastContextReleaseRequest" },
  { id_BroadcastContextModification, "id-BroadcastContextModification" },
  { id_MulticastGroupPaging, "id-MulticastGroupPaging" },
  { id_MulticastContextSetup, "id-MulticastContextSetup" },
  { id_MulticastContextRelease, "id-MulticastContextRelease" },
  { id_MulticastContextReleaseRequest, "id-MulticastContextReleaseRequest" },
  { id_MulticastContextModification, "id-MulticastContextModification" },
  { id_MulticastDistributionSetup, "id-MulticastDistributionSetup" },
  { id_MulticastDistributionRelease, "id-MulticastDistributionRelease" },
  { id_PDCMeasurementInitiation, "id-PDCMeasurementInitiation" },
  { id_PDCMeasurementReport, "id-PDCMeasurementReport" },
  { id_procedure_code_72_not_to_be_used, "id-procedure-code-72-not-to-be-used" },
  { id_procedure_code_73_not_to_be_used, "id-procedure-code-73-not-to-be-used" },
  { id_procedure_code_74_not_to_be_used, "id-procedure-code-74-not-to-be-used" },
  { id_pRSConfigurationExchange, "id-pRSConfigurationExchange" },
  { id_measurementPreconfiguration, "id-measurementPreconfiguration" },
  { id_measurementActivation, "id-measurementActivation" },
  { id_QoEInformationTransfer, "id-QoEInformationTransfer" },
  { id_PDCMeasurementTerminationCommand, "id-PDCMeasurementTerminationCommand" },
  { id_PDCMeasurementFailureIndication, "id-PDCMeasurementFailureIndication" },
  { id_PosSystemInformationDeliveryCommand, "id-PosSystemInformationDeliveryCommand" },
  { id_DUCUCellSwitchNotification, "id-DUCUCellSwitchNotification" },
  { id_CUDUCellSwitchNotification, "id-CUDUCellSwitchNotification" },
  { id_DUCUTAInformationTransfer, "id-DUCUTAInformationTransfer" },
  { id_CUDUTAInformationTransfer, "id-CUDUTAInformationTransfer" },
  { id_QoEInformationTransferControl, "id-QoEInformationTransferControl" },
  { id_RachIndication, "id-RachIndication" },
  { id_TimingSynchronisationStatus, "id-TimingSynchronisationStatus" },
  { id_TimingSynchronisationStatusReport, "id-TimingSynchronisationStatusReport" },
  { id_MIABF1SetupTriggering, "id-MIABF1SetupTriggering" },
  { id_MIABF1SetupOutcomeNotification, "id-MIABF1SetupOutcomeNotification" },
  { id_MulticastContextNotification, "id-MulticastContextNotification" },
  { id_MulticastCommonConfiguration, "id-MulticastCommonConfiguration" },
  { id_BroadcastTransportResourceRequest, "id-BroadcastTransportResourceRequest" },
  { id_DUCUAccessAndMobilityIndication, "id-DUCUAccessAndMobilityIndication" },
  { id_SRSInformationReservationNotification, "id-SRSInformationReservationNotification" },
  { id_CUDUMobilityInitiationRequest, "id-CUDUMobilityInitiationRequest" },
  { 0, NULL }
};

static value_string_ext f1ap_ProcedureCode_vals_ext = VALUE_STRING_EXT_INIT(f1ap_ProcedureCode_vals);


static int
dissect_f1ap_ProcedureCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &f1ap_data->procedure_code, false);


  return offset;
}



static int
dissect_f1ap_ProtocolExtensionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, &f1ap_data->protocol_extension_id, false);



  return offset;
}


static const value_string f1ap_ProtocolIE_ID_vals[] = {
  { id_Cause, "id-Cause" },
  { id_Cells_Failed_to_be_Activated_List, "id-Cells-Failed-to-be-Activated-List" },
  { id_Cells_Failed_to_be_Activated_List_Item, "id-Cells-Failed-to-be-Activated-List-Item" },
  { id_Cells_to_be_Activated_List, "id-Cells-to-be-Activated-List" },
  { id_Cells_to_be_Activated_List_Item, "id-Cells-to-be-Activated-List-Item" },
  { id_Cells_to_be_Deactivated_List, "id-Cells-to-be-Deactivated-List" },
  { id_Cells_to_be_Deactivated_List_Item, "id-Cells-to-be-Deactivated-List-Item" },
  { id_CriticalityDiagnostics, "id-CriticalityDiagnostics" },
  { id_CUtoDURRCInformation, "id-CUtoDURRCInformation" },
  { id_Unknown_10, "id-Unknown-10" },
  { id_Unknown_11, "id-Unknown-11" },
  { id_DRBs_FailedToBeModified_Item, "id-DRBs-FailedToBeModified-Item" },
  { id_DRBs_FailedToBeModified_List, "id-DRBs-FailedToBeModified-List" },
  { id_DRBs_FailedToBeSetup_Item, "id-DRBs-FailedToBeSetup-Item" },
  { id_DRBs_FailedToBeSetup_List, "id-DRBs-FailedToBeSetup-List" },
  { id_DRBs_FailedToBeSetupMod_Item, "id-DRBs-FailedToBeSetupMod-Item" },
  { id_DRBs_FailedToBeSetupMod_List, "id-DRBs-FailedToBeSetupMod-List" },
  { id_DRBs_ModifiedConf_Item, "id-DRBs-ModifiedConf-Item" },
  { id_DRBs_ModifiedConf_List, "id-DRBs-ModifiedConf-List" },
  { id_DRBs_Modified_Item, "id-DRBs-Modified-Item" },
  { id_DRBs_Modified_List, "id-DRBs-Modified-List" },
  { id_DRBs_Required_ToBeModified_Item, "id-DRBs-Required-ToBeModified-Item" },
  { id_DRBs_Required_ToBeModified_List, "id-DRBs-Required-ToBeModified-List" },
  { id_DRBs_Required_ToBeReleased_Item, "id-DRBs-Required-ToBeReleased-Item" },
  { id_DRBs_Required_ToBeReleased_List, "id-DRBs-Required-ToBeReleased-List" },
  { id_DRBs_Setup_Item, "id-DRBs-Setup-Item" },
  { id_DRBs_Setup_List, "id-DRBs-Setup-List" },
  { id_DRBs_SetupMod_Item, "id-DRBs-SetupMod-Item" },
  { id_DRBs_SetupMod_List, "id-DRBs-SetupMod-List" },
  { id_DRBs_ToBeModified_Item, "id-DRBs-ToBeModified-Item" },
  { id_DRBs_ToBeModified_List, "id-DRBs-ToBeModified-List" },
  { id_DRBs_ToBeReleased_Item, "id-DRBs-ToBeReleased-Item" },
  { id_DRBs_ToBeReleased_List, "id-DRBs-ToBeReleased-List" },
  { id_DRBs_ToBeSetup_Item, "id-DRBs-ToBeSetup-Item" },
  { id_DRBs_ToBeSetup_List, "id-DRBs-ToBeSetup-List" },
  { id_DRBs_ToBeSetupMod_Item, "id-DRBs-ToBeSetupMod-Item" },
  { id_DRBs_ToBeSetupMod_List, "id-DRBs-ToBeSetupMod-List" },
  { id_DRXCycle, "id-DRXCycle" },
  { id_DUtoCURRCInformation, "id-DUtoCURRCInformation" },
  { id_gNB_CU_UE_F1AP_ID, "id-gNB-CU-UE-F1AP-ID" },
  { id_gNB_DU_UE_F1AP_ID, "id-gNB-DU-UE-F1AP-ID" },
  { id_gNB_DU_ID, "id-gNB-DU-ID" },
  { id_GNB_DU_Served_Cells_Item, "id-GNB-DU-Served-Cells-Item" },
  { id_gNB_DU_Served_Cells_List, "id-gNB-DU-Served-Cells-List" },
  { id_gNB_DU_Name, "id-gNB-DU-Name" },
  { id_ProtocolIE_ID_46_not_to_be_used, "id-ProtocolIE-ID-46-not-to-be-used" },
  { id_oldgNB_DU_UE_F1AP_ID, "id-oldgNB-DU-UE-F1AP-ID" },
  { id_ResetType, "id-ResetType" },
  { id_ResourceCoordinationTransferContainer, "id-ResourceCoordinationTransferContainer" },
  { id_RRCContainer, "id-RRCContainer" },
  { id_SCell_ToBeRemoved_Item, "id-SCell-ToBeRemoved-Item" },
  { id_SCell_ToBeRemoved_List, "id-SCell-ToBeRemoved-List" },
  { id_SCell_ToBeSetup_Item, "id-SCell-ToBeSetup-Item" },
  { id_SCell_ToBeSetup_List, "id-SCell-ToBeSetup-List" },
  { id_SCell_ToBeSetupMod_Item, "id-SCell-ToBeSetupMod-Item" },
  { id_SCell_ToBeSetupMod_List, "id-SCell-ToBeSetupMod-List" },
  { id_Served_Cells_To_Add_Item, "id-Served-Cells-To-Add-Item" },
  { id_Served_Cells_To_Add_List, "id-Served-Cells-To-Add-List" },
  { id_Served_Cells_To_Delete_Item, "id-Served-Cells-To-Delete-Item" },
  { id_Served_Cells_To_Delete_List, "id-Served-Cells-To-Delete-List" },
  { id_Served_Cells_To_Modify_Item, "id-Served-Cells-To-Modify-Item" },
  { id_Served_Cells_To_Modify_List, "id-Served-Cells-To-Modify-List" },
  { id_SpCell_ID, "id-SpCell-ID" },
  { id_SRBID, "id-SRBID" },
  { id_SRBs_FailedToBeSetup_Item, "id-SRBs-FailedToBeSetup-Item" },
  { id_SRBs_FailedToBeSetup_List, "id-SRBs-FailedToBeSetup-List" },
  { id_SRBs_FailedToBeSetupMod_Item, "id-SRBs-FailedToBeSetupMod-Item" },
  { id_SRBs_FailedToBeSetupMod_List, "id-SRBs-FailedToBeSetupMod-List" },
  { id_SRBs_Required_ToBeReleased_Item, "id-SRBs-Required-ToBeReleased-Item" },
  { id_SRBs_Required_ToBeReleased_List, "id-SRBs-Required-ToBeReleased-List" },
  { id_SRBs_ToBeReleased_Item, "id-SRBs-ToBeReleased-Item" },
  { id_SRBs_ToBeReleased_List, "id-SRBs-ToBeReleased-List" },
  { id_SRBs_ToBeSetup_Item, "id-SRBs-ToBeSetup-Item" },
  { id_SRBs_ToBeSetup_List, "id-SRBs-ToBeSetup-List" },
  { id_SRBs_ToBeSetupMod_Item, "id-SRBs-ToBeSetupMod-Item" },
  { id_SRBs_ToBeSetupMod_List, "id-SRBs-ToBeSetupMod-List" },
  { id_TimeToWait, "id-TimeToWait" },
  { id_TransactionID, "id-TransactionID" },
  { id_TransmissionActionIndicator, "id-TransmissionActionIndicator" },
  { id_UE_associatedLogicalF1_ConnectionItem, "id-UE-associatedLogicalF1-ConnectionItem" },
  { id_UE_associatedLogicalF1_ConnectionListResAck, "id-UE-associatedLogicalF1-ConnectionListResAck" },
  { id_gNB_CU_Name, "id-gNB-CU-Name" },
  { id_SCell_FailedtoSetup_List, "id-SCell-FailedtoSetup-List" },
  { id_SCell_FailedtoSetup_Item, "id-SCell-FailedtoSetup-Item" },
  { id_SCell_FailedtoSetupMod_List, "id-SCell-FailedtoSetupMod-List" },
  { id_SCell_FailedtoSetupMod_Item, "id-SCell-FailedtoSetupMod-Item" },
  { id_RRCReconfigurationCompleteIndicator, "id-RRCReconfigurationCompleteIndicator" },
  { id_Cells_Status_Item, "id-Cells-Status-Item" },
  { id_Cells_Status_List, "id-Cells-Status-List" },
  { id_Candidate_SpCell_List, "id-Candidate-SpCell-List" },
  { id_Candidate_SpCell_Item, "id-Candidate-SpCell-Item" },
  { id_Potential_SpCell_List, "id-Potential-SpCell-List" },
  { id_Potential_SpCell_Item, "id-Potential-SpCell-Item" },
  { id_FullConfiguration, "id-FullConfiguration" },
  { id_C_RNTI, "id-C-RNTI" },
  { id_SpCellULConfigured, "id-SpCellULConfigured" },
  { id_InactivityMonitoringRequest, "id-InactivityMonitoringRequest" },
  { id_InactivityMonitoringResponse, "id-InactivityMonitoringResponse" },
  { id_DRB_Activity_Item, "id-DRB-Activity-Item" },
  { id_DRB_Activity_List, "id-DRB-Activity-List" },
  { id_EUTRA_NR_CellResourceCoordinationReq_Container, "id-EUTRA-NR-CellResourceCoordinationReq-Container" },
  { id_EUTRA_NR_CellResourceCoordinationReqAck_Container, "id-EUTRA-NR-CellResourceCoordinationReqAck-Container" },
  { id_Unknown_103, "id-Unknown-103" },
  { id_Unknown_104, "id-Unknown-104" },
  { id_Protected_EUTRA_Resources_List, "id-Protected-EUTRA-Resources-List" },
  { id_RequestType, "id-RequestType" },
  { id_ServCellIndex, "id-ServCellIndex" },
  { id_RAT_FrequencyPriorityInformation, "id-RAT-FrequencyPriorityInformation" },
  { id_ExecuteDuplication, "id-ExecuteDuplication" },
  { id_Unknown_110, "id-Unknown-110" },
  { id_NRCGI, "id-NRCGI" },
  { id_PagingCell_Item, "id-PagingCell-Item" },
  { id_PagingCell_List, "id-PagingCell-List" },
  { id_PagingDRX, "id-PagingDRX" },
  { id_PagingPriority, "id-PagingPriority" },
  { id_SItype_List, "id-SItype-List" },
  { id_UEIdentityIndexValue, "id-UEIdentityIndexValue" },
  { id_gNB_CUSystemInformation, "id-gNB-CUSystemInformation" },
  { id_HandoverPreparationInformation, "id-HandoverPreparationInformation" },
  { id_GNB_CU_TNL_Association_To_Add_Item, "id-GNB-CU-TNL-Association-To-Add-Item" },
  { id_GNB_CU_TNL_Association_To_Add_List, "id-GNB-CU-TNL-Association-To-Add-List" },
  { id_GNB_CU_TNL_Association_To_Remove_Item, "id-GNB-CU-TNL-Association-To-Remove-Item" },
  { id_GNB_CU_TNL_Association_To_Remove_List, "id-GNB-CU-TNL-Association-To-Remove-List" },
  { id_GNB_CU_TNL_Association_To_Update_Item, "id-GNB-CU-TNL-Association-To-Update-Item" },
  { id_GNB_CU_TNL_Association_To_Update_List, "id-GNB-CU-TNL-Association-To-Update-List" },
  { id_MaskedIMEISV, "id-MaskedIMEISV" },
  { id_PagingIdentity, "id-PagingIdentity" },
  { id_DUtoCURRCContainer, "id-DUtoCURRCContainer" },
  { id_Cells_to_be_Barred_List, "id-Cells-to-be-Barred-List" },
  { id_Cells_to_be_Barred_Item, "id-Cells-to-be-Barred-Item" },
  { id_TAISliceSupportList, "id-TAISliceSupportList" },
  { id_GNB_CU_TNL_Association_Setup_List, "id-GNB-CU-TNL-Association-Setup-List" },
  { id_GNB_CU_TNL_Association_Setup_Item, "id-GNB-CU-TNL-Association-Setup-Item" },
  { id_GNB_CU_TNL_Association_Failed_To_Setup_List, "id-GNB-CU-TNL-Association-Failed-To-Setup-List" },
  { id_GNB_CU_TNL_Association_Failed_To_Setup_Item, "id-GNB-CU-TNL-Association-Failed-To-Setup-Item" },
  { id_DRB_Notify_Item, "id-DRB-Notify-Item" },
  { id_DRB_Notify_List, "id-DRB-Notify-List" },
  { id_ProtocolIE_ID_138_not_to_be_used, "id-ProtocolIE-ID-138-not-to-be-used" },
  { id_RANAC, "id-RANAC" },
  { id_PWSSystemInformation, "id-PWSSystemInformation" },
  { id_RepetitionPeriod, "id-RepetitionPeriod" },
  { id_NumberofBroadcastRequest, "id-NumberofBroadcastRequest" },
  { id_Unknown_143, "id-Unknown-143" },
  { id_Cells_To_Be_Broadcast_List, "id-Cells-To-Be-Broadcast-List" },
  { id_Cells_To_Be_Broadcast_Item, "id-Cells-To-Be-Broadcast-Item" },
  { id_Cells_Broadcast_Completed_List, "id-Cells-Broadcast-Completed-List" },
  { id_Cells_Broadcast_Completed_Item, "id-Cells-Broadcast-Completed-Item" },
  { id_Broadcast_To_Be_Cancelled_List, "id-Broadcast-To-Be-Cancelled-List" },
  { id_Broadcast_To_Be_Cancelled_Item, "id-Broadcast-To-Be-Cancelled-Item" },
  { id_Cells_Broadcast_Cancelled_List, "id-Cells-Broadcast-Cancelled-List" },
  { id_Cells_Broadcast_Cancelled_Item, "id-Cells-Broadcast-Cancelled-Item" },
  { id_NR_CGI_List_For_Restart_List, "id-NR-CGI-List-For-Restart-List" },
  { id_NR_CGI_List_For_Restart_Item, "id-NR-CGI-List-For-Restart-Item" },
  { id_PWS_Failed_NR_CGI_List, "id-PWS-Failed-NR-CGI-List" },
  { id_PWS_Failed_NR_CGI_Item, "id-PWS-Failed-NR-CGI-Item" },
  { id_ConfirmedUEID, "id-ConfirmedUEID" },
  { id_Cancel_all_Warning_Messages_Indicator, "id-Cancel-all-Warning-Messages-Indicator" },
  { id_GNB_DU_UE_AMBR_UL, "id-GNB-DU-UE-AMBR-UL" },
  { id_DRXConfigurationIndicator, "id-DRXConfigurationIndicator" },
  { id_RLC_Status, "id-RLC-Status" },
  { id_DLPDCPSNLength, "id-DLPDCPSNLength" },
  { id_GNB_DUConfigurationQuery, "id-GNB-DUConfigurationQuery" },
  { id_MeasurementTimingConfiguration, "id-MeasurementTimingConfiguration" },
  { id_DRB_Information, "id-DRB-Information" },
  { id_ServingPLMN, "id-ServingPLMN" },
  { id_Unknown_166, "id-Unknown-166" },
  { id_Unknown_167, "id-Unknown-167" },
  { id_Protected_EUTRA_Resources_Item, "id-Protected-EUTRA-Resources-Item" },
  { id_Unknown_169, "id-Unknown-169" },
  { id_GNB_CU_RRC_Version, "id-GNB-CU-RRC-Version" },
  { id_GNB_DU_RRC_Version, "id-GNB-DU-RRC-Version" },
  { id_GNBDUOverloadInformation, "id-GNBDUOverloadInformation" },
  { id_CellGroupConfig, "id-CellGroupConfig" },
  { id_RLCFailureIndication, "id-RLCFailureIndication" },
  { id_UplinkTxDirectCurrentListInformation, "id-UplinkTxDirectCurrentListInformation" },
  { id_DC_Based_Duplication_Configured, "id-DC-Based-Duplication-Configured" },
  { id_DC_Based_Duplication_Activation, "id-DC-Based-Duplication-Activation" },
  { id_SULAccessIndication, "id-SULAccessIndication" },
  { id_AvailablePLMNList, "id-AvailablePLMNList" },
  { id_PDUSessionID, "id-PDUSessionID" },
  { id_ULPDUSessionAggregateMaximumBitRate, "id-ULPDUSessionAggregateMaximumBitRate" },
  { id_ServingCellMO, "id-ServingCellMO" },
  { id_QoSFlowMappingIndication, "id-QoSFlowMappingIndication" },
  { id_RRCDeliveryStatusRequest, "id-RRCDeliveryStatusRequest" },
  { id_RRCDeliveryStatus, "id-RRCDeliveryStatus" },
  { id_BearerTypeChange, "id-BearerTypeChange" },
  { id_RLCMode, "id-RLCMode" },
  { id_Duplication_Activation, "id-Duplication-Activation" },
  { id_Dedicated_SIDelivery_NeededUE_List, "id-Dedicated-SIDelivery-NeededUE-List" },
  { id_Dedicated_SIDelivery_NeededUE_Item, "id-Dedicated-SIDelivery-NeededUE-Item" },
  { id_DRX_LongCycleStartOffset, "id-DRX-LongCycleStartOffset" },
  { id_ULPDCPSNLength, "id-ULPDCPSNLength" },
  { id_SelectedBandCombinationIndex, "id-SelectedBandCombinationIndex" },
  { id_SelectedFeatureSetEntryIndex, "id-SelectedFeatureSetEntryIndex" },
  { id_ResourceCoordinationTransferInformation, "id-ResourceCoordinationTransferInformation" },
  { id_ExtendedServedPLMNs_List, "id-ExtendedServedPLMNs-List" },
  { id_ExtendedAvailablePLMN_List, "id-ExtendedAvailablePLMN-List" },
  { id_Associated_SCell_List, "id-Associated-SCell-List" },
  { id_latest_RRC_Version_Enhanced, "id-latest-RRC-Version-Enhanced" },
  { id_Associated_SCell_Item, "id-Associated-SCell-Item" },
  { id_Cell_Direction, "id-Cell-Direction" },
  { id_SRBs_Setup_List, "id-SRBs-Setup-List" },
  { id_SRBs_Setup_Item, "id-SRBs-Setup-Item" },
  { id_SRBs_SetupMod_List, "id-SRBs-SetupMod-List" },
  { id_SRBs_SetupMod_Item, "id-SRBs-SetupMod-Item" },
  { id_SRBs_Modified_List, "id-SRBs-Modified-List" },
  { id_SRBs_Modified_Item, "id-SRBs-Modified-Item" },
  { id_Ph_InfoSCG, "id-Ph-InfoSCG" },
  { id_RequestedBandCombinationIndex, "id-RequestedBandCombinationIndex" },
  { id_RequestedFeatureSetEntryIndex, "id-RequestedFeatureSetEntryIndex" },
  { id_RequestedP_MaxFR2, "id-RequestedP-MaxFR2" },
  { id_DRX_Config, "id-DRX-Config" },
  { id_IgnoreResourceCoordinationContainer, "id-IgnoreResourceCoordinationContainer" },
  { id_UEAssistanceInformation, "id-UEAssistanceInformation" },
  { id_NeedforGap, "id-NeedforGap" },
  { id_PagingOrigin, "id-PagingOrigin" },
  { id_new_gNB_CU_UE_F1AP_ID, "id-new-gNB-CU-UE-F1AP-ID" },
  { id_RedirectedRRCmessage, "id-RedirectedRRCmessage" },
  { id_new_gNB_DU_UE_F1AP_ID, "id-new-gNB-DU-UE-F1AP-ID" },
  { id_NotificationInformation, "id-NotificationInformation" },
  { id_PLMNAssistanceInfoForNetShar, "id-PLMNAssistanceInfoForNetShar" },
  { id_UEContextNotRetrievable, "id-UEContextNotRetrievable" },
  { id_BPLMN_ID_Info_List, "id-BPLMN-ID-Info-List" },
  { id_SelectedPLMNID, "id-SelectedPLMNID" },
  { id_UAC_Assistance_Info, "id-UAC-Assistance-Info" },
  { id_RANUEID, "id-RANUEID" },
  { id_GNB_DU_TNL_Association_To_Remove_Item, "id-GNB-DU-TNL-Association-To-Remove-Item" },
  { id_GNB_DU_TNL_Association_To_Remove_List, "id-GNB-DU-TNL-Association-To-Remove-List" },
  { id_TNLAssociationTransportLayerAddressgNBDU, "id-TNLAssociationTransportLayerAddressgNBDU" },
  { id_portNumber, "id-portNumber" },
  { id_AdditionalSIBMessageList, "id-AdditionalSIBMessageList" },
  { id_Cell_Type, "id-Cell-Type" },
  { id_IgnorePRACHConfiguration, "id-IgnorePRACHConfiguration" },
  { id_CG_Config, "id-CG-Config" },
  { id_PDCCH_BlindDetectionSCG, "id-PDCCH-BlindDetectionSCG" },
  { id_Requested_PDCCH_BlindDetectionSCG, "id-Requested-PDCCH-BlindDetectionSCG" },
  { id_Ph_InfoMCG, "id-Ph-InfoMCG" },
  { id_MeasGapSharingConfig, "id-MeasGapSharingConfig" },
  { id_systemInformationAreaID, "id-systemInformationAreaID" },
  { id_areaScope, "id-areaScope" },
  { id_RRCContainer_RRCSetupComplete, "id-RRCContainer-RRCSetupComplete" },
  { id_TraceActivation, "id-TraceActivation" },
  { id_TraceID, "id-TraceID" },
  { id_Neighbour_Cell_Information_List, "id-Neighbour-Cell-Information-List" },
  { id_Unknown_245, "id-Unknown-245" },
  { id_ProtocolIE_ID_246_not_to_be_used, "id-ProtocolIE-ID-246-not-to-be-used" },
  { id_ProtocolIE_ID_247_not_to_be_used, "id-ProtocolIE-ID-247-not-to-be-used" },
  { id_AdditionalRRMPriorityIndex, "id-AdditionalRRMPriorityIndex" },
  { id_DUCURadioInformationType, "id-DUCURadioInformationType" },
  { id_CUDURadioInformationType, "id-CUDURadioInformationType" },
  { id_AggressorgNBSetID, "id-AggressorgNBSetID" },
  { id_VictimgNBSetID, "id-VictimgNBSetID" },
  { id_LowerLayerPresenceStatusChange, "id-LowerLayerPresenceStatusChange" },
  { id_Transport_Layer_Address_Info, "id-Transport-Layer-Address-Info" },
  { id_Neighbour_Cell_Information_Item, "id-Neighbour-Cell-Information-Item" },
  { id_IntendedTDD_DL_ULConfig, "id-IntendedTDD-DL-ULConfig" },
  { id_QosMonitoringRequest, "id-QosMonitoringRequest" },
  { id_BHChannels_ToBeSetup_List, "id-BHChannels-ToBeSetup-List" },
  { id_BHChannels_ToBeSetup_Item, "id-BHChannels-ToBeSetup-Item" },
  { id_BHChannels_Setup_List, "id-BHChannels-Setup-List" },
  { id_BHChannels_Setup_Item, "id-BHChannels-Setup-Item" },
  { id_BHChannels_ToBeModified_Item, "id-BHChannels-ToBeModified-Item" },
  { id_BHChannels_ToBeModified_List, "id-BHChannels-ToBeModified-List" },
  { id_BHChannels_ToBeReleased_Item, "id-BHChannels-ToBeReleased-Item" },
  { id_BHChannels_ToBeReleased_List, "id-BHChannels-ToBeReleased-List" },
  { id_BHChannels_ToBeSetupMod_Item, "id-BHChannels-ToBeSetupMod-Item" },
  { id_BHChannels_ToBeSetupMod_List, "id-BHChannels-ToBeSetupMod-List" },
  { id_BHChannels_FailedToBeModified_Item, "id-BHChannels-FailedToBeModified-Item" },
  { id_BHChannels_FailedToBeModified_List, "id-BHChannels-FailedToBeModified-List" },
  { id_BHChannels_FailedToBeSetupMod_Item, "id-BHChannels-FailedToBeSetupMod-Item" },
  { id_BHChannels_FailedToBeSetupMod_List, "id-BHChannels-FailedToBeSetupMod-List" },
  { id_BHChannels_Modified_Item, "id-BHChannels-Modified-Item" },
  { id_BHChannels_Modified_List, "id-BHChannels-Modified-List" },
  { id_BHChannels_SetupMod_Item, "id-BHChannels-SetupMod-Item" },
  { id_BHChannels_SetupMod_List, "id-BHChannels-SetupMod-List" },
  { id_BHChannels_Required_ToBeReleased_Item, "id-BHChannels-Required-ToBeReleased-Item" },
  { id_BHChannels_Required_ToBeReleased_List, "id-BHChannels-Required-ToBeReleased-List" },
  { id_BHChannels_FailedToBeSetup_Item, "id-BHChannels-FailedToBeSetup-Item" },
  { id_BHChannels_FailedToBeSetup_List, "id-BHChannels-FailedToBeSetup-List" },
  { id_BHInfo, "id-BHInfo" },
  { id_BAPAddress, "id-BAPAddress" },
  { id_ConfiguredBAPAddress, "id-ConfiguredBAPAddress" },
  { id_BH_Routing_Information_Added_List, "id-BH-Routing-Information-Added-List" },
  { id_BH_Routing_Information_Added_List_Item, "id-BH-Routing-Information-Added-List-Item" },
  { id_BH_Routing_Information_Removed_List, "id-BH-Routing-Information-Removed-List" },
  { id_BH_Routing_Information_Removed_List_Item, "id-BH-Routing-Information-Removed-List-Item" },
  { id_UL_BH_Non_UP_Traffic_Mapping, "id-UL-BH-Non-UP-Traffic-Mapping" },
  { id_Activated_Cells_to_be_Updated_List, "id-Activated-Cells-to-be-Updated-List" },
  { id_Child_Nodes_List, "id-Child-Nodes-List" },
  { id_IAB_Info_IAB_DU, "id-IAB-Info-IAB-DU" },
  { id_IAB_Info_IAB_donor_CU, "id-IAB-Info-IAB-donor-CU" },
  { id_IAB_TNL_Addresses_To_Remove_List, "id-IAB-TNL-Addresses-To-Remove-List" },
  { id_IAB_TNL_Addresses_To_Remove_Item, "id-IAB-TNL-Addresses-To-Remove-Item" },
  { id_IAB_Allocated_TNL_Address_List, "id-IAB-Allocated-TNL-Address-List" },
  { id_IAB_Allocated_TNL_Address_Item, "id-IAB-Allocated-TNL-Address-Item" },
  { id_IABIPv6RequestType, "id-IABIPv6RequestType" },
  { id_IABv4AddressesRequested, "id-IABv4AddressesRequested" },
  { id_IAB_Barred, "id-IAB-Barred" },
  { id_TrafficMappingInformation, "id-TrafficMappingInformation" },
  { id_UL_UP_TNL_Information_to_Update_List, "id-UL-UP-TNL-Information-to-Update-List" },
  { id_UL_UP_TNL_Information_to_Update_List_Item, "id-UL-UP-TNL-Information-to-Update-List-Item" },
  { id_UL_UP_TNL_Address_to_Update_List, "id-UL-UP-TNL-Address-to-Update-List" },
  { id_UL_UP_TNL_Address_to_Update_List_Item, "id-UL-UP-TNL-Address-to-Update-List-Item" },
  { id_DL_UP_TNL_Address_to_Update_List, "id-DL-UP-TNL-Address-to-Update-List" },
  { id_DL_UP_TNL_Address_to_Update_List_Item, "id-DL-UP-TNL-Address-to-Update-List-Item" },
  { id_NRV2XServicesAuthorized, "id-NRV2XServicesAuthorized" },
  { id_LTEV2XServicesAuthorized, "id-LTEV2XServicesAuthorized" },
  { id_NRUESidelinkAggregateMaximumBitrate, "id-NRUESidelinkAggregateMaximumBitrate" },
  { id_LTEUESidelinkAggregateMaximumBitrate, "id-LTEUESidelinkAggregateMaximumBitrate" },
  { id_SIB12_message, "id-SIB12-message" },
  { id_SIB13_message, "id-SIB13-message" },
  { id_SIB14_message, "id-SIB14-message" },
  { id_SLDRBs_FailedToBeModified_Item, "id-SLDRBs-FailedToBeModified-Item" },
  { id_SLDRBs_FailedToBeModified_List, "id-SLDRBs-FailedToBeModified-List" },
  { id_SLDRBs_FailedToBeSetup_Item, "id-SLDRBs-FailedToBeSetup-Item" },
  { id_SLDRBs_FailedToBeSetup_List, "id-SLDRBs-FailedToBeSetup-List" },
  { id_SLDRBs_Modified_Item, "id-SLDRBs-Modified-Item" },
  { id_SLDRBs_Modified_List, "id-SLDRBs-Modified-List" },
  { id_SLDRBs_Required_ToBeModified_Item, "id-SLDRBs-Required-ToBeModified-Item" },
  { id_SLDRBs_Required_ToBeModified_List, "id-SLDRBs-Required-ToBeModified-List" },
  { id_SLDRBs_Required_ToBeReleased_Item, "id-SLDRBs-Required-ToBeReleased-Item" },
  { id_SLDRBs_Required_ToBeReleased_List, "id-SLDRBs-Required-ToBeReleased-List" },
  { id_SLDRBs_Setup_Item, "id-SLDRBs-Setup-Item" },
  { id_SLDRBs_Setup_List, "id-SLDRBs-Setup-List" },
  { id_SLDRBs_ToBeModified_Item, "id-SLDRBs-ToBeModified-Item" },
  { id_SLDRBs_ToBeModified_List, "id-SLDRBs-ToBeModified-List" },
  { id_SLDRBs_ToBeReleased_Item, "id-SLDRBs-ToBeReleased-Item" },
  { id_SLDRBs_ToBeReleased_List, "id-SLDRBs-ToBeReleased-List" },
  { id_SLDRBs_ToBeSetup_Item, "id-SLDRBs-ToBeSetup-Item" },
  { id_SLDRBs_ToBeSetup_List, "id-SLDRBs-ToBeSetup-List" },
  { id_SLDRBs_ToBeSetupMod_Item, "id-SLDRBs-ToBeSetupMod-Item" },
  { id_SLDRBs_ToBeSetupMod_List, "id-SLDRBs-ToBeSetupMod-List" },
  { id_SLDRBs_SetupMod_List, "id-SLDRBs-SetupMod-List" },
  { id_SLDRBs_FailedToBeSetupMod_List, "id-SLDRBs-FailedToBeSetupMod-List" },
  { id_SLDRBs_SetupMod_Item, "id-SLDRBs-SetupMod-Item" },
  { id_SLDRBs_FailedToBeSetupMod_Item, "id-SLDRBs-FailedToBeSetupMod-Item" },
  { id_SLDRBs_ModifiedConf_List, "id-SLDRBs-ModifiedConf-List" },
  { id_SLDRBs_ModifiedConf_Item, "id-SLDRBs-ModifiedConf-Item" },
  { id_UEAssistanceInformationEUTRA, "id-UEAssistanceInformationEUTRA" },
  { id_PC5LinkAMBR, "id-PC5LinkAMBR" },
  { id_SL_PHY_MAC_RLC_Config, "id-SL-PHY-MAC-RLC-Config" },
  { id_SL_ConfigDedicatedEUTRA_Info, "id-SL-ConfigDedicatedEUTRA-Info" },
  { id_AlternativeQoSParaSetList, "id-AlternativeQoSParaSetList" },
  { id_CurrentQoSParaSetIndex, "id-CurrentQoSParaSetIndex" },
  { id_gNBCUMeasurementID, "id-gNBCUMeasurementID" },
  { id_gNBDUMeasurementID, "id-gNBDUMeasurementID" },
  { id_RegistrationRequest, "id-RegistrationRequest" },
  { id_ReportCharacteristics, "id-ReportCharacteristics" },
  { id_CellToReportList, "id-CellToReportList" },
  { id_CellMeasurementResultList, "id-CellMeasurementResultList" },
  { id_HardwareLoadIndicator, "id-HardwareLoadIndicator" },
  { id_ReportingPeriodicity, "id-ReportingPeriodicity" },
  { id_TNLCapacityIndicator, "id-TNLCapacityIndicator" },
  { id_CarrierList, "id-CarrierList" },
  { id_ULCarrierList, "id-ULCarrierList" },
  { id_FrequencyShift7p5khz, "id-FrequencyShift7p5khz" },
  { id_SSB_PositionsInBurst, "id-SSB-PositionsInBurst" },
  { id_NRPRACHConfig, "id-NRPRACHConfig" },
  { id_RAReportList, "id-RAReportList" },
  { id_RLFReportInformationList, "id-RLFReportInformationList" },
  { id_TDD_UL_DLConfigCommonNR, "id-TDD-UL-DLConfigCommonNR" },
  { id_CNPacketDelayBudgetDownlink, "id-CNPacketDelayBudgetDownlink" },
  { id_ExtendedPacketDelayBudget, "id-ExtendedPacketDelayBudget" },
  { id_TSCTrafficCharacteristics, "id-TSCTrafficCharacteristics" },
  { id_ReportingRequestType, "id-ReportingRequestType" },
  { id_TimeReferenceInformation, "id-TimeReferenceInformation" },
  { id_Unknown_367, "id-Unknown-367" },
  { id_Unknown_368, "id-Unknown-368" },
  { id_CNPacketDelayBudgetUplink, "id-CNPacketDelayBudgetUplink" },
  { id_AdditionalPDCPDuplicationTNL_List, "id-AdditionalPDCPDuplicationTNL-List" },
  { id_RLCDuplicationInformation, "id-RLCDuplicationInformation" },
  { id_AdditionalDuplicationIndication, "id-AdditionalDuplicationIndication" },
  { id_ConditionalInterDUMobilityInformation, "id-ConditionalInterDUMobilityInformation" },
  { id_ConditionalIntraDUMobilityInformation, "id-ConditionalIntraDUMobilityInformation" },
  { id_targetCellsToCancel, "id-targetCellsToCancel" },
  { id_requestedTargetCellGlobalID, "id-requestedTargetCellGlobalID" },
  { id_ManagementBasedMDTPLMNList, "id-ManagementBasedMDTPLMNList" },
  { id_TraceCollectionEntityIPAddress, "id-TraceCollectionEntityIPAddress" },
  { id_PrivacyIndicator, "id-PrivacyIndicator" },
  { id_TraceCollectionEntityURI, "id-TraceCollectionEntityURI" },
  { id_mdtConfiguration, "id-mdtConfiguration" },
  { id_ServingNID, "id-ServingNID" },
  { id_NPNBroadcastInformation, "id-NPNBroadcastInformation" },
  { id_NPNSupportInfo, "id-NPNSupportInfo" },
  { id_NID, "id-NID" },
  { id_AvailableSNPN_ID_List, "id-AvailableSNPN-ID-List" },
  { id_SIB10_message, "id-SIB10-message" },
  { id_Unknown_388, "id-Unknown-388" },
  { id_DLCarrierList, "id-DLCarrierList" },
  { id_ExtendedTAISliceSupportList, "id-ExtendedTAISliceSupportList" },
  { id_RequestedSRSTransmissionCharacteristics, "id-RequestedSRSTransmissionCharacteristics" },
  { id_PosAssistance_Information, "id-PosAssistance-Information" },
  { id_PosBroadcast, "id-PosBroadcast" },
  { id_RoutingID, "id-RoutingID" },
  { id_PosAssistanceInformationFailureList, "id-PosAssistanceInformationFailureList" },
  { id_PosMeasurementQuantities, "id-PosMeasurementQuantities" },
  { id_PosMeasurementResultList, "id-PosMeasurementResultList" },
  { id_TRPInformationTypeListTRPReq, "id-TRPInformationTypeListTRPReq" },
  { id_TRPInformationTypeItem, "id-TRPInformationTypeItem" },
  { id_TRPInformationListTRPResp, "id-TRPInformationListTRPResp" },
  { id_TRPInformationItem, "id-TRPInformationItem" },
  { id_LMF_MeasurementID, "id-LMF-MeasurementID" },
  { id_SRSType, "id-SRSType" },
  { id_ActivationTime, "id-ActivationTime" },
  { id_AbortTransmission, "id-AbortTransmission" },
  { id_PositioningBroadcastCells, "id-PositioningBroadcastCells" },
  { id_SRSConfiguration, "id-SRSConfiguration" },
  { id_PosReportCharacteristics, "id-PosReportCharacteristics" },
  { id_PosMeasurementPeriodicity, "id-PosMeasurementPeriodicity" },
  { id_TRPList, "id-TRPList" },
  { id_RAN_MeasurementID, "id-RAN-MeasurementID" },
  { id_LMF_UE_MeasurementID, "id-LMF-UE-MeasurementID" },
  { id_RAN_UE_MeasurementID, "id-RAN-UE-MeasurementID" },
  { id_E_CID_MeasurementQuantities, "id-E-CID-MeasurementQuantities" },
  { id_E_CID_MeasurementQuantities_Item, "id-E-CID-MeasurementQuantities-Item" },
  { id_E_CID_MeasurementPeriodicity, "id-E-CID-MeasurementPeriodicity" },
  { id_E_CID_MeasurementResult, "id-E-CID-MeasurementResult" },
  { id_Cell_Portion_ID, "id-Cell-Portion-ID" },
  { id_SFNInitialisationTime, "id-SFNInitialisationTime" },
  { id_SystemFrameNumber, "id-SystemFrameNumber" },
  { id_SlotNumber, "id-SlotNumber" },
  { id_TRP_MeasurementRequestList, "id-TRP-MeasurementRequestList" },
  { id_MeasurementBeamInfoRequest, "id-MeasurementBeamInfoRequest" },
  { id_E_CID_ReportCharacteristics, "id-E-CID-ReportCharacteristics" },
  { id_ConfiguredTACIndication, "id-ConfiguredTACIndication" },
  { id_Extended_GNB_CU_Name, "id-Extended-GNB-CU-Name" },
  { id_Extended_GNB_DU_Name, "id-Extended-GNB-DU-Name" },
  { id_F1CTransferPath, "id-F1CTransferPath" },
  { id_SFN_Offset, "id-SFN-Offset" },
  { id_TransmissionStopIndicator, "id-TransmissionStopIndicator" },
  { id_SrsFrequency, "id-SrsFrequency" },
  { id_SCGIndicator, "id-SCGIndicator" },
  { id_EstimatedArrivalProbability, "id-EstimatedArrivalProbability" },
  { id_TRPType, "id-TRPType" },
  { id_SRSSpatialRelationPerSRSResource, "id-SRSSpatialRelationPerSRSResource" },
  { id_PDCPTerminatingNodeDLTNLAddrInfo, "id-PDCPTerminatingNodeDLTNLAddrInfo" },
  { id_ENBDLTNLAddress, "id-ENBDLTNLAddress" },
  { id_PosMeasurementPeriodicityExtended, "id-PosMeasurementPeriodicityExtended" },
  { id_PRS_Resource_ID, "id-PRS-Resource-ID" },
  { id_LocationMeasurementInformation, "id-LocationMeasurementInformation" },
  { id_SliceRadioResourceStatus, "id-SliceRadioResourceStatus" },
  { id_CompositeAvailableCapacity_SUL, "id-CompositeAvailableCapacity-SUL" },
  { id_SuccessfulHOReportInformationList, "id-SuccessfulHOReportInformationList" },
  { id_NR_U_Channel_List, "id-NR-U-Channel-List" },
  { id_NR_U, "id-NR-U" },
  { id_Coverage_Modification_Notification, "id-Coverage-Modification-Notification" },
  { id_CCO_Assistance_Information, "id-CCO-Assistance-Information" },
  { id_ProtocolIE_ID_448_not_to_be_used, "id-ProtocolIE-ID-448-not-to-be-used" },
  { id_CellsForSON_List, "id-CellsForSON-List" },
  { id_MIMOPRBusageInformation, "id-MIMOPRBusageInformation" },
  { id_gNB_CU_MBS_F1AP_ID, "id-gNB-CU-MBS-F1AP-ID" },
  { id_gNB_DU_MBS_F1AP_ID, "id-gNB-DU-MBS-F1AP-ID" },
  { id_ProtocolIE_ID_453_not_to_be_used, "id-ProtocolIE-ID-453-not-to-be-used" },
  { id_MBS_CUtoDURRCInformation, "id-MBS-CUtoDURRCInformation" },
  { id_MBS_Session_ID, "id-MBS-Session-ID" },
  { id_SNSSAI, "id-SNSSAI" },
  { id_MBS_Broadcast_NeighbourCellList, "id-MBS-Broadcast-NeighbourCellList" },
  { id_BroadcastMRBs_FailedToBeModified_List, "id-BroadcastMRBs-FailedToBeModified-List" },
  { id_BroadcastMRBs_FailedToBeModified_Item, "id-BroadcastMRBs-FailedToBeModified-Item" },
  { id_BroadcastMRBs_FailedToBeSetup_List, "id-BroadcastMRBs-FailedToBeSetup-List" },
  { id_BroadcastMRBs_FailedToBeSetup_Item, "id-BroadcastMRBs-FailedToBeSetup-Item" },
  { id_BroadcastMRBs_FailedToBeSetupMod_List, "id-BroadcastMRBs-FailedToBeSetupMod-List" },
  { id_BroadcastMRBs_FailedToBeSetupMod_Item, "id-BroadcastMRBs-FailedToBeSetupMod-Item" },
  { id_BroadcastMRBs_Modified_List, "id-BroadcastMRBs-Modified-List" },
  { id_BroadcastMRBs_Modified_Item, "id-BroadcastMRBs-Modified-Item" },
  { id_BroadcastMRBs_Setup_List, "id-BroadcastMRBs-Setup-List" },
  { id_BroadcastMRBs_Setup_Item, "id-BroadcastMRBs-Setup-Item" },
  { id_BroadcastMRBs_SetupMod_List, "id-BroadcastMRBs-SetupMod-List" },
  { id_BroadcastMRBs_SetupMod_Item, "id-BroadcastMRBs-SetupMod-Item" },
  { id_BroadcastMRBs_ToBeModified_List, "id-BroadcastMRBs-ToBeModified-List" },
  { id_BroadcastMRBs_ToBeModified_Item, "id-BroadcastMRBs-ToBeModified-Item" },
  { id_BroadcastMRBs_ToBeReleased_List, "id-BroadcastMRBs-ToBeReleased-List" },
  { id_BroadcastMRBs_ToBeReleased_Item, "id-BroadcastMRBs-ToBeReleased-Item" },
  { id_BroadcastMRBs_ToBeSetup_List, "id-BroadcastMRBs-ToBeSetup-List" },
  { id_BroadcastMRBs_ToBeSetup_Item, "id-BroadcastMRBs-ToBeSetup-Item" },
  { id_BroadcastMRBs_ToBeSetupMod_List, "id-BroadcastMRBs-ToBeSetupMod-List" },
  { id_BroadcastMRBs_ToBeSetupMod_Item, "id-BroadcastMRBs-ToBeSetupMod-Item" },
  { id_Supported_MBS_FSA_ID_List, "id-Supported-MBS-FSA-ID-List" },
  { id_UEIdentity_List_For_Paging_List, "id-UEIdentity-List-For-Paging-List" },
  { id_UEIdentity_List_For_Paging_Item, "id-UEIdentity-List-For-Paging-Item" },
  { id_MBS_ServiceArea, "id-MBS-ServiceArea" },
  { id_MulticastMRBs_FailedToBeModified_List, "id-MulticastMRBs-FailedToBeModified-List" },
  { id_MulticastMRBs_FailedToBeModified_Item, "id-MulticastMRBs-FailedToBeModified-Item" },
  { id_MulticastMRBs_FailedToBeSetup_List, "id-MulticastMRBs-FailedToBeSetup-List" },
  { id_MulticastMRBs_FailedToBeSetup_Item, "id-MulticastMRBs-FailedToBeSetup-Item" },
  { id_MulticastMRBs_FailedToBeSetupMod_List, "id-MulticastMRBs-FailedToBeSetupMod-List" },
  { id_MulticastMRBs_FailedToBeSetupMod_Item, "id-MulticastMRBs-FailedToBeSetupMod-Item" },
  { id_MulticastMRBs_Modified_List, "id-MulticastMRBs-Modified-List" },
  { id_MulticastMRBs_Modified_Item, "id-MulticastMRBs-Modified-Item" },
  { id_MulticastMRBs_Setup_List, "id-MulticastMRBs-Setup-List" },
  { id_MulticastMRBs_Setup_Item, "id-MulticastMRBs-Setup-Item" },
  { id_MulticastMRBs_SetupMod_List, "id-MulticastMRBs-SetupMod-List" },
  { id_MulticastMRBs_SetupMod_Item, "id-MulticastMRBs-SetupMod-Item" },
  { id_MulticastMRBs_ToBeModified_List, "id-MulticastMRBs-ToBeModified-List" },
  { id_MulticastMRBs_ToBeModified_Item, "id-MulticastMRBs-ToBeModified-Item" },
  { id_MulticastMRBs_ToBeReleased_List, "id-MulticastMRBs-ToBeReleased-List" },
  { id_MulticastMRBs_ToBeReleased_Item, "id-MulticastMRBs-ToBeReleased-Item" },
  { id_MulticastMRBs_ToBeSetup_List, "id-MulticastMRBs-ToBeSetup-List" },
  { id_MulticastMRBs_ToBeSetup_Item, "id-MulticastMRBs-ToBeSetup-Item" },
  { id_MulticastMRBs_ToBeSetupMod_List, "id-MulticastMRBs-ToBeSetupMod-List" },
  { id_MulticastMRBs_ToBeSetupMod_Item, "id-MulticastMRBs-ToBeSetupMod-Item" },
  { id_MBSMulticastF1UContextDescriptor, "id-MBSMulticastF1UContextDescriptor" },
  { id_MulticastF1UContext_ToBeSetup_List, "id-MulticastF1UContext-ToBeSetup-List" },
  { id_MulticastF1UContext_ToBeSetup_Item, "id-MulticastF1UContext-ToBeSetup-Item" },
  { id_MulticastF1UContext_Setup_List, "id-MulticastF1UContext-Setup-List" },
  { id_MulticastF1UContext_Setup_Item, "id-MulticastF1UContext-Setup-Item" },
  { id_MulticastF1UContext_FailedToBeSetup_List, "id-MulticastF1UContext-FailedToBeSetup-List" },
  { id_MulticastF1UContext_FailedToBeSetup_Item, "id-MulticastF1UContext-FailedToBeSetup-Item" },
  { id_IABCongestionIndication, "id-IABCongestionIndication" },
  { id_IABConditionalRRCMessageDeliveryIndication, "id-IABConditionalRRCMessageDeliveryIndication" },
  { id_F1CTransferPathNRDC, "id-F1CTransferPathNRDC" },
  { id_BufferSizeThresh, "id-BufferSizeThresh" },
  { id_IAB_TNL_Addresses_Exception, "id-IAB-TNL-Addresses-Exception" },
  { id_BAP_Header_Rewriting_Added_List, "id-BAP-Header-Rewriting-Added-List" },
  { id_BAP_Header_Rewriting_Added_List_Item, "id-BAP-Header-Rewriting-Added-List-Item" },
  { id_Re_routingEnableIndicator, "id-Re-routingEnableIndicator" },
  { id_NonF1terminatingTopologyIndicator, "id-NonF1terminatingTopologyIndicator" },
  { id_EgressNonF1terminatingTopologyIndicator, "id-EgressNonF1terminatingTopologyIndicator" },
  { id_IngressNonF1terminatingTopologyIndicator, "id-IngressNonF1terminatingTopologyIndicator" },
  { id_rBSetConfiguration, "id-rBSetConfiguration" },
  { id_frequency_Domain_HSNA_Configuration_List, "id-frequency-Domain-HSNA-Configuration-List" },
  { id_child_IAB_Nodes_NA_Resource_List, "id-child-IAB-Nodes-NA-Resource-List" },
  { id_Parent_IAB_Nodes_NA_Resource_Configuration_List, "id-Parent-IAB-Nodes-NA-Resource-Configuration-List" },
  { id_uL_FreqInfo, "id-uL-FreqInfo" },
  { id_uL_Transmission_Bandwidth, "id-uL-Transmission-Bandwidth" },
  { id_dL_FreqInfo, "id-dL-FreqInfo" },
  { id_dL_Transmission_Bandwidth, "id-dL-Transmission-Bandwidth" },
  { id_uL_NR_Carrier_List, "id-uL-NR-Carrier-List" },
  { id_dL_NR_Carrier_List, "id-dL-NR-Carrier-List" },
  { id_nRFreqInfo, "id-nRFreqInfo" },
  { id_transmission_Bandwidth, "id-transmission-Bandwidth" },
  { id_nR_Carrier_List, "id-nR-Carrier-List" },
  { id_Neighbour_Node_Cells_List, "id-Neighbour-Node-Cells-List" },
  { id_Serving_Cells_List, "id-Serving-Cells-List" },
  { id_permutation, "id-permutation" },
  { id_MDTPollutedMeasurementIndicator, "id-MDTPollutedMeasurementIndicator" },
  { id_M5ReportAmount, "id-M5ReportAmount" },
  { id_M6ReportAmount, "id-M6ReportAmount" },
  { id_M7ReportAmount, "id-M7ReportAmount" },
  { id_SurvivalTime, "id-SurvivalTime" },
  { id_PDCMeasurementPeriodicity, "id-PDCMeasurementPeriodicity" },
  { id_PDCMeasurementQuantities, "id-PDCMeasurementQuantities" },
  { id_PDCMeasurementQuantities_Item, "id-PDCMeasurementQuantities-Item" },
  { id_PDCMeasurementResult, "id-PDCMeasurementResult" },
  { id_PDCReportType, "id-PDCReportType" },
  { id_RAN_UE_PDC_MeasID, "id-RAN-UE-PDC-MeasID" },
  { id_SCGActivationRequest, "id-SCGActivationRequest" },
  { id_SCGActivationStatus, "id-SCGActivationStatus" },
  { id_PRSTRPList, "id-PRSTRPList" },
  { id_PRSTransmissionTRPList, "id-PRSTransmissionTRPList" },
  { id_OnDemandPRS, "id-OnDemandPRS" },
  { id_AoA_SearchWindow, "id-AoA-SearchWindow" },
  { id_TRP_MeasurementUpdateList, "id-TRP-MeasurementUpdateList" },
  { id_ZoAInformation, "id-ZoAInformation" },
  { id_ResponseTime, "id-ResponseTime" },
  { id_ARPLocationInfo, "id-ARPLocationInfo" },
  { id_ARP_ID, "id-ARP-ID" },
  { id_MultipleULAoA, "id-MultipleULAoA" },
  { id_UL_SRS_RSRPP, "id-UL-SRS-RSRPP" },
  { id_SRSResourcetype, "id-SRSResourcetype" },
  { id_ExtendedAdditionalPathList, "id-ExtendedAdditionalPathList" },
  { id_LoS_NLoSInformation, "id-LoS-NLoSInformation" },
  { id_Unknown_563, "id-Unknown-563" },
  { id_NumberOfTRPRxTEG, "id-NumberOfTRPRxTEG" },
  { id_NumberOfTRPRxTxTEG, "id-NumberOfTRPRxTxTEG" },
  { id_TRPTxTEGAssociation, "id-TRPTxTEGAssociation" },
  { id_TRPTEGInformation, "id-TRPTEGInformation" },
  { id_TRPRx_TEGInformation, "id-TRPRx-TEGInformation" },
  { id_TRP_PRS_Info_List, "id-TRP-PRS-Info-List" },
  { id_PRS_Measurement_Info_List, "id-PRS-Measurement-Info-List" },
  { id_PRSConfigRequestType, "id-PRSConfigRequestType" },
  { id_Unknown_572, "id-Unknown-572" },
  { id_MeasurementTimeOccasion, "id-MeasurementTimeOccasion" },
  { id_MeasurementCharacteristicsRequestIndicator, "id-MeasurementCharacteristicsRequestIndicator" },
  { id_UEReportingInformation, "id-UEReportingInformation" },
  { id_PosContextRevIndication, "id-PosContextRevIndication" },
  { id_TRPBeamAntennaInformation, "id-TRPBeamAntennaInformation" },
  { id_NRRedCapUEIndication, "id-NRRedCapUEIndication" },
  { id_Redcap_Bcast_Information, "id-Redcap-Bcast-Information" },
  { id_RANUEPagingDRX, "id-RANUEPagingDRX" },
  { id_CNUEPagingDRX, "id-CNUEPagingDRX" },
  { id_NRPagingeDRXInformation, "id-NRPagingeDRXInformation" },
  { id_NRPagingeDRXInformationforRRCINACTIVE, "id-NRPagingeDRXInformationforRRCINACTIVE" },
  { id_NR_TADV, "id-NR-TADV" },
  { id_QoEInformation, "id-QoEInformation" },
  { id_CG_SDTQueryIndication, "id-CG-SDTQueryIndication" },
  { id_SDT_MAC_PHY_CG_Config, "id-SDT-MAC-PHY-CG-Config" },
  { id_CG_SDTKeptIndicator, "id-CG-SDTKeptIndicator" },
  { id_CG_SDTindicatorSetup, "id-CG-SDTindicatorSetup" },
  { id_CG_SDTindicatorMod, "id-CG-SDTindicatorMod" },
  { id_CG_SDTSessionInfoOld, "id-CG-SDTSessionInfoOld" },
  { id_SDTInformation, "id-SDTInformation" },
  { id_SDTRLCBearerConfiguration, "id-SDTRLCBearerConfiguration" },
  { id_FiveG_ProSeAuthorized, "id-FiveG-ProSeAuthorized" },
  { id_FiveG_ProSeUEPC5AggregateMaximumBitrate, "id-FiveG-ProSeUEPC5AggregateMaximumBitrate" },
  { id_FiveG_ProSePC5LinkAMBR, "id-FiveG-ProSePC5LinkAMBR" },
  { id_SRBMappingInfo, "id-SRBMappingInfo" },
  { id_DRBMappingInfo, "id-DRBMappingInfo" },
  { id_UuRLCChannelToBeSetupList, "id-UuRLCChannelToBeSetupList" },
  { id_UuRLCChannelToBeModifiedList, "id-UuRLCChannelToBeModifiedList" },
  { id_UuRLCChannelToBeReleasedList, "id-UuRLCChannelToBeReleasedList" },
  { id_UuRLCChannelSetupList, "id-UuRLCChannelSetupList" },
  { id_UuRLCChannelFailedToBeSetupList, "id-UuRLCChannelFailedToBeSetupList" },
  { id_UuRLCChannelModifiedList, "id-UuRLCChannelModifiedList" },
  { id_UuRLCChannelFailedToBeModifiedList, "id-UuRLCChannelFailedToBeModifiedList" },
  { id_UuRLCChannelRequiredToBeModifiedList, "id-UuRLCChannelRequiredToBeModifiedList" },
  { id_UuRLCChannelRequiredToBeReleasedList, "id-UuRLCChannelRequiredToBeReleasedList" },
  { id_PC5RLCChannelToBeSetupList, "id-PC5RLCChannelToBeSetupList" },
  { id_PC5RLCChannelToBeModifiedList, "id-PC5RLCChannelToBeModifiedList" },
  { id_PC5RLCChannelToBeReleasedList, "id-PC5RLCChannelToBeReleasedList" },
  { id_PC5RLCChannelSetupList, "id-PC5RLCChannelSetupList" },
  { id_PC5RLCChannelFailedToBeSetupList, "id-PC5RLCChannelFailedToBeSetupList" },
  { id_PC5RLCChannelFailedToBeModifiedList, "id-PC5RLCChannelFailedToBeModifiedList" },
  { id_PC5RLCChannelRequiredToBeModifiedList, "id-PC5RLCChannelRequiredToBeModifiedList" },
  { id_PC5RLCChannelRequiredToBeReleasedList, "id-PC5RLCChannelRequiredToBeReleasedList" },
  { id_PC5RLCChannelModifiedList, "id-PC5RLCChannelModifiedList" },
  { id_SidelinkRelayConfiguration, "id-SidelinkRelayConfiguration" },
  { id_UpdatedRemoteUELocalID, "id-UpdatedRemoteUELocalID" },
  { id_PathSwitchConfiguration, "id-PathSwitchConfiguration" },
  { id_PagingCause, "id-PagingCause" },
  { id_MUSIM_GapConfig, "id-MUSIM-GapConfig" },
  { id_PEIPSAssistanceInfo, "id-PEIPSAssistanceInfo" },
  { id_UEPagingCapability, "id-UEPagingCapability" },
  { id_LastUsedCellIndication, "id-LastUsedCellIndication" },
  { id_SIB17_message, "id-SIB17-message" },
  { id_GNBDUUESliceMaximumBitRateList, "id-GNBDUUESliceMaximumBitRateList" },
  { id_SIB20_message, "id-SIB20-message" },
  { id_UE_MulticastMRBs_ToBeReleased_List, "id-UE-MulticastMRBs-ToBeReleased-List" },
  { id_UE_MulticastMRBs_ToBeReleased_Item, "id-UE-MulticastMRBs-ToBeReleased-Item" },
  { id_UE_MulticastMRBs_ToBeSetup_List, "id-UE-MulticastMRBs-ToBeSetup-List" },
  { id_UE_MulticastMRBs_ToBeSetup_Item, "id-UE-MulticastMRBs-ToBeSetup-Item" },
  { id_MulticastMBSSessionSetupList, "id-MulticastMBSSessionSetupList" },
  { id_MulticastMBSSessionRemoveList, "id-MulticastMBSSessionRemoveList" },
  { id_PosMeasurementAmount, "id-PosMeasurementAmount" },
  { id_SDT_Termination_Request, "id-SDT-Termination-Request" },
  { id_pathPower, "id-pathPower" },
  { id_DU_RX_MT_RX_Extend, "id-DU-RX-MT-RX-Extend" },
  { id_DU_TX_MT_TX_Extend, "id-DU-TX-MT-TX-Extend" },
  { id_DU_RX_MT_TX_Extend, "id-DU-RX-MT-TX-Extend" },
  { id_DU_TX_MT_RX_Extend, "id-DU-TX-MT-RX-Extend" },
  { id_BAP_Header_Rewriting_Removed_List, "id-BAP-Header-Rewriting-Removed-List" },
  { id_BAP_Header_Rewriting_Removed_List_Item, "id-BAP-Header-Rewriting-Removed-List-Item" },
  { id_SLDRXCycleList, "id-SLDRXCycleList" },
  { id_TAINSAGSupportList, "id-TAINSAGSupportList" },
  { id_SL_RLC_ChannelToAddModList, "id-SL-RLC-ChannelToAddModList" },
  { id_BroadcastAreaScope, "id-BroadcastAreaScope" },
  { id_ManagementBasedMDTPLMNModificationList, "id-ManagementBasedMDTPLMNModificationList" },
  { id_SIB15_message, "id-SIB15-message" },
  { id_ActivationRequestType, "id-ActivationRequestType" },
  { id_PosMeasGapPreConfigList, "id-PosMeasGapPreConfigList" },
  { id_InterFrequencyConfig_NoGap, "id-InterFrequencyConfig-NoGap" },
  { id_MBSInterestIndication, "id-MBSInterestIndication" },
  { id_UE_MulticastMRBs_ConfirmedToBeModified_List, "id-UE-MulticastMRBs-ConfirmedToBeModified-List" },
  { id_UE_MulticastMRBs_ConfirmedToBeModified_Item, "id-UE-MulticastMRBs-ConfirmedToBeModified-Item" },
  { id_UE_MulticastMRBs_RequiredToBeModified_List, "id-UE-MulticastMRBs-RequiredToBeModified-List" },
  { id_UE_MulticastMRBs_RequiredToBeModified_Item, "id-UE-MulticastMRBs-RequiredToBeModified-Item" },
  { id_UE_MulticastMRBs_RequiredToBeReleased_List, "id-UE-MulticastMRBs-RequiredToBeReleased-List" },
  { id_UE_MulticastMRBs_RequiredToBeReleased_Item, "id-UE-MulticastMRBs-RequiredToBeReleased-Item" },
  { id_L571Info, "id-L571Info" },
  { id_L1151Info, "id-L1151Info" },
  { id_SCS_480, "id-SCS-480" },
  { id_SCS_960, "id-SCS-960" },
  { id_SRSPortIndex, "id-SRSPortIndex" },
  { id_PEISubgroupingSupportIndication, "id-PEISubgroupingSupportIndication" },
  { id_NeedForGapsInfoNR, "id-NeedForGapsInfoNR" },
  { id_NeedForGapNCSGInfoNR, "id-NeedForGapNCSGInfoNR" },
  { id_NeedForGapNCSGInfoEUTRA, "id-NeedForGapNCSGInfoEUTRA" },
  { id_ProtocolIE_ID_668_not_to_be_used, "id-ProtocolIE-ID-668-not-to-be-used" },
  { id_ProtocolIE_ID_669_not_to_be_used, "id-ProtocolIE-ID-669-not-to-be-used" },
  { id_ProtocolIE_ID_670_not_to_be_used, "id-ProtocolIE-ID-670-not-to-be-used" },
  { id_Source_MRB_ID, "id-Source-MRB-ID" },
  { id_PosMeasurementPeriodicityNR_AoA, "id-PosMeasurementPeriodicityNR-AoA" },
  { id_RedCapIndication, "id-RedCapIndication" },
  { id_SRSPosRRCInactiveConfig, "id-SRSPosRRCInactiveConfig" },
  { id_SDTBearerConfigurationQueryIndication, "id-SDTBearerConfigurationQueryIndication" },
  { id_SDTBearerConfigurationInfo, "id-SDTBearerConfigurationInfo" },
  { id_UL_GapFR2_Config, "id-UL-GapFR2-Config" },
  { id_ConfigRestrictInfoDAPS, "id-ConfigRestrictInfoDAPS" },
  { id_UE_MulticastMRBs_Setup_List, "id-UE-MulticastMRBs-Setup-List" },
  { id_UE_MulticastMRBs_Setup_Item, "id-UE-MulticastMRBs-Setup-Item" },
  { id_MulticastF1UContextReferenceCU, "id-MulticastF1UContextReferenceCU" },
  { id_PosSItypeList, "id-PosSItypeList" },
  { id_DAPS_HO_Status, "id-DAPS-HO-Status" },
  { id_UplinkTxDirectCurrentTwoCarrierListInfo, "id-UplinkTxDirectCurrentTwoCarrierListInfo" },
  { id_UE_MulticastMRBs_ToBeSetup_atModify_List, "id-UE-MulticastMRBs-ToBeSetup-atModify-List" },
  { id_UE_MulticastMRBs_ToBeSetup_atModify_Item, "id-UE-MulticastMRBs-ToBeSetup-atModify-Item" },
  { id_MC_PagingCell_List, "id-MC-PagingCell-List" },
  { id_MC_PagingCell_Item, "id-MC-PagingCell-Item" },
  { id_SRSPosRRCInactiveQueryIndication, "id-SRSPosRRCInactiveQueryIndication" },
  { id_UlTxDirectCurrentMoreCarrierInformation, "id-UlTxDirectCurrentMoreCarrierInformation" },
  { id_CPACMCGInformation, "id-CPACMCGInformation" },
  { id_TwoPHRModeMCG, "id-TwoPHRModeMCG" },
  { id_TwoPHRModeSCG, "id-TwoPHRModeSCG" },
  { id_ExtendedUEIdentityIndexValue, "id-ExtendedUEIdentityIndexValue" },
  { id_ServingCellMO_List, "id-ServingCellMO-List" },
  { id_ServingCellMO_List_Item, "id-ServingCellMO-List-Item" },
  { id_ServingCellMO_encoded_in_CGC_List, "id-ServingCellMO-encoded-in-CGC-List" },
  { id_HashedUEIdentityIndexValue, "id-HashedUEIdentityIndexValue" },
  { id_UE_MulticastMRBs_Setupnew_List, "id-UE-MulticastMRBs-Setupnew-List" },
  { id_UE_MulticastMRBs_Setupnew_Item, "id-UE-MulticastMRBs-Setupnew-Item" },
  { id_ncd_SSB_RedCapInitialBWP_SDT, "id-ncd-SSB-RedCapInitialBWP-SDT" },
  { id_nrofSymbolsExtended, "id-nrofSymbolsExtended" },
  { id_repetitionFactorExtended, "id-repetitionFactorExtended" },
  { id_startRBHopping, "id-startRBHopping" },
  { id_startRBIndex, "id-startRBIndex" },
  { id_transmissionCombn8, "id-transmissionCombn8" },
  { id_ServCellInfoList, "id-ServCellInfoList" },
  { id_DedicatedSIDeliveryIndication, "id-DedicatedSIDeliveryIndication" },
  { id_Configured_BWP_List, "id-Configured-BWP-List" },
  { id_Preconfigured_measurement_GAP_Request, "id-Preconfigured-measurement-GAP-Request" },
  { id_BWP_Id, "id-BWP-Id" },
  { id_NetworkControlledRepeaterAuthorized, "id-NetworkControlledRepeaterAuthorized" },
  { id_MT_SDT_Information, "id-MT-SDT-Information" },
  { id_ExtendedResourceSymbolOffset, "id-ExtendedResourceSymbolOffset" },
  { id_NeedForInterruptionInfoNR, "id-NeedForInterruptionInfoNR" },
  { id_SDT_Volume_Threshold, "id-SDT-Volume-Threshold" },
  { id_SupportedUETypeList, "id-SupportedUETypeList" },
  { id_MusimCapabilityRestrictionIndication, "id-MusimCapabilityRestrictionIndication" },
  { id_duplicationIndication, "id-duplicationIndication" },
  { id_LTMInformation_Setup, "id-LTMInformation-Setup" },
  { id_LTMConfigurationIDMappingList, "id-LTMConfigurationIDMappingList" },
  { id_LTMInformation_Modify, "id-LTMInformation-Modify" },
  { id_LTMCells_ToBeReleased_List, "id-LTMCells-ToBeReleased-List" },
  { id_ProtocolIE_ID_724_not_to_be_used, "id-ProtocolIE-ID-724-not-to-be-used" },
  { id_LTMConfiguration, "id-LTMConfiguration" },
  { id_EarlySyncInformation_Request, "id-EarlySyncInformation-Request" },
  { id_EarlySyncInformation, "id-EarlySyncInformation" },
  { id_EarlySyncCandidateCellInformation_List, "id-EarlySyncCandidateCellInformation-List" },
  { id_LTMCellSwitchInformation, "id-LTMCellSwitchInformation" },
  { id_DUtoCUTAInformation_List, "id-DUtoCUTAInformation-List" },
  { id_ProtocolIE_ID_731_not_to_be_used, "id-ProtocolIE-ID-731-not-to-be-used" },
  { id_dRB_List, "id-dRB-List" },
  { id_DeactivationIndication, "id-DeactivationIndication" },
  { id_RAReportIndicationList, "id-RAReportIndicationList" },
  { id_ChannelOccupancyTimePercentageUL, "id-ChannelOccupancyTimePercentageUL" },
  { id_SuccessfulPSCellChangeReportInformationList, "id-SuccessfulPSCellChangeReportInformationList" },
  { id_RadioResourceStatusNR_U, "id-RadioResourceStatusNR-U" },
  { id_FiveG_ProSeLayer2Multipath, "id-FiveG-ProSeLayer2Multipath" },
  { id_FiveG_ProSeLayer2UEtoUERelay, "id-FiveG-ProSeLayer2UEtoUERelay" },
  { id_FiveG_ProSeLayer2UEtoUERemote, "id-FiveG-ProSeLayer2UEtoUERemote" },
  { id_PathAdditionInformation, "id-PathAdditionInformation" },
  { id_Recommended_SSBs_List, "id-Recommended-SSBs-List" },
  { id_Recommended_SSBs_for_Paging_List, "id-Recommended-SSBs-for-Paging-List" },
  { id_SSBs_withinTheCell_tobe_Activated_List, "id-SSBs-withinTheCell-tobe-Activated-List" },
  { id_Cells_With_SSBs_Activated_List, "id-Cells-With-SSBs-Activated-List" },
  { id_Cells_Allowed_to_be_Deactivated_List, "id-Cells-Allowed-to-be-Deactivated-List" },
  { id_Cells_Allowed_to_be_Deactivated_List_Item, "id-Cells-Allowed-to-be-Deactivated-List-Item" },
  { id_Coverage_Modification_Cause, "id-Coverage-Modification-Cause" },
  { id_RANTSSRequestType, "id-RANTSSRequestType" },
  { id_RANTimingSynchronisationStatusInfo, "id-RANTimingSynchronisationStatusInfo" },
  { id_TSCTrafficCharacteristicsFeedback, "id-TSCTrafficCharacteristicsFeedback" },
  { id_RANfeedbacktype, "id-RANfeedbacktype" },
  { id_Mobile_TRP_LocationInformation, "id-Mobile-TRP-LocationInformation" },
  { id_Mobile_IAB_MT_UE_ID, "id-Mobile-IAB-MT-UE-ID" },
  { id_Target_gNB_ID, "id-Target-gNB-ID" },
  { id_Target_gNB_IP_address, "id-Target-gNB-IP-address" },
  { id_Target_SeGW_IP_address, "id-Target-SeGW-IP-address" },
  { id_Activated_Cells_Mapping_List, "id-Activated-Cells-Mapping-List" },
  { id_Activated_Cells_Mapping_List_Item, "id-Activated-Cells-Mapping-List-Item" },
  { id_F1SetupOutcome, "id-F1SetupOutcome" },
  { id_RRC_Terminating_IAB_Donor_Related_Info, "id-RRC-Terminating-IAB-Donor-Related-Info" },
  { id_RRC_Terminating_IAB_Donor_gNB_ID, "id-RRC-Terminating-IAB-Donor-gNB-ID" },
  { id_NCGI_to_be_Updated_List, "id-NCGI-to-be-Updated-List" },
  { id_NCGI_to_be_Updated_List_Item, "id-NCGI-to-be-Updated-List-Item" },
  { id_Mobile_IAB_MTUserLocationInformation, "id-Mobile-IAB-MTUserLocationInformation" },
  { id_MobileAccessPointLocation, "id-MobileAccessPointLocation" },
  { id_AssociatedSessionID, "id-AssociatedSessionID" },
  { id_IndicationMCInactiveReception, "id-IndicationMCInactiveReception" },
  { id_MulticastCU2DURRCInfo, "id-MulticastCU2DURRCInfo" },
  { id_MBSMulticastSessionReceptionState, "id-MBSMulticastSessionReceptionState" },
  { id_F1UTunnelNotEstablished, "id-F1UTunnelNotEstablished" },
  { id_MulticastDU2CURRCInfo, "id-MulticastDU2CURRCInfo" },
  { id_SIB24_message, "id-SIB24-message" },
  { id_MulticastCU2DUCommonRRCInfo, "id-MulticastCU2DUCommonRRCInfo" },
  { id_PDUSetQoSParameters, "id-PDUSetQoSParameters" },
  { id_N6JitterInformation, "id-N6JitterInformation" },
  { id_ECNMarkingorCongestionInformationReportingRequest, "id-ECNMarkingorCongestionInformationReportingRequest" },
  { id_ECNMarkingorCongestionInformationReportingStatus, "id-ECNMarkingorCongestionInformationReportingStatus" },
  { id_NRA2XServicesAuthorized, "id-NRA2XServicesAuthorized" },
  { id_LTEA2XServicesAuthorized, "id-LTEA2XServicesAuthorized" },
  { id_NRUESidelinkAggregateMaximumBitrateForA2X, "id-NRUESidelinkAggregateMaximumBitrateForA2X" },
  { id_LTEUESidelinkAggregateMaximumBitrateForA2X, "id-LTEUESidelinkAggregateMaximumBitrateForA2X" },
  { id_NReRedCapUEIndication, "id-NReRedCapUEIndication" },
  { id_ERedcap_Bcast_Information, "id-ERedcap-Bcast-Information" },
  { id_NRPaginglongeDRXInformationforRRCINACTIVE, "id-NRPaginglongeDRXInformationforRRCINACTIVE" },
  { id_SCPAC_Request, "id-SCPAC-Request" },
  { id_Target_F1_Terminating_Donor_gNB_ID, "id-Target-F1-Terminating-Donor-gNB-ID" },
  { id_MobileIAB_Barred, "id-MobileIAB-Barred" },
  { id_Broadcast_MRBs_Transport_Request_List, "id-Broadcast-MRBs-Transport-Request-List" },
  { id_Broadcast_MRBs_Transport_Request_Item, "id-Broadcast-MRBs-Transport-Request-Item" },
  { id_S_CPACLowerLayerReferenceConfigRequest, "id-S-CPACLowerLayerReferenceConfigRequest" },
  { id_S_CPAC_Configuration, "id-S-CPAC-Configuration" },
  { id_MusimCandidateBandList, "id-MusimCandidateBandList" },
  { id_DLLBTFailureInformationRequest, "id-DLLBTFailureInformationRequest" },
  { id_DLLBTFailureInformationList, "id-DLLBTFailureInformationList" },
  { id_PSIbasedSDUdiscardUL, "id-PSIbasedSDUdiscardUL" },
  { id_SIB22_message, "id-SIB22-message" },
  { id_CUtoDUTAInformation_List, "id-CUtoDUTAInformation-List" },
  { id_U2URLCChannelQoS, "id-U2URLCChannelQoS" },
  { id_SL_PHY_MAC_RLC_ConfigExt, "id-SL-PHY-MAC-RLC-ConfigExt" },
  { id_SLPositioning_Ranging_Service_Info, "id-SLPositioning-Ranging-Service-Info" },
  { id_TimeWindowInformation_SRS_List, "id-TimeWindowInformation-SRS-List" },
  { id_TimeWindowInformation_Measurement_List, "id-TimeWindowInformation-Measurement-List" },
  { id_UL_RSCP, "id-UL-RSCP" },
  { id_BW_Aggregation_Request_Indication, "id-BW-Aggregation-Request-Indication" },
  { id_ReportingGranularitykminus1, "id-ReportingGranularitykminus1" },
  { id_ReportingGranularitykminus2, "id-ReportingGranularitykminus2" },
  { id_ReportingGranularitykminus1additionalpath, "id-ReportingGranularitykminus1additionalpath" },
  { id_ReportingGranularitykminus2additionalpath, "id-ReportingGranularitykminus2additionalpath" },
  { id_TimingReportingGranularityFactorExtended, "id-TimingReportingGranularityFactorExtended" },
  { id_SRSPosRRCInactiveValidityAreaConfig, "id-SRSPosRRCInactiveValidityAreaConfig" },
  { id_PosValidityAreaCellList, "id-PosValidityAreaCellList" },
  { id_SRSReservationType, "id-SRSReservationType" },
  { id_SymbolIndex, "id-SymbolIndex" },
  { id_PRSBWAggregationRequestInfoList, "id-PRSBWAggregationRequestInfoList" },
  { id_AggregatedPosSRSResourceIDList, "id-AggregatedPosSRSResourceIDList" },
  { id_AggregatedPRSResourceSetList, "id-AggregatedPRSResourceSetList" },
  { id_PhaseQuality, "id-PhaseQuality" },
  { id_MeasuredFrequencyHops, "id-MeasuredFrequencyHops" },
  { id_TxHoppingConfiguration, "id-TxHoppingConfiguration" },
  { id_ReportingGranularitykminus3, "id-ReportingGranularitykminus3" },
  { id_ReportingGranularitykminus4, "id-ReportingGranularitykminus4" },
  { id_ReportingGranularitykminus5, "id-ReportingGranularitykminus5" },
  { id_ReportingGranularitykminus6, "id-ReportingGranularitykminus6" },
  { id_ReportingGranularitykminus3additionalpath, "id-ReportingGranularitykminus3additionalpath" },
  { id_ReportingGranularitykminus4additionalpath, "id-ReportingGranularitykminus4additionalpath" },
  { id_ReportingGranularitykminus5additionalpath, "id-ReportingGranularitykminus5additionalpath" },
  { id_ReportingGranularitykminus6additionalpath, "id-ReportingGranularitykminus6additionalpath" },
  { id_AggregatedPosSRSResourceSetList, "id-AggregatedPosSRSResourceSetList" },
  { id_RequestedSRSPreconfigurationCharacteristics_List, "id-RequestedSRSPreconfigurationCharacteristics-List" },
  { id_SRSPreconfiguration_List, "id-SRSPreconfiguration-List" },
  { id_SRSInformation, "id-SRSInformation" },
  { id_ValidityAreaSpecificSRSInformation, "id-ValidityAreaSpecificSRSInformation" },
  { id_E_CID_MeasuredResultsAssociatedInfoList, "id-E-CID-MeasuredResultsAssociatedInfoList" },
  { id_XR_Bcast_Information, "id-XR-Bcast-Information" },
  { id_MaxDataBurstVolume, "id-MaxDataBurstVolume" },
  { id_TAInformation_List, "id-TAInformation-List" },
  { id_NonIntegerDRXCycle, "id-NonIntegerDRXCycle" },
  { id_PointA, "id-PointA" },
  { id_SCS_SpecificCarrier, "id-SCS-SpecificCarrier" },
  { id_NR_PCI, "id-NR-PCI" },
  { id_PeerUE_ID, "id-PeerUE-ID" },
  { id_EarlySyncServingCellInformation, "id-EarlySyncServingCellInformation" },
  { id_RANSharingAssistanceInformation, "id-RANSharingAssistanceInformation" },
  { id_LTMCFRAResourceConfig_List, "id-LTMCFRAResourceConfig-List" },
  { id_F1U_PathFailure, "id-F1U-PathFailure" },
  { id_MeasBasedOnAggregatedResources, "id-MeasBasedOnAggregatedResources" },
  { id_SIB23_message, "id-SIB23-message" },
  { id_BarringExemptionforEmerCallInfo, "id-BarringExemptionforEmerCallInfo" },
  { id_SIB17bis_message, "id-SIB17bis-message" },
  { id_ReportingIntervalIMs, "id-ReportingIntervalIMs" },
  { id_Transmission_Bandwidth_asymmetric, "id-Transmission-Bandwidth-asymmetric" },
  { id_TagIDPointer, "id-TagIDPointer" },
  { id_LocalOrigin, "id-LocalOrigin" },
  { id_LTMResetInformation, "id-LTMResetInformation" },
  { id_SRSPosPeriodicConfigHyperSFNIndex, "id-SRSPosPeriodicConfigHyperSFNIndex" },
  { id_PreconfiguredSRSInformation, "id-PreconfiguredSRSInformation" },
  { id_candidatePSCellsToCancel, "id-candidatePSCellsToCancel" },
  { id_MobilityInitiation, "id-MobilityInitiation" },
  { id_ValidityAreaSpecificSRSInformationExtended, "id-ValidityAreaSpecificSRSInformationExtended" },
  { id_PLMNIndexNRAssistanceInfoForNetShar, "id-PLMNIndexNRAssistanceInfoForNetShar" },
  { 0, NULL }
};

static value_string_ext f1ap_ProtocolIE_ID_vals_ext = VALUE_STRING_EXT_INIT(f1ap_ProtocolIE_ID_vals);


static int
dissect_f1ap_ProtocolIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, &f1ap_data->protocol_ie_id, false);



  if (tree) {
    proto_item_append_text(proto_item_get_parent_nth(actx->created_item, 2), ": %s",
                           val_to_str_ext(actx->pinfo->pool, f1ap_data->protocol_ie_id, &f1ap_ProtocolIE_ID_vals_ext, "unknown (%d)"));
  }

  return offset;
}


static const value_string f1ap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessful-outcome" },
  { 0, NULL }
};


static int
dissect_f1ap_TriggeringMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_f1ap_T_ie_field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolIEFieldValue);

  return offset;
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_f1ap_id             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_ID },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_ie_field_value , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_ie_field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ProtocolIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_f1ap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_Field },
};

static int
dissect_f1ap_ProtocolIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, maxProtocolIEs, false);

  return offset;
}



static int
dissect_f1ap_ProtocolIE_SingleContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_f1ap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_f1ap_T_extensionValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolExtensionFieldExtensionValue);

  return offset;
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_f1ap_ext_id         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolExtensionID },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_extensionValue , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_extensionValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ProtocolExtensionField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_f1ap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolExtensionField },
};

static int
dissect_f1ap_ProtocolExtensionContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, maxProtocolExtensions, false);

  return offset;
}



static int
dissect_f1ap_T_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  if (f1ap_data->obj_id) {
    offset = call_per_oid_callback(f1ap_data->obj_id, tvb, actx->pinfo, tree, offset, actx, hf_index);
  } else {
  offset = dissect_per_open_type(tvb, offset, actx, tree, hf_index, NULL);

  }


  return offset;
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_f1ap_private_id     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PrivateIE_ID },
  { &hf_f1ap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_value          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PrivateIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_f1ap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PrivateIE_Field },
};

static int
dissect_f1ap_PrivateIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, maxPrivateIEs, false);

  return offset;
}



static int
dissect_f1ap_SRSResourceSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}



static int
dissect_f1ap_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string f1ap_AbortTransmission_vals[] = {
  {   0, "sRSResourceSetID" },
  {   1, "releaseALL" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AbortTransmission_choice[] = {
  {   0, &hf_f1ap_sRSResourceSetID, ASN1_NO_EXTENSIONS     , dissect_f1ap_SRSResourceSetID },
  {   1, &hf_f1ap_releaseALL     , ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_AbortTransmission(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_AbortTransmission, AbortTransmission_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_T_latitudeSign_vals[] = {
  {   0, "north" },
  {   1, "south" },
  { 0, NULL }
};


static int
dissect_f1ap_T_latitudeSign(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8388607U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_M8388608_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8388608, 8388607U, NULL, false);

  return offset;
}


static const value_string f1ap_T_directionOfAltitude_vals[] = {
  {   0, "height" },
  {   1, "depth" },
  { 0, NULL }
};


static int
dissect_f1ap_T_directionOfAltitude(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_179(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 179U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t AccessPointPosition_sequence[] = {
  { &hf_f1ap_latitudeSign   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_latitudeSign },
  { &hf_f1ap_latitude       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_8388607 },
  { &hf_f1ap_longitude      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M8388608_8388607 },
  { &hf_f1ap_directionOfAltitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_directionOfAltitude },
  { &hf_f1ap_altitude       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_32767 },
  { &hf_f1ap_uncertaintySemi_major, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_uncertaintySemi_minor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_orientationOfMajorAxis, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_179 },
  { &hf_f1ap_uncertaintyAltitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_confidence     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AccessPointPosition(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AccessPointPosition, AccessPointPosition_sequence);

  return offset;
}



static int
dissect_f1ap_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  e212_number_type_t number_type = f1ap_data->number_type;
  f1ap_data->number_type = E212_NONE;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_PLMN_Identity);
    dissect_e212_mcc_mnc(param_tvb, actx->pinfo, subtree, 0, number_type, false);
  }


  return offset;
}



static int
dissect_f1ap_NRCellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     36, 36, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t NRCGI_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_nRCellIdentity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCellIdentity },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRCGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  f1ap_data->number_type = E212_NRCGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRCGI, NRCGI_sequence);



  return offset;
}


static const per_sequence_t Activated_Cells_Mapping_List_Item_sequence[] = {
  { &hf_f1ap_nRCGIforTargetLogicalDU, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_nRCGIforSourceLogicalDU, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Activated_Cells_Mapping_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Activated_Cells_Mapping_List_Item, Activated_Cells_Mapping_List_Item_sequence);

  return offset;
}


static const value_string f1ap_SubcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  {   4, "kHz240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_f1ap_SubcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_DUFTransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  { 0, NULL }
};


static int
dissect_f1ap_DUFTransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_Permutation_vals[] = {
  {   0, "dfu" },
  {   1, "ufd" },
  { 0, NULL }
};


static int
dissect_f1ap_Permutation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_NoofDownlinkSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, false);

  return offset;
}



static int
dissect_f1ap_NoofUplinkSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, false);

  return offset;
}


static const per_sequence_t ExplicitFormat_sequence[] = {
  { &hf_f1ap_permutation    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Permutation },
  { &hf_f1ap_noofDownlinkSymbols, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NoofDownlinkSymbols },
  { &hf_f1ap_noofUplinkSymbols, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NoofUplinkSymbols },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ExplicitFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ExplicitFormat, ExplicitFormat_sequence);

  return offset;
}



static int
dissect_f1ap_DUFSlotformatIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 254U, NULL, false);

  return offset;
}


static const per_sequence_t ImplicitFormat_sequence[] = {
  { &hf_f1ap_dUFSlotformatIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DUFSlotformatIndex },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ImplicitFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ImplicitFormat, ImplicitFormat_sequence);

  return offset;
}


static const value_string f1ap_DUF_Slot_Config_Item_vals[] = {
  {   0, "explicitFormat" },
  {   1, "implicitFormat" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DUF_Slot_Config_Item_choice[] = {
  {   0, &hf_f1ap_explicitFormat , ASN1_NO_EXTENSIONS     , dissect_f1ap_ExplicitFormat },
  {   1, &hf_f1ap_implicitFormat , ASN1_NO_EXTENSIONS     , dissect_f1ap_ImplicitFormat },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DUF_Slot_Config_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DUF_Slot_Config_Item, DUF_Slot_Config_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DUF_Slot_Config_List_sequence_of[1] = {
  { &hf_f1ap_DUF_Slot_Config_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DUF_Slot_Config_Item },
};

static int
dissect_f1ap_DUF_Slot_Config_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DUF_Slot_Config_List, DUF_Slot_Config_List_sequence_of,
                                                  1, maxnoofDUFSlots, false);

  return offset;
}


static const value_string f1ap_HSNATransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  {   8, "ms20" },
  {   9, "ms40" },
  {  10, "ms80" },
  {  11, "ms160" },
  { 0, NULL }
};


static int
dissect_f1ap_HSNATransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_HSNADownlink_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_f1ap_HSNADownlink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_HSNAUplink_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_f1ap_HSNAUplink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_HSNAFlexible_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_f1ap_HSNAFlexible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t HSNASlotConfigItem_sequence[] = {
  { &hf_f1ap_hSNADownlink   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNADownlink },
  { &hf_f1ap_hSNAUplink     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNAUplink },
  { &hf_f1ap_hSNAFlexible   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNAFlexible },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_HSNASlotConfigItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_HSNASlotConfigItem, HSNASlotConfigItem_sequence);

  return offset;
}


static const per_sequence_t HSNASlotConfigList_sequence_of[1] = {
  { &hf_f1ap_HSNASlotConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_HSNASlotConfigItem },
};

static int
dissect_f1ap_HSNASlotConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_HSNASlotConfigList, HSNASlotConfigList_sequence_of,
                                                  1, maxnoofHSNASlots, false);

  return offset;
}


static const per_sequence_t GNB_DU_Cell_Resource_Configuration_sequence[] = {
  { &hf_f1ap_subcarrierSpacing_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SubcarrierSpacing },
  { &hf_f1ap_dUFTransmissionPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_DUFTransmissionPeriodicity },
  { &hf_f1ap_dUF_Slot_Config_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_DUF_Slot_Config_List },
  { &hf_f1ap_hSNATransmissionPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_HSNATransmissionPeriodicity },
  { &hf_f1ap_hsNSASlotConfigList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNASlotConfigList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_DU_Cell_Resource_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_DU_Cell_Resource_Configuration, GNB_DU_Cell_Resource_Configuration_sequence);

  return offset;
}


static const per_sequence_t IAB_DU_Cell_Resource_Configuration_FDD_Info_sequence[] = {
  { &hf_f1ap_gNB_DU_Cell_Resource_Configuration_FDD_UL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_gNB_DU_Cell_Resource_Configuration_FDD_DL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_DU_Cell_Resource_Configuration_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_DU_Cell_Resource_Configuration_FDD_Info, IAB_DU_Cell_Resource_Configuration_FDD_Info_sequence);

  return offset;
}


static const per_sequence_t IAB_DU_Cell_Resource_Configuration_TDD_Info_sequence[] = {
  { &hf_f1ap_gNB_DU_Cell_Resourc_Configuration_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_DU_Cell_Resource_Configuration_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_DU_Cell_Resource_Configuration_TDD_Info, IAB_DU_Cell_Resource_Configuration_TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IAB_DU_Cell_Resource_Configuration_Mode_Info_choice[] = {
  {   0, &hf_f1ap_fDD_02         , ASN1_NO_EXTENSIONS     , dissect_f1ap_IAB_DU_Cell_Resource_Configuration_FDD_Info },
  {   1, &hf_f1ap_tDD_02         , ASN1_NO_EXTENSIONS     , dissect_f1ap_IAB_DU_Cell_Resource_Configuration_TDD_Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info, IAB_DU_Cell_Resource_Configuration_Mode_Info_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Activated_Cells_to_be_Updated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iAB_DU_Cell_Resource_Configuration_Mode_Info, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Activated_Cells_to_be_Updated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Activated_Cells_to_be_Updated_List_Item, Activated_Cells_to_be_Updated_List_Item_sequence);

  return offset;
}


static const per_sequence_t Activated_Cells_to_be_Updated_List_sequence_of[1] = {
  { &hf_f1ap_Activated_Cells_to_be_Updated_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Activated_Cells_to_be_Updated_List_Item },
};

static int
dissect_f1ap_Activated_Cells_to_be_Updated_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Activated_Cells_to_be_Updated_List, Activated_Cells_to_be_Updated_List_sequence_of,
                                                  1, maxnoofServedCellsIAB, false);

  return offset;
}


static const value_string f1ap_ActivationRequestType_vals[] = {
  {   0, "activate" },
  {   1, "deactivate" },
  { 0, NULL }
};


static int
dissect_f1ap_ActivationRequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_37949_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37949U, NULL, true);

  return offset;
}


static const value_string f1ap_T_subcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  {   4, "kHz480" },
  {   5, "kHz960" },
  { 0, NULL }
};


static int
dissect_f1ap_T_subcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 2, NULL);

  return offset;
}


static const value_string f1ap_T_cyclicPrefix_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_T_cyclicPrefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_3301_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3301U, NULL, true);

  return offset;
}


static const value_string f1ap_T_shift7dot5kHz_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_shift7dot5kHz(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_SRSResourceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const value_string f1ap_T_nrofSRS_Ports_vals[] = {
  {   0, "port1" },
  {   1, "ports2" },
  {   2, "ports4" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nrofSRS_Ports(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t T_n2_sequence[] = {
  { &hf_f1ap_combOffset_n2  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1 },
  { &hf_f1ap_cyclicShift_n2 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n2, T_n2_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 11U, NULL, false);

  return offset;
}


static const per_sequence_t T_n4_sequence[] = {
  { &hf_f1ap_combOffset_n4  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3 },
  { &hf_f1ap_cyclicShift_n4 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n4, T_n4_sequence);

  return offset;
}


static const value_string f1ap_TransmissionComb_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TransmissionComb_choice[] = {
  {   0, &hf_f1ap_n2             , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n2 },
  {   1, &hf_f1ap_n4             , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n4 },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TransmissionComb(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TransmissionComb, TransmissionComb_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 13U, NULL, false);

  return offset;
}


static const value_string f1ap_T_nrofSymbols_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nrofSymbols_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_T_repetitionFactor_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  { 0, NULL }
};


static int
dissect_f1ap_T_repetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_67(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 67U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_268(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 268U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const value_string f1ap_T_groupOrSequenceHopping_01_vals[] = {
  {   0, "neither" },
  {   1, "groupHopping" },
  {   2, "sequenceHopping" },
  { 0, NULL }
};


static int
dissect_f1ap_T_groupOrSequenceHopping_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_T_periodicity_vals[] = {
  {   0, "slot1" },
  {   1, "slot2" },
  {   2, "slot4" },
  {   3, "slot5" },
  {   4, "slot8" },
  {   5, "slot10" },
  {   6, "slot16" },
  {   7, "slot20" },
  {   8, "slot32" },
  {   9, "slot40" },
  {  10, "slot64" },
  {  11, "slot80" },
  {  12, "slot160" },
  {  13, "slot320" },
  {  14, "slot640" },
  {  15, "slot1280" },
  {  16, "slot2560" },
  { 0, NULL }
};


static int
dissect_f1ap_T_periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     17, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_2559_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2559U, NULL, true);

  return offset;
}


static const per_sequence_t ResourceTypePeriodic_sequence[] = {
  { &hf_f1ap_periodicity    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_periodicity },
  { &hf_f1ap_offset         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2559_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypePeriodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypePeriodic, ResourceTypePeriodic_sequence);

  return offset;
}


static const value_string f1ap_T_periodicity_01_vals[] = {
  {   0, "slot1" },
  {   1, "slot2" },
  {   2, "slot4" },
  {   3, "slot5" },
  {   4, "slot8" },
  {   5, "slot10" },
  {   6, "slot16" },
  {   7, "slot20" },
  {   8, "slot32" },
  {   9, "slot40" },
  {  10, "slot64" },
  {  11, "slot80" },
  {  12, "slot160" },
  {  13, "slot320" },
  {  14, "slot640" },
  {  15, "slot1280" },
  {  16, "slot2560" },
  { 0, NULL }
};


static int
dissect_f1ap_T_periodicity_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     17, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceTypeSemi_persistent_sequence[] = {
  { &hf_f1ap_periodicity_01 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_periodicity_01 },
  { &hf_f1ap_offset         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2559_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypeSemi_persistent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypeSemi_persistent, ResourceTypeSemi_persistent_sequence);

  return offset;
}


static const value_string f1ap_T_aperiodicResourceType_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_aperiodicResourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceTypeAperiodic_sequence[] = {
  { &hf_f1ap_aperiodicResourceType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_aperiodicResourceType },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypeAperiodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypeAperiodic, ResourceTypeAperiodic_sequence);

  return offset;
}


static const value_string f1ap_ResourceType_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResourceType_choice[] = {
  {   0, &hf_f1ap_periodic_02    , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypePeriodic },
  {   1, &hf_f1ap_semi_persistent_02, ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypeSemi_persistent },
  {   2, &hf_f1ap_aperiodic_02   , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypeAperiodic },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ResourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ResourceType, ResourceType_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, false);

  return offset;
}


static const per_sequence_t SRSResource_sequence[] = {
  { &hf_f1ap_sRSResourceID  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceID },
  { &hf_f1ap_nrofSRS_Ports  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nrofSRS_Ports },
  { &hf_f1ap_transmissionComb, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransmissionComb },
  { &hf_f1ap_startPosition  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_13 },
  { &hf_f1ap_nrofSymbols_01 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nrofSymbols_01 },
  { &hf_f1ap_repetitionFactor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_repetitionFactor },
  { &hf_f1ap_freqDomainPosition, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_67 },
  { &hf_f1ap_freqDomainShift, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_268 },
  { &hf_f1ap_c_SRS          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_b_SRS          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3 },
  { &hf_f1ap_b_hop          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3 },
  { &hf_f1ap_groupOrSequenceHopping_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_groupOrSequenceHopping_01 },
  { &hf_f1ap_resourceType_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ResourceType },
  { &hf_f1ap_sequenceId_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1023 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSResource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSResource, SRSResource_sequence);

  return offset;
}


static const per_sequence_t SRSResource_List_sequence_of[1] = {
  { &hf_f1ap_SRSResource_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResource },
};

static int
dissect_f1ap_SRSResource_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRSResource_List, SRSResource_List_sequence_of,
                                                  1, maxnoSRS_Resources, false);

  return offset;
}



static int
dissect_f1ap_SRSPosResourceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const per_sequence_t T_n2_01_sequence[] = {
  { &hf_f1ap_combOffset_n2  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1 },
  { &hf_f1ap_cyclicShift_n2 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n2_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n2_01, T_n2_01_sequence);

  return offset;
}


static const per_sequence_t T_n4_01_sequence[] = {
  { &hf_f1ap_combOffset_n4  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3 },
  { &hf_f1ap_cyclicShift_n4 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n4_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n4_01, T_n4_01_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5U, NULL, false);

  return offset;
}


static const per_sequence_t T_n8_sequence[] = {
  { &hf_f1ap_combOffset_n8  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_7 },
  { &hf_f1ap_cyclicShift_n8 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_5 },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_T_n8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_T_n8, T_n8_sequence);

  return offset;
}


static const value_string f1ap_TransmissionCombPos_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n8" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TransmissionCombPos_choice[] = {
  {   0, &hf_f1ap_n2_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n2_01 },
  {   1, &hf_f1ap_n4_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n4_01 },
  {   2, &hf_f1ap_n8             , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_n8 },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TransmissionCombPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TransmissionCombPos, TransmissionCombPos_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_T_nrofSymbols_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nrofSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_T_groupOrSequenceHopping_vals[] = {
  {   0, "neither" },
  {   1, "groupHopping" },
  {   2, "sequenceHopping" },
  { 0, NULL }
};


static int
dissect_f1ap_T_groupOrSequenceHopping(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_SRS_Periodicity_vals[] = {
  {   0, "slot1" },
  {   1, "slot2" },
  {   2, "slot4" },
  {   3, "slot5" },
  {   4, "slot8" },
  {   5, "slot10" },
  {   6, "slot16" },
  {   7, "slot20" },
  {   8, "slot32" },
  {   9, "slot40" },
  {  10, "slot64" },
  {  11, "slot80" },
  {  12, "slot160" },
  {  13, "slot320" },
  {  14, "slot640" },
  {  15, "slot1280" },
  {  16, "slot2560" },
  {  17, "slot5120" },
  {  18, "slot10240" },
  {  19, "slot40960" },
  {  20, "slot81920" },
  {  21, "slot128" },
  {  22, "slot256" },
  {  23, "slot512" },
  {  24, "slot20480" },
  { 0, NULL }
};


static int
dissect_f1ap_SRS_Periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     21, NULL, true, 4, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_81919_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 81919U, NULL, true);

  return offset;
}


static const per_sequence_t ResourceTypePeriodicPos_sequence[] = {
  { &hf_f1ap_periodicity_02 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRS_Periodicity },
  { &hf_f1ap_offset_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_81919_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypePeriodicPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypePeriodicPos, ResourceTypePeriodicPos_sequence);

  return offset;
}


static const per_sequence_t ResourceTypeSemi_persistentPos_sequence[] = {
  { &hf_f1ap_periodicity_02 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRS_Periodicity },
  { &hf_f1ap_offset_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_81919_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypeSemi_persistentPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypeSemi_persistentPos, ResourceTypeSemi_persistentPos_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32U, NULL, false);

  return offset;
}


static const per_sequence_t ResourceTypeAperiodicPos_sequence[] = {
  { &hf_f1ap_slotOffset     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_32 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceTypeAperiodicPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceTypeAperiodicPos, ResourceTypeAperiodicPos_sequence);

  return offset;
}


static const value_string f1ap_ResourceTypePos_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResourceTypePos_choice[] = {
  {   0, &hf_f1ap_periodic_03    , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypePeriodicPos },
  {   1, &hf_f1ap_semi_persistent_03, ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypeSemi_persistentPos },
  {   2, &hf_f1ap_aperiodic_03   , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceTypeAperiodicPos },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ResourceTypePos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ResourceTypePos, ResourceTypePos_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_NRPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, false);

  return offset;
}



static int
dissect_f1ap_SSB_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const per_sequence_t SSB_sequence[] = {
  { &hf_f1ap_pCI_NR_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRPCI },
  { &hf_f1ap_ssb_index      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSB_Index },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSB, SSB_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t PRSInformationPos_sequence[] = {
  { &hf_f1ap_pRS_IDPos      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_pRS_Resource_Set_IDPos, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_7 },
  { &hf_f1ap_pRS_Resource_IDPos, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PRSInformationPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PRSInformationPos, PRSInformationPos_sequence);

  return offset;
}


static const value_string f1ap_SpatialRelationPos_vals[] = {
  {   0, "sSBPos" },
  {   1, "pRSInformationPos" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SpatialRelationPos_choice[] = {
  {   0, &hf_f1ap_sSBPos         , ASN1_NO_EXTENSIONS     , dissect_f1ap_SSB },
  {   1, &hf_f1ap_pRSInformationPos, ASN1_NO_EXTENSIONS     , dissect_f1ap_PRSInformationPos },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SpatialRelationPos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SpatialRelationPos, SpatialRelationPos_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PosSRSResource_Item_sequence[] = {
  { &hf_f1ap_srs_PosResourceId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSPosResourceID },
  { &hf_f1ap_transmissionCombPos, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransmissionCombPos },
  { &hf_f1ap_startPosition  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_13 },
  { &hf_f1ap_nrofSymbols    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nrofSymbols },
  { &hf_f1ap_freqDomainShift, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_268 },
  { &hf_f1ap_c_SRS          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_groupOrSequenceHopping, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_groupOrSequenceHopping },
  { &hf_f1ap_resourceTypePos, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ResourceTypePos },
  { &hf_f1ap_sequenceId     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_65535 },
  { &hf_f1ap_spatialRelationPos, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SpatialRelationPos },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosSRSResource_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosSRSResource_Item, PosSRSResource_Item_sequence);

  return offset;
}


static const per_sequence_t PosSRSResource_List_sequence_of[1] = {
  { &hf_f1ap_PosSRSResource_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosSRSResource_Item },
};

static int
dissect_f1ap_PosSRSResource_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosSRSResource_List, PosSRSResource_List_sequence_of,
                                                  1, maxnoSRS_PosResources, false);

  return offset;
}


static const per_sequence_t SRSResourceID_List_sequence_of[1] = {
  { &hf_f1ap_SRSResourceID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceID },
};

static int
dissect_f1ap_SRSResourceID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRSResourceID_List, SRSResourceID_List_sequence_of,
                                                  1, maxnoSRS_ResourcePerSet, false);

  return offset;
}


static const value_string f1ap_T_periodicSet_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_periodicSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceSetTypePeriodic_sequence[] = {
  { &hf_f1ap_periodicSet    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_periodicSet },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceSetTypePeriodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceSetTypePeriodic, ResourceSetTypePeriodic_sequence);

  return offset;
}


static const value_string f1ap_T_semi_persistentSet_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_semi_persistentSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ResourceSetTypeSemi_persistent_sequence[] = {
  { &hf_f1ap_semi_persistentSet, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_semi_persistentSet },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceSetTypeSemi_persistent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceSetTypeSemi_persistent, ResourceSetTypeSemi_persistent_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, false);

  return offset;
}


static const per_sequence_t ResourceSetTypeAperiodic_sequence[] = {
  { &hf_f1ap_sRSResourceTrigger_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_3 },
  { &hf_f1ap_slotoffset     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_32 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ResourceSetTypeAperiodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ResourceSetTypeAperiodic, ResourceSetTypeAperiodic_sequence);

  return offset;
}


static const value_string f1ap_ResourceSetType_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResourceSetType_choice[] = {
  {   0, &hf_f1ap_periodic_01    , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceSetTypePeriodic },
  {   1, &hf_f1ap_semi_persistent_01, ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceSetTypeSemi_persistent },
  {   2, &hf_f1ap_aperiodic_01   , ASN1_NO_EXTENSIONS     , dissect_f1ap_ResourceSetTypeAperiodic },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ResourceSetType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ResourceSetType, ResourceSetType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SRSResourceSet_sequence[] = {
  { &hf_f1ap_sRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceSetID },
  { &hf_f1ap_sRSResourceID_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceID_List },
  { &hf_f1ap_resourceSetType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ResourceSetType },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSResourceSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSResourceSet, SRSResourceSet_sequence);

  return offset;
}


static const per_sequence_t SRSResourceSet_List_sequence_of[1] = {
  { &hf_f1ap_SRSResourceSet_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSResourceSet },
};

static int
dissect_f1ap_SRSResourceSet_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SRSResourceSet_List, SRSResourceSet_List_sequence_of,
                                                  1, maxnoSRS_ResourceSets, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const per_sequence_t PosSRSResourceID_List_sequence_of[1] = {
  { &hf_f1ap_PosSRSResourceID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSPosResourceID },
};

static int
dissect_f1ap_PosSRSResourceID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosSRSResourceID_List, PosSRSResourceID_List_sequence_of,
                                                  1, maxnoSRS_PosResourcePerSet, false);

  return offset;
}


static const value_string f1ap_T_posperiodicSet_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_posperiodicSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PosResourceSetTypePR_sequence[] = {
  { &hf_f1ap_posperiodicSet , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_posperiodicSet },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosResourceSetTypePR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosResourceSetTypePR, PosResourceSetTypePR_sequence);

  return offset;
}


static const value_string f1ap_T_possemi_persistentSet_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_possemi_persistentSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PosResourceSetTypeSP_sequence[] = {
  { &hf_f1ap_possemi_persistentSet, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_possemi_persistentSet },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosResourceSetTypeSP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosResourceSetTypeSP, PosResourceSetTypeSP_sequence);

  return offset;
}


static const per_sequence_t PosResourceSetTypeAP_sequence[] = {
  { &hf_f1ap_sRSResourceTrigger_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_3 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosResourceSetTypeAP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosResourceSetTypeAP, PosResourceSetTypeAP_sequence);

  return offset;
}


static const value_string f1ap_PosResourceSetType_vals[] = {
  {   0, "periodic" },
  {   1, "semi-persistent" },
  {   2, "aperiodic" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PosResourceSetType_choice[] = {
  {   0, &hf_f1ap_periodic       , ASN1_NO_EXTENSIONS     , dissect_f1ap_PosResourceSetTypePR },
  {   1, &hf_f1ap_semi_persistent, ASN1_NO_EXTENSIONS     , dissect_f1ap_PosResourceSetTypeSP },
  {   2, &hf_f1ap_aperiodic      , ASN1_NO_EXTENSIONS     , dissect_f1ap_PosResourceSetTypeAP },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_PosResourceSetType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_PosResourceSetType, PosResourceSetType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PosSRSResourceSet_Item_sequence[] = {
  { &hf_f1ap_possrsResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_possRSResourceID_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosSRSResourceID_List },
  { &hf_f1ap_posresourceSetType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosResourceSetType },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PosSRSResourceSet_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PosSRSResourceSet_Item, PosSRSResourceSet_Item_sequence);

  return offset;
}


static const per_sequence_t PosSRSResourceSet_List_sequence_of[1] = {
  { &hf_f1ap_PosSRSResourceSet_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PosSRSResourceSet_Item },
};

static int
dissect_f1ap_PosSRSResourceSet_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PosSRSResourceSet_List, PosSRSResourceSet_List_sequence_of,
                                                  1, maxnoSRS_PosResourceSets, false);

  return offset;
}


static const per_sequence_t SRSConfig_sequence[] = {
  { &hf_f1ap_sRSResource_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SRSResource_List },
  { &hf_f1ap_posSRSResource_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PosSRSResource_List },
  { &hf_f1ap_sRSResourceSet_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SRSResourceSet_List },
  { &hf_f1ap_posSRSResourceSet_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PosSRSResourceSet_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SRSConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SRSConfig, SRSConfig_sequence);

  return offset;
}


static const per_sequence_t ActiveULBWP_sequence[] = {
  { &hf_f1ap_locationAndBandwidth, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_37949_ },
  { &hf_f1ap_subcarrierSpacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_subcarrierSpacing },
  { &hf_f1ap_cyclicPrefix   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_cyclicPrefix },
  { &hf_f1ap_txDirectCurrentLocation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3301_ },
  { &hf_f1ap_shift7dot5kHz  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_shift7dot5kHz },
  { &hf_f1ap_sRSConfig      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ActiveULBWP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ActiveULBWP, ActiveULBWP_sequence);

  return offset;
}


static const value_string f1ap_AdditionalDuplicationIndication_vals[] = {
  {   0, "three" },
  {   1, "four" },
  { 0, NULL }
};


static int
dissect_f1ap_AdditionalDuplicationIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_16351(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16351U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_8176(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8176U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_4088(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4088U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_2044(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2044U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1022(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1022U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, false);

  return offset;
}


static const value_string f1ap_RelativePathDelay_vals[] = {
  {   0, "k0" },
  {   1, "k1" },
  {   2, "k2" },
  {   3, "k3" },
  {   4, "k4" },
  {   5, "k5" },
  {   6, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RelativePathDelay_choice[] = {
  {   0, &hf_f1ap_k0_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_16351 },
  {   1, &hf_f1ap_k1_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_8176 },
  {   2, &hf_f1ap_k2_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_4088 },
  {   3, &hf_f1ap_k3_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_2044 },
  {   4, &hf_f1ap_k4_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_1022 },
  {   5, &hf_f1ap_k5_01          , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_511 },
  {   6, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_RelativePathDelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_RelativePathDelay, RelativePathDelay_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, false);

  return offset;
}


static const value_string f1ap_T_resolution_01_vals[] = {
  {   0, "m0dot1" },
  {   1, "m1" },
  {   2, "m10" },
  {   3, "m30" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resolution_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t TimingMeasurementQuality_sequence[] = {
  { &hf_f1ap_measurementQuality_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_31 },
  { &hf_f1ap_resolution_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resolution_01 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TimingMeasurementQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TimingMeasurementQuality, TimingMeasurementQuality_sequence);

  return offset;
}


static const value_string f1ap_T_resolution_vals[] = {
  {   0, "deg0dot1" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resolution(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t AngleMeasurementQuality_sequence[] = {
  { &hf_f1ap_azimuthQuality , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_zenithQuality  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_resolution     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_resolution },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AngleMeasurementQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AngleMeasurementQuality, AngleMeasurementQuality_sequence);

  return offset;
}


static const value_string f1ap_TRPMeasurementQuality_Item_vals[] = {
  {   0, "timingMeasurementQuality" },
  {   1, "angleMeasurementQuality" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPMeasurementQuality_Item_choice[] = {
  {   0, &hf_f1ap_timingMeasurementQuality, ASN1_NO_EXTENSIONS     , dissect_f1ap_TimingMeasurementQuality },
  {   1, &hf_f1ap_angleMeasurementQuality, ASN1_NO_EXTENSIONS     , dissect_f1ap_AngleMeasurementQuality },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPMeasurementQuality_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPMeasurementQuality_Item, TRPMeasurementQuality_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TRPMeasurementQuality_sequence[] = {
  { &hf_f1ap_tRPmeasurementQuality_Item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPMeasurementQuality_Item },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPMeasurementQuality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPMeasurementQuality, TRPMeasurementQuality_sequence);

  return offset;
}


static const per_sequence_t AdditionalPath_Item_sequence[] = {
  { &hf_f1ap_relativePathDelay, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RelativePathDelay },
  { &hf_f1ap_pathQuality    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TRPMeasurementQuality },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AdditionalPath_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AdditionalPath_Item, AdditionalPath_Item_sequence);

  return offset;
}


static const per_sequence_t AdditionalPath_List_sequence_of[1] = {
  { &hf_f1ap_AdditionalPath_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AdditionalPath_Item },
};

static int
dissect_f1ap_AdditionalPath_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AdditionalPath_List, AdditionalPath_List_sequence_of,
                                                  1, maxnoofPath, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_3599(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3599U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1799(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1799U, NULL, false);

  return offset;
}


static const per_sequence_t LCS_to_GCS_Translation_sequence[] = {
  { &hf_f1ap_alpha          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3599 },
  { &hf_f1ap_beta           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3599 },
  { &hf_f1ap_gamma          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3599 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LCS_to_GCS_Translation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LCS_to_GCS_Translation, LCS_to_GCS_Translation_sequence);

  return offset;
}


static const per_sequence_t UL_AoA_sequence[] = {
  { &hf_f1ap_azimuthAoA     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3599 },
  { &hf_f1ap_zenithAoA      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_1799 },
  { &hf_f1ap_lCS_to_GCS_Translation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCS_to_GCS_Translation },
  { &hf_f1ap_iE_extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UL_AoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UL_AoA, UL_AoA_sequence);

  return offset;
}


static const per_sequence_t ZoAInformation_sequence[] = {
  { &hf_f1ap_zenithAoA      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1799 },
  { &hf_f1ap_lCS_to_GCS_Translation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCS_to_GCS_Translation },
  { &hf_f1ap_iE_extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ZoAInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ZoAInformation, ZoAInformation_sequence);

  return offset;
}


static const value_string f1ap_MultipleULAoA_Item_vals[] = {
  {   0, "uL-AoA" },
  {   1, "ul-ZoA" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MultipleULAoA_Item_choice[] = {
  {   0, &hf_f1ap_uL_AoA         , ASN1_NO_EXTENSIONS     , dissect_f1ap_UL_AoA },
  {   1, &hf_f1ap_ul_ZoA         , ASN1_NO_EXTENSIONS     , dissect_f1ap_ZoAInformation },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_MultipleULAoA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_MultipleULAoA_Item, MultipleULAoA_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MultipleULAoA_List_sequence_of[1] = {
  { &hf_f1ap_MultipleULAoA_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MultipleULAoA_Item },
};

static int
dissect_f1ap_MultipleULAoA_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MultipleULAoA_List, MultipleULAoA_List_sequence_of,
                                                  1, maxnoofULAoAs, false);

  return offset;
}


static const per_sequence_t MultipleULAoA_sequence[] = {
  { &hf_f1ap_multipleULAoA_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MultipleULAoA_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MultipleULAoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MultipleULAoA, MultipleULAoA_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_126(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 126U, NULL, false);

  return offset;
}


static const per_sequence_t UL_SRS_RSRPP_sequence[] = {
  { &hf_f1ap_firstPathRSRPP , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_126 },
  { &hf_f1ap_iE_extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UL_SRS_RSRPP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UL_SRS_RSRPP, UL_SRS_RSRPP_sequence);

  return offset;
}


static const per_sequence_t ExtendedAdditionalPathList_Item_sequence[] = {
  { &hf_f1ap_relativeTimeOfPath, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RelativePathDelay },
  { &hf_f1ap_pathQuality    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TRPMeasurementQuality },
  { &hf_f1ap_multipleULAoA  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MultipleULAoA },
  { &hf_f1ap_pathPower      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_UL_SRS_RSRPP },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ExtendedAdditionalPathList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ExtendedAdditionalPathList_Item, ExtendedAdditionalPathList_Item_sequence);

  return offset;
}


static const per_sequence_t ExtendedAdditionalPathList_sequence_of[1] = {
  { &hf_f1ap_ExtendedAdditionalPathList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedAdditionalPathList_Item },
};

static int
dissect_f1ap_ExtendedAdditionalPathList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ExtendedAdditionalPathList, ExtendedAdditionalPathList_sequence_of,
                                                  1, maxNoPathExtended, false);

  return offset;
}



static int
dissect_f1ap_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, true, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    proto_tree *subtree;
    int tvb_len;

    tvb_len = tvb_reported_length(param_tvb);
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_TransportLayerAddress);
    if (tvb_len == 4) {
      /* IPv4 */
       proto_tree_add_item(subtree, hf_f1ap_transportLayerAddressIPv4, param_tvb, 0, 4, ENC_BIG_ENDIAN);
    } else if (tvb_len == 16) {
      /* IPv6 */
       proto_tree_add_item(subtree, hf_f1ap_transportLayerAddressIPv6, param_tvb, 0, 16, ENC_NA);
    } else if (tvb_len == 20) {
      /* IPv4 */
       proto_tree_add_item(subtree, hf_f1ap_transportLayerAddressIPv4, param_tvb, 0, 4, ENC_BIG_ENDIAN);
      /* IPv6 */
       proto_tree_add_item(subtree, hf_f1ap_transportLayerAddressIPv6, param_tvb, 4, 16, ENC_NA);
    }
  }


  return offset;
}



static int
dissect_f1ap_GTP_TEID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, NULL);

  return offset;
}


static const per_sequence_t GTPTunnel_sequence[] = {
  { &hf_f1ap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_gTP_TEID       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GTP_TEID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GTPTunnel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GTPTunnel, GTPTunnel_sequence);

  return offset;
}


static const value_string f1ap_UPTransportLayerInformation_vals[] = {
  {   0, "gTPTunnel" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UPTransportLayerInformation_choice[] = {
  {   0, &hf_f1ap_gTPTunnel      , ASN1_NO_EXTENSIONS     , dissect_f1ap_GTPTunnel },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_UPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_UPTransportLayerInformation, UPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AdditionalPDCPDuplicationTNL_Item_sequence[] = {
  { &hf_f1ap_additionalPDCPDuplicationUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AdditionalPDCPDuplicationTNL_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AdditionalPDCPDuplicationTNL_Item, AdditionalPDCPDuplicationTNL_Item_sequence);

  return offset;
}


static const per_sequence_t AdditionalPDCPDuplicationTNL_List_sequence_of[1] = {
  { &hf_f1ap_AdditionalPDCPDuplicationTNL_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AdditionalPDCPDuplicationTNL_Item },
};

static int
dissect_f1ap_AdditionalPDCPDuplicationTNL_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AdditionalPDCPDuplicationTNL_List, AdditionalPDCPDuplicationTNL_List_sequence_of,
                                                  1, maxnoofAdditionalPDCPDuplicationTNL, false);

  return offset;
}



static int
dissect_f1ap_T_additionalSIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sIBmessage);
    switch (f1ap_data->sib_type) {
    case 6:
      dissect_nr_rrc_SIB6_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 7:
      dissect_nr_rrc_SIB7_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 8:
      dissect_nr_rrc_SIB8_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
    }
  }


  return offset;
}


static const per_sequence_t AdditionalSIBMessageList_Item_sequence[] = {
  { &hf_f1ap_additionalSIB  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_additionalSIB },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AdditionalSIBMessageList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AdditionalSIBMessageList_Item, AdditionalSIBMessageList_Item_sequence);

  return offset;
}


static const per_sequence_t AdditionalSIBMessageList_sequence_of[1] = {
  { &hf_f1ap_AdditionalSIBMessageList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AdditionalSIBMessageList_Item },
};

static int
dissect_f1ap_AdditionalSIBMessageList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AdditionalSIBMessageList, AdditionalSIBMessageList_sequence_of,
                                                  1, maxnoofAdditionalSIBs, false);

  return offset;
}



static int
dissect_f1ap_AdditionalRRMPriorityIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t AffectedSSB_Item_sequence[] = {
  { &hf_f1ap_sSB_Index      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AffectedSSB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AffectedSSB_Item, AffectedSSB_Item_sequence);

  return offset;
}


static const per_sequence_t AffectedSSB_List_sequence_of[1] = {
  { &hf_f1ap_AffectedSSB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AffectedSSB_Item },
};

static int
dissect_f1ap_AffectedSSB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AffectedSSB_List, AffectedSSB_List_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t AffectedCellsAndBeams_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_affectedSSB_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_AffectedSSB_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AffectedCellsAndBeams_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AffectedCellsAndBeams_Item, AffectedCellsAndBeams_Item_sequence);

  return offset;
}


static const per_sequence_t AffectedCellsAndBeams_List_sequence_of[1] = {
  { &hf_f1ap_AffectedCellsAndBeams_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AffectedCellsAndBeams_Item },
};

static int
dissect_f1ap_AffectedCellsAndBeams_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AffectedCellsAndBeams_List, AffectedCellsAndBeams_List_sequence_of,
                                                  1, maxAffectedCells, false);

  return offset;
}


static const per_sequence_t Aggregated_PosSRS_Resource_ID_Item_sequence[] = {
  { &hf_f1ap_positioningSRS , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SRSPosResourceID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Aggregated_PosSRS_Resource_ID_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Aggregated_PosSRS_Resource_ID_Item, Aggregated_PosSRS_Resource_ID_Item_sequence);

  return offset;
}


static const per_sequence_t AggregatedPosSRSResourceIDList_sequence_of[1] = {
  { &hf_f1ap_AggregatedPosSRSResourceIDList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Aggregated_PosSRS_Resource_ID_Item },
};

static int
dissect_f1ap_AggregatedPosSRSResourceIDList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AggregatedPosSRSResourceIDList, AggregatedPosSRSResourceIDList_sequence_of,
                                                  2, maxnoAggregatedSRS_Resources, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_3279165(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3279165U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_2199_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2199U, NULL, true);

  return offset;
}


static const value_string f1ap_T_subcarrierSpacing_02_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  {   4, "kHz480" },
  {   5, "kHz960" },
  { 0, NULL }
};


static int
dissect_f1ap_T_subcarrierSpacing_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 2, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_275_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 275U, NULL, true);

  return offset;
}


static const per_sequence_t SCS_SpecificCarrier_sequence[] = {
  { &hf_f1ap_offsetToCarrier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2199_ },
  { &hf_f1ap_subcarrierSpacing_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_subcarrierSpacing_02 },
  { &hf_f1ap_carrierBandwidth_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_275_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SCS_SpecificCarrier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SCS_SpecificCarrier, SCS_SpecificCarrier_sequence);

  return offset;
}


static const per_sequence_t Combined_PosSRSResourceSet_Item_sequence[] = {
  { &hf_f1ap_pointA         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3279165 },
  { &hf_f1ap_nRPCI          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRPCI },
  { &hf_f1ap_posSRSResourceSetID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_scs_specificCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SCS_SpecificCarrier },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Combined_PosSRSResourceSet_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Combined_PosSRSResourceSet_Item, Combined_PosSRSResourceSet_Item_sequence);

  return offset;
}


static const per_sequence_t Combined_PosSRSResourceSet_List_sequence_of[1] = {
  { &hf_f1ap_Combined_PosSRSResourceSet_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Combined_PosSRSResourceSet_Item },
};

static int
dissect_f1ap_Combined_PosSRSResourceSet_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Combined_PosSRSResourceSet_List, Combined_PosSRSResourceSet_List_sequence_of,
                                                  2, maxnoAggregatedPosSRSResourceSets, false);

  return offset;
}


static const per_sequence_t AggregatedPosSRSResourceSet_Item_sequence[] = {
  { &hf_f1ap_combined_posSRSResourceSet_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Combined_PosSRSResourceSet_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AggregatedPosSRSResourceSet_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AggregatedPosSRSResourceSet_Item, AggregatedPosSRSResourceSet_Item_sequence);

  return offset;
}


static const per_sequence_t AggregatedPosSRSResourceSetList_sequence_of[1] = {
  { &hf_f1ap_AggregatedPosSRSResourceSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AggregatedPosSRSResourceSet_Item },
};

static int
dissect_f1ap_AggregatedPosSRSResourceSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AggregatedPosSRSResourceSetList, AggregatedPosSRSResourceSetList_sequence_of,
                                                  1, maxnoAggregatedPosSRSCombinations, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, false);

  return offset;
}


static const per_sequence_t DL_PRS_ResourceSet_Item_sequence[] = {
  { &hf_f1ap_dl_prs_ResourceSetIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_8 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DL_PRS_ResourceSet_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DL_PRS_ResourceSet_Item, DL_PRS_ResourceSet_Item_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_ResourceSet_List_sequence_of[1] = {
  { &hf_f1ap_DL_PRS_ResourceSet_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DL_PRS_ResourceSet_Item },
};

static int
dissect_f1ap_DL_PRS_ResourceSet_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DL_PRS_ResourceSet_List, DL_PRS_ResourceSet_List_sequence_of,
                                                  1, maxnoAggregatedPosPRSResourceSets, false);

  return offset;
}


static const per_sequence_t AggregatedPRSResourceSet_Item_sequence[] = {
  { &hf_f1ap_dl_PRS_ResourceSet_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DL_PRS_ResourceSet_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AggregatedPRSResourceSet_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AggregatedPRSResourceSet_Item, AggregatedPRSResourceSet_Item_sequence);

  return offset;
}


static const per_sequence_t AggregatedPRSResourceSetList_sequence_of[1] = {
  { &hf_f1ap_AggregatedPRSResourceSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AggregatedPRSResourceSet_Item },
};

static int
dissect_f1ap_AggregatedPRSResourceSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AggregatedPRSResourceSetList, AggregatedPRSResourceSetList_sequence_of,
                                                  1, maxnoAggCombinations, false);

  return offset;
}


static const per_sequence_t AggressorCellList_Item_sequence[] = {
  { &hf_f1ap_aggressorCell_ID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AggressorCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AggressorCellList_Item, AggressorCellList_Item_sequence);

  return offset;
}


static const per_sequence_t AggressorCellList_sequence_of[1] = {
  { &hf_f1ap_AggressorCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AggressorCellList_Item },
};

static int
dissect_f1ap_AggressorCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AggressorCellList, AggressorCellList_sequence_of,
                                                  1, maxCellingNBDU, false);

  return offset;
}



static int
dissect_f1ap_GNBSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 22, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t AggressorgNBSetID_sequence[] = {
  { &hf_f1ap_aggressorgNBSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBSetID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AggressorgNBSetID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AggressorgNBSetID, AggressorgNBSetID_sequence);

  return offset;
}


static const value_string f1ap_PriorityLevel_vals[] = {
  {   0, "spare" },
  {   1, "highest" },
  {  14, "lowest" },
  {  15, "no-priority" },
  { 0, NULL }
};


static int
dissect_f1ap_PriorityLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const value_string f1ap_Pre_emptionCapability_vals[] = {
  {   0, "shall-not-trigger-pre-emption" },
  {   1, "may-trigger-pre-emption" },
  { 0, NULL }
};


static int
dissect_f1ap_Pre_emptionCapability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_Pre_emptionVulnerability_vals[] = {
  {   0, "not-pre-emptable" },
  {   1, "pre-emptable" },
  { 0, NULL }
};


static int
dissect_f1ap_Pre_emptionVulnerability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t AllocationAndRetentionPriority_sequence[] = {
  { &hf_f1ap_priorityLevel  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PriorityLevel },
  { &hf_f1ap_pre_emptionCapability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Pre_emptionCapability },
  { &hf_f1ap_pre_emptionVulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Pre_emptionVulnerability },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AllocationAndRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AllocationAndRetentionPriority, AllocationAndRetentionPriority_sequence);

  return offset;
}



static int
dissect_f1ap_QoSParaSetIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, true);

  return offset;
}



static int
dissect_f1ap_BitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(4000000000000), NULL, true);

  return offset;
}



static int
dissect_f1ap_PacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, true);

  return offset;
}



static int
dissect_f1ap_PER_Scalar(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, true);

  return offset;
}



static int
dissect_f1ap_PER_Exponent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, true);

  return offset;
}


static const per_sequence_t PacketErrorRate_sequence[] = {
  { &hf_f1ap_pER_Scalar     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PER_Scalar },
  { &hf_f1ap_pER_Exponent   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PER_Exponent },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PacketErrorRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PacketErrorRate, PacketErrorRate_sequence);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetItem_sequence[] = {
  { &hf_f1ap_alternativeQoSParaSetIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSParaSetIndex },
  { &hf_f1ap_guaranteedFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BitRate },
  { &hf_f1ap_guaranteedFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BitRate },
  { &hf_f1ap_packetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_PacketDelayBudget },
  { &hf_f1ap_packetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_PacketErrorRate },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AlternativeQoSParaSetItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AlternativeQoSParaSetItem, AlternativeQoSParaSetItem_sequence);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetList_sequence_of[1] = {
  { &hf_f1ap_AlternativeQoSParaSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AlternativeQoSParaSetItem },
};

static int
dissect_f1ap_AlternativeQoSParaSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AlternativeQoSParaSetList, AlternativeQoSParaSetList_sequence_of,
                                                  1, maxnoofQoSParaSets, false);

  return offset;
}



static int
dissect_f1ap_AperiodicSRSResourceTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, false);

  return offset;
}


static const per_sequence_t AperiodicSRSResourceTriggerList_sequence_of[1] = {
  { &hf_f1ap_AperiodicSRSResourceTriggerList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AperiodicSRSResourceTrigger },
};

static int
dissect_f1ap_AperiodicSRSResourceTriggerList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AperiodicSRSResourceTriggerList, AperiodicSRSResourceTriggerList_sequence_of,
                                                  1, maxnoofSRSTriggerStates, false);

  return offset;
}


static const per_sequence_t Associated_SCell_Item_sequence[] = {
  { &hf_f1ap_sCell_ID       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Associated_SCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Associated_SCell_Item, Associated_SCell_Item_sequence);

  return offset;
}



static int
dissect_f1ap_AssociatedSessionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const per_sequence_t AvailablePLMNList_Item_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AvailablePLMNList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AvailablePLMNList_Item, AvailablePLMNList_Item_sequence);

  return offset;
}


static const per_sequence_t AvailablePLMNList_sequence_of[1] = {
  { &hf_f1ap_AvailablePLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AvailablePLMNList_Item },
};

static int
dissect_f1ap_AvailablePLMNList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AvailablePLMNList, AvailablePLMNList_sequence_of,
                                                  1, maxnoofBPLMNs, false);

  return offset;
}



static int
dissect_f1ap_NID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     44, 44, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BroadcastNIDList_sequence_of[1] = {
  { &hf_f1ap_BroadcastNIDList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NID },
};

static int
dissect_f1ap_BroadcastNIDList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastNIDList, BroadcastNIDList_sequence_of,
                                                  1, maxnoofNIDsupported, false);

  return offset;
}


static const per_sequence_t AvailableSNPN_ID_List_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_availableNIDList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastNIDList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AvailableSNPN_ID_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AvailableSNPN_ID_List_Item, AvailableSNPN_ID_List_Item_sequence);

  return offset;
}


static const per_sequence_t AvailableSNPN_ID_List_sequence_of[1] = {
  { &hf_f1ap_AvailableSNPN_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AvailableSNPN_ID_List_Item },
};

static int
dissect_f1ap_AvailableSNPN_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_AvailableSNPN_ID_List, AvailableSNPN_ID_List_sequence_of,
                                                  1, maxnoofNIDsupported, false);

  return offset;
}



static int
dissect_f1ap_AveragingWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}


static const value_string f1ap_AreaScope_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_AreaScope(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_Expected_Value_AoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3599U, NULL, false);

  return offset;
}



static int
dissect_f1ap_Uncertainty_range_AoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3599U, NULL, false);

  return offset;
}


static const per_sequence_t Expected_Azimuth_AoA_sequence[] = {
  { &hf_f1ap_expected_Azimuth_AoA_value, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Expected_Value_AoA },
  { &hf_f1ap_expected_Azimuth_AoA_uncertainty, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Uncertainty_range_AoA },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Expected_Azimuth_AoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Expected_Azimuth_AoA, Expected_Azimuth_AoA_sequence);

  return offset;
}



static int
dissect_f1ap_Expected_Value_ZoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1799U, NULL, false);

  return offset;
}



static int
dissect_f1ap_Uncertainty_range_ZoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1799U, NULL, false);

  return offset;
}


static const per_sequence_t Expected_Zenith_AoA_sequence[] = {
  { &hf_f1ap_expected_Zenith_AoA_value, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Expected_Value_ZoA },
  { &hf_f1ap_expected_Zenith_AoA_uncertainty, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Uncertainty_range_ZoA },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Expected_Zenith_AoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Expected_Zenith_AoA, Expected_Zenith_AoA_sequence);

  return offset;
}


static const per_sequence_t Expected_UL_AoA_sequence[] = {
  { &hf_f1ap_expected_Azimuth_AoA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Expected_Azimuth_AoA },
  { &hf_f1ap_expected_Zenith_AoA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Expected_Zenith_AoA },
  { &hf_f1ap_iE_extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Expected_UL_AoA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Expected_UL_AoA, Expected_UL_AoA_sequence);

  return offset;
}


static const per_sequence_t Expected_ZoA_only_sequence[] = {
  { &hf_f1ap_expected_ZoA_only, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Expected_Zenith_AoA },
  { &hf_f1ap_iE_extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Expected_ZoA_only(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Expected_ZoA_only, Expected_ZoA_only_sequence);

  return offset;
}


static const value_string f1ap_AngleMeasurementType_vals[] = {
  {   0, "expected-ULAoA" },
  {   1, "expected-ZoA" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AngleMeasurementType_choice[] = {
  {   0, &hf_f1ap_expected_ULAoA , ASN1_NO_EXTENSIONS     , dissect_f1ap_Expected_UL_AoA },
  {   1, &hf_f1ap_expected_ZoA   , ASN1_NO_EXTENSIONS     , dissect_f1ap_Expected_ZoA_only },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_AngleMeasurementType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_AngleMeasurementType, AngleMeasurementType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AoA_AssistanceInfo_sequence[] = {
  { &hf_f1ap_angleMeasurement, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_AngleMeasurementType },
  { &hf_f1ap_lCS_to_GCS_Translation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCS_to_GCS_Translation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_AoA_AssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_AoA_AssistanceInfo, AoA_AssistanceInfo_sequence);

  return offset;
}



static int
dissect_f1ap_AppLayerBufferLevelList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}



static int
dissect_f1ap_ARP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, true);

  return offset;
}


static const value_string f1ap_T_milli_Arc_SecondUnits_vals[] = {
  {   0, "zerodot03" },
  {   1, "zerodot3" },
  {   2, "three" },
  { 0, NULL }
};


static int
dissect_f1ap_T_milli_Arc_SecondUnits(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_T_heightUnits_vals[] = {
  {   0, "mm" },
  {   1, "cm" },
  {   2, "m" },
  { 0, NULL }
};


static int
dissect_f1ap_T_heightUnits(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_M1024_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1024, 1023U, NULL, false);

  return offset;
}


static const per_sequence_t LocationUncertainty_sequence[] = {
  { &hf_f1ap_horizontalUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_horizontalConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_verticalUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_verticalConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LocationUncertainty(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LocationUncertainty, LocationUncertainty_sequence);

  return offset;
}


static const per_sequence_t RelativeGeodeticLocation_sequence[] = {
  { &hf_f1ap_milli_Arc_SecondUnits, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_milli_Arc_SecondUnits },
  { &hf_f1ap_heightUnits    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_heightUnits },
  { &hf_f1ap_deltaLatitude  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M1024_1023 },
  { &hf_f1ap_deltaLongitude , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M1024_1023 },
  { &hf_f1ap_deltaHeight    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M1024_1023 },
  { &hf_f1ap_locationUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LocationUncertainty },
  { &hf_f1ap_iE_extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RelativeGeodeticLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RelativeGeodeticLocation, RelativeGeodeticLocation_sequence);

  return offset;
}


static const value_string f1ap_T_xYZunit_vals[] = {
  {   0, "mm" },
  {   1, "cm" },
  {   2, "dm" },
  { 0, NULL }
};


static int
dissect_f1ap_T_xYZunit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_M65536_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -65536, 65535U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_M32768_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32768, 32767U, NULL, false);

  return offset;
}


static const per_sequence_t RelativeCartesianLocation_sequence[] = {
  { &hf_f1ap_xYZunit        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_xYZunit },
  { &hf_f1ap_xvalue         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M65536_65535 },
  { &hf_f1ap_yvalue         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M65536_65535 },
  { &hf_f1ap_zvalue         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M32768_32767 },
  { &hf_f1ap_locationUncertainty, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LocationUncertainty },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RelativeCartesianLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RelativeCartesianLocation, RelativeCartesianLocation_sequence);

  return offset;
}


static const value_string f1ap_ARPLocationType_vals[] = {
  {   0, "aRPPositionRelativeGeodetic" },
  {   1, "aRPPositionRelativeCartesian" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ARPLocationType_choice[] = {
  {   0, &hf_f1ap_aRPPositionRelativeGeodetic, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeGeodeticLocation },
  {   1, &hf_f1ap_aRPPositionRelativeCartesian, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeCartesianLocation },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ARPLocationType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ARPLocationType, ARPLocationType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ARPLocationInformation_Item_sequence[] = {
  { &hf_f1ap_aRP_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ARP_ID },
  { &hf_f1ap_aRPLocationType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ARPLocationType },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ARPLocationInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ARPLocationInformation_Item, ARPLocationInformation_Item_sequence);

  return offset;
}


static const per_sequence_t ARPLocationInformation_sequence_of[1] = {
  { &hf_f1ap_ARPLocationInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ARPLocationInformation_Item },
};

static int
dissect_f1ap_ARPLocationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ARPLocationInformation, ARPLocationInformation_sequence_of,
                                                  1, maxnoARPs, false);

  return offset;
}



static int
dissect_f1ap_BAPAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BAPPathID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BAPRoutingID_sequence[] = {
  { &hf_f1ap_bAPAddress     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPAddress },
  { &hf_f1ap_bAPPathID      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPPathID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPRoutingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPRoutingID, BAPRoutingID_sequence);

  return offset;
}


static const value_string f1ap_NonF1terminatingTopologyIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_NonF1terminatingTopologyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t BAP_Header_Rewriting_Added_List_Item_sequence[] = {
  { &hf_f1ap_ingressBAPRoutingID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_egressBAPRoutingID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_nonF1terminatingTopologyIndicator, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NonF1terminatingTopologyIndicator },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAP_Header_Rewriting_Added_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAP_Header_Rewriting_Added_List_Item, BAP_Header_Rewriting_Added_List_Item_sequence);

  return offset;
}


static const per_sequence_t BAP_Header_Rewriting_Removed_List_Item_sequence[] = {
  { &hf_f1ap_ingressBAPRoutingID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAP_Header_Rewriting_Removed_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAP_Header_Rewriting_Removed_List_Item, BAP_Header_Rewriting_Removed_List_Item_sequence);

  return offset;
}


static const value_string f1ap_FR1_Bandwidth_vals[] = {
  {   0, "bw5" },
  {   1, "bw10" },
  {   2, "bw20" },
  {   3, "bw40" },
  {   4, "bw50" },
  {   5, "bw80" },
  {   6, "bw100" },
  {   7, "bw160" },
  {   8, "bw200" },
  {   9, "bw15" },
  {  10, "bw25" },
  {  11, "bw30" },
  {  12, "bw60" },
  {  13, "bw35" },
  {  14, "bw45" },
  {  15, "bw70" },
  {  16, "bw90" },
  { 0, NULL }
};


static int
dissect_f1ap_FR1_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 10, NULL);

  return offset;
}


static const value_string f1ap_FR2_Bandwidth_vals[] = {
  {   0, "bw50" },
  {   1, "bw100" },
  {   2, "bw200" },
  {   3, "bw400" },
  {   4, "bw800" },
  {   5, "bw1600" },
  {   6, "bw2000" },
  {   7, "bw600" },
  { 0, NULL }
};


static int
dissect_f1ap_FR2_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 4, NULL);

  return offset;
}


static const value_string f1ap_BandwidthSRS_vals[] = {
  {   0, "fR1" },
  {   1, "fR2" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t BandwidthSRS_choice[] = {
  {   0, &hf_f1ap_fR1            , ASN1_NO_EXTENSIONS     , dissect_f1ap_FR1_Bandwidth },
  {   1, &hf_f1ap_fR2            , ASN1_NO_EXTENSIONS     , dissect_f1ap_FR2_Bandwidth },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_BandwidthSRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_BandwidthSRS, BandwidthSRS_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_BAPCtrlPDUChannel_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_BAPCtrlPDUChannel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_MappingInformationIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     26, 26, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BHRLCChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BAPlayerBHRLCchannelMappingInfo_Item_sequence[] = {
  { &hf_f1ap_mappingInformationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MappingInformationIndex },
  { &hf_f1ap_priorHopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BAPAddress },
  { &hf_f1ap_ingressbHRLCChannelID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_nextHopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BAPAddress },
  { &hf_f1ap_egressbHRLCChannelID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPlayerBHRLCchannelMappingInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPlayerBHRLCchannelMappingInfo_Item, BAPlayerBHRLCchannelMappingInfo_Item_sequence);

  return offset;
}


static const per_sequence_t BAPlayerBHRLCchannelMappingInfoList_sequence_of[1] = {
  { &hf_f1ap_BAPlayerBHRLCchannelMappingInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPlayerBHRLCchannelMappingInfo_Item },
};

static int
dissect_f1ap_BAPlayerBHRLCchannelMappingInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BAPlayerBHRLCchannelMappingInfoList, BAPlayerBHRLCchannelMappingInfoList_sequence_of,
                                                  1, maxnoofMappingEntries, false);

  return offset;
}


static const per_sequence_t MappingInformationtoRemove_sequence_of[1] = {
  { &hf_f1ap_MappingInformationtoRemove_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MappingInformationIndex },
};

static int
dissect_f1ap_MappingInformationtoRemove(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MappingInformationtoRemove, MappingInformationtoRemove_sequence_of,
                                                  1, maxnoofMappingEntries, false);

  return offset;
}


static const per_sequence_t BAPlayerBHRLCchannelMappingInfo_sequence[] = {
  { &hf_f1ap_bAPlayerBHRLCchannelMappingInfoToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BAPlayerBHRLCchannelMappingInfoList },
  { &hf_f1ap_bAPlayerBHRLCchannelMappingInfoToRemove, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MappingInformationtoRemove },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BAPlayerBHRLCchannelMappingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BAPlayerBHRLCchannelMappingInfo, BAPlayerBHRLCchannelMappingInfo_sequence);

  return offset;
}


static const value_string f1ap_BarringExemptionforEmerCallInfo_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_BarringExemptionforEmerCallInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MBSF1UInformation_sequence[] = {
  { &hf_f1ap_mbs_f1u_info   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBSF1UInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBSF1UInformation, MBSF1UInformation_sequence);

  return offset;
}



static int
dissect_f1ap_MBS_Area_Session_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, true);

  return offset;
}


static const per_sequence_t LocationDependentMBSF1UInformation_Item_sequence[] = {
  { &hf_f1ap_mbsAreaSession_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Area_Session_ID },
  { &hf_f1ap_mbs_f1u_info_at_CU, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LocationDependentMBSF1UInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LocationDependentMBSF1UInformation_Item, LocationDependentMBSF1UInformation_Item_sequence);

  return offset;
}


static const per_sequence_t LocationDependentMBSF1UInformation_sequence_of[1] = {
  { &hf_f1ap_LocationDependentMBSF1UInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LocationDependentMBSF1UInformation_Item },
};

static int
dissect_f1ap_LocationDependentMBSF1UInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LocationDependentMBSF1UInformation, LocationDependentMBSF1UInformation_sequence_of,
                                                  1, maxnoofMBSAreaSessionIDs, false);

  return offset;
}


static const value_string f1ap_BCBearerContextF1U_TNLInfo_vals[] = {
  {   0, "locationindpendent" },
  {   1, "locationdependent" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t BCBearerContextF1U_TNLInfo_choice[] = {
  {   0, &hf_f1ap_locationindpendent, ASN1_NO_EXTENSIONS     , dissect_f1ap_MBSF1UInformation },
  {   1, &hf_f1ap_locationdependent, ASN1_NO_EXTENSIONS     , dissect_f1ap_LocationDependentMBSF1UInformation },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_BCBearerContextF1U_TNLInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_BCBearerContextF1U_TNLInfo, BCBearerContextF1U_TNLInfo_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_BearerTypeChange_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_BearerTypeChange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_CauseRadioNetwork_vals[] = {
  {   0, "unspecified" },
  {   1, "rl-failure-rlc" },
  {   2, "unknown-or-already-allocated-gnb-cu-ue-f1ap-id" },
  {   3, "unknown-or-already-allocated-gnb-du-ue-f1ap-id" },
  {   4, "unknown-or-inconsistent-pair-of-ue-f1ap-id" },
  {   5, "interaction-with-other-procedure" },
  {   6, "not-supported-qci-Value" },
  {   7, "action-desirable-for-radio-reasons" },
  {   8, "no-radio-resources-available" },
  {   9, "procedure-cancelled" },
  {  10, "normal-release" },
  {  11, "cell-not-available" },
  {  12, "rl-failure-others" },
  {  13, "ue-rejection" },
  {  14, "resources-not-available-for-the-slice" },
  {  15, "amf-initiated-abnormal-release" },
  {  16, "release-due-to-pre-emption" },
  {  17, "plmn-not-served-by-the-gNB-CU" },
  {  18, "multiple-drb-id-instances" },
  {  19, "unknown-drb-id" },
  {  20, "multiple-bh-rlc-ch-id-instances" },
  {  21, "unknown-bh-rlc-ch-id" },
  {  22, "cho-cpc-resources-tobechanged" },
  {  23, "nPN-not-supported" },
  {  24, "nPN-access-denied" },
  {  25, "gNB-CU-Cell-Capacity-Exceeded" },
  {  26, "report-characteristics-empty" },
  {  27, "existing-measurement-ID" },
  {  28, "measurement-temporarily-not-available" },
  {  29, "measurement-not-supported-for-the-object" },
  {  30, "unknown-bh-address" },
  {  31, "unknown-bap-routing-id" },
  {  32, "insufficient-ue-capabilities" },
  {  33, "scg-activation-deactivation-failure" },
  {  34, "scg-deactivation-failure-due-to-data-transmission" },
  {  35, "requested-item-not-supported-on-time" },
  {  36, "unknown-or-already-allocated-gNB-CU-MBS-F1AP-ID" },
  {  37, "unknown-or-already-allocated-gNB-DU-MBS-F1AP-ID" },
  {  38, "unknown-or-inconsistent-pair-of-MBS-F1AP-ID" },
  {  39, "unknown-or-inconsistent-MRB-ID" },
  {  40, "tat-sdt-expiry" },
  {  41, "lTM-command-triggered" },
  {  42, "sSB-not-available" },
  { 0, NULL }
};


static int
dissect_f1ap_CauseRadioNetwork(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, true, 32, NULL);

  return offset;
}


static const value_string f1ap_CauseTransport_vals[] = {
  {   0, "unspecified" },
  {   1, "transport-resource-unavailable" },
  {   2, "unknown-TNL-address-for-IAB" },
  {   3, "unknown-UP-TNL-information-for-IAB" },
  { 0, NULL }
};


static int
dissect_f1ap_CauseTransport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 2, NULL);

  return offset;
}


static const value_string f1ap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "abstract-syntax-error-falsely-constructed-message" },
  {   6, "unspecified" },
  { 0, NULL }
};


static int
dissect_f1ap_CauseProtocol(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "not-enough-user-plane-processing-resources" },
  {   2, "hardware-failure" },
  {   3, "om-intervention" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_f1ap_CauseMisc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "protocol" },
  {   3, "misc" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_f1ap_radioNetwork   , ASN1_NO_EXTENSIONS     , dissect_f1ap_CauseRadioNetwork },
  {   1, &hf_f1ap_transport      , ASN1_NO_EXTENSIONS     , dissect_f1ap_CauseTransport },
  {   2, &hf_f1ap_protocol       , ASN1_NO_EXTENSIONS     , dissect_f1ap_CauseProtocol },
  {   3, &hf_f1ap_misc           , ASN1_NO_EXTENSIONS     , dissect_f1ap_CauseMisc },
  {   4, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_Cause, Cause_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeModified_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_FailedToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_FailedToBeModified_Item, BHChannels_FailedToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeSetup_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_FailedToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_FailedToBeSetup_Item, BHChannels_FailedToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_FailedToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_FailedToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_FailedToBeSetupMod_Item, BHChannels_FailedToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_Modified_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_Modified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_Modified_Item, BHChannels_Modified_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_Required_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_Required_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_Required_ToBeReleased_Item, BHChannels_Required_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_Setup_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_Setup_Item, BHChannels_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_SetupMod_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_SetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_SetupMod_Item, BHChannels_SetupMod_Item_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_255_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, false);

  return offset;
}



static int
dissect_f1ap_MaxDataBurstVolume(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}


static const per_sequence_t NonDynamic5QIDescriptor_sequence[] = {
  { &hf_f1ap_fiveQI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255_ },
  { &hf_f1ap_qoSPriorityLevel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_127 },
  { &hf_f1ap_averagingWindow, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AveragingWindow },
  { &hf_f1ap_maxDataBurstVolume, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MaxDataBurstVolume },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NonDynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NonDynamic5QIDescriptor, NonDynamic5QIDescriptor_sequence);

  return offset;
}


static const value_string f1ap_T_delayCritical_vals[] = {
  {   0, "delay-critical" },
  {   1, "non-delay-critical" },
  { 0, NULL }
};


static int
dissect_f1ap_T_delayCritical(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t Dynamic5QIDescriptor_sequence[] = {
  { &hf_f1ap_qoSPriorityLevel, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_127 },
  { &hf_f1ap_packetDelayBudget, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PacketDelayBudget },
  { &hf_f1ap_packetErrorRate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PacketErrorRate },
  { &hf_f1ap_fiveQI         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_255_ },
  { &hf_f1ap_delayCritical  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_delayCritical },
  { &hf_f1ap_averagingWindow, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AveragingWindow },
  { &hf_f1ap_maxDataBurstVolume, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MaxDataBurstVolume },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Dynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Dynamic5QIDescriptor, Dynamic5QIDescriptor_sequence);

  return offset;
}


static const value_string f1ap_QoS_Characteristics_vals[] = {
  {   0, "non-Dynamic-5QI" },
  {   1, "dynamic-5QI" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t QoS_Characteristics_choice[] = {
  {   0, &hf_f1ap_non_Dynamic_5QI, ASN1_NO_EXTENSIONS     , dissect_f1ap_NonDynamic5QIDescriptor },
  {   1, &hf_f1ap_dynamic_5QI    , ASN1_NO_EXTENSIONS     , dissect_f1ap_Dynamic5QIDescriptor },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_QoS_Characteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_QoS_Characteristics, QoS_Characteristics_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NGRANAllocationAndRetentionPriority_sequence[] = {
  { &hf_f1ap_priorityLevel  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PriorityLevel },
  { &hf_f1ap_pre_emptionCapability, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Pre_emptionCapability },
  { &hf_f1ap_pre_emptionVulnerability, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Pre_emptionVulnerability },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NGRANAllocationAndRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NGRANAllocationAndRetentionPriority, NGRANAllocationAndRetentionPriority_sequence);

  return offset;
}



static int
dissect_f1ap_MaxPacketLossRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1000U, NULL, false);

  return offset;
}


static const per_sequence_t GBR_QoSFlowInformation_sequence[] = {
  { &hf_f1ap_maxFlowBitRateDownlink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_maxFlowBitRateUplink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_guaranteedFlowBitRateDownlink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_guaranteedFlowBitRateUplink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_maxPacketLossRateDownlink, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MaxPacketLossRate },
  { &hf_f1ap_maxPacketLossRateUplink, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MaxPacketLossRate },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GBR_QoSFlowInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GBR_QoSFlowInformation, GBR_QoSFlowInformation_sequence);

  return offset;
}


static const value_string f1ap_T_reflective_QoS_Attribute_vals[] = {
  {   0, "subject-to" },
  { 0, NULL }
};


static int
dissect_f1ap_T_reflective_QoS_Attribute(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlowLevelQoSParameters_sequence[] = {
  { &hf_f1ap_qoS_Characteristics, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoS_Characteristics },
  { &hf_f1ap_nGRANallocationRetentionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NGRANAllocationAndRetentionPriority },
  { &hf_f1ap_gBR_QoS_Flow_Information, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_GBR_QoSFlowInformation },
  { &hf_f1ap_reflective_QoS_Attribute, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_reflective_QoS_Attribute },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_QoSFlowLevelQoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_QoSFlowLevelQoSParameters, QoSFlowLevelQoSParameters_sequence);

  return offset;
}



static int
dissect_f1ap_QCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t GBR_QosInformation_sequence[] = {
  { &hf_f1ap_e_RAB_MaximumBitrateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_e_RAB_MaximumBitrateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_e_RAB_GuaranteedBitrateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_e_RAB_GuaranteedBitrateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GBR_QosInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GBR_QosInformation, GBR_QosInformation_sequence);

  return offset;
}


static const per_sequence_t EUTRANQoS_sequence[] = {
  { &hf_f1ap_qCI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QCI },
  { &hf_f1ap_allocationAndRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_AllocationAndRetentionPriority },
  { &hf_f1ap_gbrQosInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GBR_QosInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRANQoS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRANQoS, EUTRANQoS_sequence);

  return offset;
}



static int
dissect_f1ap_CPTrafficType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, true);

  return offset;
}


static const value_string f1ap_BHQoSInformation_vals[] = {
  {   0, "bHRLCCHQoS" },
  {   1, "eUTRANBHRLCCHQoS" },
  {   2, "cPTrafficType" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t BHQoSInformation_choice[] = {
  {   0, &hf_f1ap_bHRLCCHQoS     , ASN1_NO_EXTENSIONS     , dissect_f1ap_QoSFlowLevelQoSParameters },
  {   1, &hf_f1ap_eUTRANBHRLCCHQoS, ASN1_NO_EXTENSIONS     , dissect_f1ap_EUTRANQoS },
  {   2, &hf_f1ap_cPTrafficType  , ASN1_NO_EXTENSIONS     , dissect_f1ap_CPTrafficType },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_BHQoSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_BHQoSInformation, BHQoSInformation_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_RLCMode_vals[] = {
  {   0, "rlc-am" },
  {   1, "rlc-um-bidirectional" },
  {   2, "rlc-um-unidirectional-ul" },
  {   3, "rlc-um-unidirectional-dl" },
  { 0, NULL }
};


static int
dissect_f1ap_RLCMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_T_iPv4Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_IABTNLAddressIPv4Address);
    proto_tree_add_item(subtree, hf_f1ap_IABTNLAddressIPv4, param_tvb, 0, 4, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_f1ap_T_iPv6Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     128, 128, false, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_IABTNLAddressIPv6Address);
    proto_tree_add_item(subtree, hf_f1ap_IABTNLAddressIPv6, param_tvb, 0, 16, ENC_NA);
  }


  return offset;
}



static int
dissect_f1ap_T_iPv6Prefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, false, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_IABTNLAddressIPv6Prefix);
    proto_tree_add_item(subtree, hf_f1ap_IABTNLAddressIPv6Prefix, param_tvb, 0, 8, ENC_NA);
  }


  return offset;
}


static const value_string f1ap_IABTNLAddress_vals[] = {
  {   0, "iPv4Address" },
  {   1, "iPv6Address" },
  {   2, "iPv6Prefix" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IABTNLAddress_choice[] = {
  {   0, &hf_f1ap_iPv4Address    , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_iPv4Address },
  {   1, &hf_f1ap_iPv6Address_01 , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_iPv6Address },
  {   2, &hf_f1ap_iPv6Prefix_01  , ASN1_NO_EXTENSIONS     , dissect_f1ap_T_iPv6Prefix },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_IABTNLAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_IABTNLAddress, IABTNLAddress_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_DSCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DSInformationList_sequence_of[1] = {
  { &hf_f1ap_DSInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DSCP },
};

static int
dissect_f1ap_DSInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DSInformationList, DSInformationList_sequence_of,
                                                  0, maxnoofDSInfo, false);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t IPHeaderInformation_sequence[] = {
  { &hf_f1ap_destinationIABTNLAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddress },
  { &hf_f1ap_dsInformationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DSInformationList },
  { &hf_f1ap_iPv6FlowLabel  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BIT_STRING_SIZE_20 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IPHeaderInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IPHeaderInformation, IPHeaderInformation_sequence);

  return offset;
}


static const per_sequence_t EgressBHRLCCHItem_sequence[] = {
  { &hf_f1ap_nextHopBAPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPAddress },
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EgressBHRLCCHItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EgressBHRLCCHItem, EgressBHRLCCHItem_sequence);

  return offset;
}


static const per_sequence_t EgressBHRLCCHList_sequence_of[1] = {
  { &hf_f1ap_EgressBHRLCCHList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EgressBHRLCCHItem },
};

static int
dissect_f1ap_EgressBHRLCCHList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_EgressBHRLCCHList, EgressBHRLCCHList_sequence_of,
                                                  1, maxnoofEgressLinks, false);

  return offset;
}


static const per_sequence_t BHInfo_sequence[] = {
  { &hf_f1ap_bAProutingID   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_egressBHRLCCHList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_EgressBHRLCCHList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHInfo, BHInfo_sequence);

  return offset;
}


static const per_sequence_t IPtolayer2TrafficMappingInfo_Item_sequence[] = {
  { &hf_f1ap_mappingInformationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MappingInformationIndex },
  { &hf_f1ap_iPHeaderInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_IPHeaderInformation },
  { &hf_f1ap_bHInfo         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BHInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IPtolayer2TrafficMappingInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IPtolayer2TrafficMappingInfo_Item, IPtolayer2TrafficMappingInfo_Item_sequence);

  return offset;
}


static const per_sequence_t IPtolayer2TrafficMappingInfoList_sequence_of[1] = {
  { &hf_f1ap_IPtolayer2TrafficMappingInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IPtolayer2TrafficMappingInfo_Item },
};

static int
dissect_f1ap_IPtolayer2TrafficMappingInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IPtolayer2TrafficMappingInfoList, IPtolayer2TrafficMappingInfoList_sequence_of,
                                                  1, maxnoofMappingEntries, false);

  return offset;
}


static const per_sequence_t IPtolayer2TrafficMappingInfo_sequence[] = {
  { &hf_f1ap_iPtolayer2TrafficMappingInfoToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_IPtolayer2TrafficMappingInfoList },
  { &hf_f1ap_iPtolayer2TrafficMappingInfoToRemove, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MappingInformationtoRemove },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IPtolayer2TrafficMappingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IPtolayer2TrafficMappingInfo, IPtolayer2TrafficMappingInfo_sequence);

  return offset;
}


static const value_string f1ap_TrafficMappingInfo_vals[] = {
  {   0, "iPtolayer2TrafficMappingInfo" },
  {   1, "bAPlayerBHRLCchannelMappingInfo" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TrafficMappingInfo_choice[] = {
  {   0, &hf_f1ap_iPtolayer2TrafficMappingInfo, ASN1_NO_EXTENSIONS     , dissect_f1ap_IPtolayer2TrafficMappingInfo },
  {   1, &hf_f1ap_bAPlayerBHRLCchannelMappingInfo, ASN1_NO_EXTENSIONS     , dissect_f1ap_BAPlayerBHRLCchannelMappingInfo },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TrafficMappingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TrafficMappingInfo, TrafficMappingInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BHChannels_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_bHQoSInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHQoSInformation },
  { &hf_f1ap_rLCmode        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RLCMode },
  { &hf_f1ap_bAPCtrlPDUChannel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BAPCtrlPDUChannel },
  { &hf_f1ap_trafficMappingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TrafficMappingInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_ToBeModified_Item, BHChannels_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_ToBeReleased_Item, BHChannels_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_bHQoSInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHQoSInformation },
  { &hf_f1ap_rLCmode        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_bAPCtrlPDUChannel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BAPCtrlPDUChannel },
  { &hf_f1ap_trafficMappingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TrafficMappingInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_ToBeSetup_Item, BHChannels_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t BHChannels_ToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_bHQoSInformation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHQoSInformation },
  { &hf_f1ap_rLCmode        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_bAPCtrlPDUChannel, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BAPCtrlPDUChannel },
  { &hf_f1ap_trafficMappingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TrafficMappingInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHChannels_ToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHChannels_ToBeSetupMod_Item, BHChannels_ToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t BHRLCCHItem_sequence[] = {
  { &hf_f1ap_bHRLCChannelID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCChannelID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BHRLCCHItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BHRLCCHItem, BHRLCCHItem_sequence);

  return offset;
}


static const per_sequence_t BHRLCCHList_sequence_of[1] = {
  { &hf_f1ap_BHRLCCHList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BHRLCCHItem },
};

static int
dissect_f1ap_BHRLCCHList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BHRLCCHList, BHRLCCHList_sequence_of,
                                                  1, maxnoofBHRLCChannels, false);

  return offset;
}


static const per_sequence_t BH_Routing_Information_Added_List_Item_sequence[] = {
  { &hf_f1ap_bAPRoutingID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_nextHopBAPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BH_Routing_Information_Added_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BH_Routing_Information_Added_List_Item, BH_Routing_Information_Added_List_Item_sequence);

  return offset;
}


static const per_sequence_t BH_Routing_Information_Removed_List_Item_sequence[] = {
  { &hf_f1ap_bAPRoutingID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPRoutingID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BH_Routing_Information_Removed_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BH_Routing_Information_Removed_List_Item, BH_Routing_Information_Removed_List_Item_sequence);

  return offset;
}


static const per_sequence_t ExtendedAvailablePLMN_Item_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ExtendedAvailablePLMN_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ExtendedAvailablePLMN_Item, ExtendedAvailablePLMN_Item_sequence);

  return offset;
}


static const per_sequence_t ExtendedAvailablePLMN_List_sequence_of[1] = {
  { &hf_f1ap_ExtendedAvailablePLMN_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedAvailablePLMN_Item },
};

static int
dissect_f1ap_ExtendedAvailablePLMN_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ExtendedAvailablePLMN_List, ExtendedAvailablePLMN_List_sequence_of,
                                                  1, maxnoofExtendedBPLMNs, false);

  return offset;
}



static int
dissect_f1ap_FiveGS_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       3, 3, false, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 3, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_f1ap_RANAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_AvailablePLMNList },
  { &hf_f1ap_extended_PLMN_Identity_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ExtendedAvailablePLMN_List },
  { &hf_f1ap_fiveGS_TAC     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveGS_TAC },
  { &hf_f1ap_nr_cell_ID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCellIdentity },
  { &hf_f1ap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_RANAC },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BPLMN_ID_Info_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BPLMN_ID_Info_Item, BPLMN_ID_Info_Item_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_List_sequence_of[1] = {
  { &hf_f1ap_BPLMN_ID_Info_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BPLMN_ID_Info_Item },
};

static int
dissect_f1ap_BPLMN_ID_Info_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BPLMN_ID_Info_List, BPLMN_ID_Info_List_sequence_of,
                                                  1, maxnoofBPLMNsNR, false);

  return offset;
}


static const per_sequence_t ServedPLMNs_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ServedPLMNs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ServedPLMNs_Item, ServedPLMNs_Item_sequence);

  return offset;
}


static const per_sequence_t ServedPLMNs_List_sequence_of[1] = {
  { &hf_f1ap_ServedPLMNs_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ServedPLMNs_Item },
};

static int
dissect_f1ap_ServedPLMNs_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ServedPLMNs_List, ServedPLMNs_List_sequence_of,
                                                  1, maxnoofBPLMNs, false);

  return offset;
}



static int
dissect_f1ap_CAGID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BroadcastCAGList_sequence_of[1] = {
  { &hf_f1ap_BroadcastCAGList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CAGID },
};

static int
dissect_f1ap_BroadcastCAGList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastCAGList, BroadcastCAGList_sequence_of,
                                                  1, maxnoofCAGsupported, false);

  return offset;
}



static int
dissect_f1ap_MRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 512U, NULL, true);

  return offset;
}


static const per_sequence_t BroadcastMRBs_FailedToBeModified_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_FailedToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_FailedToBeModified_Item, BroadcastMRBs_FailedToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastMRBs_FailedToBeSetup_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_FailedToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_FailedToBeSetup_Item, BroadcastMRBs_FailedToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastMRBs_FailedToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_FailedToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_FailedToBeSetupMod_Item, BroadcastMRBs_FailedToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastMRBs_Modified_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_bcBearerCtxtF1U_TNLInfoatDU, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BCBearerContextF1U_TNLInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_Modified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_Modified_Item, BroadcastMRBs_Modified_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastMRBs_Setup_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_bcBearerCtxtF1U_TNLInfoatDU, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BCBearerContextF1U_TNLInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_Setup_Item, BroadcastMRBs_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastMRBs_SetupMod_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_bcBearerCtxtF1U_TNLInfoatDU, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BCBearerContextF1U_TNLInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_SetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_SetupMod_Item, BroadcastMRBs_SetupMod_Item_sequence);

  return offset;
}



static int
dissect_f1ap_QoSFlowIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const per_sequence_t MBS_Flows_Mapped_To_MRB_Item_sequence[] = {
  { &hf_f1ap_mBS_QoSFlowIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowIdentifier },
  { &hf_f1ap_mbs_QoSFlowLevelQoSParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowLevelQoSParameters },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBS_Flows_Mapped_To_MRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBS_Flows_Mapped_To_MRB_Item, MBS_Flows_Mapped_To_MRB_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_Flows_Mapped_To_MRB_List_sequence_of[1] = {
  { &hf_f1ap_MBS_Flows_Mapped_To_MRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Flows_Mapped_To_MRB_Item },
};

static int
dissect_f1ap_MBS_Flows_Mapped_To_MRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MBS_Flows_Mapped_To_MRB_List, MBS_Flows_Mapped_To_MRB_List_sequence_of,
                                                  1, maxnoofMBSQoSFlows, false);

  return offset;
}


static const per_sequence_t BroadcastMRBs_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_mRB_QoSInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_QoSFlowLevelQoSParameters },
  { &hf_f1ap_mBS_Flows_Mapped_To_MRB_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MBS_Flows_Mapped_To_MRB_List },
  { &hf_f1ap_bcBearerCtxtF1U_TNLInfoatCU, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_BCBearerContextF1U_TNLInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_ToBeModified_Item, BroadcastMRBs_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastMRBs_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_ToBeReleased_Item, BroadcastMRBs_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastMRBs_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_mRB_QoSInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowLevelQoSParameters },
  { &hf_f1ap_mBS_Flows_Mapped_To_MRB_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Flows_Mapped_To_MRB_List },
  { &hf_f1ap_bcBearerCtxtF1U_TNLInfoatCU, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BCBearerContextF1U_TNLInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_ToBeSetup_Item, BroadcastMRBs_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastMRBs_ToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_mRB_QoSInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowLevelQoSParameters },
  { &hf_f1ap_mBS_Flows_Mapped_To_MRB_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Flows_Mapped_To_MRB_List },
  { &hf_f1ap_bcBearerCtxtF1U_TNLInfoatCU, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BCBearerContextF1U_TNLInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastMRBs_ToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastMRBs_ToBeSetupMod_Item, BroadcastMRBs_ToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastSNPN_ID_List_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_broadcastNIDList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastNIDList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastSNPN_ID_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastSNPN_ID_List_Item, BroadcastSNPN_ID_List_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastSNPN_ID_List_sequence_of[1] = {
  { &hf_f1ap_BroadcastSNPN_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastSNPN_ID_List_Item },
};

static int
dissect_f1ap_BroadcastSNPN_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastSNPN_ID_List, BroadcastSNPN_ID_List_sequence_of,
                                                  1, maxnoofNIDsupported, false);

  return offset;
}


static const per_sequence_t BroadcastPNI_NPN_ID_List_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_broadcastCAGList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastCAGList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BroadcastPNI_NPN_ID_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BroadcastPNI_NPN_ID_List_Item, BroadcastPNI_NPN_ID_List_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastPNI_NPN_ID_List_sequence_of[1] = {
  { &hf_f1ap_BroadcastPNI_NPN_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastPNI_NPN_ID_List_Item },
};

static int
dissect_f1ap_BroadcastPNI_NPN_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastPNI_NPN_ID_List, BroadcastPNI_NPN_ID_List_sequence_of,
                                                  1, maxnoofCAGsupported, false);

  return offset;
}


static const per_sequence_t Broadcast_Cell_List_Item_sequence[] = {
  { &hf_f1ap_cellID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Broadcast_Cell_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Broadcast_Cell_List_Item, Broadcast_Cell_List_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastCellList_sequence_of[1] = {
  { &hf_f1ap_BroadcastCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Broadcast_Cell_List_Item },
};

static int
dissect_f1ap_BroadcastCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_BroadcastCellList, BroadcastCellList_sequence_of,
                                                  1, maxCellingNBDU, false);

  return offset;
}


static const per_sequence_t PartialSuccessCell_sequence[] = {
  { &hf_f1ap_broadcastCellList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BroadcastCellList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PartialSuccessCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PartialSuccessCell, PartialSuccessCell_sequence);

  return offset;
}


static const value_string f1ap_BroadcastAreaScope_vals[] = {
  {   0, "completeSuccess" },
  {   1, "partialSuccess" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t BroadcastAreaScope_choice[] = {
  {   0, &hf_f1ap_completeSuccess, ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   1, &hf_f1ap_partialSuccess , ASN1_NO_EXTENSIONS     , dissect_f1ap_PartialSuccessCell },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_BroadcastAreaScope(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_BroadcastAreaScope, BroadcastAreaScope_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_BufferSizeThresh(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, false);

  return offset;
}



static int
dissect_f1ap_BurstArrivalTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_BurstArrivalTime);
    dissect_nr_rrc_ReferenceTime_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_BW_Aggregation_Request_Indication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_BW_Aggregation_Request_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_BWP_Id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_640000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 640000U, NULL, true);

  return offset;
}


static const per_sequence_t BurstArrivalTimeWindow_sequence[] = {
  { &hf_f1ap_burstArrivalTimeWindowStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_640000_ },
  { &hf_f1ap_burstArrivalTimeWindowEnd, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_640000_ },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_BurstArrivalTimeWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_BurstArrivalTimeWindow, BurstArrivalTimeWindow_sequence);

  return offset;
}


static const per_sequence_t Broadcast_MRBs_Transport_Request_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_bcBearerCtxtF1U_TNLInfoatDU, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BCBearerContextF1U_TNLInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Broadcast_MRBs_Transport_Request_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Broadcast_MRBs_Transport_Request_Item, Broadcast_MRBs_Transport_Request_Item_sequence);

  return offset;
}


static const value_string f1ap_Cancel_all_Warning_Messages_Indicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_Cancel_all_Warning_Messages_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Candidate_SpCell_Item_sequence[] = {
  { &hf_f1ap_candidate_SpCell_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Candidate_SpCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Candidate_SpCell_Item, Candidate_SpCell_Item_sequence);

  return offset;
}



static int
dissect_f1ap_SSBIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const per_sequence_t CandidateCellwithBeamInfo_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_sSBIndex       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBIndex },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CandidateCellwithBeamInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CandidateCellwithBeamInfo, CandidateCellwithBeamInfo_sequence);

  return offset;
}


static const per_sequence_t SSBIndexList_Item_sequence[] = {
  { &hf_f1ap_sSBIndex       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBIndex },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBIndexList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBIndexList_Item, SSBIndexList_Item_sequence);

  return offset;
}


static const per_sequence_t SSBIndexList_sequence_of[1] = {
  { &hf_f1ap_SSBIndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBIndexList_Item },
};

static int
dissect_f1ap_SSBIndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBIndexList, SSBIndexList_sequence_of,
                                                  1, maxnoofSSBIndices, false);

  return offset;
}


static const per_sequence_t CandidateCellwithBeamInfo_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_sSBIndexList   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBIndexList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CandidateCellwithBeamInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CandidateCellwithBeamInfo_Item, CandidateCellwithBeamInfo_Item_sequence);

  return offset;
}


static const per_sequence_t CandidateCellwithBeamInfoList_sequence_of[1] = {
  { &hf_f1ap_CandidateCellwithBeamInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CandidateCellwithBeamInfo_Item },
};

static int
dissect_f1ap_CandidateCellwithBeamInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CandidateCellwithBeamInfoList, CandidateCellwithBeamInfoList_sequence_of,
                                                  1, maxnoofCandidateCells, false);

  return offset;
}


static const per_sequence_t SelectedMeasurementQuantities_sequence[] = {
  { &hf_f1ap_rSRP           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_rSRQ           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_sINR           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_127 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SelectedMeasurementQuantities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SelectedMeasurementQuantities, SelectedMeasurementQuantities_sequence);

  return offset;
}


static const per_sequence_t SSBIndexwithMeasurements_Item_sequence[] = {
  { &hf_f1ap_sSBIndex       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBIndex },
  { &hf_f1ap_selectedMeasurementQuantities, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SelectedMeasurementQuantities },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBIndexwithMeasurements_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBIndexwithMeasurements_Item, SSBIndexwithMeasurements_Item_sequence);

  return offset;
}


static const per_sequence_t SSBIndexwithMeasurementsList_sequence_of[1] = {
  { &hf_f1ap_SSBIndexwithMeasurementsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBIndexwithMeasurements_Item },
};

static int
dissect_f1ap_SSBIndexwithMeasurementsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBIndexwithMeasurementsList, SSBIndexwithMeasurementsList_sequence_of,
                                                  1, maxnoofSSBIndices, false);

  return offset;
}


static const per_sequence_t CandidateCellwithMeasurements_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_sSBIndexwithMeasurementsList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBIndexwithMeasurementsList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CandidateCellwithMeasurements_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CandidateCellwithMeasurements_Item, CandidateCellwithMeasurements_Item_sequence);

  return offset;
}


static const per_sequence_t CandidateCellwithMeasurementsList_sequence_of[1] = {
  { &hf_f1ap_CandidateCellwithMeasurementsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CandidateCellwithMeasurements_Item },
};

static int
dissect_f1ap_CandidateCellwithMeasurementsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CandidateCellwithMeasurementsList, CandidateCellwithMeasurementsList_sequence_of,
                                                  1, maxnoofCandidateCells, false);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValueItem_sequence[] = {
  { &hf_f1ap_sSBIndex_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_sSBAreaCapacityValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBAreaCapacityValueItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBAreaCapacityValueItem, SSBAreaCapacityValueItem_sequence);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValueList_sequence_of[1] = {
  { &hf_f1ap_SSBAreaCapacityValueList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBAreaCapacityValueItem },
};

static int
dissect_f1ap_SSBAreaCapacityValueList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBAreaCapacityValueList, SSBAreaCapacityValueList_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t CapacityValue_sequence[] = {
  { &hf_f1ap_capacityValue  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaCapacityValueList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSBAreaCapacityValueList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CapacityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CapacityValue, CapacityValue_sequence);

  return offset;
}



static int
dissect_f1ap_CellGroupConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_CellGroupConfig);
    dissect_nr_rrc_CellGroupConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_CellCapacityClassValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, true);

  return offset;
}


static const value_string f1ap_Cell_Direction_vals[] = {
  {   0, "dl-only" },
  {   1, "ul-only" },
  { 0, NULL }
};


static int
dissect_f1ap_Cell_Direction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatusItem_sequence[] = {
  { &hf_f1ap_sSBIndex_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_sSBAreaDLGBRPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaULGBRPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaDLnon_GBRPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaULnon_GBRPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaDLTotalPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sSBAreaULTotalPRBusage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_dLschedulingPDCCHCCEusage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_uLschedulingPDCCHCCEusage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBAreaRadioResourceStatusItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBAreaRadioResourceStatusItem, SSBAreaRadioResourceStatusItem_sequence);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatusList_sequence_of[1] = {
  { &hf_f1ap_SSBAreaRadioResourceStatusList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBAreaRadioResourceStatusItem },
};

static int
dissect_f1ap_SSBAreaRadioResourceStatusList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBAreaRadioResourceStatusList, SSBAreaRadioResourceStatusList_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t RadioResourceStatus_sequence[] = {
  { &hf_f1ap_sSBAreaRadioResourceStatusList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBAreaRadioResourceStatusList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_RadioResourceStatus, RadioResourceStatus_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacity_sequence[] = {
  { &hf_f1ap_cellCapacityClassValue, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_CellCapacityClassValue },
  { &hf_f1ap_capacityValue_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CapacityValue },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CompositeAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CompositeAvailableCapacity, CompositeAvailableCapacity_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacityGroup_sequence[] = {
  { &hf_f1ap_compositeAvailableCapacityDownlink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CompositeAvailableCapacity },
  { &hf_f1ap_compositeAvailableCapacityUplink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CompositeAvailableCapacity },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CompositeAvailableCapacityGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CompositeAvailableCapacityGroup, CompositeAvailableCapacityGroup_sequence);

  return offset;
}



static int
dissect_f1ap_OCTET_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, false, NULL);

  return offset;
}



static int
dissect_f1ap_OCTET_STRING_SIZE_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, false, NULL);

  return offset;
}


static const per_sequence_t SNSSAI_sequence[] = {
  { &hf_f1ap_sST            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_OCTET_STRING_SIZE_1 },
  { &hf_f1ap_sD             , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_OCTET_STRING_SIZE_3 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SNSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SNSSAI, SNSSAI_sequence);

  return offset;
}


static const per_sequence_t SNSSAIAvailableCapacity_Item_sequence[] = {
  { &hf_f1ap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_sliceAvailableCapacityValueDownlink, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_sliceAvailableCapacityValueUplink, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SNSSAIAvailableCapacity_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SNSSAIAvailableCapacity_Item, SNSSAIAvailableCapacity_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAIAvailableCapacity_List_sequence_of[1] = {
  { &hf_f1ap_SNSSAIAvailableCapacity_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAIAvailableCapacity_Item },
};

static int
dissect_f1ap_SNSSAIAvailableCapacity_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SNSSAIAvailableCapacity_List, SNSSAIAvailableCapacity_List_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}


static const per_sequence_t SliceAvailableCapacityItem_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_sNSSAIAvailableCapacity_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAIAvailableCapacity_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SliceAvailableCapacityItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SliceAvailableCapacityItem, SliceAvailableCapacityItem_sequence);

  return offset;
}


static const per_sequence_t SliceAvailableCapacityList_sequence_of[1] = {
  { &hf_f1ap_SliceAvailableCapacityList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceAvailableCapacityItem },
};

static int
dissect_f1ap_SliceAvailableCapacityList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SliceAvailableCapacityList, SliceAvailableCapacityList_sequence_of,
                                                  1, maxnoofBPLMNsNR, false);

  return offset;
}


static const per_sequence_t SliceAvailableCapacity_sequence[] = {
  { &hf_f1ap_sliceAvailableCapacityList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceAvailableCapacityList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SliceAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SliceAvailableCapacity, SliceAvailableCapacity_sequence);

  return offset;
}



static int
dissect_f1ap_NumberofActiveUEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, true);

  return offset;
}


static const per_sequence_t CellMeasurementResultItem_sequence[] = {
  { &hf_f1ap_cellID         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_radioResourceStatus, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RadioResourceStatus },
  { &hf_f1ap_compositeAvailableCapacityGroup, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_CompositeAvailableCapacityGroup },
  { &hf_f1ap_sliceAvailableCapacity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SliceAvailableCapacity },
  { &hf_f1ap_numberofActiveUEs, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NumberofActiveUEs },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CellMeasurementResultItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CellMeasurementResultItem, CellMeasurementResultItem_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResultList_sequence_of[1] = {
  { &hf_f1ap_CellMeasurementResultList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CellMeasurementResultItem },
};

static int
dissect_f1ap_CellMeasurementResultList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CellMeasurementResultList, CellMeasurementResultList_sequence_of,
                                                  1, maxCellingNBDU, false);

  return offset;
}



static int
dissect_f1ap_Cell_Portion_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_maxNRARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, false);

  return offset;
}


static const value_string f1ap_FrequencyShift7p5khz_vals[] = {
  {   0, "false" },
  {   1, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_FrequencyShift7p5khz(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_NRSCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  {   4, "scs480" },
  {   5, "scs960" },
  { 0, NULL }
};


static int
dissect_f1ap_NRSCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 2, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_maxnoofPhysicalResourceBlocks_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofPhysicalResourceBlocks, NULL, true);

  return offset;
}


static const per_sequence_t NRCarrierItem_sequence[] = {
  { &hf_f1ap_carrierSCS     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRSCS },
  { &hf_f1ap_offsetToCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_2199_ },
  { &hf_f1ap_carrierBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxnoofPhysicalResourceBlocks_ },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRCarrierItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRCarrierItem, NRCarrierItem_sequence);

  return offset;
}


static const per_sequence_t NRCarrierList_sequence_of[1] = {
  { &hf_f1ap_NRCarrierList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCarrierItem },
};

static int
dissect_f1ap_NRCarrierList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_NRCarrierList, NRCarrierList_sequence_of,
                                                  1, maxnoofNRSCSs, false);

  return offset;
}


static const per_sequence_t FreqInfoRel16_sequence[] = {
  { &hf_f1ap_nRARFCN        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_maxNRARFCN },
  { &hf_f1ap_frequencyShift7p5khz, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FrequencyShift7p5khz },
  { &hf_f1ap_carrierList    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRCarrierList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FreqInfoRel16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FreqInfoRel16, FreqInfoRel16_sequence);

  return offset;
}


static const per_sequence_t FDD_InfoRel16_sequence[] = {
  { &hf_f1ap_uL_FreqInfo    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FreqInfoRel16 },
  { &hf_f1ap_sUL_FreqInfo   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FreqInfoRel16 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FDD_InfoRel16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FDD_InfoRel16, FDD_InfoRel16_sequence);

  return offset;
}



static int
dissect_f1ap_TDD_UL_DLConfigCommonNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb && lte_rrc_conn_reconf_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_TDD_UL_DLConfigCommonNR);
    dissect_nr_rrc_TDD_UL_DL_ConfigCommon_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t TDD_InfoRel16_sequence[] = {
  { &hf_f1ap_tDD_FreqInfo   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FreqInfoRel16 },
  { &hf_f1ap_sUL_FreqInfo   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FreqInfoRel16 },
  { &hf_f1ap_tDD_UL_DLConfigCommonNR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TDD_UL_DLConfigCommonNR },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TDD_InfoRel16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TDD_InfoRel16, TDD_InfoRel16_sequence);

  return offset;
}


static const value_string f1ap_NR_ModeInfoRel16_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NR_ModeInfoRel16_choice[] = {
  {   0, &hf_f1ap_fDD_04         , ASN1_NO_EXTENSIONS     , dissect_f1ap_FDD_InfoRel16 },
  {   1, &hf_f1ap_tDD_04         , ASN1_NO_EXTENSIONS     , dissect_f1ap_TDD_InfoRel16 },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_NR_ModeInfoRel16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_NR_ModeInfoRel16, NR_ModeInfoRel16_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_SSB_PositionsInBurst_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SSB_PositionsInBurst_choice[] = {
  {   0, &hf_f1ap_shortBitmap    , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_4 },
  {   1, &hf_f1ap_mediumBitmap   , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_8 },
  {   2, &hf_f1ap_longBitmap     , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_64 },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SSB_PositionsInBurst(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SSB_PositionsInBurst, SSB_PositionsInBurst_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_maxnoofPhysicalResourceBlocks_1_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofPhysicalResourceBlocks_1, NULL, true);

  return offset;
}


static const value_string f1ap_T_prachFDM_vals[] = {
  {   0, "one" },
  {   1, "two" },
  {   2, "four" },
  {   3, "eight" },
  { 0, NULL }
};


static int
dissect_f1ap_T_prachFDM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_T_ssb_perRACH_Occasion_vals[] = {
  {   0, "oneEighth" },
  {   1, "oneFourth" },
  {   2, "oneHalf" },
  {   3, "one" },
  {   4, "two" },
  {   5, "four" },
  {   6, "eight" },
  {   7, "sixteen" },
  { 0, NULL }
};


static int
dissect_f1ap_T_ssb_perRACH_Occasion(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_837(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 837U, NULL, false);

  return offset;
}


static const value_string f1ap_T_restrictedSetConfig_vals[] = {
  {   0, "unrestrictedSet" },
  {   1, "restrictedSetTypeA" },
  {   2, "restrictedSetTypeB" },
  { 0, NULL }
};


static int
dissect_f1ap_T_restrictedSetConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t L839Info_sequence[] = {
  { &hf_f1ap_rootSequenceIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_837 },
  { &hf_f1ap_restrictedSetConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_restrictedSetConfig },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_L839Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_L839Info, L839Info_sequence);

  return offset;
}


static const value_string f1ap_T_prachSCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  {   4, "scs480" },
  {   5, "scs960" },
  { 0, NULL }
};


static int
dissect_f1ap_T_prachSCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 2, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_137(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 137U, NULL, false);

  return offset;
}


static const per_sequence_t L139Info_sequence[] = {
  { &hf_f1ap_prachSCS       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_prachSCS },
  { &hf_f1ap_rootSequenceIndex_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_137 },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_L139Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_L139Info, L139Info_sequence);

  return offset;
}


static const value_string f1ap_FreqDomainLength_vals[] = {
  {   0, "l839" },
  {   1, "l139" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t FreqDomainLength_choice[] = {
  {   0, &hf_f1ap_l839           , ASN1_NO_EXTENSIONS     , dissect_f1ap_L839Info },
  {   1, &hf_f1ap_l139           , ASN1_NO_EXTENSIONS     , dissect_f1ap_L139Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_FreqDomainLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_FreqDomainLength, FreqDomainLength_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NRPRACHConfigItem_sequence[] = {
  { &hf_f1ap_nRSCS_01       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRSCS },
  { &hf_f1ap_prachFreqStartfromCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxnoofPhysicalResourceBlocks_1_ },
  { &hf_f1ap_prachFDM       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_prachFDM },
  { &hf_f1ap_prachConfigIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255_ },
  { &hf_f1ap_ssb_perRACH_Occasion, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_ssb_perRACH_Occasion },
  { &hf_f1ap_freqDomainLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_FreqDomainLength },
  { &hf_f1ap_zeroCorrelZoneConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRPRACHConfigItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRPRACHConfigItem, NRPRACHConfigItem_sequence);

  return offset;
}


static const per_sequence_t NRPRACHConfigList_sequence_of[1] = {
  { &hf_f1ap_NRPRACHConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRPRACHConfigItem },
};

static int
dissect_f1ap_NRPRACHConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_NRPRACHConfigList, NRPRACHConfigList_sequence_of,
                                                  0, maxnoofPRACHconfigs, false);

  return offset;
}


static const per_sequence_t NRPRACHConfig_sequence[] = {
  { &hf_f1ap_ulPRACHConfigList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRPRACHConfigList },
  { &hf_f1ap_sulPRACHConfigList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRPRACHConfigList },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRPRACHConfig, NRPRACHConfig_sequence);

  return offset;
}


static const per_sequence_t NeighbourNR_CellsForSON_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_nR_ModeInfoRel16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NR_ModeInfoRel16 },
  { &hf_f1ap_sSB_PositionsInBurst, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SSB_PositionsInBurst },
  { &hf_f1ap_nRPRACHConfig  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRPRACHConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NeighbourNR_CellsForSON_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NeighbourNR_CellsForSON_Item, NeighbourNR_CellsForSON_Item_sequence);

  return offset;
}


static const per_sequence_t NeighbourNR_CellsForSON_List_sequence_of[1] = {
  { &hf_f1ap_NeighbourNR_CellsForSON_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NeighbourNR_CellsForSON_Item },
};

static int
dissect_f1ap_NeighbourNR_CellsForSON_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_NeighbourNR_CellsForSON_List, NeighbourNR_CellsForSON_List_sequence_of,
                                                  1, maxNeighbourCellforSON, false);

  return offset;
}


static const per_sequence_t CellsForSON_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_neighbourNR_CellsForSON_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NeighbourNR_CellsForSON_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CellsForSON_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CellsForSON_Item, CellsForSON_Item_sequence);

  return offset;
}


static const per_sequence_t CellsForSON_List_sequence_of[1] = {
  { &hf_f1ap_CellsForSON_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CellsForSON_Item },
};

static int
dissect_f1ap_CellsForSON_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CellsForSON_List, CellsForSON_List_sequence_of,
                                                  1, maxServedCellforSON, false);

  return offset;
}


static const per_sequence_t Cells_Failed_to_be_Activated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Failed_to_be_Activated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Failed_to_be_Activated_List_Item, Cells_Failed_to_be_Activated_List_Item_sequence);

  return offset;
}


static const value_string f1ap_Service_State_vals[] = {
  {   0, "in-service" },
  {   1, "out-of-service" },
  { 0, NULL }
};


static int
dissect_f1ap_Service_State(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_T_switchingOffOngoing_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_T_switchingOffOngoing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Service_Status_sequence[] = {
  { &hf_f1ap_service_state  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Service_State },
  { &hf_f1ap_switchingOffOngoing, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_T_switchingOffOngoing },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Service_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Service_Status, Service_Status_sequence);

  return offset;
}


static const per_sequence_t Cells_Status_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_service_status , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Service_Status },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Status_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Status_Item, Cells_Status_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_To_Be_Broadcast_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_To_Be_Broadcast_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_To_Be_Broadcast_Item, Cells_To_Be_Broadcast_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_Broadcast_Completed_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Broadcast_Completed_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Broadcast_Completed_Item, Cells_Broadcast_Completed_Item_sequence);

  return offset;
}


static const per_sequence_t Broadcast_To_Be_Cancelled_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Broadcast_To_Be_Cancelled_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Broadcast_To_Be_Cancelled_Item, Broadcast_To_Be_Cancelled_Item_sequence);

  return offset;
}



static int
dissect_f1ap_NumberOfBroadcasts(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}


static const per_sequence_t Cells_Broadcast_Cancelled_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_numberOfBroadcasts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NumberOfBroadcasts },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Broadcast_Cancelled_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Broadcast_Cancelled_Item, Cells_Broadcast_Cancelled_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_to_be_Activated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_nRPCI          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRPCI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_to_be_Activated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_to_be_Activated_List_Item, Cells_to_be_Activated_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSBs_activated_List_sequence_of[1] = {
  { &hf_f1ap_SSBs_activated_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_Index },
};

static int
dissect_f1ap_SSBs_activated_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBs_activated_List, SSBs_activated_List_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t Cells_With_SSBs_Activated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_sSBs_activated_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBs_activated_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_With_SSBs_Activated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_With_SSBs_Activated_List_Item, Cells_With_SSBs_Activated_List_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_With_SSBs_Activated_List_sequence_of[1] = {
  { &hf_f1ap_Cells_With_SSBs_Activated_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Cells_With_SSBs_Activated_List_Item },
};

static int
dissect_f1ap_Cells_With_SSBs_Activated_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Cells_With_SSBs_Activated_List, Cells_With_SSBs_Activated_List_sequence_of,
                                                  1, maxCellingNBDU, false);

  return offset;
}


static const per_sequence_t Cells_Allowed_to_be_Deactivated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_Allowed_to_be_Deactivated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_Allowed_to_be_Deactivated_List_Item, Cells_Allowed_to_be_Deactivated_List_Item_sequence);

  return offset;
}


static const per_sequence_t Cells_to_be_Deactivated_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_to_be_Deactivated_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_to_be_Deactivated_List_Item, Cells_to_be_Deactivated_List_Item_sequence);

  return offset;
}


static const value_string f1ap_CellBarred_vals[] = {
  {   0, "barred" },
  {   1, "not-barred" },
  { 0, NULL }
};


static int
dissect_f1ap_CellBarred(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Cells_to_be_Barred_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_cellBarred     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CellBarred },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Cells_to_be_Barred_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Cells_to_be_Barred_Item, Cells_to_be_Barred_Item_sequence);

  return offset;
}


static const value_string f1ap_CellSize_vals[] = {
  {   0, "verysmall" },
  {   1, "small" },
  {   2, "medium" },
  {   3, "large" },
  { 0, NULL }
};


static int
dissect_f1ap_CellSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SSBToReportItem_sequence[] = {
  { &hf_f1ap_sSBIndex_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBToReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBToReportItem, SSBToReportItem_sequence);

  return offset;
}


static const per_sequence_t SSBToReportList_sequence_of[1] = {
  { &hf_f1ap_SSBToReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBToReportItem },
};

static int
dissect_f1ap_SSBToReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBToReportList, SSBToReportList_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t SNSSAI_Item_sequence[] = {
  { &hf_f1ap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SNSSAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SNSSAI_Item, SNSSAI_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAI_list_sequence_of[1] = {
  { &hf_f1ap_SNSSAI_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI_Item },
};

static int
dissect_f1ap_SNSSAI_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SNSSAI_list, SNSSAI_list_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}


static const per_sequence_t SliceToReportItem_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_sNSSAIlist     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI_list },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SliceToReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SliceToReportItem, SliceToReportItem_sequence);

  return offset;
}


static const per_sequence_t SliceToReportList_sequence_of[1] = {
  { &hf_f1ap_SliceToReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceToReportItem },
};

static int
dissect_f1ap_SliceToReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SliceToReportList, SliceToReportList_sequence_of,
                                                  1, maxnoofBPLMNsNR, false);

  return offset;
}


static const per_sequence_t CellToReportItem_sequence[] = {
  { &hf_f1ap_cellID         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_sSBToReportList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSBToReportList },
  { &hf_f1ap_sliceToReportList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SliceToReportList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CellToReportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CellToReportItem, CellToReportItem_sequence);

  return offset;
}


static const per_sequence_t CellToReportList_sequence_of[1] = {
  { &hf_f1ap_CellToReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CellToReportItem },
};

static int
dissect_f1ap_CellToReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CellToReportList, CellToReportList_sequence_of,
                                                  1, maxCellingNBDU, false);

  return offset;
}


static const per_sequence_t CellType_sequence[] = {
  { &hf_f1ap_cellSize       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CellSize },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CellType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CellType, CellType_sequence);

  return offset;
}


static const value_string f1ap_CellULConfigured_vals[] = {
  {   0, "none" },
  {   1, "ul" },
  {   2, "sul" },
  {   3, "ul-and-sul" },
  { 0, NULL }
};


static int
dissect_f1ap_CellULConfigured(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_CG_SDTQueryIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_CG_SDTQueryIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_CG_SDTKeptIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_CG_SDTKeptIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_CG_SDTindicatorSetup_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_CG_SDTindicatorSetup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_CG_SDTindicatorMod_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_CG_SDTindicatorMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_GNB_CU_UE_F1AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, &id, false);

  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  f1ap_data->gdb_cu_ue_f1ap_id = id;


  return offset;
}



static int
dissect_f1ap_GNB_DU_UE_F1AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}


static const per_sequence_t CG_SDTSessionInfo_sequence[] = {
  { &hf_f1ap_gNB_CU_UE_F1AP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_gNB_DU_UE_F1AP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CG_SDTSessionInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CG_SDTSessionInfo, CG_SDTSessionInfo_sequence);

  return offset;
}



static int
dissect_f1ap_ChannelOccupancyTimePercentage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, true);

  return offset;
}


static const value_string f1ap_NADownlink_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_NADownlink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_NAUplink_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_NAUplink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_NAFlexible_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_NAFlexible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NA_Resource_Configuration_Item_sequence[] = {
  { &hf_f1ap_nADownlink     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NADownlink },
  { &hf_f1ap_nAUplink       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NAUplink },
  { &hf_f1ap_nAFlexible     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NAFlexible },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NA_Resource_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NA_Resource_Configuration_Item, NA_Resource_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t NA_Resource_Configuration_List_sequence_of[1] = {
  { &hf_f1ap_NA_Resource_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NA_Resource_Configuration_Item },
};

static int
dissect_f1ap_NA_Resource_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_NA_Resource_Configuration_List, NA_Resource_Configuration_List_sequence_of,
                                                  1, maxnoofHSNASlots, false);

  return offset;
}


static const per_sequence_t Child_IAB_Nodes_NA_Resource_List_Item_sequence[] = {
  { &hf_f1ap_gNB_CU_UE_F1AP_ID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_gNB_DU_UE_F1AP_ID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_nA_Resource_Configuration_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NA_Resource_Configuration_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Child_IAB_Nodes_NA_Resource_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Child_IAB_Nodes_NA_Resource_List_Item, Child_IAB_Nodes_NA_Resource_List_Item_sequence);

  return offset;
}


static const per_sequence_t Child_IAB_Nodes_NA_Resource_List_sequence_of[1] = {
  { &hf_f1ap_Child_IAB_Nodes_NA_Resource_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Child_IAB_Nodes_NA_Resource_List_Item },
};

static int
dissect_f1ap_Child_IAB_Nodes_NA_Resource_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Child_IAB_Nodes_NA_Resource_List, Child_IAB_Nodes_NA_Resource_List_sequence_of,
                                                  1, maxnoofChildIABNodes, false);

  return offset;
}



static int
dissect_f1ap_SSB_freqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, false);

  return offset;
}


static const value_string f1ap_SSB_subcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz120" },
  {   3, "kHz240" },
  {   4, "spare3" },
  {   5, "spare2" },
  {   6, "spare1" },
  { 0, NULL }
};


static int
dissect_f1ap_SSB_subcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_SSB_transmissionPeriodicity_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf40" },
  {   3, "sf80" },
  {   4, "sf160" },
  {   5, "sf320" },
  {   6, "sf640" },
  {   7, "sf5" },
  { 0, NULL }
};


static int
dissect_f1ap_SSB_transmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 1, NULL);

  return offset;
}



static int
dissect_f1ap_SSB_transmissionTimingOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, true);

  return offset;
}


static const value_string f1ap_SSB_transmissionBitmap_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SSB_transmissionBitmap_choice[] = {
  {   0, &hf_f1ap_shortBitmap    , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_4 },
  {   1, &hf_f1ap_mediumBitmap   , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_8 },
  {   2, &hf_f1ap_longBitmap     , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_64 },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SSB_transmissionBitmap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SSB_transmissionBitmap, SSB_transmissionBitmap_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IAB_STC_Info_Item_sequence[] = {
  { &hf_f1ap_sSB_freqInfo   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_freqInfo },
  { &hf_f1ap_sSB_subcarrierSpacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_subcarrierSpacing },
  { &hf_f1ap_sSB_transmissionPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_transmissionPeriodicity },
  { &hf_f1ap_sSB_transmissionTimingOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_transmissionTimingOffset },
  { &hf_f1ap_sSB_transmissionBitmap, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_transmissionBitmap },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_STC_Info_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_STC_Info_Item, IAB_STC_Info_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_STC_Info_List_sequence_of[1] = {
  { &hf_f1ap_IAB_STC_Info_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_STC_Info_Item },
};

static int
dissect_f1ap_IAB_STC_Info_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IAB_STC_Info_List, IAB_STC_Info_List_sequence_of,
                                                  1, maxnoofIABSTCInfo, false);

  return offset;
}


static const per_sequence_t IAB_STC_Info_sequence[] = {
  { &hf_f1ap_iAB_STC_Info_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_STC_Info_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_STC_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_STC_Info, IAB_STC_Info_sequence);

  return offset;
}



static int
dissect_f1ap_RACH_Config_Common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RACH_Config_Common);
    dissect_nr_rrc_RACH_ConfigCommon_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_RACH_Config_Common_IAB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RACH_Config_Common_IAB);
    dissect_nr_rrc_RACH_ConfigCommon_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_T_cSI_RS_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_cSI_RS_Configuration);
    dissect_nr_rrc_NZP_CSI_RS_Resource_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_T_sR_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sR_Configuration);
    dissect_nr_rrc_SchedulingRequestResourceConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_T_pDCCH_ConfigSIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_pDCCH_ConfigSIB1);
    dissect_nr_rrc_PDCCH_ConfigSIB1_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_T_sCS_Common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sCS_Common);
    dissect_nr_rrc_subCarrierSpacingCommon_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_DU_RX_MT_RX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_RX_MT_RX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_TX_MT_TX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_TX_MT_TX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_RX_MT_TX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_RX_MT_TX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_TX_MT_RX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_TX_MT_RX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t IAB_MT_Cell_List_Item_sequence[] = {
  { &hf_f1ap_nRCellIdentity , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCellIdentity },
  { &hf_f1ap_dU_RX_MT_RX    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DU_RX_MT_RX },
  { &hf_f1ap_dU_TX_MT_TX    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DU_TX_MT_TX },
  { &hf_f1ap_dU_RX_MT_TX    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DU_RX_MT_TX },
  { &hf_f1ap_dU_TX_MT_RX    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DU_TX_MT_RX },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_MT_Cell_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_MT_Cell_List_Item, IAB_MT_Cell_List_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_MT_Cell_List_sequence_of[1] = {
  { &hf_f1ap_IAB_MT_Cell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_MT_Cell_List_Item },
};

static int
dissect_f1ap_IAB_MT_Cell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IAB_MT_Cell_List, IAB_MT_Cell_List_sequence_of,
                                                  1, maxnoofServingCells, false);

  return offset;
}


static const per_sequence_t MultiplexingInfo_sequence[] = {
  { &hf_f1ap_iAB_MT_Cell_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_MT_Cell_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MultiplexingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MultiplexingInfo, MultiplexingInfo_sequence);

  return offset;
}


static const per_sequence_t Child_Node_Cells_List_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iAB_DU_Cell_Resource_Configuration_Mode_Info, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IAB_DU_Cell_Resource_Configuration_Mode_Info },
  { &hf_f1ap_iAB_STC_Info   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IAB_STC_Info },
  { &hf_f1ap_rACH_Config_Common, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RACH_Config_Common },
  { &hf_f1ap_rACH_Config_Common_IAB, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RACH_Config_Common_IAB },
  { &hf_f1ap_cSI_RS_Configuration, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_cSI_RS_Configuration },
  { &hf_f1ap_sR_Configuration, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_sR_Configuration },
  { &hf_f1ap_pDCCH_ConfigSIB1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_pDCCH_ConfigSIB1 },
  { &hf_f1ap_sCS_Common     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_sCS_Common },
  { &hf_f1ap_multiplexingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MultiplexingInfo },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Child_Node_Cells_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Child_Node_Cells_List_Item, Child_Node_Cells_List_Item_sequence);

  return offset;
}


static const per_sequence_t Child_Node_Cells_List_sequence_of[1] = {
  { &hf_f1ap_Child_Node_Cells_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Child_Node_Cells_List_Item },
};

static int
dissect_f1ap_Child_Node_Cells_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Child_Node_Cells_List, Child_Node_Cells_List_sequence_of,
                                                  1, maxnoofChildIABNodes, false);

  return offset;
}


static const per_sequence_t Child_Nodes_List_Item_sequence[] = {
  { &hf_f1ap_gNB_CU_UE_F1AP_ID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_gNB_DU_UE_F1AP_ID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_child_Node_Cells_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_Child_Node_Cells_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Child_Nodes_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Child_Nodes_List_Item, Child_Nodes_List_Item_sequence);

  return offset;
}


static const per_sequence_t Child_Nodes_List_sequence_of[1] = {
  { &hf_f1ap_Child_Nodes_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Child_Nodes_List_Item },
};

static int
dissect_f1ap_Child_Nodes_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Child_Nodes_List, Child_Nodes_List_sequence_of,
                                                  1, maxnoofChildIABNodes, false);

  return offset;
}


static const value_string f1ap_CHOtrigger_InterDU_vals[] = {
  {   0, "cho-initiation" },
  {   1, "cho-replace" },
  { 0, NULL }
};


static int
dissect_f1ap_CHOtrigger_InterDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_CHOtrigger_IntraDU_vals[] = {
  {   0, "cho-initiation" },
  {   1, "cho-replace" },
  {   2, "cho-cancel" },
  { 0, NULL }
};


static int
dissect_f1ap_CHOtrigger_IntraDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_CNSubgroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, true);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_48(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     48, 48, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_CNUEPagingIdentity_vals[] = {
  {   0, "fiveG-S-TMSI" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CNUEPagingIdentity_choice[] = {
  {   0, &hf_f1ap_fiveG_S_TMSI   , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_48 },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_CNUEPagingIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_CNUEPagingIdentity, CNUEPagingIdentity_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_CHO_Probability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t ConditionalInterDUMobilityInformation_sequence[] = {
  { &hf_f1ap_cho_trigger    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CHOtrigger_InterDU },
  { &hf_f1ap_targetgNB_DUUEF1APID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ConditionalInterDUMobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ConditionalInterDUMobilityInformation, ConditionalInterDUMobilityInformation_sequence);

  return offset;
}


static const per_sequence_t TargetCellList_Item_sequence[] = {
  { &hf_f1ap_target_cell    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TargetCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TargetCellList_Item, TargetCellList_Item_sequence);

  return offset;
}


static const per_sequence_t TargetCellList_sequence_of[1] = {
  { &hf_f1ap_TargetCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TargetCellList_Item },
};

static int
dissect_f1ap_TargetCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_TargetCellList, TargetCellList_sequence_of,
                                                  1, maxnoofCHOcells, false);

  return offset;
}


static const per_sequence_t ConditionalIntraDUMobilityInformation_sequence[] = {
  { &hf_f1ap_cho_trigger_01 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CHOtrigger_IntraDU },
  { &hf_f1ap_targetCellsTocancel, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TargetCellList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ConditionalIntraDUMobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ConditionalIntraDUMobilityInformation, ConditionalIntraDUMobilityInformation_sequence);

  return offset;
}



static int
dissect_f1ap_ConfigRestrictInfoDAPS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_ConfigRestrictInfoDAPS);
    dissect_nr_rrc_ConfigRestrictInfoDAPS_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_ConfiguredTACIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_ConfiguredTACIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_37949(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37949U, NULL, false);

  return offset;
}


static const per_sequence_t Configured_BWP_Item_sequence[] = {
  { &hf_f1ap_bWP_Id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BWP_Id },
  { &hf_f1ap_bWP_Location_and_bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_37949 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Configured_BWP_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Configured_BWP_Item, Configured_BWP_Item_sequence);

  return offset;
}


static const per_sequence_t Configured_BWP_List_sequence_of[1] = {
  { &hf_f1ap_Configured_BWP_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Configured_BWP_Item },
};

static int
dissect_f1ap_Configured_BWP_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Configured_BWP_List, Configured_BWP_List_sequence_of,
                                                  1, maxNrofBWPs, false);

  return offset;
}



static int
dissect_f1ap_CoordinateID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, true);

  return offset;
}



static int
dissect_f1ap_CellCoverageState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, true);

  return offset;
}



static int
dissect_f1ap_SSBCoverageState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, true);

  return offset;
}


static const per_sequence_t SSBCoverageModification_Item_sequence[] = {
  { &hf_f1ap_sSBIndex_01    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_sSBCoverageState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBCoverageState },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBCoverageModification_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBCoverageModification_Item, SSBCoverageModification_Item_sequence);

  return offset;
}


static const per_sequence_t SSBCoverageModification_List_sequence_of[1] = {
  { &hf_f1ap_SSBCoverageModification_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBCoverageModification_Item },
};

static int
dissect_f1ap_SSBCoverageModification_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBCoverageModification_List, SSBCoverageModification_List_sequence_of,
                                                  1, maxnoofSSBAreas, false);

  return offset;
}


static const per_sequence_t Coverage_Modification_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_cellCoverageState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CellCoverageState },
  { &hf_f1ap_sSBCoverageModificationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SSBCoverageModification_List },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Coverage_Modification_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Coverage_Modification_Item, Coverage_Modification_Item_sequence);

  return offset;
}


static const per_sequence_t Coverage_Modification_List_sequence_of[1] = {
  { &hf_f1ap_Coverage_Modification_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Coverage_Modification_Item },
};

static int
dissect_f1ap_Coverage_Modification_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Coverage_Modification_List, Coverage_Modification_List_sequence_of,
                                                  1, maxCellingNBDU, false);

  return offset;
}


static const per_sequence_t Coverage_Modification_Notification_sequence[] = {
  { &hf_f1ap_coverage_Modification_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Coverage_Modification_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Coverage_Modification_Notification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Coverage_Modification_Notification, Coverage_Modification_Notification_sequence);

  return offset;
}


static const value_string f1ap_CCO_issue_detection_vals[] = {
  {   0, "coverage" },
  {   1, "cell-edge-capacity" },
  {   2, "network-energy-saving" },
  { 0, NULL }
};


static int
dissect_f1ap_CCO_issue_detection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 1, NULL);

  return offset;
}


static const per_sequence_t CCO_Assistance_Information_sequence[] = {
  { &hf_f1ap_cCO_issue_detection, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CCO_issue_detection },
  { &hf_f1ap_affectedCellsAndBeams_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_AffectedCellsAndBeams_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CCO_Assistance_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CCO_Assistance_Information, CCO_Assistance_Information_sequence);

  return offset;
}


static const per_sequence_t Endpoint_IP_address_and_port_sequence[] = {
  { &hf_f1ap_endpointIPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Endpoint_IP_address_and_port(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Endpoint_IP_address_and_port, Endpoint_IP_address_and_port_sequence);

  return offset;
}


static const value_string f1ap_CP_TransportLayerAddress_vals[] = {
  {   0, "endpoint-IP-address" },
  {   1, "endpoint-IP-address-and-port" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CP_TransportLayerAddress_choice[] = {
  {   0, &hf_f1ap_endpoint_IP_address, ASN1_NO_EXTENSIONS     , dissect_f1ap_TransportLayerAddress },
  {   1, &hf_f1ap_endpoint_IP_address_and_port, ASN1_NO_EXTENSIONS     , dissect_f1ap_Endpoint_IP_address_and_port },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_CP_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_CP_TransportLayerAddress, CP_TransportLayerAddress_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_CPAC_trigger_vals[] = {
  {   0, "cpac-preparation" },
  {   1, "cpac-executed" },
  {   2, "cpac-cancel" },
  { 0, NULL }
};


static int
dissect_f1ap_CPAC_trigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 1, NULL);

  return offset;
}


static const per_sequence_t CPACMCGInformation_sequence[] = {
  { &hf_f1ap_cpac_trigger   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CPAC_trigger },
  { &hf_f1ap_pscellid       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CPACMCGInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CPACMCGInformation, CPACMCGInformation_sequence);

  return offset;
}



static int
dissect_f1ap_TransactionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}


static const value_string f1ap_TypeOfError_vals[] = {
  {   0, "not-understood" },
  {   1, "missing" },
  { 0, NULL }
};


static int
dissect_f1ap_TypeOfError(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_Item_sequence[] = {
  { &hf_f1ap_iECriticality  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Criticality },
  { &hf_f1ap_iE_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_ID },
  { &hf_f1ap_typeOfError    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TypeOfError },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CriticalityDiagnostics_IE_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CriticalityDiagnostics_IE_Item, CriticalityDiagnostics_IE_Item_sequence);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_f1ap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CriticalityDiagnostics_IE_Item },
};

static int
dissect_f1ap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, maxnoofErrors, false);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_f1ap_procedureCode  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProcedureCode },
  { &hf_f1ap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TriggeringMessage },
  { &hf_f1ap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Criticality },
  { &hf_f1ap_transactionID  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TransactionID },
  { &hf_f1ap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CriticalityDiagnostics_IE_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CriticalityDiagnostics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}



static int
dissect_f1ap_C_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, true);

  return offset;
}


static const value_string f1ap_RIMRSDetectionStatus_vals[] = {
  {   0, "rs-detected" },
  {   1, "rs-disappeared" },
  { 0, NULL }
};


static int
dissect_f1ap_RIMRSDetectionStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t CUDURIMInformation_sequence[] = {
  { &hf_f1ap_victimgNBSetID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBSetID },
  { &hf_f1ap_rIMRSDetectionStatus, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RIMRSDetectionStatus },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CUDURIMInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CUDURIMInformation, CUDURIMInformation_sequence);

  return offset;
}


static const value_string f1ap_CUDURadioInformationType_vals[] = {
  {   0, "rIM" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CUDURadioInformationType_choice[] = {
  {   0, &hf_f1ap_rIM            , ASN1_NO_EXTENSIONS     , dissect_f1ap_CUDURIMInformation },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_CUDURadioInformationType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_CUDURadioInformationType, CUDURadioInformationType_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_CG_ConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_CG_ConfigInfo);
    dissect_nr_rrc_CG_ConfigInfo_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_UE_CapabilityRAT_ContainerList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_UE_CapabilityRAT_ContainerList);
    dissect_nr_rrc_UE_CapabilityRAT_ContainerList_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_MeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MeasConfig);
    dissect_nr_rrc_MeasConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t CUtoDURRCInformation_sequence[] = {
  { &hf_f1ap_cG_ConfigInfo  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CG_ConfigInfo },
  { &hf_f1ap_uE_CapabilityRAT_ContainerList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_UE_CapabilityRAT_ContainerList },
  { &hf_f1ap_measConfig     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MeasConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CUtoDURRCInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CUtoDURRCInformation, CUtoDURRCInformation_sequence);

  return offset;
}



static int
dissect_f1ap_TAValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  return offset;
}



static int
dissect_f1ap_PreambleIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}



static int
dissect_f1ap_RA_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, true);

  return offset;
}



static int
dissect_f1ap_TagIDPointer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const per_sequence_t CUtoDUTAInformation_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_tAValue        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TAValue },
  { &hf_f1ap_preambleIndex  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PreambleIndex },
  { &hf_f1ap_rA_RNTI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RA_RNTI },
  { &hf_f1ap_tagIDPointer   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TagIDPointer },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CUtoDUTAInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CUtoDUTAInformation_Item, CUtoDUTAInformation_Item_sequence);

  return offset;
}


static const per_sequence_t CUtoDUTAInformation_List_sequence_of[1] = {
  { &hf_f1ap_CUtoDUTAInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CUtoDUTAInformation_Item },
};

static int
dissect_f1ap_CUtoDUTAInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_CUtoDUTAInformation_List, CUtoDUTAInformation_List_sequence_of,
                                                  1, maxnoofTAList, false);

  return offset;
}



static int
dissect_f1ap_T_cSIResourceConfigToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_cSIResourceConfigToAddModList);
    dissect_nr_rrc_LTM_CSI_ResourceConfigToAddModList_r18_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_T_cSIResourceConfigToReleaseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_cSIResourceConfigToReleaseList);
    dissect_nr_rrc_LTM_CSI_ResourceConfigToReleaseList_r18_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t CSIResourceConfiguration_sequence[] = {
  { &hf_f1ap_cSIResourceConfigToAddModList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_cSIResourceConfigToAddModList },
  { &hf_f1ap_cSIResourceConfigToReleaseList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_cSIResourceConfigToReleaseList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_CSIResourceConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_CSIResourceConfiguration, CSIResourceConfiguration_sequence);

  return offset;
}


static const value_string f1ap_DAPS_HO_Status_vals[] = {
  {   0, "initiation" },
  { 0, NULL }
};


static int
dissect_f1ap_DAPS_HO_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_DCBasedDuplicationConfigured_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_DCBasedDuplicationConfigured(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 1, NULL);

  return offset;
}


static const per_sequence_t DeactivationIndicationList_Item_sequence[] = {
  { &hf_f1ap_gNB_CU_UE_F1AP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_gNB_DU_UE_F1AP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_UE_F1AP_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DeactivationIndicationList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DeactivationIndicationList_Item, DeactivationIndicationList_Item_sequence);

  return offset;
}


static const per_sequence_t DeactivationIndicationList_sequence_of[1] = {
  { &hf_f1ap_DeactivationIndicationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DeactivationIndicationList_Item },
};

static int
dissect_f1ap_DeactivationIndicationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DeactivationIndicationList, DeactivationIndicationList_sequence_of,
                                                  1, maxnoofUEsInQMCTransferControlMessage, false);

  return offset;
}


static const value_string f1ap_DeactivationIndication_vals[] = {
  {   0, "perUE" },
  {   1, "deactivateAll" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DeactivationIndication_choice[] = {
  {   0, &hf_f1ap_perUE          , ASN1_NO_EXTENSIONS     , dissect_f1ap_DeactivationIndicationList },
  {   1, &hf_f1ap_deactivateAll  , ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DeactivationIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DeactivationIndication, DeactivationIndication_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Dedicated_SIDelivery_NeededUE_Item_sequence[] = {
  { &hf_f1ap_gNB_CU_UE_F1AP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Dedicated_SIDelivery_NeededUE_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Dedicated_SIDelivery_NeededUE_Item, Dedicated_SIDelivery_NeededUE_Item_sequence);

  return offset;
}


static const value_string f1ap_DedicatedSIDeliveryIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_DedicatedSIDeliveryIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_PRS_Resource_Set_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}



static int
dissect_f1ap_PRS_Resource_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const per_sequence_t DL_PRS_sequence[] = {
  { &hf_f1ap_prsid          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_dl_PRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_Set_ID },
  { &hf_f1ap_dl_PRSResourceID, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PRS_Resource_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DL_PRS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DL_PRS, DL_PRS_sequence);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_DL_PRSMutingPattern_vals[] = {
  {   0, "two" },
  {   1, "four" },
  {   2, "six" },
  {   3, "eight" },
  {   4, "sixteen" },
  {   5, "thirty-two" },
  {   6, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DL_PRSMutingPattern_choice[] = {
  {   0, &hf_f1ap_two            , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_2 },
  {   1, &hf_f1ap_four           , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_4 },
  {   2, &hf_f1ap_six            , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_6 },
  {   3, &hf_f1ap_eight          , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_8 },
  {   4, &hf_f1ap_sixteen        , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_16 },
  {   5, &hf_f1ap_thirty_two     , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_32 },
  {   6, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DL_PRSMutingPattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DL_PRSMutingPattern, DL_PRSMutingPattern_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_DL_PRSResourceSetARPLocation_vals[] = {
  {   0, "relativeGeodeticLocation" },
  {   1, "relativeCartesianLocation" },
  {   2, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t DL_PRSResourceSetARPLocation_choice[] = {
  {   0, &hf_f1ap_relativeGeodeticLocation, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeGeodeticLocation },
  {   1, &hf_f1ap_relativeCartesianLocation, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeCartesianLocation },
  {   2, &hf_f1ap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DL_PRSResourceSetARPLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DL_PRSResourceSetARPLocation, DL_PRSResourceSetARPLocation_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_DL_PRSResourceARPLocation_vals[] = {
  {   0, "relativeGeodeticLocation" },
  {   1, "relativeCartesianLocation" },
  {   2, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t DL_PRSResourceARPLocation_choice[] = {
  {   0, &hf_f1ap_relativeGeodeticLocation, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeGeodeticLocation },
  {   1, &hf_f1ap_relativeCartesianLocation, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeCartesianLocation },
  {   2, &hf_f1ap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DL_PRSResourceARPLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DL_PRSResourceARPLocation, DL_PRSResourceARPLocation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DLPRSResourceARP_sequence[] = {
  { &hf_f1ap_dl_PRSResourceID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_ID },
  { &hf_f1ap_dL_PRSResourceARPLocation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DL_PRSResourceARPLocation },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLPRSResourceARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLPRSResourceARP, DLPRSResourceARP_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP_sequence_of[1] = {
  { &hf_f1ap_listofDL_PRSResourceARP_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DLPRSResourceARP },
};

static int
dissect_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP, SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP_sequence_of,
                                                  1, maxnoofPRS_ResourcesPerSet, false);

  return offset;
}


static const per_sequence_t DLPRSResourceSetARP_sequence[] = {
  { &hf_f1ap_dl_PRSResourceSetID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PRS_Resource_Set_ID },
  { &hf_f1ap_dL_PRSResourceSetARPLocation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DL_PRSResourceSetARPLocation },
  { &hf_f1ap_listofDL_PRSResourceARP, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourcesPerSet_OF_DLPRSResourceARP },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLPRSResourceSetARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLPRSResourceSetARP, DLPRSResourceSetARP_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP_sequence_of[1] = {
  { &hf_f1ap_listofDL_PRSResourceSetARP_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DLPRSResourceSetARP },
};

static int
dissect_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP, SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP_sequence_of,
                                                  1, maxnoofPRS_ResourceSets, false);

  return offset;
}


static const per_sequence_t DLPRSResourceCoordinates_sequence[] = {
  { &hf_f1ap_listofDL_PRSResourceSetARP, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_1_maxnoofPRS_ResourceSets_OF_DLPRSResourceSetARP },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLPRSResourceCoordinates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLPRSResourceCoordinates, DLPRSResourceCoordinates_sequence);

  return offset;
}


static const per_sequence_t DL_UP_TNL_Address_to_Update_List_Item_sequence[] = {
  { &hf_f1ap_oldIPAdress    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_newIPAdress    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DL_UP_TNL_Address_to_Update_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DL_UP_TNL_Address_to_Update_List_Item, DL_UP_TNL_Address_to_Update_List_Item_sequence);

  return offset;
}


static const per_sequence_t DLUPTNLInformation_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_dLUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLUPTNLInformation_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLUPTNLInformation_ToBeSetup_Item, DLUPTNLInformation_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t DLUPTNLInformation_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_DLUPTNLInformation_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_Item },
};

static int
dissect_f1ap_DLUPTNLInformation_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DLUPTNLInformation_ToBeSetup_List, DLUPTNLInformation_ToBeSetup_List_sequence_of,
                                                  1, maxnoofDLUPTNLInformation, false);

  return offset;
}



static int
dissect_f1ap_DRBID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, true);

  return offset;
}


static const value_string f1ap_DRB_Activity_vals[] = {
  {   0, "active" },
  {   1, "not-active" },
  { 0, NULL }
};


static int
dissect_f1ap_DRB_Activity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t DRB_Activity_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_dRB_Activity   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DRB_Activity },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRB_Activity_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRB_Activity_Item, DRB_Activity_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeModified_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_FailedToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_FailedToBeModified_Item, DRBs_FailedToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeSetup_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_FailedToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_FailedToBeSetup_Item, DRBs_FailedToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_FailedToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_FailedToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_FailedToBeSetupMod_Item, DRBs_FailedToBeSetupMod_Item_sequence);

  return offset;
}


static const value_string f1ap_NotificationControl_vals[] = {
  {   0, "active" },
  {   1, "not-active" },
  { 0, NULL }
};


static int
dissect_f1ap_NotificationControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t Flows_Mapped_To_DRB_Item_sequence[] = {
  { &hf_f1ap_qoSFlowIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowIdentifier },
  { &hf_f1ap_qoSFlowLevelQoSParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowLevelQoSParameters },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Flows_Mapped_To_DRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Flows_Mapped_To_DRB_Item, Flows_Mapped_To_DRB_Item_sequence);

  return offset;
}


static const per_sequence_t Flows_Mapped_To_DRB_List_sequence_of[1] = {
  { &hf_f1ap_Flows_Mapped_To_DRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Flows_Mapped_To_DRB_Item },
};

static int
dissect_f1ap_Flows_Mapped_To_DRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Flows_Mapped_To_DRB_List, Flows_Mapped_To_DRB_List_sequence_of,
                                                  1, maxnoofQoSFlows, false);

  return offset;
}


static const per_sequence_t DRB_Information_sequence[] = {
  { &hf_f1ap_dRB_QoS        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSFlowLevelQoSParameters },
  { &hf_f1ap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_notificationControl, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_NotificationControl },
  { &hf_f1ap_flows_Mapped_To_DRB_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Flows_Mapped_To_DRB_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRB_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRB_Information, DRB_Information_sequence);

  return offset;
}



static int
dissect_f1ap_LCID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, true);

  return offset;
}


static const per_sequence_t DRBs_Modified_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCID },
  { &hf_f1ap_dLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_Modified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_Modified_Item, DRBs_Modified_Item_sequence);

  return offset;
}


static const per_sequence_t ULUPTNLInformation_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_uLUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_UPTransportLayerInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ULUPTNLInformation_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ULUPTNLInformation_ToBeSetup_Item, ULUPTNLInformation_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t ULUPTNLInformation_ToBeSetup_List_sequence_of[1] = {
  { &hf_f1ap_ULUPTNLInformation_ToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_Item },
};

static int
dissect_f1ap_ULUPTNLInformation_ToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ULUPTNLInformation_ToBeSetup_List, ULUPTNLInformation_ToBeSetup_List_sequence_of,
                                                  1, maxnoofULUPTNLInformation, false);

  return offset;
}


static const per_sequence_t DRBs_ModifiedConf_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_uLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ModifiedConf_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ModifiedConf_Item, DRBs_ModifiedConf_Item_sequence);

  return offset;
}


static const value_string f1ap_Notification_Cause_vals[] = {
  {   0, "fulfilled" },
  {   1, "not-fulfilled" },
  { 0, NULL }
};


static int
dissect_f1ap_Notification_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DRB_Notify_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_notification_Cause, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Notification_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRB_Notify_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRB_Notify_Item, DRB_Notify_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_Required_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_dLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_Required_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_Required_ToBeModified_Item, DRBs_Required_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_Required_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_Required_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_Required_ToBeReleased_Item, DRBs_Required_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_Setup_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCID },
  { &hf_f1ap_dLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_Setup_Item, DRBs_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_SetupMod_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LCID },
  { &hf_f1ap_dLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DLUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_SetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_SetupMod_Item, DRBs_SetupMod_Item_sequence);

  return offset;
}


static const value_string f1ap_QoSInformation_vals[] = {
  {   0, "eUTRANQoS" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t QoSInformation_choice[] = {
  {   0, &hf_f1ap_eUTRANQoS      , ASN1_NO_EXTENSIONS     , dissect_f1ap_EUTRANQoS },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_QoSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_QoSInformation, QoSInformation_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_ULUEConfiguration_vals[] = {
  {   0, "no-data" },
  {   1, "shared" },
  {   2, "only" },
  { 0, NULL }
};


static int
dissect_f1ap_ULUEConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t ULConfiguration_sequence[] = {
  { &hf_f1ap_uLUEConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUEConfiguration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ULConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ULConfiguration, ULConfiguration_sequence);

  return offset;
}


static const per_sequence_t DRBs_ToBeModified_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_qoSInformation , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_QoSInformation },
  { &hf_f1ap_uLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_uLConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ULConfiguration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ToBeModified_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ToBeModified_Item, DRBs_ToBeModified_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ToBeReleased_Item, DRBs_ToBeReleased_Item_sequence);

  return offset;
}


static const value_string f1ap_DuplicationActivation_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_f1ap_DuplicationActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DRBs_ToBeSetup_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_qoSInformation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSInformation },
  { &hf_f1ap_uLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_rLCMode        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_uLConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ULConfiguration },
  { &hf_f1ap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DuplicationActivation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ToBeSetup_Item, DRBs_ToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t DRBs_ToBeSetupMod_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_qoSInformation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_QoSInformation },
  { &hf_f1ap_uLUPTNLInformation_ToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ULUPTNLInformation_ToBeSetup_List },
  { &hf_f1ap_rLCMode        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RLCMode },
  { &hf_f1ap_uLConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ULConfiguration },
  { &hf_f1ap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_DuplicationActivation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRBs_ToBeSetupMod_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRBs_ToBeSetupMod_Item, DRBs_ToBeSetupMod_Item_sequence);

  return offset;
}


static const per_sequence_t DRB_List_Item_sequence[] = {
  { &hf_f1ap_dRBID          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DRBID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRB_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRB_List_Item, DRB_List_Item_sequence);

  return offset;
}


static const per_sequence_t DRB_List_sequence_of[1] = {
  { &hf_f1ap_DRB_List_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DRB_List_Item },
};

static int
dissect_f1ap_DRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DRB_List, DRB_List_sequence_of,
                                                  1, maxnoofDRBs, false);

  return offset;
}


static const value_string f1ap_LongDRXCycleLength_vals[] = {
  {   0, "ms10" },
  {   1, "ms20" },
  {   2, "ms32" },
  {   3, "ms40" },
  {   4, "ms60" },
  {   5, "ms64" },
  {   6, "ms70" },
  {   7, "ms80" },
  {   8, "ms128" },
  {   9, "ms160" },
  {  10, "ms256" },
  {  11, "ms320" },
  {  12, "ms512" },
  {  13, "ms640" },
  {  14, "ms1024" },
  {  15, "ms1280" },
  {  16, "ms2048" },
  {  17, "ms2560" },
  {  18, "ms5120" },
  {  19, "ms10240" },
  { 0, NULL }
};

static value_string_ext f1ap_LongDRXCycleLength_vals_ext = VALUE_STRING_EXT_INIT(f1ap_LongDRXCycleLength_vals);


static int
dissect_f1ap_LongDRXCycleLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     20, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_ShortDRXCycleLength_vals[] = {
  {   0, "ms2" },
  {   1, "ms3" },
  {   2, "ms4" },
  {   3, "ms5" },
  {   4, "ms6" },
  {   5, "ms7" },
  {   6, "ms8" },
  {   7, "ms10" },
  {   8, "ms14" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms30" },
  {  12, "ms32" },
  {  13, "ms35" },
  {  14, "ms40" },
  {  15, "ms64" },
  {  16, "ms80" },
  {  17, "ms128" },
  {  18, "ms160" },
  {  19, "ms256" },
  {  20, "ms320" },
  {  21, "ms512" },
  {  22, "ms640" },
  { 0, NULL }
};

static value_string_ext f1ap_ShortDRXCycleLength_vals_ext = VALUE_STRING_EXT_INIT(f1ap_ShortDRXCycleLength_vals);


static int
dissect_f1ap_ShortDRXCycleLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     23, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_ShortDRXCycleTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, false);

  return offset;
}


static const per_sequence_t DRXCycle_sequence[] = {
  { &hf_f1ap_longDRXCycleLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LongDRXCycleLength },
  { &hf_f1ap_shortDRXCycleLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ShortDRXCycleLength },
  { &hf_f1ap_shortDRXCycleTimer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ShortDRXCycleTimer },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DRXCycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DRXCycle, DRXCycle_sequence);

  return offset;
}


static const value_string f1ap_LongNonIntegerDRXCycleLength_vals[] = {
  {   0, "ms1001over240" },
  {   1, "ms25over6" },
  {   2, "ms25over3" },
  {   3, "ms1001over120" },
  {   4, "ms100over9" },
  {   5, "ms25over2" },
  {   6, "ms40over3" },
  {   7, "ms125over9" },
  {   8, "ms50over3" },
  {   9, "ms1001over60" },
  {  10, "ms125over6" },
  {  11, "ms200over9" },
  {  12, "ms250over9" },
  {  13, "ms100over3" },
  {  14, "ms1001over30" },
  {  15, "ms75over2" },
  {  16, "ms125over3" },
  {  17, "ms1001over24" },
  {  18, "ms200over3" },
  {  19, "ms1001over15" },
  {  20, "ms250over3" },
  {  21, "ms1001over12" },
  {  22, "ms400over3" },
  { 0, NULL }
};


static int
dissect_f1ap_LongNonIntegerDRXCycleLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     23, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_ShortNonIntegerDRXCycleLength_vals[] = {
  {   0, "ms1001over240" },
  {   1, "ms25over6" },
  {   2, "ms25over3" },
  {   3, "ms1001over120" },
  {   4, "ms100over9" },
  {   5, "ms25over2" },
  {   6, "ms40over3" },
  {   7, "ms125over9" },
  {   8, "ms50over3" },
  {   9, "ms1001over60" },
  {  10, "ms125over6" },
  {  11, "ms200over9" },
  {  12, "ms100over3" },
  {  13, "ms1001over30" },
  {  14, "ms125over3" },
  {  15, "ms1001over24" },
  {  16, "ms200over3" },
  { 0, NULL }
};


static int
dissect_f1ap_ShortNonIntegerDRXCycleLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     17, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NonIntegerDRXCycle_sequence[] = {
  { &hf_f1ap_longNonIntegerDRXCycleLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LongNonIntegerDRXCycleLength },
  { &hf_f1ap_shortNonIntegerDRXCycleLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ShortNonIntegerDRXCycleLength },
  { &hf_f1ap_shortDRXCycleTimer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ShortDRXCycleTimer },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NonIntegerDRXCycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NonIntegerDRXCycle, NonIntegerDRXCycle_sequence);

  return offset;
}



static int
dissect_f1ap_DRX_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_DRX_Config);
    dissect_nr_rrc_DRX_Config_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_DRXConfigurationIndicator_vals[] = {
  {   0, "release" },
  { 0, NULL }
};


static int
dissect_f1ap_DRXConfigurationIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_DRX_LongCycleStartOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10239U, NULL, false);

  return offset;
}



static int
dissect_f1ap_DUtoCURRCContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_DUtoCURRCContainer);
    dissect_nr_rrc_CellGroupConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t DUCURIMInformation_sequence[] = {
  { &hf_f1ap_victimgNBSetID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBSetID },
  { &hf_f1ap_rIMRSDetectionStatus, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_RIMRSDetectionStatus },
  { &hf_f1ap_aggressorCellList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_AggressorCellList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DUCURIMInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DUCURIMInformation, DUCURIMInformation_sequence);

  return offset;
}


static const value_string f1ap_DUCURadioInformationType_vals[] = {
  {   0, "rIM" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DUCURadioInformationType_choice[] = {
  {   0, &hf_f1ap_rIM_01         , ASN1_NO_EXTENSIONS     , dissect_f1ap_DUCURIMInformation },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_DUCURadioInformationType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_DUCURadioInformationType, DUCURadioInformationType_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_DU_RX_MT_RX_Extend_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-and-FDM-required" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_RX_MT_RX_Extend(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_TX_MT_TX_Extend_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-and-FDM-required" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_TX_MT_TX_Extend(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_RX_MT_TX_Extend_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-and-FDM-required" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_RX_MT_TX_Extend(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_DU_TX_MT_RX_Extend_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-and-FDM-required" },
  { 0, NULL }
};


static int
dissect_f1ap_DU_TX_MT_RX_Extend(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_MeasGapConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MeasGapConfig);
    dissect_nr_rrc_MeasGapConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_T_requestedP_MaxFR1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_requestedP_MaxFR1);
    dissect_nr_rrc_P_Max_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t DUtoCURRCInformation_sequence[] = {
  { &hf_f1ap_cellGroupConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_CellGroupConfig },
  { &hf_f1ap_measGapConfig  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MeasGapConfig },
  { &hf_f1ap_requestedP_MaxFR1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_T_requestedP_MaxFR1 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DUtoCURRCInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DUtoCURRCInformation, DUtoCURRCInformation_sequence);

  return offset;
}



static int
dissect_f1ap_GNB_DU_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, UINT64_C(68719476735), NULL, false);

  return offset;
}


static const per_sequence_t DUtoCUTAInformation_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_tAValue        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TAValue },
  { &hf_f1ap_preambleIndex  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PreambleIndex },
  { &hf_f1ap_rA_RNTI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RA_RNTI },
  { &hf_f1ap_sourceGNB_DU_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_ID },
  { &hf_f1ap_tagIDPointer   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TagIDPointer },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DUtoCUTAInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DUtoCUTAInformation_Item, DUtoCUTAInformation_Item_sequence);

  return offset;
}


static const per_sequence_t DUtoCUTAInformation_List_sequence_of[1] = {
  { &hf_f1ap_DUtoCUTAInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DUtoCUTAInformation_Item },
};

static int
dissect_f1ap_DUtoCUTAInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DUtoCUTAInformation_List, DUtoCUTAInformation_List_sequence_of,
                                                  1, maxnoofTAList, false);

  return offset;
}


static const value_string f1ap_DuplicationIndication_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_f1ap_DuplicationIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 1, NULL);

  return offset;
}


static const value_string f1ap_DuplicationState_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_f1ap_DuplicationState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_T_resourceType_vals[] = {
  {   0, "gbr" },
  {   1, "non-gbr" },
  {   2, "delay-critical-grb" },
  { 0, NULL }
};


static int
dissect_f1ap_T_resourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_8_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, true);

  return offset;
}


static const per_sequence_t DynamicPQIDescriptor_sequence[] = {
  { &hf_f1ap_resourceType   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_T_resourceType },
  { &hf_f1ap_qoSPriorityLevel_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_8_ },
  { &hf_f1ap_packetDelayBudget, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PacketDelayBudget },
  { &hf_f1ap_packetErrorRate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PacketErrorRate },
  { &hf_f1ap_averagingWindow, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AveragingWindow },
  { &hf_f1ap_maxDataBurstVolume, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MaxDataBurstVolume },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DynamicPQIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DynamicPQIDescriptor, DynamicPQIDescriptor_sequence);

  return offset;
}


static const value_string f1ap_DLLBTFailureInformationRequest_vals[] = {
  {   0, "inquiry" },
  { 0, NULL }
};


static int
dissect_f1ap_DLLBTFailureInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_1000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1000U, NULL, true);

  return offset;
}


static const per_sequence_t DLLBTFailureInformationList_Item_sequence[] = {
  { &hf_f1ap_uEAssistantIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_CU_UE_F1AP_ID },
  { &hf_f1ap_numberOfDLLBTFailures, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_1000_ },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_DLLBTFailureInformationList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_DLLBTFailureInformationList_Item, DLLBTFailureInformationList_Item_sequence);

  return offset;
}


static const per_sequence_t DLLBTFailureInformationList_sequence_of[1] = {
  { &hf_f1ap_DLLBTFailureInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_DLLBTFailureInformationList_Item },
};

static int
dissect_f1ap_DLLBTFailureInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_DLLBTFailureInformationList, DLLBTFailureInformationList_sequence_of,
                                                  1, maxnoofLBTFailureInformation, false);

  return offset;
}



static int
dissect_f1ap_RACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_RACHConfiguration);
    dissect_nr_rrc_EarlyUL_SyncConfig_r18_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t PreambleIndexList_Item_sequence[] = {
  { &hf_f1ap_preambleIndex_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_PreambleIndexList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_PreambleIndexList_Item, PreambleIndexList_Item_sequence);

  return offset;
}


static const per_sequence_t PreambleIndexList_sequence_of[1] = {
  { &hf_f1ap_PreambleIndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_PreambleIndexList_Item },
};

static int
dissect_f1ap_PreambleIndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_PreambleIndexList, PreambleIndexList_sequence_of,
                                                  1, maxnoofLTMCells, false);

  return offset;
}


static const per_sequence_t LTMgNB_DU_IDs_PreambleIndex_Item_sequence[] = {
  { &hf_f1ap_lTMgNB_DU_ID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_ID },
  { &hf_f1ap_preambleIndexList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PreambleIndexList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMgNB_DU_IDs_PreambleIndex_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMgNB_DU_IDs_PreambleIndex_Item, LTMgNB_DU_IDs_PreambleIndex_Item_sequence);

  return offset;
}


static const per_sequence_t LTMgNB_DU_IDs_PreambleIndexList_sequence_of[1] = {
  { &hf_f1ap_LTMgNB_DU_IDs_PreambleIndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMgNB_DU_IDs_PreambleIndex_Item },
};

static int
dissect_f1ap_LTMgNB_DU_IDs_PreambleIndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LTMgNB_DU_IDs_PreambleIndexList, LTMgNB_DU_IDs_PreambleIndexList_sequence_of,
                                                  1, maxnoofLTMgNB_DUs, false);

  return offset;
}


static const per_sequence_t EarlyULSyncConfig_sequence[] = {
  { &hf_f1ap_rACH           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RACHConfiguration },
  { &hf_f1ap_lTMgNB_DU_IDs_PreambleIndexList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LTMgNB_DU_IDs_PreambleIndexList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EarlyULSyncConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EarlyULSyncConfig, EarlyULSyncConfig_sequence);

  return offset;
}


static const value_string f1ap_RequestforRACHConfiguration_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_RequestforRACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LTMgNB_DU_IDs_Item_sequence[] = {
  { &hf_f1ap_lTMgNB_DU_ID   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMgNB_DU_IDs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMgNB_DU_IDs_Item, LTMgNB_DU_IDs_Item_sequence);

  return offset;
}


static const per_sequence_t LTMgNB_DU_IDsList_sequence_of[1] = {
  { &hf_f1ap_LTMgNB_DU_IDsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMgNB_DU_IDs_Item },
};

static int
dissect_f1ap_LTMgNB_DU_IDsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LTMgNB_DU_IDsList, LTMgNB_DU_IDsList_sequence_of,
                                                  1, maxnoofLTMgNB_DUs, false);

  return offset;
}


static const per_sequence_t EarlySyncInformation_Request_sequence[] = {
  { &hf_f1ap_requestforRACHConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RequestforRACHConfiguration },
  { &hf_f1ap_lTMgNB_DU_IDsList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMgNB_DU_IDsList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EarlySyncInformation_Request(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EarlySyncInformation_Request, EarlySyncInformation_Request_sequence);

  return offset;
}



static int
dissect_f1ap_TCIStatesConfigurationsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_TCIStatesConfigurationsList);
    dissect_nr_rrc_LTM_TCI_Info_r18_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t EarlySyncInformation_sequence[] = {
  { &hf_f1ap_tCIStatesConfigurationsList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TCIStatesConfigurationsList },
  { &hf_f1ap_earlyULSyncConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_EarlyULSyncConfig },
  { &hf_f1ap_earlyULSyncConfigSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_EarlyULSyncConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EarlySyncInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EarlySyncInformation, EarlySyncInformation_sequence);

  return offset;
}


static const value_string f1ap_TAAssistanceInfo_vals[] = {
  {   0, "zero" },
  { 0, NULL }
};


static int
dissect_f1ap_TAAssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_OCTET_STRING(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, NULL);

  return offset;
}


static const per_sequence_t EarlySyncCandidateCellInformation_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_tCIStatesConfigurationsList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TCIStatesConfigurationsList },
  { &hf_f1ap_earlyULSyncConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_EarlyULSyncConfig },
  { &hf_f1ap_earlyULSyncConfigSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_EarlyULSyncConfig },
  { &hf_f1ap_tAAssistanceInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TAAssistanceInfo },
  { &hf_f1ap_uEbasedTAmeasurementConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_OCTET_STRING },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EarlySyncCandidateCellInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EarlySyncCandidateCellInformation_Item, EarlySyncCandidateCellInformation_Item_sequence);

  return offset;
}


static const per_sequence_t EarlySyncCandidateCellInformation_List_sequence_of[1] = {
  { &hf_f1ap_EarlySyncCandidateCellInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EarlySyncCandidateCellInformation_Item },
};

static int
dissect_f1ap_EarlySyncCandidateCellInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_EarlySyncCandidateCellInformation_List, EarlySyncCandidateCellInformation_List_sequence_of,
                                                  1, maxnoofLTMCells, false);

  return offset;
}


static const per_sequence_t EarlySyncServingCellInformation_sequence[] = {
  { &hf_f1ap_uEbasedTAmeasurementConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_OCTET_STRING },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EarlySyncServingCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EarlySyncServingCellInformation, EarlySyncServingCellInformation_sequence);

  return offset;
}


static const per_sequence_t E_CID_MeasurementQuantities_sequence_of[1] = {
  { &hf_f1ap_E_CID_MeasurementQuantities_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtocolIE_SingleContainer },
};

static int
dissect_f1ap_E_CID_MeasurementQuantities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_E_CID_MeasurementQuantities, E_CID_MeasurementQuantities_sequence_of,
                                                  1, maxnoofMeasE_CID, false);

  return offset;
}


static const value_string f1ap_E_CID_MeasurementQuantitiesValue_vals[] = {
  {   0, "default" },
  {   1, "angleOfArrivalNR" },
  {   2, "timingAdvanceNR" },
  { 0, NULL }
};


static int
dissect_f1ap_E_CID_MeasurementQuantitiesValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 1, NULL);

  return offset;
}


static const per_sequence_t E_CID_MeasurementQuantities_Item_sequence[] = {
  { &hf_f1ap_e_CIDmeasurementQuantitiesValue, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_E_CID_MeasurementQuantitiesValue },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasurementQuantities_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CID_MeasurementQuantities_Item, E_CID_MeasurementQuantities_Item_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_M2147483648_2147483647(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            INT32_MIN, 2147483647U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_M64000_1280000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -64000, 1280000U, NULL, false);

  return offset;
}


static const per_sequence_t NGRANHighAccuracyAccessPointPosition_sequence[] = {
  { &hf_f1ap_latitude_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M2147483648_2147483647 },
  { &hf_f1ap_longitude_01   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M2147483648_2147483647 },
  { &hf_f1ap_altitude_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M64000_1280000 },
  { &hf_f1ap_uncertaintySemi_major_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_uncertaintySemi_minor_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_orientationOfMajorAxis, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_179 },
  { &hf_f1ap_horizontalConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_uncertaintyAltitude_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_255 },
  { &hf_f1ap_verticalConfidence, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NGRANHighAccuracyAccessPointPosition(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NGRANHighAccuracyAccessPointPosition, NGRANHighAccuracyAccessPointPosition_sequence);

  return offset;
}


static const value_string f1ap_TRPPositionDirectAccuracy_vals[] = {
  {   0, "tRPPosition" },
  {   1, "tRPHAposition" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPPositionDirectAccuracy_choice[] = {
  {   0, &hf_f1ap_tRPPosition    , ASN1_NO_EXTENSIONS     , dissect_f1ap_AccessPointPosition },
  {   1, &hf_f1ap_tRPHAposition  , ASN1_NO_EXTENSIONS     , dissect_f1ap_NGRANHighAccuracyAccessPointPosition },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPPositionDirectAccuracy(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPPositionDirectAccuracy, TRPPositionDirectAccuracy_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TRPPositionDirect_sequence[] = {
  { &hf_f1ap_accuracy       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPPositionDirectAccuracy },
  { &hf_f1ap_iE_extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPPositionDirect(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPPositionDirect, TRPPositionDirect_sequence);

  return offset;
}


static const value_string f1ap_ReferencePoint_vals[] = {
  {   0, "coordinateID" },
  {   1, "referencePointCoordinate" },
  {   2, "referencePointCoordinateHA" },
  {   3, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t ReferencePoint_choice[] = {
  {   0, &hf_f1ap_coordinateID   , ASN1_NO_EXTENSIONS     , dissect_f1ap_CoordinateID },
  {   1, &hf_f1ap_referencePointCoordinate, ASN1_NO_EXTENSIONS     , dissect_f1ap_AccessPointPosition },
  {   2, &hf_f1ap_referencePointCoordinateHA, ASN1_NO_EXTENSIONS     , dissect_f1ap_NGRANHighAccuracyAccessPointPosition },
  {   3, &hf_f1ap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ReferencePoint(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ReferencePoint, ReferencePoint_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_TRPReferencePointType_vals[] = {
  {   0, "tRPPositionRelativeGeodetic" },
  {   1, "tRPPositionRelativeCartesian" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPReferencePointType_choice[] = {
  {   0, &hf_f1ap_tRPPositionRelativeGeodetic, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeGeodeticLocation },
  {   1, &hf_f1ap_tRPPositionRelativeCartesian, ASN1_NO_EXTENSIONS     , dissect_f1ap_RelativeCartesianLocation },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPReferencePointType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPReferencePointType, TRPReferencePointType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TRPPositionReferenced_sequence[] = {
  { &hf_f1ap_referencePoint , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ReferencePoint },
  { &hf_f1ap_referencePointType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPReferencePointType },
  { &hf_f1ap_iE_extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TRPPositionReferenced(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TRPPositionReferenced, TRPPositionReferenced_sequence);

  return offset;
}


static const value_string f1ap_TRPPositionDefinitionType_vals[] = {
  {   0, "direct" },
  {   1, "referenced" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TRPPositionDefinitionType_choice[] = {
  {   0, &hf_f1ap_direct         , ASN1_NO_EXTENSIONS     , dissect_f1ap_TRPPositionDirect },
  {   1, &hf_f1ap_referenced     , ASN1_NO_EXTENSIONS     , dissect_f1ap_TRPPositionReferenced },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TRPPositionDefinitionType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TRPPositionDefinitionType, TRPPositionDefinitionType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GeographicalCoordinates_sequence[] = {
  { &hf_f1ap_tRPPositionDefinitionType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TRPPositionDefinitionType },
  { &hf_f1ap_dLPRSResourceCoordinates, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_DLPRSResourceCoordinates },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GeographicalCoordinates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GeographicalCoordinates, GeographicalCoordinates_sequence);

  return offset;
}


static const value_string f1ap_E_CID_MeasuredResults_Value_vals[] = {
  {   0, "valueAngleofArrivalNR" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t E_CID_MeasuredResults_Value_choice[] = {
  {   0, &hf_f1ap_valueAngleofArrivalNR, ASN1_NO_EXTENSIONS     , dissect_f1ap_UL_AoA },
  {   1, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasuredResults_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_E_CID_MeasuredResults_Value, E_CID_MeasuredResults_Value_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_CID_MeasuredResults_Item_sequence[] = {
  { &hf_f1ap_e_CID_MeasuredResults_Value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_E_CID_MeasuredResults_Value },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasuredResults_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CID_MeasuredResults_Item, E_CID_MeasuredResults_Item_sequence);

  return offset;
}


static const per_sequence_t E_CID_MeasuredResults_List_sequence_of[1] = {
  { &hf_f1ap_E_CID_MeasuredResults_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_E_CID_MeasuredResults_Item },
};

static int
dissect_f1ap_E_CID_MeasuredResults_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_E_CID_MeasuredResults_List, E_CID_MeasuredResults_List_sequence_of,
                                                  1, maxnoofMeasE_CID, false);

  return offset;
}


static const per_sequence_t E_CID_MeasurementResult_sequence[] = {
  { &hf_f1ap_geographicalCoordinates, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_GeographicalCoordinates },
  { &hf_f1ap_measuredResults_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_E_CID_MeasuredResults_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasurementResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CID_MeasurementResult, E_CID_MeasurementResult_sequence);

  return offset;
}



static int
dissect_f1ap_SystemFrameNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 19U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_39(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 39U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_79(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 79U, NULL, false);

  return offset;
}


static const value_string f1ap_TimeStampSlotIndex_vals[] = {
  {   0, "sCS-15" },
  {   1, "sCS-30" },
  {   2, "sCS-60" },
  {   3, "sCS-120" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TimeStampSlotIndex_choice[] = {
  {   0, &hf_f1ap_sCS_15         , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_9 },
  {   1, &hf_f1ap_sCS_30         , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_19 },
  {   2, &hf_f1ap_sCS_60         , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_39 },
  {   3, &hf_f1ap_sCS_120        , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_79 },
  {   4, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_TimeStampSlotIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_TimeStampSlotIndex, TimeStampSlotIndex_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_RelativeTime1900(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     64, 64, false, NULL, 0, &param_tvb, NULL);

  if (param_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, param_tvb, 0, 8, ENC_TIME_NTP|ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t TimeStamp_sequence[] = {
  { &hf_f1ap_systemFrameNumber, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SystemFrameNumber },
  { &hf_f1ap_slotIndex_02   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TimeStampSlotIndex },
  { &hf_f1ap_measurementTime, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RelativeTime1900 },
  { &hf_f1ap_iE_Extension   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TimeStamp, TimeStamp_sequence);

  return offset;
}


static const per_sequence_t E_CID_MeasuredResultsAssociatedInfoItem_sequence[] = {
  { &hf_f1ap_timeStamp      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TimeStamp },
  { &hf_f1ap_measurementQuality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_TRPMeasurementQuality },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_E_CID_MeasuredResultsAssociatedInfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_E_CID_MeasuredResultsAssociatedInfoItem, E_CID_MeasuredResultsAssociatedInfoItem_sequence);

  return offset;
}


static const per_sequence_t E_CID_MeasuredResultsAssociatedInfoList_sequence_of[1] = {
  { &hf_f1ap_E_CID_MeasuredResultsAssociatedInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_E_CID_MeasuredResultsAssociatedInfoItem },
};

static int
dissect_f1ap_E_CID_MeasuredResultsAssociatedInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_E_CID_MeasuredResultsAssociatedInfoList, E_CID_MeasuredResultsAssociatedInfoList_sequence_of,
                                                  1, maxnoofMeasE_CID, false);

  return offset;
}


static const value_string f1ap_E_CID_ReportCharacteristics_vals[] = {
  {   0, "onDemand" },
  {   1, "periodic" },
  { 0, NULL }
};


static int
dissect_f1ap_E_CID_ReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_EgressNonF1terminatingTopologyIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_EgressNonF1terminatingTopologyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_EnergyDetectionThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100, -50, NULL, true);

  return offset;
}


static const per_sequence_t SliceSupportItem_sequence[] = {
  { &hf_f1ap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SliceSupportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SliceSupportItem, SliceSupportItem_sequence);

  return offset;
}


static const per_sequence_t SliceSupportList_sequence_of[1] = {
  { &hf_f1ap_SliceSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceSupportItem },
};

static int
dissect_f1ap_SliceSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SliceSupportList, SliceSupportList_sequence_of,
                                                  1, maxnoofSliceItems, false);

  return offset;
}


static const per_sequence_t ExtendedServedPLMNs_Item_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_tAISliceSupportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SliceSupportList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ExtendedServedPLMNs_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ExtendedServedPLMNs_Item, ExtendedServedPLMNs_Item_sequence);

  return offset;
}


static const per_sequence_t ExtendedServedPLMNs_List_sequence_of[1] = {
  { &hf_f1ap_ExtendedServedPLMNs_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedServedPLMNs_Item },
};

static int
dissect_f1ap_ExtendedServedPLMNs_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ExtendedServedPLMNs_List, ExtendedServedPLMNs_List_sequence_of,
                                                  1, maxnoofExtendedBPLMNs, false);

  return offset;
}


static const per_sequence_t ExtendedSliceSupportList_sequence_of[1] = {
  { &hf_f1ap_ExtendedSliceSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SliceSupportItem },
};

static int
dissect_f1ap_ExtendedSliceSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ExtendedSliceSupportList, ExtendedSliceSupportList_sequence_of,
                                                  1, maxnoofExtSliceItems, false);

  return offset;
}



static int
dissect_f1ap_ExtendedUEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_EUTRA_Cell_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_OffsetToPointA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2199U, NULL, true);

  return offset;
}


static const per_sequence_t EUTRA_FDD_Info_sequence[] = {
  { &hf_f1ap_uL_offsetToPointA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_OffsetToPointA },
  { &hf_f1ap_dL_offsetToPointA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_OffsetToPointA },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_FDD_Info, EUTRA_FDD_Info_sequence);

  return offset;
}


static const per_sequence_t EUTRA_TDD_Info_sequence[] = {
  { &hf_f1ap_offsetToPointA , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_OffsetToPointA },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_TDD_Info, EUTRA_TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_EUTRA_Mode_Info_vals[] = {
  {   0, "eUTRAFDD" },
  {   1, "eUTRATDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t EUTRA_Mode_Info_choice[] = {
  {   0, &hf_f1ap_eUTRAFDD       , ASN1_NO_EXTENSIONS     , dissect_f1ap_EUTRA_FDD_Info },
  {   1, &hf_f1ap_eUTRATDD       , ASN1_NO_EXTENSIONS     , dissect_f1ap_EUTRA_TDD_Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_EUTRA_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_EUTRA_Mode_Info, EUTRA_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_ProtectedEUTRAResourceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_ProtectedEUTRAResourceIndication);
    dissect_x2ap_ProtectedEUTRAResourceIndication_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t Served_EUTRA_Cells_Information_sequence[] = {
  { &hf_f1ap_eUTRA_Mode_Info_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Mode_Info },
  { &hf_f1ap_protectedEUTRAResourceIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ProtectedEUTRAResourceIndication },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Served_EUTRA_Cells_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Served_EUTRA_Cells_Information, Served_EUTRA_Cells_Information_sequence);

  return offset;
}


static const per_sequence_t EUTRACells_List_item_sequence[] = {
  { &hf_f1ap_eUTRA_Cell_ID  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Cell_ID },
  { &hf_f1ap_served_EUTRA_Cells_Information, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Served_EUTRA_Cells_Information },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRACells_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRACells_List_item, EUTRACells_List_item_sequence);

  return offset;
}


static const per_sequence_t EUTRACells_List_sequence_of[1] = {
  { &hf_f1ap_EUTRACells_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRACells_List_item },
};

static int
dissect_f1ap_EUTRACells_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_EUTRACells_List, EUTRACells_List_sequence_of,
                                                  1, maxCellineNB, false);

  return offset;
}



static int
dissect_f1ap_ExtendedEARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 262143U, NULL, false);

  return offset;
}


static const value_string f1ap_EUTRA_Transmission_Bandwidth_vals[] = {
  {   0, "bw6" },
  {   1, "bw15" },
  {   2, "bw25" },
  {   3, "bw50" },
  {   4, "bw75" },
  {   5, "bw100" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_Transmission_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRA_Coex_FDD_Info_sequence[] = {
  { &hf_f1ap_uL_EARFCN      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ExtendedEARFCN },
  { &hf_f1ap_dL_EARFCN      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedEARFCN },
  { &hf_f1ap_uL_Transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_EUTRA_Transmission_Bandwidth },
  { &hf_f1ap_dL_Transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Transmission_Bandwidth },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_Coex_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_Coex_FDD_Info, EUTRA_Coex_FDD_Info_sequence);

  return offset;
}


static const value_string f1ap_EUTRA_SubframeAssignment_vals[] = {
  {   0, "sa0" },
  {   1, "sa1" },
  {   2, "sa2" },
  {   3, "sa3" },
  {   4, "sa4" },
  {   5, "sa5" },
  {   6, "sa6" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_SubframeAssignment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_EUTRA_SpecialSubframePatterns_vals[] = {
  {   0, "ssp0" },
  {   1, "ssp1" },
  {   2, "ssp2" },
  {   3, "ssp3" },
  {   4, "ssp4" },
  {   5, "ssp5" },
  {   6, "ssp6" },
  {   7, "ssp7" },
  {   8, "ssp8" },
  {   9, "ssp9" },
  {  10, "ssp10" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_SpecialSubframePatterns(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_EUTRA_CyclicPrefixDL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_CyclicPrefixDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_EUTRA_CyclicPrefixUL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_EUTRA_CyclicPrefixUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRA_SpecialSubframe_Info_sequence[] = {
  { &hf_f1ap_specialSubframePatterns, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_SpecialSubframePatterns },
  { &hf_f1ap_cyclicPrefixDL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_CyclicPrefixDL },
  { &hf_f1ap_cyclicPrefixUL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_CyclicPrefixUL },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_SpecialSubframe_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_SpecialSubframe_Info, EUTRA_SpecialSubframe_Info_sequence);

  return offset;
}


static const per_sequence_t EUTRA_Coex_TDD_Info_sequence[] = {
  { &hf_f1ap_eARFCN         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ExtendedEARFCN },
  { &hf_f1ap_transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_Transmission_Bandwidth },
  { &hf_f1ap_subframeAssignment, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_SubframeAssignment },
  { &hf_f1ap_specialSubframe_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_EUTRA_SpecialSubframe_Info },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_Coex_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_Coex_TDD_Info, EUTRA_Coex_TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_EUTRA_Coex_Mode_Info_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  { 0, NULL }
};

static const per_choice_t EUTRA_Coex_Mode_Info_choice[] = {
  {   0, &hf_f1ap_fDD            , ASN1_EXTENSION_ROOT    , dissect_f1ap_EUTRA_Coex_FDD_Info },
  {   1, &hf_f1ap_tDD            , ASN1_EXTENSION_ROOT    , dissect_f1ap_EUTRA_Coex_TDD_Info },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_EUTRA_Coex_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_EUTRA_Coex_Mode_Info, EUTRA_Coex_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_94(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 94U, NULL, false);

  return offset;
}


static const per_sequence_t EUTRA_PRACH_Configuration_sequence[] = {
  { &hf_f1ap_rootSequenceIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_837 },
  { &hf_f1ap_zeroCorrelationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_highSpeedFlag  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BOOLEAN },
  { &hf_f1ap_prach_FreqOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_94 },
  { &hf_f1ap_prach_ConfigIndex, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_63 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_EUTRA_PRACH_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_EUTRA_PRACH_Configuration, EUTRA_PRACH_Configuration_sequence);

  return offset;
}


static const value_string f1ap_ExecuteDuplication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_ExecuteDuplication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_EUTRA_NR_CellResourceCoordinationReq_Container);
    dissect_x2ap_EUTRANRCellResourceCoordinationRequest_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_EUTRA_NR_CellResourceCoordinationReqAck_Container);
    dissect_x2ap_EUTRANRCellResourceCoordinationResponse_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_EventType_vals[] = {
  {   0, "on-demand" },
  {   1, "periodic" },
  {   2, "stop" },
  { 0, NULL }
};


static int
dissect_f1ap_EventType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_ExtendedPacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65535U, NULL, true);

  return offset;
}


static const value_string f1ap_ECNmarkingRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_f1ap_ECNmarkingRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_CongestionInformationRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  {   3, "stop" },
  { 0, NULL }
};


static int
dissect_f1ap_CongestionInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_ECNMarkingorCongestionInformationReportingRequest_vals[] = {
  {   0, "ecnMarking" },
  {   1, "congestionInformation" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ECNMarkingorCongestionInformationReportingRequest_choice[] = {
  {   0, &hf_f1ap_ecnMarking     , ASN1_NO_EXTENSIONS     , dissect_f1ap_ECNmarkingRequest },
  {   1, &hf_f1ap_congestionInformation, ASN1_NO_EXTENSIONS     , dissect_f1ap_CongestionInformationRequest },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ECNMarkingorCongestionInformationReportingRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ECNMarkingorCongestionInformationReportingRequest, ECNMarkingorCongestionInformationReportingRequest_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_ECNMarkingorCongestionInformationReportingStatus_vals[] = {
  {   0, "active" },
  {   1, "not-active" },
  { 0, NULL }
};


static int
dissect_f1ap_ECNMarkingorCongestionInformationReportingStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_F1CPathNSA_vals[] = {
  {   0, "lte" },
  {   1, "nr" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_f1ap_F1CPathNSA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t F1CTransferPath_sequence[] = {
  { &hf_f1ap_f1CPathNSA     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_F1CPathNSA },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1CTransferPath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1CTransferPath, F1CTransferPath_sequence);

  return offset;
}


static const value_string f1ap_F1CPathNRDC_vals[] = {
  {   0, "mcg" },
  {   1, "scg" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_f1ap_F1CPathNRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t F1CTransferPathNRDC_sequence[] = {
  { &hf_f1ap_f1CPathNRDC    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_F1CPathNRDC },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_F1CTransferPathNRDC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_F1CTransferPathNRDC, F1CTransferPathNRDC_sequence);

  return offset;
}


static const value_string f1ap_F1U_PathFailure_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_F1U_PathFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_F1UTunnelNotEstablished_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_F1UTunnelNotEstablished(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_NRNRB_vals[] = {
  {   0, "nrb11" },
  {   1, "nrb18" },
  {   2, "nrb24" },
  {   3, "nrb25" },
  {   4, "nrb31" },
  {   5, "nrb32" },
  {   6, "nrb38" },
  {   7, "nrb51" },
  {   8, "nrb52" },
  {   9, "nrb65" },
  {  10, "nrb66" },
  {  11, "nrb78" },
  {  12, "nrb79" },
  {  13, "nrb93" },
  {  14, "nrb106" },
  {  15, "nrb107" },
  {  16, "nrb121" },
  {  17, "nrb132" },
  {  18, "nrb133" },
  {  19, "nrb135" },
  {  20, "nrb160" },
  {  21, "nrb162" },
  {  22, "nrb189" },
  {  23, "nrb216" },
  {  24, "nrb217" },
  {  25, "nrb245" },
  {  26, "nrb264" },
  {  27, "nrb270" },
  {  28, "nrb273" },
  {  29, "nrb33" },
  {  30, "nrb62" },
  {  31, "nrb124" },
  {  32, "nrb148" },
  {  33, "nrb248" },
  {  34, "nrb44" },
  {  35, "nrb58" },
  {  36, "nrb92" },
  {  37, "nrb119" },
  {  38, "nrb188" },
  {  39, "nrb242" },
  {  40, "nrb15" },
  { 0, NULL }
};

static value_string_ext f1ap_NRNRB_vals_ext = VALUE_STRING_EXT_INIT(f1ap_NRNRB_vals);


static int
dissect_f1ap_NRNRB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     29, NULL, true, 12, NULL);

  return offset;
}


static const per_sequence_t Transmission_Bandwidth_sequence[] = {
  { &hf_f1ap_nRSCS_01       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRSCS },
  { &hf_f1ap_nRNRB          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRNRB },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Transmission_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Transmission_Bandwidth, Transmission_Bandwidth_sequence);

  return offset;
}


static const per_sequence_t SUL_Information_sequence[] = {
  { &hf_f1ap_sUL_NRARFCN    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxNRARFCN },
  { &hf_f1ap_sUL_transmission_Bandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SUL_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SUL_Information, SUL_Information_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_1024_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, true);

  return offset;
}


static const per_sequence_t SupportedSULFreqBandItem_sequence[] = {
  { &hf_f1ap_freqBandIndicatorNr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_1024_ },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SupportedSULFreqBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SupportedSULFreqBandItem, SupportedSULFreqBandItem_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem_sequence_of[1] = {
  { &hf_f1ap_supportedSULBandList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SupportedSULFreqBandItem },
};

static int
dissect_f1ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem, SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem_sequence_of,
                                                  0, maxnoofNrCellBands, false);

  return offset;
}


static const per_sequence_t FreqBandNrItem_sequence[] = {
  { &hf_f1ap_freqBandIndicatorNr, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_1_1024_ },
  { &hf_f1ap_supportedSULBandList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_0_maxnoofNrCellBands_OF_SupportedSULFreqBandItem },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FreqBandNrItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FreqBandNrItem, FreqBandNrItem_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem_sequence_of[1] = {
  { &hf_f1ap_freqBandListNr_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_FreqBandNrItem },
};

static int
dissect_f1ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem, SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem_sequence_of,
                                                  1, maxnoofNrCellBands, false);

  return offset;
}


static const per_sequence_t NRFreqInfo_sequence[] = {
  { &hf_f1ap_nRARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxNRARFCN },
  { &hf_f1ap_sul_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_SUL_Information },
  { &hf_f1ap_freqBandListNr , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_1_maxnoofNrCellBands_OF_FreqBandNrItem },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NRFreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NRFreqInfo, NRFreqInfo_sequence);

  return offset;
}


static const per_sequence_t FDD_Info_sequence[] = {
  { &hf_f1ap_uL_NRFreqInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_dL_NRFreqInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_uL_Transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_dL_Transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FDD_Info, FDD_Info_sequence);

  return offset;
}


static const value_string f1ap_FiveG_ProSeDirectDiscovery_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_FiveG_ProSeDirectDiscovery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_FiveG_ProSeDirectCommunication_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_FiveG_ProSeDirectCommunication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_FiveG_ProSeLayer2UEtoNetworkRelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_FiveG_ProSeLayer2UEtoNetworkRelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_FiveG_ProSeLayer3UEtoNetworkRelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_FiveG_ProSeLayer3UEtoNetworkRelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_FiveG_ProSeLayer2RemoteUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_FiveG_ProSeLayer2RemoteUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t FiveG_ProSeAuthorized_sequence[] = {
  { &hf_f1ap_fiveG_proSeDirectDiscovery, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveG_ProSeDirectDiscovery },
  { &hf_f1ap_fiveG_proSeDirectCommunication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveG_ProSeDirectCommunication },
  { &hf_f1ap_fiveG_ProSeLayer2UEtoNetworkRelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveG_ProSeLayer2UEtoNetworkRelay },
  { &hf_f1ap_fiveG_ProSeLayer3UEtoNetworkRelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveG_ProSeLayer3UEtoNetworkRelay },
  { &hf_f1ap_fiveG_ProSeLayer2RemoteUE, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveG_ProSeLayer2RemoteUE },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FiveG_ProSeAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FiveG_ProSeAuthorized, FiveG_ProSeAuthorized_sequence);

  return offset;
}


static const value_string f1ap_FiveG_ProSeLayer2Multipath_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_FiveG_ProSeLayer2Multipath(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_FiveG_ProSeLayer2UEtoUERelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_FiveG_ProSeLayer2UEtoUERelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_FiveG_ProSeLayer2UEtoUERemote_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_FiveG_ProSeLayer2UEtoUERemote(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_FiveQI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_maxnoofRBsetsPerCell_1_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofRBsetsPerCell_1, NULL, true);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_5119(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5119U, NULL, false);

  return offset;
}


static const per_sequence_t Frequency_Domain_HSNA_Slot_Configuration_Item_sequence[] = {
  { &hf_f1ap_slotIndex      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_5119 },
  { &hf_f1ap_hSNADownlink   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNADownlink },
  { &hf_f1ap_hSNAUplink     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNAUplink },
  { &hf_f1ap_hSNAFlexible   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_HSNAFlexible },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Frequency_Domain_HSNA_Slot_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Frequency_Domain_HSNA_Slot_Configuration_Item, Frequency_Domain_HSNA_Slot_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t Frequency_Domain_HSNA_Slot_Configuration_List_sequence_of[1] = {
  { &hf_f1ap_Frequency_Domain_HSNA_Slot_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Frequency_Domain_HSNA_Slot_Configuration_Item },
};

static int
dissect_f1ap_Frequency_Domain_HSNA_Slot_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Frequency_Domain_HSNA_Slot_Configuration_List, Frequency_Domain_HSNA_Slot_Configuration_List_sequence_of,
                                                  1, maxnoofHSNASlots, false);

  return offset;
}


static const per_sequence_t Frequency_Domain_HSNA_Configuration_Item_sequence[] = {
  { &hf_f1ap_rBSetIndex     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_maxnoofRBsetsPerCell_1_ },
  { &hf_f1ap_frequency_Domain_HSNA_Slot_Configuration_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Frequency_Domain_HSNA_Slot_Configuration_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Frequency_Domain_HSNA_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Frequency_Domain_HSNA_Configuration_Item, Frequency_Domain_HSNA_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t Frequency_Domain_HSNA_Configuration_List_sequence_of[1] = {
  { &hf_f1ap_Frequency_Domain_HSNA_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Frequency_Domain_HSNA_Configuration_Item },
};

static int
dissect_f1ap_Frequency_Domain_HSNA_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Frequency_Domain_HSNA_Configuration_List, Frequency_Domain_HSNA_Configuration_List_sequence_of,
                                                  1, maxnoofRBsetsPerCell, false);

  return offset;
}


static const value_string f1ap_FullConfiguration_vals[] = {
  {   0, "full" },
  { 0, NULL }
};


static int
dissect_f1ap_FullConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_PC5QoSFlowIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 2048U, NULL, false);

  return offset;
}


static const per_sequence_t FlowsMappedToSLDRB_Item_sequence[] = {
  { &hf_f1ap_pc5QoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PC5QoSFlowIdentifier },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_FlowsMappedToSLDRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_FlowsMappedToSLDRB_Item, FlowsMappedToSLDRB_Item_sequence);

  return offset;
}


static const per_sequence_t FlowsMappedToSLDRB_List_sequence_of[1] = {
  { &hf_f1ap_FlowsMappedToSLDRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_FlowsMappedToSLDRB_Item },
};

static int
dissect_f1ap_FlowsMappedToSLDRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_FlowsMappedToSLDRB_List, FlowsMappedToSLDRB_List_sequence_of,
                                                  1, maxnoofPC5QoSFlows, false);

  return offset;
}



static int
dissect_f1ap_CG_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_CG_Config);
    dissect_nr_rrc_CG_Config_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_22_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_GNB_ID_vals[] = {
  {   0, "gNB-ID" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t GNB_ID_choice[] = {
  {   0, &hf_f1ap_gNB_ID         , ASN1_NO_EXTENSIONS     , dissect_f1ap_BIT_STRING_SIZE_22_32 },
  {   1, &hf_f1ap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_GNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_GNB_ID, GNB_ID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalGNB_ID_sequence[] = {
  { &hf_f1ap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_gnb_id_choice  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GlobalGNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GlobalGNB_ID, GlobalGNB_ID_sequence);

  return offset;
}



static int
dissect_f1ap_GNB_CU_MBS_F1AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}



static int
dissect_f1ap_GNBCUMeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}



static int
dissect_f1ap_GNBDUMeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, true);

  return offset;
}



static int
dissect_f1ap_T_sIBtype(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, 32U, &f1ap_data->sib_type, true);



  return offset;
}



static int
dissect_f1ap_T_sIBmessage_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    f1ap_private_data_t *f1ap_data = f1ap_get_private_data(actx->pinfo);
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_sIBmessage);
    switch (f1ap_data->sib_type) {
    case 2:
      dissect_nr_rrc_SIB2_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 3:
      dissect_nr_rrc_SIB3_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 4:
      dissect_nr_rrc_SIB4_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 5:
      dissect_nr_rrc_SIB5_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 6:
      dissect_nr_rrc_SIB6_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 7:
      dissect_nr_rrc_SIB7_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 8:
      dissect_nr_rrc_SIB8_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 9:
      dissect_nr_rrc_SIB9_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 10:
      dissect_nr_rrc_SIB10_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 11:
      dissect_nr_rrc_SIB11_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 12:
      dissect_nr_rrc_SIB12_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 13:
      dissect_nr_rrc_SIB13_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 14:
      dissect_nr_rrc_SIB14_r16_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 15:
      dissect_nr_rrc_SIB15_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 16:
      dissect_nr_rrc_SIB16_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 17:
      dissect_nr_rrc_SIB17_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 18:
      dissect_nr_rrc_SIB18_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 19:
      dissect_nr_rrc_SIB19_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 20:
      dissect_nr_rrc_SIB20_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 21:
      dissect_nr_rrc_SIB21_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 22:
      dissect_nr_rrc_SIB22_r18_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 23:
      dissect_nr_rrc_SIB23_r18_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 24:
      dissect_nr_rrc_SIB24_r18_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    case 25:
      dissect_nr_rrc_SIB25_r18_PDU(param_tvb, actx->pinfo, subtree, NULL);
      break;
    default:
      break;
    }
  }


  return offset;
}



static int
dissect_f1ap_INTEGER_0_31_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, true);

  return offset;
}


static const per_sequence_t SibtypetobeupdatedListItem_sequence[] = {
  { &hf_f1ap_sIBtype_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sIBtype },
  { &hf_f1ap_sIBmessage_01  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sIBmessage_01 },
  { &hf_f1ap_valueTag       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_31_ },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SibtypetobeupdatedListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SibtypetobeupdatedListItem, SibtypetobeupdatedListItem_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem_sequence_of[1] = {
  { &hf_f1ap_sibtypetobeupdatedlist_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SibtypetobeupdatedListItem },
};

static int
dissect_f1ap_SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem, SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem_sequence_of,
                                                  1, maxnoofSIBTypes, false);

  return offset;
}


static const per_sequence_t GNB_CUSystemInformation_sequence[] = {
  { &hf_f1ap_sibtypetobeupdatedlist, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SEQUENCE_SIZE_1_maxnoofSIBTypes_OF_SibtypetobeupdatedListItem },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CUSystemInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CUSystemInformation, GNB_CUSystemInformation_sequence);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_Setup_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_Setup_Item, GNB_CU_TNL_Association_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_Failed_To_Setup_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_cause          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Cause },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_Failed_To_Setup_Item, GNB_CU_TNL_Association_Failed_To_Setup_Item_sequence);

  return offset;
}


static const value_string f1ap_TNLAssociationUsage_vals[] = {
  {   0, "ue" },
  {   1, "non-ue" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_f1ap_TNLAssociationUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Add_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_tNLAssociationUsage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TNLAssociationUsage },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Add_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_To_Add_Item, GNB_CU_TNL_Association_To_Add_Item_sequence);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Remove_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_To_Remove_Item, GNB_CU_TNL_Association_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t GNB_CU_TNL_Association_To_Update_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_tNLAssociationUsage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_TNLAssociationUsage },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_CU_TNL_Association_To_Update_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_CU_TNL_Association_To_Update_Item, GNB_CU_TNL_Association_To_Update_Item_sequence);

  return offset;
}



static int
dissect_f1ap_GNB_DU_MBS_F1AP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, false);

  return offset;
}



static int
dissect_f1ap_GNB_CU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_PrintableString(tvb, offset, actx, tree, hf_index,
                                          1, 150, true,
                                          NULL);

  return offset;
}



static int
dissect_f1ap_GNB_DU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_PrintableString(tvb, offset, actx, tree, hf_index,
                                          1, 150, true,
                                          NULL);

  return offset;
}



static int
dissect_f1ap_GNB_CU_NameVisibleString(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 150, true,
                                          NULL);

  return offset;
}



static int
dissect_f1ap_GNB_CU_NameUTF8String(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 150, true);

  return offset;
}


static const per_sequence_t Extended_GNB_CU_Name_sequence[] = {
  { &hf_f1ap_gNB_CU_NameVisibleString, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_CU_NameVisibleString },
  { &hf_f1ap_gNB_CU_NameUTF8String, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_CU_NameUTF8String },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Extended_GNB_CU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Extended_GNB_CU_Name, Extended_GNB_CU_Name_sequence);

  return offset;
}



static int
dissect_f1ap_GNB_DU_NameVisibleString(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 150, true,
                                          NULL);

  return offset;
}



static int
dissect_f1ap_GNB_DU_NameUTF8String(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_UTF8String(tvb, offset, actx, tree, hf_index,
                                          1, 150, true);

  return offset;
}


static const per_sequence_t Extended_GNB_DU_Name_sequence[] = {
  { &hf_f1ap_gNB_DU_NameVisibleString, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_NameVisibleString },
  { &hf_f1ap_gNB_DU_NameUTF8String, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_NameUTF8String },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Extended_GNB_DU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Extended_GNB_DU_Name, Extended_GNB_DU_Name_sequence);

  return offset;
}



static int
dissect_f1ap_Configured_EPS_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       2, 2, false, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t TDD_Info_sequence[] = {
  { &hf_f1ap_nRFreqInfo     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TDD_Info, TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_NR_Mode_Info_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NR_Mode_Info_choice[] = {
  {   0, &hf_f1ap_fDD_03         , ASN1_NO_EXTENSIONS     , dissect_f1ap_FDD_Info },
  {   1, &hf_f1ap_tDD_03         , ASN1_NO_EXTENSIONS     , dissect_f1ap_TDD_Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_NR_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_NR_Mode_Info, NR_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_T_measurementTimingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_measurementTimingConfiguration);
    dissect_nr_rrc_MeasurementTimingConfiguration_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t Served_Cell_Information_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_nRPCI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRPCI },
  { &hf_f1ap_fiveGS_TAC     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_FiveGS_TAC },
  { &hf_f1ap_configured_EPS_TAC, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Configured_EPS_TAC },
  { &hf_f1ap_servedPLMNs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ServedPLMNs_List },
  { &hf_f1ap_nR_Mode_Info   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NR_Mode_Info },
  { &hf_f1ap_measurementTimingConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_measurementTimingConfiguration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Served_Cell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Served_Cell_Information, Served_Cell_Information_sequence);

  return offset;
}



static int
dissect_f1ap_MIB_message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MIB_message);
    dissect_nr_rrc_MIB_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_SIB1_message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_SIB1_message);
    dissect_nr_rrc_SIB1_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t GNB_DU_System_Information_sequence[] = {
  { &hf_f1ap_mIB_message    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MIB_message },
  { &hf_f1ap_sIB1_message   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SIB1_message },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_DU_System_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_DU_System_Information, GNB_DU_System_Information_sequence);

  return offset;
}


static const per_sequence_t GNB_DU_Served_Cells_Item_sequence[] = {
  { &hf_f1ap_served_Cell_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_Served_Cell_Information },
  { &hf_f1ap_gNB_DU_System_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_GNB_DU_System_Information },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_DU_Served_Cells_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_DU_Served_Cells_Item, GNB_DU_Served_Cells_Item_sequence);

  return offset;
}


static const value_string f1ap_GNB_DUConfigurationQuery_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_GNB_DUConfigurationQuery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_GNBDUOverloadInformation_vals[] = {
  {   0, "overloaded" },
  {   1, "not-overloaded" },
  { 0, NULL }
};


static int
dissect_f1ap_GNBDUOverloadInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNB_DU_TNL_Association_To_Remove_Item_sequence[] = {
  { &hf_f1ap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_tNLAssociationTransportLayerAddressgNBCU, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_CP_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_DU_TNL_Association_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_DU_TNL_Association_To_Remove_Item, GNB_DU_TNL_Association_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t GNBDUUESliceMaximumBitRateItem_sequence[] = {
  { &hf_f1ap_sNSSAI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SNSSAI },
  { &hf_f1ap_uESliceMaximumBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNBDUUESliceMaximumBitRateItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNBDUUESliceMaximumBitRateItem, GNBDUUESliceMaximumBitRateItem_sequence);

  return offset;
}


static const per_sequence_t GNBDUUESliceMaximumBitRateList_sequence_of[1] = {
  { &hf_f1ap_GNBDUUESliceMaximumBitRateList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBDUUESliceMaximumBitRateItem },
};

static int
dissect_f1ap_GNBDUUESliceMaximumBitRateList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GNBDUUESliceMaximumBitRateList, GNBDUUESliceMaximumBitRateList_sequence_of,
                                                  1, maxnoofSMBRValues, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1970049(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1970049U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_985025(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 985025U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_492513(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 492513U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_246257(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 246257U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_123129(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 123129U, NULL, false);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_61565(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 61565U, NULL, false);

  return offset;
}


static const value_string f1ap_GNBRxTxTimeDiffMeas_vals[] = {
  {   0, "k0" },
  {   1, "k1" },
  {   2, "k2" },
  {   3, "k3" },
  {   4, "k4" },
  {   5, "k5" },
  {   6, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t GNBRxTxTimeDiffMeas_choice[] = {
  {   0, &hf_f1ap_k0             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_1970049 },
  {   1, &hf_f1ap_k1             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_985025 },
  {   2, &hf_f1ap_k2             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_492513 },
  {   3, &hf_f1ap_k3             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_246257 },
  {   4, &hf_f1ap_k4             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_123129 },
  {   5, &hf_f1ap_k5             , ASN1_NO_EXTENSIONS     , dissect_f1ap_INTEGER_0_61565 },
  {   6, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_GNBRxTxTimeDiffMeas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_GNBRxTxTimeDiffMeas, GNBRxTxTimeDiffMeas_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNB_RxTxTimeDiff_sequence[] = {
  { &hf_f1ap_rxTxTimeDiff   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GNBRxTxTimeDiffMeas },
  { &hf_f1ap_additionalPath_List, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AdditionalPath_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GNB_RxTxTimeDiff(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GNB_RxTxTimeDiff, GNB_RxTxTimeDiff_sequence);

  return offset;
}


static const per_sequence_t GTPTLA_Item_sequence[] = {
  { &hf_f1ap_gTPTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TransportLayerAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_GTPTLA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_GTPTLA_Item, GTPTLA_Item_sequence);

  return offset;
}


static const per_sequence_t GTPTLAs_sequence_of[1] = {
  { &hf_f1ap_GTPTLAs_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_GTPTLA_Item },
};

static int
dissect_f1ap_GTPTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_GTPTLAs, GTPTLAs_sequence_of,
                                                  1, maxnoofGTPTLAs, false);

  return offset;
}



static int
dissect_f1ap_HandoverPreparationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_HandoverPreparationInformation);
    dissect_nr_rrc_HandoverPreparationInformation_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_INTEGER_0_100_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, true);

  return offset;
}


static const per_sequence_t HardwareLoadIndicator_sequence[] = {
  { &hf_f1ap_dLHardwareLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100_ },
  { &hf_f1ap_uLHardwareLoadIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_100_ },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_HardwareLoadIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_HardwareLoadIndicator, HardwareLoadIndicator_sequence);

  return offset;
}



static int
dissect_f1ap_HashedUEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     13, 13, true, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string f1ap_IAB_Barred_vals[] = {
  {   0, "barred" },
  {   1, "not-barred" },
  { 0, NULL }
};


static int
dissect_f1ap_IAB_Barred(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_IABConditionalRRCMessageDeliveryIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_IABConditionalRRCMessageDeliveryIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t IAB_Congestion_Indication_Item_sequence[] = {
  { &hf_f1ap_childNodeIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BAPAddress },
  { &hf_f1ap_bHRLCCHList    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_BHRLCCHList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_Congestion_Indication_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_Congestion_Indication_Item, IAB_Congestion_Indication_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_Congestion_Indication_List_sequence_of[1] = {
  { &hf_f1ap_IAB_Congestion_Indication_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_Congestion_Indication_Item },
};

static int
dissect_f1ap_IAB_Congestion_Indication_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IAB_Congestion_Indication_List, IAB_Congestion_Indication_List_sequence_of,
                                                  1, maxnoofIABCongInd, false);

  return offset;
}


static const per_sequence_t IABCongestionIndication_sequence[] = {
  { &hf_f1ap_iAB_Congestion_Indication_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IAB_Congestion_Indication_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABCongestionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABCongestionIndication, IABCongestionIndication_sequence);

  return offset;
}


static const per_sequence_t IAB_Info_IAB_donor_CU_sequence[] = {
  { &hf_f1ap_iAB_STC_Info   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IAB_STC_Info },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_Info_IAB_donor_CU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_Info_IAB_donor_CU, IAB_Info_IAB_donor_CU_sequence);

  return offset;
}


static const per_sequence_t IAB_Info_IAB_DU_sequence[] = {
  { &hf_f1ap_multiplexingInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_MultiplexingInfo },
  { &hf_f1ap_iAB_STC_Info   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IAB_STC_Info },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_Info_IAB_DU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_Info_IAB_DU, IAB_Info_IAB_DU_sequence);

  return offset;
}


static const per_sequence_t IAB_MT_Cell_NA_Resource_Configuration_FDD_Info_sequence[] = {
  { &hf_f1ap_gNB_DU_Cell_NA_Resource_Configuration_FDD_UL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_gNB_DU_Cell_NA_Resource_Configuration_FDD_DL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_uL_FreqInfo_01 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_uL_Transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_uL_NR_Carrier_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRCarrierList },
  { &hf_f1ap_dL_FreqInfo    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_dL_Transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_dL_NR_Carrier_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRCarrierList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_MT_Cell_NA_Resource_Configuration_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_MT_Cell_NA_Resource_Configuration_FDD_Info, IAB_MT_Cell_NA_Resource_Configuration_FDD_Info_sequence);

  return offset;
}


static const per_sequence_t IAB_MT_Cell_NA_Resource_Configuration_TDD_Info_sequence[] = {
  { &hf_f1ap_gNB_DU_Cell_NA_Resourc_Configuration_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_GNB_DU_Cell_Resource_Configuration },
  { &hf_f1ap_nRFreqInfo     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRFreqInfo },
  { &hf_f1ap_transmission_Bandwidth_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_Transmission_Bandwidth },
  { &hf_f1ap_nR_Carrier_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NRCarrierList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_MT_Cell_NA_Resource_Configuration_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_MT_Cell_NA_Resource_Configuration_TDD_Info, IAB_MT_Cell_NA_Resource_Configuration_TDD_Info_sequence);

  return offset;
}


static const value_string f1ap_IAB_MT_Cell_NA_Resource_Configuration_Mode_Info_vals[] = {
  {   0, "fDD" },
  {   1, "tDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IAB_MT_Cell_NA_Resource_Configuration_Mode_Info_choice[] = {
  {   0, &hf_f1ap_fDD_01         , ASN1_NO_EXTENSIONS     , dissect_f1ap_IAB_MT_Cell_NA_Resource_Configuration_FDD_Info },
  {   1, &hf_f1ap_tDD_01         , ASN1_NO_EXTENSIONS     , dissect_f1ap_IAB_MT_Cell_NA_Resource_Configuration_TDD_Info },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_IAB_MT_Cell_NA_Resource_Configuration_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_IAB_MT_Cell_NA_Resource_Configuration_Mode_Info, IAB_MT_Cell_NA_Resource_Configuration_Mode_Info_choice,
                                 NULL);

  return offset;
}


static const value_string f1ap_IABTNLAddressUsage_vals[] = {
  {   0, "f1-c" },
  {   1, "f1-u" },
  {   2, "non-f1" },
  { 0, NULL }
};


static int
dissect_f1ap_IABTNLAddressUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t IAB_Allocated_TNL_Address_Item_sequence[] = {
  { &hf_f1ap_iABTNLAddress  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddress },
  { &hf_f1ap_iABTNLAddressUsage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_IABTNLAddressUsage },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_Allocated_TNL_Address_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_Allocated_TNL_Address_Item, IAB_Allocated_TNL_Address_Item_sequence);

  return offset;
}



static int
dissect_f1ap_INTEGER_1_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, false);

  return offset;
}


static const per_sequence_t IABTNLAddressesRequested_sequence[] = {
  { &hf_f1ap_tNLAddressesOrPrefixesRequestedAllTraffic, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_256 },
  { &hf_f1ap_tNLAddressesOrPrefixesRequestedF1_C, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_256 },
  { &hf_f1ap_tNLAddressesOrPrefixesRequestedF1_U, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_256 },
  { &hf_f1ap_tNLAddressesOrPrefixesRequestedNoNF1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_1_256 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABTNLAddressesRequested(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABTNLAddressesRequested, IABTNLAddressesRequested_sequence);

  return offset;
}


static const value_string f1ap_IABIPv6RequestType_vals[] = {
  {   0, "iPv6Address" },
  {   1, "iPv6Prefix" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IABIPv6RequestType_choice[] = {
  {   0, &hf_f1ap_iPv6Address    , ASN1_NO_EXTENSIONS     , dissect_f1ap_IABTNLAddressesRequested },
  {   1, &hf_f1ap_iPv6Prefix     , ASN1_NO_EXTENSIONS     , dissect_f1ap_IABTNLAddressesRequested },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_IABIPv6RequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_IABIPv6RequestType, IABIPv6RequestType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IAB_TNL_Addresses_To_Remove_Item_sequence[] = {
  { &hf_f1ap_iABTNLAddress  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_TNL_Addresses_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_TNL_Addresses_To_Remove_Item, IAB_TNL_Addresses_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddress_Item_sequence[] = {
  { &hf_f1ap_iABTNLAddress  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddress },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABTNLAddress_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABTNLAddress_Item, IABTNLAddress_Item_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddressList_sequence_of[1] = {
  { &hf_f1ap_IABTNLAddressList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddress_Item },
};

static int
dissect_f1ap_IABTNLAddressList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_IABTNLAddressList, IABTNLAddressList_sequence_of,
                                                  1, maxnoofTLAsIAB, false);

  return offset;
}


static const per_sequence_t IAB_TNL_Addresses_Exception_sequence[] = {
  { &hf_f1ap_iABTNLAddressList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddressList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IAB_TNL_Addresses_Exception(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IAB_TNL_Addresses_Exception, IAB_TNL_Addresses_Exception_sequence);

  return offset;
}


static const per_sequence_t IABv4AddressesRequested_sequence[] = {
  { &hf_f1ap_iABv4AddressesRequested, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_IABTNLAddressesRequested },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IABv4AddressesRequested(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IABv4AddressesRequested, IABv4AddressesRequested_sequence);

  return offset;
}


static const per_sequence_t TAI_sequence[] = {
  { &hf_f1ap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_PLMN_Identity },
  { &hf_f1ap_fiveGS_TAC     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_FiveGS_TAC },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_TAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_TAI, TAI_sequence);

  return offset;
}


static const per_sequence_t Mobile_IAB_MTUserLocationInformation_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_tAI            , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_TAI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Mobile_IAB_MTUserLocationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Mobile_IAB_MTUserLocationInformation, Mobile_IAB_MTUserLocationInformation_sequence);

  return offset;
}


static const value_string f1ap_IgnorePRACHConfiguration_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_IgnorePRACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_IgnoreResourceCoordinationContainer_vals[] = {
  {   0, "yes" },
  { 0, NULL }
};


static int
dissect_f1ap_IgnoreResourceCoordinationContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_InactivityMonitoringRequest_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_InactivityMonitoringRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_InactivityMonitoringResponse_vals[] = {
  {   0, "not-supported" },
  { 0, NULL }
};


static int
dissect_f1ap_InactivityMonitoringResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_BIT_STRING_SIZE_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_RemoteUELocalID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, true);

  return offset;
}


static const per_sequence_t IndirectPathAddition_sequence[] = {
  { &hf_f1ap_targetRelayUEID_bit_string, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_BIT_STRING_SIZE_24 },
  { &hf_f1ap_remoteUELocalID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_RemoteUELocalID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IndirectPathAddition(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IndirectPathAddition, IndirectPathAddition_sequence);

  return offset;
}



static int
dissect_f1ap_InterfacesToTrace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, &param_tvb, NULL);

  if(param_tvb){
    static int * const fields[] = {
      &hf_f1ap_interfacesToTrace_NG_C,
      &hf_f1ap_interfacesToTrace_Xn_C,
      &hf_f1ap_interfacesToTrace_Uu,
      &hf_f1ap_interfacesToTrace_F1_C,
      &hf_f1ap_interfacesToTrace_E1,
      &hf_f1ap_interfacesToTrace_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_InterfacesToTrace);
    proto_tree_add_bitmask_list(subtree, param_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string f1ap_T_nRSCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  {   4, "scs480" },
  {   5, "scs960" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nRSCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 2, NULL);

  return offset;
}


static const value_string f1ap_T_nRCP_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nRCP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_T_nRDLULTxPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms3" },
  {   7, "ms4" },
  {   8, "ms5" },
  {   9, "ms10" },
  {  10, "ms20" },
  {  11, "ms40" },
  {  12, "ms60" },
  {  13, "ms80" },
  {  14, "ms100" },
  {  15, "ms120" },
  {  16, "ms140" },
  {  17, "ms160" },
  { 0, NULL }
};


static int
dissect_f1ap_T_nRDLULTxPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_5119_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5119U, NULL, true);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_13_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 13U, NULL, true);

  return offset;
}


static const per_sequence_t NumDLULSymbols_sequence[] = {
  { &hf_f1ap_numDLSymbols   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_13_ },
  { &hf_f1ap_numULSymbols   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_13_ },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_NumDLULSymbols(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_NumDLULSymbols, NumDLULSymbols_sequence);

  return offset;
}


static const value_string f1ap_SymbolAllocInSlot_vals[] = {
  {   0, "all-DL" },
  {   1, "all-UL" },
  {   2, "both-DL-and-UL" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SymbolAllocInSlot_choice[] = {
  {   0, &hf_f1ap_all_DL         , ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   1, &hf_f1ap_all_UL         , ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_both_DL_and_UL , ASN1_NO_EXTENSIONS     , dissect_f1ap_NumDLULSymbols },
  {   3, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_SymbolAllocInSlot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_SymbolAllocInSlot, SymbolAllocInSlot_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Slot_Configuration_Item_sequence[] = {
  { &hf_f1ap_slotIndex_01   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_5119_ },
  { &hf_f1ap_symbolAllocInSlot, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SymbolAllocInSlot },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_Slot_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_Slot_Configuration_Item, Slot_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t Slot_Configuration_List_sequence_of[1] = {
  { &hf_f1ap_Slot_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Slot_Configuration_Item },
};

static int
dissect_f1ap_Slot_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_Slot_Configuration_List, Slot_Configuration_List_sequence_of,
                                                  1, maxnoofslots, false);

  return offset;
}


static const per_sequence_t IntendedTDD_DL_ULConfig_sequence[] = {
  { &hf_f1ap_nRSCS          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nRSCS },
  { &hf_f1ap_nRCP           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nRCP },
  { &hf_f1ap_nRDLULTxPeriodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_nRDLULTxPeriodicity },
  { &hf_f1ap_slot_Configuration_List, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_Slot_Configuration_List },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_IntendedTDD_DL_ULConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_IntendedTDD_DL_ULConfig, IntendedTDD_DL_ULConfig_sequence);

  return offset;
}


static const value_string f1ap_InterFrequencyConfig_NoGap_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_InterFrequencyConfig_NoGap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_IngressNonF1terminatingTopologyIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_IngressNonF1terminatingTopologyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_IndicationMCInactiveReception_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_IndicationMCInactiveReception(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LTML2ResetConfiguration_Item_sequence[] = {
  { &hf_f1ap_cellID         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_ltmL2ResetConfiguration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_OCTET_STRING },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTML2ResetConfiguration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTML2ResetConfiguration_Item, LTML2ResetConfiguration_Item_sequence);

  return offset;
}


static const per_sequence_t LTML2ResetConfigurationList_sequence_of[1] = {
  { &hf_f1ap_LTML2ResetConfigurationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LTML2ResetConfiguration_Item },
};

static int
dissect_f1ap_LTML2ResetConfigurationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LTML2ResetConfigurationList, LTML2ResetConfigurationList_sequence_of,
                                                  1, maxnoofLTMCells, false);

  return offset;
}


static const per_sequence_t LTMResetInformation_sequence[] = {
  { &hf_f1ap_servingCellL2ResetConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_OCTET_STRING },
  { &hf_f1ap_lTML2ResetConfigurationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LTML2ResetConfigurationList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMResetInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMResetInformation, LTMResetInformation_sequence);

  return offset;
}



static int
dissect_f1ap_JointorDLTCIStateID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb && lte_rrc_conn_reconf_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_JointorDLTCIStateID);
    dissect_nr_rrc_TCI_StateId_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_AerialUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_AerialUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_ControllerUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_ControllerUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LTEA2XServicesAuthorized_sequence[] = {
  { &hf_f1ap_aerialUE       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_AerialUE },
  { &hf_f1ap_controllerUE   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ControllerUE },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTEA2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTEA2XServicesAuthorized, LTEA2XServicesAuthorized_sequence);

  return offset;
}


static const value_string f1ap_T_prachSCSForL571_vals[] = {
  {   0, "scs30" },
  {   1, "scs120" },
  {   2, "scs480" },
  { 0, NULL }
};


static int
dissect_f1ap_T_prachSCSForL571(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 1, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_569(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 569U, NULL, false);

  return offset;
}


static const per_sequence_t L571Info_sequence[] = {
  { &hf_f1ap_prachSCSForL571, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_prachSCSForL571 },
  { &hf_f1ap_rootSequenceIndex_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_569 },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_L571Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_L571Info, L571Info_sequence);

  return offset;
}


static const value_string f1ap_T_prachSCSForL1151_vals[] = {
  {   0, "scs15" },
  {   1, "scs120" },
  { 0, NULL }
};


static int
dissect_f1ap_T_prachSCSForL1151(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_1149(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1149U, NULL, false);

  return offset;
}


static const per_sequence_t L1151Info_sequence[] = {
  { &hf_f1ap_prachSCSForL1151, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_prachSCSForL1151 },
  { &hf_f1ap_rootSequenceIndex_03, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1149 },
  { &hf_f1ap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_L1151Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_L1151Info, L1151Info_sequence);

  return offset;
}


static const value_string f1ap_LastUsedCellIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_LastUsedCellIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_0_359(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 359U, NULL, false);

  return offset;
}


static const per_sequence_t LCStoGCSTranslation_sequence[] = {
  { &hf_f1ap_alpha_01       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_359 },
  { &hf_f1ap_alpha_fine     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_9 },
  { &hf_f1ap_beta_01        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_359 },
  { &hf_f1ap_beta_fine      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_9 },
  { &hf_f1ap_gamma_01       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_359 },
  { &hf_f1ap_gamma_fine     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_INTEGER_0_9 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LCStoGCSTranslation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LCStoGCSTranslation, LCStoGCSTranslation_sequence);

  return offset;
}


static const per_sequence_t LCStoGCSTranslationList_sequence_of[1] = {
  { &hf_f1ap_LCStoGCSTranslationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LCStoGCSTranslation },
};

static int
dissect_f1ap_LCStoGCSTranslationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LCStoGCSTranslationList, LCStoGCSTranslationList_sequence_of,
                                                  1, maxnooflcs_gcs_translation, false);

  return offset;
}



static int
dissect_f1ap_LMF_MeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65536U, NULL, true);

  return offset;
}



static int
dissect_f1ap_LMF_UE_MeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, true);

  return offset;
}



static int
dissect_f1ap_LocationMeasurementInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_LocationMeasurementInformation);
    dissect_nr_rrc_LocationMeasurementInfo_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_LowerLayerPresenceStatusChange_vals[] = {
  {   0, "suspend-lower-layers" },
  {   1, "resume-lower-layers" },
  { 0, NULL }
};


static int
dissect_f1ap_LowerLayerPresenceStatusChange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_LoS_NLoSIndicatorHard_vals[] = {
  {   0, "nLoS" },
  {   1, "loS" },
  { 0, NULL }
};


static int
dissect_f1ap_LoS_NLoSIndicatorHard(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_f1ap_LoS_NLoSIndicatorSoft(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10U, NULL, false);

  return offset;
}


static const value_string f1ap_LoS_NLoSInformation_vals[] = {
  {   0, "loS-NLoSIndicatorSoft" },
  {   1, "loS-NLoSIndicatorHard" },
  {   2, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t LoS_NLoSInformation_choice[] = {
  {   0, &hf_f1ap_loS_NLoSIndicatorSoft, ASN1_NO_EXTENSIONS     , dissect_f1ap_LoS_NLoSIndicatorSoft },
  {   1, &hf_f1ap_loS_NLoSIndicatorHard, ASN1_NO_EXTENSIONS     , dissect_f1ap_LoS_NLoSIndicatorHard },
  {   2, &hf_f1ap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_LoS_NLoSInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_LoS_NLoSInformation, LoS_NLoSInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LTEUESidelinkAggregateMaximumBitrate_sequence[] = {
  { &hf_f1ap_uELTESidelinkAggregateMaximumBitrate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_BitRate },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTEUESidelinkAggregateMaximumBitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTEUESidelinkAggregateMaximumBitrate, LTEUESidelinkAggregateMaximumBitrate_sequence);

  return offset;
}


static const value_string f1ap_VehicleUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_VehicleUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_PedestrianUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_f1ap_PedestrianUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t LTEV2XServicesAuthorized_sequence[] = {
  { &hf_f1ap_vehicleUE      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_VehicleUE },
  { &hf_f1ap_pedestrianUE   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_PedestrianUE },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTEV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTEV2XServicesAuthorized, LTEV2XServicesAuthorized_sequence);

  return offset;
}


static const per_sequence_t LTMCells_ToBeReleased_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMCells_ToBeReleased_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMCells_ToBeReleased_Item, LTMCells_ToBeReleased_Item_sequence);

  return offset;
}


static const per_sequence_t LTMCells_ToBeReleased_List_sequence_of[1] = {
  { &hf_f1ap_LTMCells_ToBeReleased_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMCells_ToBeReleased_Item },
};

static int
dissect_f1ap_LTMCells_ToBeReleased_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LTMCells_ToBeReleased_List, LTMCells_ToBeReleased_List_sequence_of,
                                                  1, maxnoofLTMCells, false);

  return offset;
}


static const value_string f1ap_LTMIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_LTMIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_RequestforLowerLayerConfiguration_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_RequestforLowerLayerConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_f1ap_ReferenceConfigurationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb && lte_rrc_conn_reconf_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_ReferenceConfigurationInformation);
    dissect_nr_rrc_CellGroupConfig_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_ReferenceConfiguration_vals[] = {
  {   0, "rEQUESTforLowerLayerConfiguration" },
  {   1, "referenceConfiguration" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ReferenceConfiguration_choice[] = {
  {   0, &hf_f1ap_rEQUESTforLowerLayerConfiguration, ASN1_NO_EXTENSIONS     , dissect_f1ap_RequestforLowerLayerConfiguration },
  {   1, &hf_f1ap_referenceConfiguration_item, ASN1_NO_EXTENSIONS     , dissect_f1ap_ReferenceConfigurationInformation },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ReferenceConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ReferenceConfiguration, ReferenceConfiguration_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LTMInformation_Setup_sequence[] = {
  { &hf_f1ap_lTMIndicator   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMIndicator },
  { &hf_f1ap_referenceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ReferenceConfiguration },
  { &hf_f1ap_cSIResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CSIResourceConfiguration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMInformation_Setup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMInformation_Setup, LTMInformation_Setup_sequence);

  return offset;
}



static int
dissect_f1ap_LTMConfigurationID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, false);

  return offset;
}


static const per_sequence_t LTMConfigurationIDMapping_Item_sequence[] = {
  { &hf_f1ap_lTMCellID      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_lTMConfigurationID, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMConfigurationID },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMConfigurationIDMapping_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMConfigurationIDMapping_Item, LTMConfigurationIDMapping_Item_sequence);

  return offset;
}


static const per_sequence_t LTMConfigurationIDMappingList_sequence_of[1] = {
  { &hf_f1ap_LTMConfigurationIDMappingList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMConfigurationIDMapping_Item },
};

static int
dissect_f1ap_LTMConfigurationIDMappingList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LTMConfigurationIDMappingList, LTMConfigurationIDMappingList_sequence_of,
                                                  1, maxnoofLTMCells, false);

  return offset;
}


static const per_sequence_t LTMInformation_Modify_sequence[] = {
  { &hf_f1ap_lTMIndicator   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMIndicator },
  { &hf_f1ap_referenceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ReferenceConfiguration },
  { &hf_f1ap_cSIResourceConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CSIResourceConfiguration },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMInformation_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMInformation_Modify, LTMInformation_Modify_sequence);

  return offset;
}


static const value_string f1ap_CompleteCandidateConfigurationIndicator_vals[] = {
  {   0, "complete" },
  { 0, NULL }
};


static int
dissect_f1ap_CompleteCandidateConfigurationIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_T_sSB_subcarrier_spacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz60" },
  {   3, "kHz120" },
  {   4, "kHz240" },
  {   5, "kHz480" },
  {   6, "kHz960" },
  { 0, NULL }
};


static int
dissect_f1ap_T_sSB_subcarrier_spacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, true, 2, NULL);

  return offset;
}



static int
dissect_f1ap_INTEGER_M60_50(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -60, 50U, NULL, false);

  return offset;
}


static const value_string f1ap_T_sSB_periodicity_vals[] = {
  {   0, "ms5" },
  {   1, "ms10" },
  {   2, "ms20" },
  {   3, "ms40" },
  {   4, "ms80" },
  {   5, "ms160" },
  { 0, NULL }
};


static int
dissect_f1ap_T_sSB_periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SSB_TF_Configuration_sequence[] = {
  { &hf_f1ap_sSB_frequency  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_3279165 },
  { &hf_f1ap_sSB_subcarrier_spacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sSB_subcarrier_spacing },
  { &hf_f1ap_sSB_Transmit_power, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_M60_50 },
  { &hf_f1ap_sSB_periodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_T_sSB_periodicity },
  { &hf_f1ap_sSB_half_frame_offset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_1 },
  { &hf_f1ap_sSB_SFN_offset , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_INTEGER_0_15 },
  { &hf_f1ap_sSB_position_in_burst, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_SSB_PositionsInBurst },
  { &hf_f1ap_sFNInitialisationTime, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_RelativeTime1900 },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSB_TF_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSB_TF_Configuration, SSB_TF_Configuration_sequence);

  return offset;
}


static const per_sequence_t SSBInformationItem_sequence[] = {
  { &hf_f1ap_sSB_Configuration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSB_TF_Configuration },
  { &hf_f1ap_pCI_NR_01      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_NRPCI },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBInformationItem, SSBInformationItem_sequence);

  return offset;
}


static const per_sequence_t SSBInformationList_sequence_of[1] = {
  { &hf_f1ap_SSBInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBInformationItem },
};

static int
dissect_f1ap_SSBInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_SSBInformationList, SSBInformationList_sequence_of,
                                                  1, maxnoofSSBs, false);

  return offset;
}


static const per_sequence_t SSBInformation_sequence[] = {
  { &hf_f1ap_sSBInformationList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBInformationList },
  { &hf_f1ap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_SSBInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_SSBInformation, SSBInformation_sequence);

  return offset;
}



static int
dissect_f1ap_LTMCFRAResourceConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb && lte_rrc_conn_reconf_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_LTMCFRAResourceConfig);
    dissect_nr_rrc_RACH_ConfigDedicated_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t LTMConfiguration_sequence[] = {
  { &hf_f1ap_sSBInformation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_SSBInformation },
  { &hf_f1ap_referenceConfigurationInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ReferenceConfigurationInformation },
  { &hf_f1ap_completeCandidateConfigurationIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_CompleteCandidateConfigurationIndicator },
  { &hf_f1ap_lTMCFRAResourceConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LTMCFRAResourceConfig },
  { &hf_f1ap_lTMCFRAResourceConfigSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LTMCFRAResourceConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMConfiguration, LTMConfiguration_sequence);

  return offset;
}



static int
dissect_f1ap_ULTCIStateID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb && lte_rrc_conn_reconf_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_ULTCIStateID);
    dissect_nr_rrc_TCI_UL_StateId_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t LTMCellSwitchInformation_sequence[] = {
  { &hf_f1ap_jointorDLTCIStateID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_JointorDLTCIStateID },
  { &hf_f1ap_uLTCIStateID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ULTCIStateID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMCellSwitchInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMCellSwitchInformation, LTMCellSwitchInformation_sequence);

  return offset;
}


static const per_sequence_t LTMCFRAResourceConfig_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_lTMCFRAResourceConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LTMCFRAResourceConfig },
  { &hf_f1ap_lTMCFRAResourceConfigSUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_LTMCFRAResourceConfig },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_LTMCFRAResourceConfig_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_LTMCFRAResourceConfig_Item, LTMCFRAResourceConfig_Item_sequence);

  return offset;
}


static const per_sequence_t LTMCFRAResourceConfig_List_sequence_of[1] = {
  { &hf_f1ap_LTMCFRAResourceConfig_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_LTMCFRAResourceConfig_Item },
};

static int
dissect_f1ap_LTMCFRAResourceConfig_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_LTMCFRAResourceConfig_List, LTMCFRAResourceConfig_List_sequence_of,
                                                  1, maxnoofLTMCells, false);

  return offset;
}



static int
dissect_f1ap_MaskedIMEISV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_f1ap_MBS_Broadcast_NeighbourCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MBS_Broadcast_NeighbourCellList);
    dissect_nr_rrc_MBS_NeighbourCellList_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_MBSInterestIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_MBSInterestIndication);
    dissect_nr_rrc_MBSInterestIndication_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_TMGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, false, NULL);

  return offset;
}


static const per_sequence_t MBS_Session_ID_sequence[] = {
  { &hf_f1ap_tMGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_TMGI },
  { &hf_f1ap_nID            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_NID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBS_Session_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBS_Session_ID, MBS_Session_ID_sequence);

  return offset;
}


static const per_sequence_t MBS_Broadcast_Cell_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_mtch_neighbourCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_OCTET_STRING },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBS_Broadcast_Cell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBS_Broadcast_Cell_Item, MBS_Broadcast_Cell_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_Broadcast_Cell_List_sequence_of[1] = {
  { &hf_f1ap_MBS_Broadcast_Cell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Broadcast_Cell_Item },
};

static int
dissect_f1ap_MBS_Broadcast_Cell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MBS_Broadcast_Cell_List, MBS_Broadcast_Cell_List_sequence_of,
                                                  1, maxCellingNBDU, false);

  return offset;
}



static int
dissect_f1ap_T_mRB_PDCP_Config_Broadcast(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_mRB_PDCP_Config_Broadcast);
    dissect_nr_rrc_MRB_PDCP_ConfigBroadcast_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t MBS_Broadcast_MRB_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_mRB_PDCP_Config_Broadcast, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_mRB_PDCP_Config_Broadcast },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBS_Broadcast_MRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBS_Broadcast_MRB_Item, MBS_Broadcast_MRB_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_Broadcast_MRB_List_sequence_of[1] = {
  { &hf_f1ap_MBS_Broadcast_MRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Broadcast_MRB_Item },
};

static int
dissect_f1ap_MBS_Broadcast_MRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MBS_Broadcast_MRB_List, MBS_Broadcast_MRB_List_sequence_of,
                                                  1, maxnoofMRBs, false);

  return offset;
}


static const per_sequence_t MBS_CUtoDURRCInformation_sequence[] = {
  { &hf_f1ap_mBS_Broadcast_Cell_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Broadcast_Cell_List },
  { &hf_f1ap_mBS_Broadcast_MRB_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Broadcast_MRB_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBS_CUtoDURRCInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBS_CUtoDURRCInformation, MBS_CUtoDURRCInformation_sequence);

  return offset;
}



static int
dissect_f1ap_MulticastF1UContextReferenceF1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, false, NULL);

  return offset;
}


static const value_string f1ap_T_mc_F1UCtxtusage_vals[] = {
  {   0, "ptm" },
  {   1, "ptp" },
  {   2, "ptp-retransmission" },
  {   3, "ptp-forwarding" },
  { 0, NULL }
};


static int
dissect_f1ap_T_mc_F1UCtxtusage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MBSMulticastF1UContextDescriptor_sequence[] = {
  { &hf_f1ap_multicastF1UContextReferenceF1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MulticastF1UContextReferenceF1 },
  { &hf_f1ap_mc_F1UCtxtusage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_mc_F1UCtxtusage },
  { &hf_f1ap_mbsAreaSession , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MBS_Area_Session_ID },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBSMulticastF1UContextDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBSMulticastF1UContextDescriptor, MBSMulticastF1UContextDescriptor_sequence);

  return offset;
}


static const value_string f1ap_MT_SDT_Indicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_f1ap_MT_SDT_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MT_SDT_Information_sequence[] = {
  { &hf_f1ap_mt_SDT_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MT_SDT_Indicator },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MT_SDT_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MT_SDT_Information, MT_SDT_Information_sequence);

  return offset;
}


static const value_string f1ap_MBSMulticastSessionReceptionState_vals[] = {
  {   0, "start-monitoring-G-RNTI" },
  {   1, "stop-monitoring-G-RNTI" },
  { 0, NULL }
};


static int
dissect_f1ap_MBSMulticastSessionReceptionState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_MBSMulticastRRCINACTIVEReceptionMode_vals[] = {
  {   0, "activated" },
  {   1, "deactivated" },
  { 0, NULL }
};


static int
dissect_f1ap_MBSMulticastRRCINACTIVEReceptionMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string f1ap_T_mbsMulticastConfigurationRequest_vals[] = {
  {   0, "query" },
  { 0, NULL }
};


static int
dissect_f1ap_T_mbsMulticastConfigurationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t MBS_Multicast_CU2DU_Cell_Item_sequence[] = {
  { &hf_f1ap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_NRCGI },
  { &hf_f1ap_mbsMulticastRRC_INACTIVEReceptionMode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MBSMulticastRRCINACTIVEReceptionMode },
  { &hf_f1ap_mbsMulticastConfigurationRequest, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_T_mbsMulticastConfigurationRequest },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBS_Multicast_CU2DU_Cell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBS_Multicast_CU2DU_Cell_Item, MBS_Multicast_CU2DU_Cell_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_Multicast_CU2DU_Cell_List_sequence_of[1] = {
  { &hf_f1ap_MBS_Multicast_CU2DU_Cell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Multicast_CU2DU_Cell_Item },
};

static int
dissect_f1ap_MBS_Multicast_CU2DU_Cell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MBS_Multicast_CU2DU_Cell_List, MBS_Multicast_CU2DU_Cell_List_sequence_of,
                                                  1, maxCellingNBDU, false);

  return offset;
}



static int
dissect_f1ap_T_mRB_PDCP_Config_Broadcast_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb && lte_rrc_conn_reconf_handle) {
    subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_mRB_PDCP_Config_Broadcast);
    dissect_nr_rrc_MRB_PDCP_ConfigBroadcast_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t MBS_Multicast_MRB_Item_sequence[] = {
  { &hf_f1ap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MRB_ID },
  { &hf_f1ap_mRB_PDCP_Config_Broadcast_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_T_mRB_PDCP_Config_Broadcast_01 },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MBS_Multicast_MRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MBS_Multicast_MRB_Item, MBS_Multicast_MRB_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_Multicast_MRB_List_sequence_of[1] = {
  { &hf_f1ap_MBS_Multicast_MRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Multicast_MRB_Item },
};

static int
dissect_f1ap_MBS_Multicast_MRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MBS_Multicast_MRB_List, MBS_Multicast_MRB_List_sequence_of,
                                                  1, maxnoofMRBs, false);

  return offset;
}


static const per_sequence_t MulticastCU2DURRCInfo_sequence[] = {
  { &hf_f1ap_mBS_Multicast_CU2DU_Cell_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MBS_Multicast_CU2DU_Cell_List },
  { &hf_f1ap_mBS_Multicast_MRB_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MBS_Multicast_MRB_List },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MulticastCU2DURRCInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MulticastCU2DURRCInfo, MulticastCU2DURRCInfo_sequence);

  return offset;
}



static int
dissect_f1ap_T_mbs_NeighbourCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_mbs_NeighbourCellList);
    dissect_nr_rrc_MBS_NeighbourCellList_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_T_mtch_NeighbourCellprovided(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_mtch_NeighbourCellprovided);
    dissect_nr_rrc_MTCH_NeighbourCell_r18_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string f1ap_MTCH_NeighbourCellInformation_vals[] = {
  {   0, "mtch-NeighbourCellprovided" },
  {   1, "mtch-NeighbourCellnotprovided" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MTCH_NeighbourCellInformation_choice[] = {
  {   0, &hf_f1ap_mtch_NeighbourCellprovided, ASN1_NO_EXTENSIONS     , dissect_f1ap_T_mtch_NeighbourCellprovided },
  {   1, &hf_f1ap_mtch_NeighbourCellnotprovided, ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_MTCH_NeighbourCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_MTCH_NeighbourCellInformation, MTCH_NeighbourCellInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MTCH_NeighbourCellSession_Item_sequence[] = {
  { &hf_f1ap_mbsSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Session_ID },
  { &hf_f1ap_mtch_NeighbourCellInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MTCH_NeighbourCellInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_MTCH_NeighbourCellSession_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_MTCH_NeighbourCellSession_Item, MTCH_NeighbourCellSession_Item_sequence);

  return offset;
}


static const per_sequence_t MTCH_NeighbourCellSessionList_sequence_of[1] = {
  { &hf_f1ap_MTCH_NeighbourCellSessionList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_MTCH_NeighbourCellSession_Item },
};

static int
dissect_f1ap_MTCH_NeighbourCellSessionList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_MTCH_NeighbourCellSessionList, MTCH_NeighbourCellSessionList_sequence_of,
                                                  1, maxMBSSessionsinSessionInfoList, false);

  return offset;
}


static const per_sequence_t UpdateMBSMulticastNeighbourCellListInformation_sequence[] = {
  { &hf_f1ap_mbs_NeighbourCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_T_mbs_NeighbourCellList },
  { &hf_f1ap_mbs_MulticastSessionList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_MTCH_NeighbourCellSessionList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UpdateMBSMulticastNeighbourCellListInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UpdateMBSMulticastNeighbourCellListInformation, UpdateMBSMulticastNeighbourCellListInformation_sequence);

  return offset;
}


static const value_string f1ap_MBSMulticastNeighbourCellListItem_vals[] = {
  {   0, "mbsMulticastNeighbourCellListInformationprovided" },
  {   1, "nombsMulticastNeighbourCellListInformationprovided" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MBSMulticastNeighbourCellListItem_choice[] = {
  {   0, &hf_f1ap_mbsMulticastNeighbourCellListInformationprovided, ASN1_NO_EXTENSIONS     , dissect_f1ap_UpdateMBSMulticastNeighbourCellListInformation },
  {   1, &hf_f1ap_nombsMulticastNeighbourCellListInformationprovided, ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_MBSMulticastNeighbourCellListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_MBSMulticastNeighbourCellListItem, MBSMulticastNeighbourCellListItem_choice,
                                 NULL);

  return offset;
}



static int
dissect_f1ap_T_thresholdMBSList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_f1ap_thresholdMBSList);
    dissect_nr_rrc_ThresholdMBS_List_r18_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_f1ap_ThresholdIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofThresholdMBS_1, NULL, false);

  return offset;
}


static const value_string f1ap_ThresholdIndexInformation_vals[] = {
  {   0, "thresholdIndexprovided" },
  {   1, "thresholdIndexnotprovided" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ThresholdIndexInformation_choice[] = {
  {   0, &hf_f1ap_thresholdIndexprovided, ASN1_NO_EXTENSIONS     , dissect_f1ap_ThresholdIndex },
  {   1, &hf_f1ap_thresholdIndexnotprovided, ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ThresholdIndexInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ThresholdIndexInformation, ThresholdIndexInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ThresholdIndexSession_Item_sequence[] = {
  { &hf_f1ap_mbsSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_MBS_Session_ID },
  { &hf_f1ap_thresholdIndexInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_f1ap_ThresholdIndexInformation },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_ThresholdIndexSession_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_ThresholdIndexSession_Item, ThresholdIndexSession_Item_sequence);

  return offset;
}


static const per_sequence_t ThresholdIndexSessionList_sequence_of[1] = {
  { &hf_f1ap_ThresholdIndexSessionList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_f1ap_ThresholdIndexSession_Item },
};

static int
dissect_f1ap_ThresholdIndexSessionList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_f1ap_ThresholdIndexSessionList, ThresholdIndexSessionList_sequence_of,
                                                  1, maxMBSSessionsinSessionInfoList, false);

  return offset;
}


static const per_sequence_t UpdateThresholdMBS_ListInformation_sequence[] = {
  { &hf_f1ap_thresholdMBSList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_T_thresholdMBSList },
  { &hf_f1ap_thresholdIndexSessionList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ThresholdIndexSessionList },
  { &hf_f1ap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_f1ap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_f1ap_UpdateThresholdMBS_ListInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_f1ap_UpdateThresholdMBS_ListInformation, UpdateThresholdMBS_ListInformation_sequence);

  return offset;
}


static const value_string f1ap_ThresholdMBS_ListItem_vals[] = {
  {   0, "thresholdMBS-ListInformationprovided" },
  {   1, "nothresholdMBSListInformationprovided" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ThresholdMBS_ListItem_choice[] = {
  {   0, &hf_f1ap_thresholdMBS_ListInformationprovided, ASN1_NO_EXTENSIONS     , dissect_f1ap_UpdateThresholdMBS_ListInformation },
  {   1, &hf_f1ap_nothresholdMBSListInformationprovided, ASN1_NO_EXTENSIONS     , dissect_f1ap_NULL },
  {   2, &hf_f1ap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_f1ap_ProtocolIE_SingleContainer },
  { 0, NULL, 0, NULL }
};

static int
dissect_f1ap_ThresholdMBS_ListItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_f1ap_ThresholdMBS_ListItem, ThresholdMBS_ListItem_choice,
                                 NULL);

  return offset;
}


stati